/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource;

import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.Permission;
import java.util.Hashtable;
import jet.cs.CSUtil;
import jet.server.api.PathInfo;
import jet.server.db.resource.NodeRecord;
import jet.server.intf.resource.Node;
import jet.server.intf.security.User;
import jet.server.jrc.resource.FolderImpl;
import jet.server.jrc.resource.PathInfoImpl;

public abstract class NodeImpl
implements Node,
Cloneable {
    private NodeRecord checkPermission;
    private String clone = "";
    private Acl endsWith = null;
    private Node equals = null;
    private boolean equalsIgnoreCase = false;
    private String get = null;
    private Node getAbsolutePath = null;
    protected boolean fakeNode = false;

    public NodeImpl() {
    }

    public NodeImpl(String string) {
        this.clone = string;
        this.checkPermission = new NodeRecord();
        this.checkPermission.setAclID(-1);
    }

    @Override
    public String getDescription() {
        return this.checkPermission.getDescription();
    }

    public NodeImpl(NodeRecord nodeRecord) {
        this.checkPermission = nodeRecord;
        if (!nodeRecord.isDynamic()) {
            boolean bl = this.equalsIgnoreCase = nodeRecord.getParentID() == -1;
        }
        if (this.equalsIgnoreCase && nodeRecord.getName().length() != 0) {
            nodeRecord.setName("");
        }
    }

    @Override
    public boolean setAcl(Acl acl, User user) {
        this.endsWith = acl;
        return true;
    }

    @Override
    public Acl getAcl() {
        return this.endsWith;
    }

    @Override
    public boolean removeAcl(User user) {
        this.endsWith = null;
        return true;
    }

    @Override
    public String getName() {
        return this.checkPermission.getName();
    }

    @Override
    public void rename(String string) {
        this.checkPermission.setName(string);
    }

    @Override
    public String getOrganization() {
        return this.checkPermission.getOrganization();
    }

    @Override
    public void setOrganization(String string) {
        this.checkPermission.setOrganization(string);
    }

    @Override
    public String getAbsolutePath() {
        return this.clone;
    }

    @Override
    public Node getParent() {
        return this.equals;
    }

    @Override
    public void setParent(Node node) {
        this.equals = node;
        this.checkPermission.setParentID(node.getID());
        if (this.getOwnerName() == null) {
            this.get = node.getOwnerName();
        }
    }

    @Override
    public void remove() {
        this.checkPermission = null;
        this.endsWith = null;
        this.equals = null;
        this.getAbsolutePath = null;
    }

    @Override
    public String getCreatorName() {
        return this.checkPermission.getCreatorName();
    }

    @Override
    public long getCreateTime() {
        return this.checkPermission.getCreateTime().getTime();
    }

    @Override
    public boolean checkPermission(User user, Permission permission) {
        if (this.isValidAdminUser(user) || this.checkPermission.getCreatorName().equals(user.getName())) {
            return true;
        }
        if (this.endsWith != null) {
            return this.endsWith.checkPermission((Principal)user, permission);
        }
        return this.equals.checkPermission(user, permission);
    }

    protected boolean isValidAdminUser(User user) {
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof NodeImpl) {
            NodeImpl nodeImpl = (NodeImpl)object;
            return this.getID() == nodeImpl.getID();
        }
        return false;
    }

    @Override
    public int getID() {
        return this.checkPermission.getID();
    }

    @Override
    public boolean isRoot() {
        return this.equalsIgnoreCase;
    }

    @Override
    public boolean isLCRoot() {
        return this.clone.endsWith("/COMPONENT_LIB");
    }

    public int getParentID() {
        if (this.isRoot()) {
            return this.getID();
        }
        return this.checkPermission.getParentID();
    }

    @Override
    public byte getNodeType() {
        return this.checkPermission.getNodeType();
    }

    protected void setNodeType(byte by) {
        this.checkPermission.setNodeType(by);
    }

    public PathInfoImpl getPathInfo(String string) {
        PathInfoImpl pathInfoImpl = new PathInfoImpl();
        pathInfoImpl.setID(this.checkPermission.getID());
        pathInfoImpl.setParentID(this.isRoot() ? -1 : this.checkPermission.getParentID());
        pathInfoImpl.setDescription(this.checkPermission.getDescription());
        pathInfoImpl.setName(this.checkPermission.getName());
        pathInfoImpl.setNodeType(this.checkPermission.getNodeType());
        pathInfoImpl.setPath(this.getAbsolutePath());
        pathInfoImpl.setUserID(string);
        pathInfoImpl.setIsDynamic(this.isDynamic());
        pathInfoImpl.setEnableLinkedCatalog(this.isEnableLinkedCatalog());
        pathInfoImpl.setLinkedCatalog(this.getLinkedCatalog(), this.getLinkedCatalogID());
        pathInfoImpl.setUseInherited(this.isUseInherited());
        if (!this.isRoot()) {
            pathInfoImpl.setParentPath(this.equals.getAbsolutePath());
        }
        pathInfoImpl.setIsFakeNode(this.fakeNode);
        pathInfoImpl.initCustomFieldValue();
        return pathInfoImpl;
    }

    public String toString() {
        return "record=" + this.checkPermission + ", absolutePath=" + this.clone + ", acl=" + this.endsWith;
    }

    public void setAbsolutePath(String string) {
        this.clone = string;
    }

    public void setDescription(String string) {
        this.checkPermission.setDescription(string);
    }

    @Override
    public abstract PathInfo toPathInfo(String var1);

    @Override
    public int getAclID() {
        return this.checkPermission.getAclID();
    }

    @Override
    public void setAclID(int n) {
        this.checkPermission.setAclID(n);
    }

    @Override
    public String getOwnerName() {
        return this.get;
    }

    public void setOwnerName(String string) {
        this.get = string;
    }

    @Override
    public boolean isOwnerOrCreator(String string) {
        return this.getOwnerName() != null && this.getOwnerName().equals(string) || this.checkPermission.getCreatorName() != null && this.checkPermission.getCreatorName().equals(string);
    }

    @Override
    public boolean setNodeProperties(Hashtable hashtable) {
        String string = (String)hashtable.get("jrs.node_name");
        String string2 = (String)hashtable.get("jrs.node_desc");
        boolean bl = CSUtil.getBoolean((String)hashtable.get("jrs.is_alias"), false);
        boolean bl2 = false;
        if (!bl && string != null && string.trim().length() > 0 && !(string = string.trim()).equalsIgnoreCase(this.checkPermission.getName())) {
            bl2 = true;
            if (this.equals.getNodeType() == 1) {
                ((FolderImpl)this.equals).replaceChildName(this.checkPermission.getName(), string);
            }
            this.checkPermission.setName(string);
        }
        if (!(string2 == null || this.checkPermission.getDescription() != null && string2.equalsIgnoreCase(this.checkPermission.getDescription()))) {
            bl2 = true;
            this.checkPermission.setDescription(string2);
        }
        return bl2;
    }

    @Override
    public boolean isDynamic() {
        return this.checkPermission.isDynamic();
    }

    public Object clone() {
        Node node = null;
        try {
            node = (Node)super.clone();
            ((NodeImpl)node).checkPermission = (NodeRecord)this.checkPermission.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return node;
    }

    @Override
    public boolean isEnableLinkedCatalog() {
        return this.checkPermission.isEnableLinkedCatalog();
    }

    @Override
    public void setEnableLinkedCatalog(boolean bl) {
        this.checkPermission.setEnableLinkedCatalog(bl);
    }

    @Override
    public String getLinkedCatalog() {
        return this.checkPermission.getLinkedCatalog();
    }

    @Override
    public int getLinkedCatalogID() {
        return this.checkPermission.getLinkedCatalogID();
    }

    @Override
    public void setLinkedCatalog(String string, int n) {
        this.checkPermission.setLinkedCatalog(string, n);
    }

    @Override
    public boolean isUseInherited() {
        return this.checkPermission.isUseInherited();
    }

    @Override
    public void setUseInherited(boolean bl) {
        this.checkPermission.setUseInherited(bl);
    }
}

