/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource;

import java.io.File;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.api.PathInfo;
import jet.server.api.RptServerException;
import jet.server.api.admin.cfg.custom.CustomField;
import jet.server.api.http.HttpUtil;
import jet.server.db.dao.CustomFieldValueDAO;
import jet.server.db.model.CustomFieldValueModel;
import jet.server.jrc.resource.nls.NLSUtil;
import jet.server.log.ServiceLogger;

public class PathInfoImpl
implements PathInfo,
Serializable {
    private static final long serialVersionUID = 8908732881747031410L;
    private int nodeID;
    private String userID;
    private String path;
    private String name;
    private String parentPath;
    private String description;
    private byte status = 0;
    private String realPath = "";
    private byte nodeType;
    private byte resourceType;
    private byte resourceSubType;
    private boolean isLiveReport = false;
    private String[] fileInfo;
    private int maxVersionAmount = 0;
    private int versionNumber = -1;
    private boolean archiveNewVersion = true;
    private boolean enableArchivePolicy = false;
    private boolean shared = false;
    private boolean adhocReport = false;
    boolean isDynamic = false;
    boolean enableDynamicResource = false;
    private boolean isEnableLinkedCatalog = false;
    private String linkedCatalog = null;
    private int linkedCatalogID = -1;
    private boolean isUseInherited = false;
    private String profileName;
    private long lastModified = 0L;
    private boolean isEnableNLS = false;
    private Map customFieldValueMap;
    private boolean isFakeNode = false;
    private Map displayNameMap;
    private int parentID = -1;

    @Override
    public String getUserID() {
        return this.userID;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getParentPath() {
        return this.parentPath;
    }

    public int getParentID() {
        return this.parentID;
    }

    @Override
    public String getRealPath() throws RptServerException {
        return this.realPath == null || this.realPath.trim().length() == 0 ? "" : this.realPath;
    }

    @Override
    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    @Override
    public boolean isResourceNode() {
        return true;
    }

    @Override
    public boolean isDir() {
        return this.nodeType == 1;
    }

    @Override
    public boolean isFile() {
        return this.nodeType == 2;
    }

    @Override
    public boolean isCatalog() {
        return this.nodeType == 2 && this.resourceType == 1;
    }

    @Override
    public boolean isReport() {
        return this.nodeType == 2 && this.resourceType == 2;
    }

    @Override
    public boolean isLC() {
        return this.nodeType == 2 && this.resourceType == 4;
    }

    @Override
    public boolean isSelfContainReport() {
        return this.isReport() && this.realPath.endsWith(".clx");
    }

    @Override
    public boolean isStudioReport() {
        return this.isReport() && this.resourceSubType == 2;
    }

    @Override
    public boolean isLiveReport() {
        return this.isLiveReport;
    }

    public void setIsLiveReport(boolean bl) {
        this.isLiveReport = bl;
    }

    @Override
    public boolean isJDashboard() {
        return this.isReport() && this.resourceSubType == 3;
    }

    @Override
    public boolean isShared() {
        return this.shared;
    }

    @Override
    public String[] getFileInfo() throws RptServerException {
        return this.fileInfo;
    }

    @Override
    public boolean isResult() {
        return this.nodeType == 2 && this.resourceType == 3;
    }

    public void setDescription(String string) {
        if (string != null && (string.equalsIgnoreCase("null") || string.trim().length() == 0)) {
            this.description = null;
            return;
        }
        this.description = string;
    }

    public void setFileInfo(String[] stringArray) {
        this.fileInfo = stringArray;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setNodeType(byte by) {
        this.nodeType = by;
    }

    public void setParentPath(String string) {
        this.parentPath = string;
    }

    public void setParentID(int n) {
        this.parentID = n;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public void setRealPath(String string) {
        File file;
        String string2 = this.realPath = string == null ? "" : string;
        if (this.realPath.length() > 0 && (file = new File(string)).exists()) {
            this.lastModified = file.lastModified();
        }
    }

    public void setResourceType(byte by) {
        this.resourceType = by;
    }

    public void setUserID(String string) {
        this.userID = string;
    }

    public int getID() {
        return this.nodeID;
    }

    public void setID(int n) {
        this.nodeID = n;
    }

    @Override
    public int getMaxVersionAmount() {
        return this.maxVersionAmount;
    }

    public void setMaxVersionAmount(int n) {
        this.maxVersionAmount = n;
    }

    public void setIsFakeNode(boolean bl) {
        this.isFakeNode = bl;
    }

    public String toString() {
        return super.toString() + "[" + "nodeID=" + this.nodeID + ", name=" + this.name + ", path=" + this.path + ", userID=" + this.userID + ", realPath=" + this.realPath + ", description=" + this.description + ", nodeType=" + this.nodeType + ", resourceType=" + this.resourceType + ", selfContainReport=" + this.isSelfContainReport() + ", adhocReport=" + this.isAdhocReport() + ", archiveNewVersion=" + this.archiveNewVersion + ", maxVersionAmount=" + this.maxVersionAmount + ", enableArchivePolicy=" + this.enableArchivePolicy + ", shared=" + this.shared + ", isDynamic=" + this.isDynamic + ", isEnableNLS=" + this.isEnableNLS + "]";
    }

    @Override
    public boolean isInUserDir() {
        return this.path.startsWith("/USERFOLDERPATH");
    }

    @Override
    public boolean isOwner(String string) {
        return this.path.startsWith("/USERFOLDERPATH/" + string);
    }

    @Override
    public int getLatestVersionNumber() {
        return this.versionNumber;
    }

    public void setLatestVersionNumber(int n) {
        this.versionNumber = n;
    }

    @Override
    public boolean isArchiveNewVersion() {
        return this.archiveNewVersion;
    }

    public void setArchiveNewVersion(boolean bl) {
        this.archiveNewVersion = bl;
    }

    @Override
    public boolean isEnableArchivePolicy() {
        return this.enableArchivePolicy;
    }

    public void setEnableArchivePolicy(boolean bl) {
        this.enableArchivePolicy = bl;
    }

    public void setShared(boolean bl) {
        this.shared = bl;
    }

    @Override
    public boolean isAdhocReport() {
        return this.adhocReport;
    }

    public byte getNodeType() {
        if (this.isDir()) {
            return 3;
        }
        if (this.isReport()) {
            return 0;
        }
        if (this.isCatalog()) {
            return 2;
        }
        return 1;
    }

    public void setAdhocReport(boolean bl) {
        this.adhocReport = bl;
    }

    @Override
    public boolean isDynamic() {
        return this.isDynamic;
    }

    public void setIsDynamic(boolean bl) {
        this.isDynamic = bl;
    }

    @Override
    public boolean isEnableDynamicResource() {
        return this.enableDynamicResource;
    }

    public void setEnableDynamicResource(boolean bl) {
        this.enableDynamicResource = bl;
    }

    @Override
    public boolean isEnableLinkedCatalog() {
        return this.isEnableLinkedCatalog;
    }

    public void setEnableLinkedCatalog(boolean bl) {
        this.isEnableLinkedCatalog = bl;
    }

    @Override
    public String getLinkedCatalog() {
        return this.linkedCatalog;
    }

    public int getLinkedCatalogID() {
        return this.linkedCatalogID;
    }

    public void setLinkedCatalog(String string, int n) {
        this.linkedCatalog = string;
        this.linkedCatalogID = n;
    }

    @Override
    public boolean isUseInherited() {
        return this.isUseInherited;
    }

    public void setUseInherited(boolean bl) {
        this.isUseInherited = bl;
    }

    public void setProfileName(String string) {
        this.profileName = string;
    }

    @Override
    public String getProfileName() {
        return this.profileName;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public boolean isEnableNLS() {
        return this.isEnableNLS;
    }

    public void setIsEnableNLS(boolean bl) {
        this.isEnableNLS = bl;
    }

    public void setStatus(byte by) {
        this.status = by;
    }

    @Override
    public byte getStatus() {
        return this.status;
    }

    @Override
    public Object getCustomFieldValue(String string) {
        if (this.customFieldValueMap == null) {
            this.initCustomFieldValue();
        }
        return this.customFieldValueMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initCustomFieldValue() {
        this.customFieldValueMap = new HashMap();
        CustomFieldValueDAO customFieldValueDAO = CustomFieldValueDAO.getInstance();
        Connection connection = null;
        try {
            connection = customFieldValueDAO.getConnection();
            Vector vector = null;
            if (this.isDynamic()) {
                vector = customFieldValueDAO.getFieldValues(connection, this.getPath());
            } else if (!this.isFakeNode) {
                vector = customFieldValueDAO.getFieldValues(connection, this.nodeID);
            }
            if (vector != null) {
                for (int i = vector.size() - 1; i >= 0; --i) {
                    CustomFieldValueModel customFieldValueModel = (CustomFieldValueModel)vector.get(i);
                    CustomField customField = customFieldValueModel.getField();
                    if (customField == null) continue;
                    String string = customField.getName();
                    Object object = customFieldValueModel.getValue();
                    if (string == null || object == null) continue;
                    this.customFieldValueMap.put(string, object);
                }
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException, 3);
                }
            }
        }
    }

    @Override
    public boolean isRptReport() {
        return this.isReport() && this.realPath.endsWith(".rpt");
    }

    @Override
    public boolean isXmlReport() {
        return this.isReport() && this.realPath.endsWith(".cls.xml");
    }

    @Override
    public boolean isXmlCatalog() {
        return this.isCatalog() && this.realPath.endsWith(".cat.xml");
    }

    @Override
    public String getDisplayName() {
        String string = this.getName();
        if (!HttpUtil.isShowNameWithPostfix() && (this.isCatalog() || this.isReport() || this.isLC())) {
            string = CSUtil.getNameWithoutExt(string, true);
        }
        return string;
    }

    @Override
    public byte getResourceSubType() {
        return this.resourceSubType;
    }

    public void setResourceSubType(byte by) {
        this.resourceSubType = by;
    }

    @Override
    public byte getResourceType() {
        return this.resourceType;
    }

    @Override
    public boolean isVA() {
        return this.isReport() && this.resourceSubType == 4;
    }

    @Override
    public String getDisplay(Locale locale) {
        String string = null;
        if (this.displayNameMap != null && (string = (String)this.displayNameMap.get(locale)) == null) {
            string = (String)this.displayNameMap.get(NLSUtil.getParentLocale(locale));
        }
        return string;
    }

    public void setDisplays(Map map) {
        this.displayNameMap = map;
    }
}

