/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.api.UserSession;
import jet.server.api.admin.ResourceAlias;
import jet.server.api.cluster.ClusterException;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.http.HttpUtil;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapFactory;
import jet.server.cluster.blocks.MapFlags;
import jet.server.cluster.blocks.MapListenerAdapter;
import jet.server.cluster.util.ClusterInitLocker;
import jet.server.db.resource.AliasTable;
import jet.server.intf.resource.Node;
import jet.server.intf.security.Group;
import jet.server.intf.security.SecurityService;
import jet.server.jrc.JRDataService;
import jet.server.jrc.resource.ResourceAliasImpl;
import jet.server.log.ServiceLogger;
import jet.server.util.ui.AliasNode;
import jet.server.util.ui.AliasTree;

public class ResourceAliasManagerImpl {
    private SecurityService RESOURCE_ALIAS = null;
    private AliasTable SEDU = null;
    private final String add;
    private Hashtable addChild = null;
    private ClusterMap addListener;

    public ResourceAliasManagerImpl(JRDataService jRDataService, SecurityService securityService) {
        this.add = jRDataService.getRealmName();
        this.RESOURCE_ALIAS = securityService;
        this.SEDU = jRDataService.getAliasTable();
        this.addChild = new Hashtable(400);
        try {
            this.RESOURCE_ALIAS();
            if (!ClusterInitLocker.hasInited(this.addListener.getName())) {
                ClusterInitLocker.setInited(this.addListener.getName());
            }
        }
        catch (ClusterException clusterException) {
            ServiceLogger.logError((Throwable)((Object)clusterException));
        }
        catch (InterruptedException interruptedException) {
            ServiceLogger.logError(interruptedException);
        }
    }

    public Hashtable allLoginUserAliases() {
        return this.addChild;
    }

    private void RESOURCE_ALIAS() throws ClusterException {
        this.addListener = MapFactory.getMapForRealm(this.add, MapAttr.RESOURCE_ALIAS);
        this.addListener.addListener(new MapListenerAdapter(){

            public void afterPut(String string, int n, AliasKey aliasKey, ResourceAlias resourceAlias, ResourceAlias resourceAlias2, MapFlags mapFlags) {
                Hashtable hashtable;
                String string2 = aliasKey.getUserName();
                String string3 = aliasKey.getUpperCaseAliasPath();
                if (ResourceAliasManagerImpl.this.addChild.containsKey(string2)) {
                    hashtable = (Hashtable)ResourceAliasManagerImpl.this.addChild.get(string2);
                } else {
                    hashtable = new Hashtable();
                    ResourceAliasManagerImpl.this.addChild.put(string2, hashtable);
                }
                hashtable.put(string3, resourceAlias);
            }

            public void afterRemove(String string, int n, AliasKey aliasKey, ResourceAlias resourceAlias, MapFlags mapFlags) {
                String string2 = aliasKey.getUserName();
                String string3 = aliasKey.getUpperCaseAliasPath();
                if (ResourceAliasManagerImpl.this.addChild.containsKey(string2)) {
                    Hashtable hashtable = (Hashtable)ResourceAliasManagerImpl.this.addChild.get(string2);
                    hashtable.remove(string3);
                    Object[] objectArray = MapFlags.getUserFlags(mapFlags);
                    if (objectArray != null && objectArray[0].equals(Boolean.TRUE)) {
                        ResourceAliasManagerImpl.this.addChild.remove(string2);
                    }
                }
            }
        });
    }

    public void loadUserAliasToMem(String string) {
        Vector vector = this.SEDU.getAliasesByPrincipal(string, (byte)0);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ResourceAlias resourceAlias = (ResourceAlias)vector.elementAt(i);
                AliasKey aliasKey = new AliasKey(string, resourceAlias.aliasPath());
                this.addListener.put(aliasKey, resourceAlias);
            }
        }
        try {
            Vector vector2;
            Vector vector3 = this.RESOURCE_ALIAS.getRolesNameByUser(string);
            if (vector3 != null) {
                for (int i = 0; i < vector3.size(); ++i) {
                    String string2 = (String)vector3.elementAt(i);
                    this.SEDU(string, string2);
                }
            }
            if ((vector2 = this.RESOURCE_ALIAS.getGroupsNameByUser(string)) != null) {
                for (int i = 0; i < vector2.size(); ++i) {
                    String string3 = (String)vector2.elementAt(i);
                    this.add(string, string3);
                }
            }
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError((Throwable)((Object)noSuchUserException));
        }
    }

    private void SEDU(String string, String string2) {
        Vector vector = this.SEDU.getAliasesByPrincipal(string2, (byte)1);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ResourceAlias resourceAlias = (ResourceAlias)vector.elementAt(i);
                AliasKey aliasKey = new AliasKey(string, resourceAlias.aliasPath());
                if (this.addListener.containsKey(aliasKey)) continue;
                this.addListener.put(aliasKey, resourceAlias);
            }
        }
        try {
            Vector vector2 = this.RESOURCE_ALIAS.getRole(string2).getParentRoleNames();
            if (vector2 != null && vector2.size() > 0) {
                for (int i = 0; i < vector2.size(); ++i) {
                    String string3 = (String)vector2.elementAt(i);
                    this.SEDU(string, string3);
                }
            }
        }
        catch (NoSuchRoleException noSuchRoleException) {
            // empty catch block
        }
    }

    private void add(String string, String string2) {
        Serializable serializable;
        Vector vector = this.SEDU.getAliasesByPrincipal(string2, (byte)2);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                serializable = (ResourceAlias)vector.elementAt(i);
                AliasKey aliasKey = new AliasKey(string, serializable.aliasPath());
                if (this.addListener.containsKey(aliasKey)) continue;
                this.addListener.put(aliasKey, serializable);
            }
        }
        try {
            Vector vector2;
            Group group = this.RESOURCE_ALIAS.getGroup(string2);
            serializable = group.getRoleNames();
            if (serializable != null && ((Vector)serializable).size() > 0) {
                for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                    String string3 = (String)((Vector)serializable).elementAt(i);
                    this.SEDU(string, string3);
                }
            }
            if ((vector2 = group.getParentGroupNames()) != null && vector2.size() > 0) {
                for (int i = 0; i < vector2.size(); ++i) {
                    String string4 = (String)vector2.elementAt(i);
                    this.add(string, string4);
                }
            }
        }
        catch (NoSuchGroupException noSuchGroupException) {
            // empty catch block
        }
    }

    public Hashtable getValidAliasesOfUser(String string) {
        return (Hashtable)this.addChild.get(string);
    }

    public void removeUserAliasFromMem(String string) {
        if (string != null && this.addChild.get(string) != null) {
            AliasKey aliasKey3 = null;
            AliasKey aliasKey2 = null;
            for (AliasKey aliasKey3 : this.addListener.keySet()) {
                if (!aliasKey3.getUserName().equals(string)) continue;
                this.addListener.remove(aliasKey3);
                aliasKey2 = aliasKey3;
            }
            if (aliasKey2 != null) {
                this.addListener.remove(aliasKey2, MapFlags.create(true));
            }
        }
    }

    public boolean isAliasNode(String string, String string2) {
        boolean bl = false;
        if (string == null || string2 == null || string.startsWith("/USERFOLDERPATH")) {
            return false;
        }
        Hashtable hashtable = (Hashtable)this.addChild.get(string2);
        if (hashtable != null && hashtable.size() != 0 && hashtable.containsKey(string.toUpperCase())) {
            bl = true;
        }
        return bl;
    }

    public boolean isAliasSubNode(String string, String string2) {
        boolean bl;
        block3: {
            bl = false;
            String string3 = string;
            if (string == null || string2 == null || string3.startsWith("/USERFOLDERPATH")) {
                return false;
            }
            Hashtable hashtable = (Hashtable)this.addChild.get(string2);
            if (hashtable == null || hashtable.size() == 0) break block3;
            if (hashtable.containsKey("/")) {
                return true;
            }
            while (string3.lastIndexOf("/") > 0 && !(bl = hashtable.containsKey((string3 = string3.substring(0, string3.lastIndexOf("/"))).toUpperCase()))) {
            }
        }
        return bl;
    }

    public ResourceAlias getAlias(String string, String string2) {
        ResourceAlias resourceAlias = null;
        Hashtable hashtable = (Hashtable)this.addChild.get(string2);
        if (hashtable != null && hashtable.size() != 0) {
            if (hashtable.containsKey(string.toUpperCase())) {
                resourceAlias = (ResourceAlias)hashtable.get(string.toUpperCase());
            } else if (string.indexOf("/") > 0) {
                string = string.substring(0, string.lastIndexOf("/"));
                resourceAlias = this.getAlias(string.toUpperCase(), string2);
            }
        }
        return resourceAlias;
    }

    public ResourceAlias getParentAlias(String string, String string2) {
        if (string == null) {
            return null;
        }
        ResourceAlias resourceAlias = null;
        String string3 = string.toUpperCase();
        if (this.isAliasSubNode(string3, string2)) {
            Hashtable hashtable = (Hashtable)this.addChild.get(string2);
            while (string3.lastIndexOf("/") > 0) {
                if (!hashtable.containsKey((string3 = string3.substring(0, string3.lastIndexOf("/"))).toUpperCase())) continue;
                resourceAlias = (ResourceAlias)hashtable.get(string3.toUpperCase());
                break;
            }
            if (resourceAlias == null && hashtable.containsKey("/")) {
                resourceAlias = (ResourceAlias)hashtable.get("/");
            }
        }
        return resourceAlias;
    }

    public Vector getAliasesOfUser(String string, String string2) {
        Vector vector = null;
        try {
            if (this.RESOURCE_ALIAS.getUser(string2) != null && (this.RESOURCE_ALIAS.isAdminUser(string) || string.equalsIgnoreCase(string2))) {
                vector = this.SEDU.getAliasesByPrincipal(string2, (byte)0);
            }
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError(noSuchUserException.getMessage(), 3);
        }
        return vector;
    }

    public Vector getAliasesOfRole(String string, String string2) {
        Vector vector = null;
        try {
            if (this.RESOURCE_ALIAS.getRole(string2) != null && this.RESOURCE_ALIAS.isAdminUser(string)) {
                vector = this.SEDU.getAliasesByPrincipal(string2, (byte)1);
            }
        }
        catch (NoSuchRoleException noSuchRoleException) {
            ServiceLogger.logError(noSuchRoleException.getMessage(), 3);
        }
        return vector;
    }

    public Vector getAliasesOfGroup(String string, String string2) {
        Vector vector = null;
        try {
            if (this.RESOURCE_ALIAS.getGroup(string2) != null && this.RESOURCE_ALIAS.isAdminUser(string)) {
                vector = this.SEDU.getAliasesByPrincipal(string2, (byte)2);
            }
        }
        catch (NoSuchGroupException noSuchGroupException) {
            ServiceLogger.logError(noSuchGroupException.getMessage(), 3);
        }
        return vector;
    }

    public void deleteAliasOfUser(String string, String string2, String string3) {
        if (!this.RESOURCE_ALIAS.isAdminUser(string) && string.equalsIgnoreCase(string2)) {
            return;
        }
        this.addChild(string2, string3);
        Vector vector = this.SEDU.getAliasesByPrincipal(string2, (byte)0);
        for (ResourceAlias resourceAlias : vector) {
            if (!resourceAlias.aliasPath().startsWith(string3)) continue;
            this.addChild(string2, resourceAlias.aliasPath());
        }
    }

    private void addChild(String string, String string2) {
        boolean bl = this.SEDU.deleteRecord(string, (byte)0, string2);
        if (bl) {
            AliasKey aliasKey = new AliasKey(string, string2);
            this.addListener.remove(aliasKey);
        }
    }

    public void deleteAllAliasesOfUser(String string, String string2) {
        if (!this.RESOURCE_ALIAS.isAdminUser(string) && string.equalsIgnoreCase(string2)) {
            return;
        }
        this.SEDU.deleteRecord(string2, (byte)0, null);
    }

    public void deleteAliasOfRole(String string, String string2, String string3) {
        if (!this.RESOURCE_ALIAS.isAdminUser(string)) {
            return;
        }
        this.addListener(string2, string3);
        Vector vector = this.SEDU.getAliasesByPrincipal(string2, (byte)1);
        for (ResourceAlias resourceAlias : vector) {
            if (!resourceAlias.aliasPath().startsWith(string3)) continue;
            this.addRecord(string2, resourceAlias.aliasPath());
        }
    }

    private void addListener(String string, String string2) {
        boolean bl = this.SEDU.deleteRecord(string, (byte)1, string2);
        if (bl) {
            Enumeration enumeration = this.addChild.keys();
            while (enumeration.hasMoreElements()) {
                ResourceAlias resourceAlias;
                String string3 = (String)enumeration.nextElement();
                Hashtable hashtable = (Hashtable)this.addChild.get(string3);
                if (hashtable == null || (resourceAlias = (ResourceAlias)hashtable.get(string2.toUpperCase())) == null || resourceAlias.principalType() != 1 || !resourceAlias.principalName().equalsIgnoreCase(string)) continue;
                this.addListener.remove(new AliasKey(string3, string2));
            }
        }
    }

    public void deleteAllAliasesOfRole(String string, String string2) {
        boolean bl;
        if (!this.RESOURCE_ALIAS.isAdminUser(string)) {
            return;
        }
        Vector vector = this.SEDU.getAliasesByPrincipal(string2, (byte)1);
        if (vector != null && vector.size() != 0 && (bl = this.SEDU.deleteRecord(string2, (byte)1, null))) {
            Enumeration enumeration = this.addChild.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                Hashtable hashtable = (Hashtable)this.addChild.get(string3);
                if (hashtable == null) continue;
                for (int i = 0; i < vector.size(); ++i) {
                    String string4 = ((ResourceAliasImpl)vector.elementAt(i)).aliasPath();
                    ResourceAlias resourceAlias = (ResourceAlias)hashtable.get(string4.toUpperCase());
                    if (resourceAlias == null || resourceAlias.principalType() != 1 || !resourceAlias.principalName().equalsIgnoreCase(string2)) continue;
                    this.addListener.remove(new AliasKey(string3, string4));
                }
            }
        }
    }

    public void deleteAliasOfGroup(String string, String string2, String string3) {
        if (!this.RESOURCE_ALIAS.isAdminUser(string)) {
            return;
        }
        this.addRecord(string2, string3);
        Vector vector = this.SEDU.getAliasesByPrincipal(string2, (byte)2);
        for (ResourceAlias resourceAlias : vector) {
            if (!resourceAlias.aliasPath().startsWith(string3)) continue;
            this.addRecord(string2, resourceAlias.aliasPath());
        }
    }

    private void addRecord(String string, String string2) {
        boolean bl = this.SEDU.deleteRecord(string, (byte)2, string2);
        if (bl) {
            Enumeration enumeration = this.addChild.keys();
            while (enumeration.hasMoreElements()) {
                ResourceAlias resourceAlias;
                String string3 = (String)enumeration.nextElement();
                Hashtable hashtable = (Hashtable)this.addChild.get(string3);
                if (hashtable == null || (resourceAlias = (ResourceAlias)hashtable.get(string2.toUpperCase())) == null || resourceAlias.principalType() != 2 || !resourceAlias.principalName().equalsIgnoreCase(string)) continue;
                this.addListener.remove(new AliasKey(string3, string2));
            }
        }
    }

    public void deleteAllAliasesOfGroup(String string, String string2) {
        if (!this.RESOURCE_ALIAS.isAdminUser(string)) {
            return;
        }
        Vector vector = this.SEDU.getAliasesByPrincipal(string2, (byte)2);
        if (vector == null || vector.size() == 0) {
            return;
        }
        boolean bl = this.SEDU.deleteRecord(string2, (byte)2, null);
        if (bl) {
            Enumeration enumeration = this.addChild.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                Hashtable hashtable = (Hashtable)this.addChild.get(string3);
                if (hashtable == null) continue;
                for (int i = 0; i < vector.size(); ++i) {
                    String string4 = ((ResourceAliasImpl)vector.elementAt(i)).aliasPath();
                    ResourceAlias resourceAlias = (ResourceAlias)hashtable.get(string4.toUpperCase());
                    if (resourceAlias == null || resourceAlias.principalType() != 2 || !resourceAlias.principalName().equalsIgnoreCase(string2)) continue;
                    this.addListener.remove(new AliasKey(string3, string4));
                }
            }
        }
    }

    public String setAliasForUser(String string, String string2, String string3, String string4, boolean bl) {
        int n;
        boolean bl2 = true;
        String string5 = "Setting alias for user '" + string2 + "' failed: the user '" + string2 + "' does not exist!";
        try {
            if (this.RESOURCE_ALIAS.getUser(string2) == null) {
                bl2 = false;
            }
        }
        catch (NoSuchUserException noSuchUserException) {
            bl2 = false;
        }
        if (!bl2) {
            return string5;
        }
        if (!this.RESOURCE_ALIAS.isAdminUser(string)) {
            return "Setting alias for user '" + string2 + "' failed: the submitter '" + string + "' is not an admin user!";
        }
        String string6 = "";
        if (!string3.equalsIgnoreCase("/")) {
            n = string3.lastIndexOf("/");
            if (n == 0) {
                string6 = "/";
            } else if (n > 0) {
                string6 = string3.substring(0, n);
            }
            if (!string6.equalsIgnoreCase("/") && this.SEDU.getRecord(string2, (byte)0, string6) == null) {
                return "Setting alias '" + string3 + "' for user '" + string2 + "' failed. The parent path '" + string6 + "' does not exist!";
            }
        }
        n = 0;
        n = this.SEDU.getRecord(string2, (byte)0, string3) == null ? (int)(this.SEDU.addRecord(string2, (byte)0, string3, string6, string4, bl) ? 1 : 0) : (int)(this.SEDU.updateRecord(string2, (byte)0, string3, string6, string4, bl) ? 1 : 0);
        if (n == 0) {
            return "Setting alias '" + string3 + "' for user '" + string2 + "' error!";
        }
        Vector vector = this.create();
        if (n != 0 && vector.contains(string2)) {
            this.contains(string2, string3, string2, (byte)0, string6, string4, bl);
        }
        return null;
    }

    public String setAliasForRole(String string, String string2, String string3, String string4, boolean bl) {
        int n;
        boolean bl2 = true;
        String string5 = "Setting alias for role '" + string2 + "' failed: the role '" + string2 + "' does not exist!";
        try {
            if (this.RESOURCE_ALIAS.getRole(string2) == null) {
                bl2 = false;
            }
        }
        catch (NoSuchRoleException noSuchRoleException) {
            bl2 = false;
        }
        if (!bl2) {
            return string5;
        }
        if (!this.RESOURCE_ALIAS.isAdminUser(string)) {
            return "Setting alias for role '" + string2 + "' failed: the submitter '" + string + "' is not an admin user!";
        }
        String string6 = "";
        if (!string3.equalsIgnoreCase("/")) {
            n = string3.lastIndexOf("/");
            if (n == 0) {
                string6 = "/";
            } else if (n > 0) {
                string6 = string3.substring(0, n);
            }
            if (!string6.equalsIgnoreCase("/") && this.SEDU.getRecord(string2, (byte)1, string6) == null) {
                return "Setting alias '" + string3 + "' for role '" + string2 + "' failed. The parent path '" + string6 + "' does not exist!";
            }
        }
        n = 0;
        n = this.SEDU.getRecord(string2, (byte)1, string3) == null ? (int)(this.SEDU.addRecord(string2, (byte)1, string3, string6, string4, bl) ? 1 : 0) : (int)(this.SEDU.updateRecord(string2, (byte)1, string3, string6, string4, bl) ? 1 : 0);
        if (n != 0) {
            Enumeration enumeration = this.create().elements();
            Vector vector = new Vector();
            vector = this.append(vector, string2);
            while (enumeration.hasMoreElements()) {
                String string7 = (String)enumeration.nextElement();
                if (vector == null || !vector.contains(string7)) continue;
                this.contains(string7, string3, string2, (byte)1, string6, string4, bl);
            }
            return null;
        }
        return "Setting alias '" + string3 + "' for role '" + string2 + "' error!";
    }

    public String setAliasForGroup(String string, String string2, String string3, String string4, boolean bl) {
        int n;
        boolean bl2 = true;
        String string5 = "Setting alias for group '" + string2 + "' failed: the group '" + string2 + "' does not exist!";
        try {
            if (this.RESOURCE_ALIAS.getGroup(string2) == null) {
                bl2 = false;
            }
        }
        catch (NoSuchGroupException noSuchGroupException) {
            bl2 = false;
        }
        if (!bl2) {
            return string5;
        }
        if (!this.RESOURCE_ALIAS.isAdminUser(string)) {
            return "Setting alias for group '" + string2 + "' failed: the submitter '" + string + "' is not an admin user!";
        }
        String string6 = "";
        if (!string3.equalsIgnoreCase("/")) {
            n = string3.lastIndexOf("/");
            if (n == 0) {
                string6 = "/";
            } else if (n > 0) {
                string6 = string3.substring(0, n);
            }
            if (!string6.equalsIgnoreCase("/") && this.SEDU.getRecord(string2, (byte)2, string6) == null) {
                return "Setting alias '" + string3 + "' for group '" + string2 + "' failed. The parent path '" + string6 + "' does not exist!";
            }
        }
        n = 0;
        n = this.SEDU.getRecord(string2, (byte)2, string3) == null ? (int)(this.SEDU.addRecord(string2, (byte)2, string3, string6, string4, bl) ? 1 : 0) : (int)(this.SEDU.updateRecord(string2, (byte)2, string3, string6, string4, bl) ? 1 : 0);
        if (n != 0) {
            Enumeration enumeration = this.create().elements();
            Vector vector = new Vector();
            vector = this.aliasPath(vector, string2);
            while (enumeration.hasMoreElements()) {
                String string7 = (String)enumeration.nextElement();
                if (vector == null || !vector.contains(string7)) continue;
                this.contains(string7, string3, string2, (byte)2, string6, string4, bl);
            }
            return null;
        }
        return "Setting alias '" + string3 + "' for group '" + string2 + "' error!";
    }

    private Vector aliasPath(Vector vector, String string) {
        try {
            Vector vector2;
            Vector vector3 = this.RESOURCE_ALIAS.getUsersNameByGroup(string);
            if (vector3 != null && vector3.size() > 0) {
                for (int i = 0; i < vector3.size(); ++i) {
                    String string2 = (String)vector3.elementAt(i);
                    if (vector.contains(string2)) continue;
                    vector.add(string2);
                }
            }
            if ((vector2 = this.RESOURCE_ALIAS.getGroup(string).getSubGroupNames()) != null && vector2.size() > 0) {
                for (int i = 0; i < vector2.size(); ++i) {
                    String string3 = (String)vector2.elementAt(i);
                    vector = this.aliasPath(vector, string3);
                }
            }
        }
        catch (NoSuchGroupException noSuchGroupException) {
            // empty catch block
        }
        return vector;
    }

    private Vector append(Vector vector, String string) {
        try {
            Vector vector2;
            Vector vector3 = this.RESOURCE_ALIAS.getUsersNameByRole(string);
            if (vector3 != null && vector3.size() > 0) {
                for (int i = 0; i < vector3.size(); ++i) {
                    String string2 = (String)vector3.elementAt(i);
                    if (vector.contains(string2)) continue;
                    vector.add(string2);
                }
            }
            if ((vector2 = this.RESOURCE_ALIAS.getRole(string).getSubRoleNames()) != null && vector2.size() > 0) {
                for (int i = 0; i < vector2.size(); ++i) {
                    String string3 = (String)vector2.elementAt(i);
                    vector = this.append(vector, string3);
                }
            }
        }
        catch (NoSuchRoleException noSuchRoleException) {
            // empty catch block
        }
        return vector;
    }

    private void contains(String string, String string2, String string3, byte by, String string4, String string5, boolean bl) {
        Hashtable hashtable = (Hashtable)this.addChild.get(string);
        if (hashtable != null && hashtable.get(string2.toUpperCase()) != null) {
            this.addListener.remove(new AliasKey(string, string2));
        }
        this.addListener.put(new AliasKey(string, string2), new ResourceAliasImpl(string3, by, string2, string4, string5, bl));
    }

    public boolean hasAliasOfUser(String string, String string2) {
        int n = 0;
        try {
            if (this.RESOURCE_ALIAS.getUser(string2) != null && (this.RESOURCE_ALIAS.isAdminUser(string) || string.equalsIgnoreCase(string2))) {
                n = this.SEDU.getAliasCount(string2, (byte)0);
            }
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError(noSuchUserException.getMessage(), 3);
        }
        return n > 0;
    }

    public boolean hasAliasOfRole(String string, String string2) {
        int n = 0;
        try {
            if (this.RESOURCE_ALIAS.getRole(string2) != null && this.RESOURCE_ALIAS.isAdminUser(string)) {
                n = this.SEDU.getAliasCount(string2, (byte)1);
            }
        }
        catch (NoSuchRoleException noSuchRoleException) {
            ServiceLogger.logError(noSuchRoleException.getMessage(), 3);
        }
        return n > 0;
    }

    public boolean hasAliasOfGroup(String string, String string2) {
        int n = 0;
        try {
            if (this.RESOURCE_ALIAS.getGroup(string2) != null && this.RESOURCE_ALIAS.isAdminUser(string)) {
                n = this.SEDU.getAliasCount(string2, (byte)2);
            }
        }
        catch (NoSuchGroupException noSuchGroupException) {
            ServiceLogger.logError(noSuchGroupException.getMessage(), 3);
        }
        return n > 0;
    }

    public Vector allAssignedUsers(String string) {
        if (!this.RESOURCE_ALIAS.isAdminUser(string)) {
            return null;
        }
        return this.SEDU.getAssignedAliasUsers();
    }

    public Vector allAssignedRoles(String string) {
        if (!this.RESOURCE_ALIAS.isAdminUser(string)) {
            return null;
        }
        return this.SEDU.getAssignedAliasRoles();
    }

    public Vector allAssignedGroups(String string) {
        if (!this.RESOURCE_ALIAS.isAdminUser(string)) {
            return null;
        }
        return this.SEDU.getAssignedAliasGroups();
    }

    public boolean hiddenSubaliasUser(String string, String string2, String string3) {
        if (!this.RESOURCE_ALIAS.isAdminUser(string) && !string.equalsIgnoreCase(string2)) {
            return false;
        }
        return this.SEDU.hiddenSubalias(string2, (byte)0, string3);
    }

    public boolean hiddenSubaliasRole(String string, String string2, String string3) {
        if (!this.RESOURCE_ALIAS.isAdminUser(string) && !this.RESOURCE_ALIAS.getAllRolesName().contains(string2)) {
            return false;
        }
        return this.SEDU.hiddenSubalias(string2, (byte)1, string3);
    }

    public boolean hiddenSubaliasGroup(String string, String string2, String string3) {
        if (!this.RESOURCE_ALIAS.isAdminUser(string) && !this.RESOURCE_ALIAS.getAllGroupsName().contains(string2)) {
            return false;
        }
        return this.SEDU.hiddenSubalias(string2, (byte)2, string3);
    }

    public String refreshAliasOfUser(String string, String string2) {
        if (!this.RESOURCE_ALIAS.isAdminUser(string) && !string.equalsIgnoreCase(string2)) {
            return null;
        }
        Vector vector = this.SEDU.getAliasesByPrincipal(string2, (byte)0);
        return null;
    }

    public String refreshAliasOfRole(String string, String string2) {
        if (!this.RESOURCE_ALIAS.isAdminUser(string) && !this.RESOURCE_ALIAS.getAllRolesName().contains(string2)) {
            return null;
        }
        Vector vector = this.SEDU.getAliasesByPrincipal(string2, (byte)1);
        return null;
    }

    public String refreshAliasOfGroup(String string, String string2) {
        if (!this.RESOURCE_ALIAS.isAdminUser(string) && !this.RESOURCE_ALIAS.getAllGroupsName().contains(string2)) {
            return null;
        }
        Vector vector = this.SEDU.getAliasesByPrincipal(string2, (byte)2);
        return null;
    }

    public Vector getSubAliases(String string, String string2) {
        Vector<ResourceAlias> vector = null;
        Hashtable hashtable = (Hashtable)this.addChild.get(string2);
        if (hashtable != null && hashtable.size() > 0) {
            Enumeration enumeration = hashtable.keys();
            vector = new Vector<ResourceAlias>();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                ResourceAlias resourceAlias = (ResourceAlias)hashtable.get(string3);
                String string4 = resourceAlias.aliasPath();
                if (string4.lastIndexOf("/") > 0) {
                    if (!string.equalsIgnoreCase(string4 = string4.substring(0, string4.lastIndexOf("/")))) continue;
                    vector.add(resourceAlias);
                    continue;
                }
                if (!string.equals("/") || resourceAlias.aliasPath().equalsIgnoreCase("/")) continue;
                vector.add(resourceAlias);
            }
        }
        return vector;
    }

    public String getAliasName(ResourceAlias resourceAlias) {
        String string = "";
        string = resourceAlias.aliasPath();
        if (string.equalsIgnoreCase("/")) {
            string = string.substring(string.lastIndexOf("/"));
        }
        return string;
    }

    public static String contentPath(String string, String string2) {
        String string3 = string;
        if (string.equalsIgnoreCase("/")) {
            string3 = "";
        } else if (string3.endsWith("/")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        return string3 + string2;
    }

    public AliasTree getAliasTreeByPrincipal(String string, byte by, Hashtable hashtable, String string2) {
        Object object;
        String string3 = "";
        AliasTree aliasTree = null;
        ResourceAlias resourceAlias = null;
        boolean bl = true;
        if (by == 1) {
            try {
                if (this.RESOURCE_ALIAS.getRole(string) == null || !this.RESOURCE_ALIAS.isAdminUser(string2)) {
                    bl = false;
                }
            }
            catch (NoSuchRoleException noSuchRoleException) {
                ServiceLogger.logError(noSuchRoleException.getMessage(), 3);
                bl = false;
            }
            string3 = "alias_role_" + string;
        } else if (by == 2) {
            try {
                if (this.RESOURCE_ALIAS.getGroup(string) == null || !this.RESOURCE_ALIAS.isAdminUser(string2)) {
                    bl = false;
                }
            }
            catch (NoSuchGroupException noSuchGroupException) {
                ServiceLogger.logError(noSuchGroupException.getMessage(), 3);
                bl = false;
            }
            string3 = "alias_group_" + string;
        } else if (by == 0) {
            try {
                if (this.RESOURCE_ALIAS.getUser(string) == null || !this.RESOURCE_ALIAS.isAdminUser(string2) && !string2.equalsIgnoreCase(string)) {
                    bl = false;
                }
            }
            catch (NoSuchUserException noSuchUserException) {
                ServiceLogger.logError(noSuchUserException.getMessage(), 3);
                bl = false;
            }
            string3 = "alias_user_" + string;
        }
        if (!bl) {
            return null;
        }
        resourceAlias = this.SEDU.getRecord(string, by, "/");
        if (resourceAlias != null) {
            object = String.valueOf(((Node)hashtable.get(resourceAlias.resourcePath().toUpperCase())).getNodeType());
            aliasTree = new AliasTree(string3, string3, resourceAlias.aliasPath(), resourceAlias.aliasPath(), resourceAlias.resourcePath(), (String)object, String.valueOf(resourceAlias.hidden()));
        } else {
            resourceAlias = new ResourceAliasImpl(string, by, "/", "", "", false);
            aliasTree = new AliasTree(string3, string3, "/", "/", "", String.valueOf(1), "");
        }
        object = aliasTree.getRoot();
        this.containsKey(resourceAlias, (AliasNode)object, string, by, hashtable);
        return aliasTree;
    }

    private void containsKey(ResourceAlias resourceAlias, AliasNode aliasNode, String string, byte by, Hashtable hashtable) {
        String string2 = resourceAlias.aliasPath();
        Vector vector = this.SEDU.getAliasOfPrincipalByParent(string, by, string2);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ResourceAlias resourceAlias2 = (ResourceAlias)vector.elementAt(i);
                String string3 = resourceAlias2.resourcePath();
                byte by2 = 1;
                if (string3 != null && string3.length() > 0) {
                    try {
                        by2 = ((Node)hashtable.get(string3.toUpperCase())).getNodeType();
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception.getMessage(), 3);
                    }
                }
                String string4 = CSUtil.getLogicalFolderAndName(resourceAlias2.aliasPath())[1];
                AliasNode aliasNode2 = aliasNode.addChild(resourceAlias2.aliasPath(), string4, resourceAlias2.resourcePath(), String.valueOf(by2), String.valueOf(resourceAlias2.hidden()));
                if (by2 != 1) continue;
                this.containsKey(resourceAlias2, aliasNode2, string, by, hashtable);
            }
        }
    }

    public synchronized void upgradeAbsolutePathForAlias(String string, String string2) {
        String string3 = string.toUpperCase();
        String string4 = string2.toUpperCase();
        this.SEDU.updateResource(string, string2);
        for (Map.Entry entry : this.addListener.entrySet()) {
            ResourceAlias resourceAlias = (ResourceAlias)entry.getValue();
            String string5 = resourceAlias.resourcePath();
            if (!string5.startsWith(string3)) continue;
            if (string5.equalsIgnoreCase(string3)) {
                ((ResourceAliasImpl)resourceAlias).setResourcePath(string4);
            } else {
                ((ResourceAliasImpl)resourceAlias).setResourcePath(string4 + string5.substring(string3.length()));
            }
            this.addListener.put(entry.getKey(), resourceAlias);
        }
    }

    public synchronized void upgradeAliasPath(String string, String string2, String string3) throws NoPrivilegeException {
        for (Map.Entry entry : this.addListener.entrySet()) {
            String string4;
            ResourceAlias resourceAlias = (ResourceAlias)entry.getValue();
            String string5 = resourceAlias.aliasPath();
            if (!string5.startsWith(string)) continue;
            String string6 = "";
            string6 = string5.equalsIgnoreCase(string) ? string2 : string2 + string5.substring(string.length());
            if (resourceAlias.principalType() == 0 || this.RESOURCE_ALIAS.isAdminUser(string3)) {
                this.SEDU.deleteRecord(resourceAlias.principalName(), resourceAlias.principalType(), resourceAlias.aliasPath());
                string4 = "";
                if (!string6.equalsIgnoreCase("/")) {
                    int n = string6.lastIndexOf("/");
                    string4 = n == 0 ? "/" : string6.substring(0, n);
                }
            } else {
                throw new NoPrivilegeException(630013, (Object[])new String[]{string3, string}, null);
            }
            this.SEDU.addRecord(resourceAlias.principalName(), resourceAlias.principalType(), string6, string4, resourceAlias.resourcePath(), resourceAlias.hidden());
            ((ResourceAliasImpl)resourceAlias).setAliasPath(string6);
            this.addListener.put(entry.getKey(), resourceAlias);
        }
    }

    private Vector create() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = HttpUtil.getHttpRptServer().getUserSessionManager().getAllUserSessions();
        while (enumeration.hasMoreElements()) {
            UserSession userSession = (UserSession)enumeration.nextElement();
            String string = userSession.getUserID();
            if (vector.contains(string)) continue;
            vector.add(userSession.getUserID());
        }
        return vector;
    }

    private static class AliasKey
    implements Serializable {
        private String userName;
        private String aliasPath;

        AliasKey(String string, String string2) {
            this.userName = string;
            this.aliasPath = string2.toUpperCase();
        }

        public String getUpperCaseAliasPath() {
            return this.aliasPath;
        }

        public String getUserName() {
            return this.userName;
        }

        public int hashCode() {
            String string = this.userName + "&" + this.aliasPath;
            return string.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof AliasKey)) {
                return false;
            }
            AliasKey aliasKey = (AliasKey)object;
            return this.userName.equals(aliasKey.getUserName()) && this.aliasPath.equals(aliasKey.getUpperCaseAliasPath());
        }
    }
}

