/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource;

import com.jinfonet.report.convert.Converter;
import com.jinfonet.report.convert.ConverterEnv;
import com.jinfonet.report.convert.ConverterException;
import com.jinfonet.report.convert.ConverterFactory;
import com.jinfonet.resstore.ResourceLoadException;
import com.jinfonet.resstore.ResourceNotFoundException;
import com.jinfonet.resstore.ResourceStore;
import com.jinfonet.web.modules.dashboard.service.util.DashboardProvider;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import jet.JSvrResource;
import jet.ReportEnv;
import jet.cs.CSUtil;
import jet.cs.ExProperties;
import jet.jetc.JetRptReportIOException;
import jet.jetc.ReadFailureException;
import jet.jetc.WriteFailureException;
import jet.lc.LCObject;
import jet.lc.io.LCObjectIO;
import jet.report.JReportUtil;
import jet.server.ServerEnv;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.NodeExistsException;
import jet.server.api.exception.UnknownResource;
import jet.server.db.version.ResultDetailedInfo;
import jet.server.intf.resource.Folder;
import jet.server.intf.resource.Node;
import jet.server.intf.resource.Resource;
import jet.server.intf.resource.ResourceInfo;
import jet.server.intf.resource.Version;
import jet.server.jrc.resource.CatalogInfoImpl;
import jet.server.jrc.resource.LCInfoImpl;
import jet.server.jrc.resource.ReportInfoImpl;
import jet.server.jrc.resource.ResourceTreeManagerImpl;
import jet.server.jrc.resource.ResultInfoImpl;
import jet.server.log.ServiceLogger;
import jet.server.resstore.ServerResourceStoreFactory;
import jet.server.resstore.impl.JRServerResourceStoreFactory;
import jet.server.schedule.SchdTools;
import jet.server.schedule.jrtasks.ReportConvertEnvImpl;
import jet.server.storage.Storage;
import jet.server.storage.StorageEnv;
import jet.server.util.RefResource;
import jet.server.util.ServerUtil;
import jet.server.util.WebSecurityUtil;
import jet.universe.JetUUniverse;
import jet.universe.exception.FMLFileException;
import jet.universe.exception.UniverseFileException;
import jet.upgrade.JUpgradeException;
import jet.util.FontSets;
import jet.util.WildcardMatcher;

public class ResourceToolkit {
    private static String FONT = null;
    private static final Properties GISINFO = new Properties();
    private static long IRT_GMAPGEO = 0L;
    private static int SEDU = 5;
    private static int STYLE = 0;
    private static int add = 1;
    private static int addAll = 2;
    private static int addElement = 3;
    private static int addResource = 4;
    private static int addSubFolder = 5;

    public static void importResources(File file, Folder folder, boolean bl, boolean bl2, ResourceTreeManagerImpl resourceTreeManagerImpl, String string) {
        ResourceToolkit.importResources(file, folder, bl, bl2, false, resourceTreeManagerImpl, string);
    }

    public static void importResources(File file, Folder folder, boolean bl, boolean bl2, boolean bl3, ResourceTreeManagerImpl resourceTreeManagerImpl, String string) {
        ResourceToolkit.importResources(file, folder, bl, bl2, false, resourceTreeManagerImpl, string, false, new Hashtable());
    }

    public static void importResources(File file, Folder folder, boolean bl, boolean bl2, boolean bl3, ResourceTreeManagerImpl resourceTreeManagerImpl, String string, boolean bl4, Hashtable hashtable) {
        ResourceToolkit.importResources(file, folder, bl, bl2, bl3, false, resourceTreeManagerImpl, string, bl4, null, hashtable);
    }

    public static void importResourcesWithConvert(File file, Folder folder, boolean bl, boolean bl2, ResourceTreeManagerImpl resourceTreeManagerImpl, String string) {
        ResourceToolkit.importResourcesWithConvert(file, folder, bl, bl2, false, resourceTreeManagerImpl, string, false, new Hashtable());
    }

    public static void importResourcesWithConvert(File file, Folder folder, boolean bl, boolean bl2, boolean bl3, ResourceTreeManagerImpl resourceTreeManagerImpl, String string, boolean bl4, Hashtable hashtable) {
        ResourceToolkit.importResources(file, folder, bl, bl2, bl3, true, resourceTreeManagerImpl, string, bl4, null, hashtable);
    }

    public static String importResources(File file, Folder folder, boolean bl, boolean bl2, boolean bl3, boolean bl4, ResourceTreeManagerImpl resourceTreeManagerImpl, String string, boolean bl5, String string2, Hashtable hashtable) {
        ArrayList[] arrayListArray;
        String string3 = null;
        String string4 = "";
        File file2 = null;
        boolean bl6 = CSUtil.getBoolean((String)hashtable.get("jrs.folder_with_contents"), false);
        if (bl4 && !(file2 = new File(string4 = !(arrayListArray = ServerEnv.getReportHome()).endsWith(File.separator) ? (String)arrayListArray + File.separator + "temp" + File.separator + "convertFiles" : (String)arrayListArray + "temp" + File.separator + "convertFiles")).exists()) {
            file2.mkdirs();
        }
        if (file.exists() && file.isDirectory()) {
            Object[] objectArray;
            String string5;
            Object object2;
            arrayListArray = ResourceToolkit.GISINFO(file);
            Folder folder2 = null;
            Object var18_17 = null;
            if (hashtable != null) {
                ResourceToolkit.saveStyleFiles(WebSecurityUtil.validateFilePathStr((String)hashtable.get("jrs.deploy_local_style_dir")));
            }
            if (!bl5) {
                for (Object object2 : arrayListArray[STYLE]) {
                    if (string2 != null && ((File)object2).getName().equalsIgnoreCase(string2)) continue;
                    try {
                        block29: {
                            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                            hashtable2.put("jrs.node_name", ((File)object2).getName());
                            if (!bl6 && hashtable.get("jrs.permission_values") != null) {
                                hashtable2.put("jrs.permission_values", (String)hashtable.get("jrs.permission_values"));
                            }
                            try {
                                folder2 = null;
                                folder2 = resourceTreeManagerImpl.addSubFolder(folder, hashtable2, string);
                            }
                            catch (NodeExistsException nodeExistsException) {
                                Node node = folder.getChild(((File)object2).getName());
                                if (node == null || node.getNodeType() != 1) break block29;
                                folder2 = (Folder)node;
                            }
                        }
                        if (folder2 == null || !bl || (string5 = ResourceToolkit.importResources((File)object2, folder2, bl, bl2, bl3, bl4, resourceTreeManagerImpl, string, false, string2, hashtable)) == null || string5.indexOf("LR") == -1) continue;
                        if (string3 == null) {
                            string3 = string5;
                            continue;
                        }
                        string3 = string3 + "," + string5.substring(string5.indexOf("LR") + 3);
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                    }
                }
            }
            object2 = null;
            string5 = null;
            for (int i = arrayListArray[add].size() - 1; i >= 0; --i) {
                if (string2 != null && ((File)arrayListArray[add].get(i)).getName().equalsIgnoreCase(string2)) continue;
                try {
                    objectArray = ResourceToolkit.FONT((File)arrayListArray[add].get(i), folder, add, bl2, bl6, bl4, hashtable, resourceTreeManagerImpl, string, null, null, string3);
                    Object object3 = (Version)objectArray[1];
                    object2 = object3.getParent().getAbsolutePath();
                    string5 = object3.getEntity().getRealPath();
                    continue;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
            }
            if (object2 == null && (arrayListArray[addAll].size() > 0 || arrayListArray[addElement].size() > 0)) {
                try {
                    Vector vector = resourceTreeManagerImpl.getResources(folder, string);
                    for (Resource resource : vector) {
                        if (resource.getResourceType() != 1) continue;
                        object2 = resource.getAbsolutePath();
                        string5 = resource.getEntity().getRealPath();
                        break;
                    }
                }
                catch (NoPrivilegeException noPrivilegeException) {
                    ServiceLogger.logError((Throwable)((Object)noPrivilegeException), 3);
                }
            }
            if (!folder.getAbsolutePath().startsWith("/COMPONENT_LIB")) {
                for (Object object3 : arrayListArray[addAll]) {
                    if (string2 != null && ((File)object3).getName().equalsIgnoreCase(string2)) continue;
                    try {
                        objectArray = ResourceToolkit.FONT((File)object3, folder, addAll, bl2, bl6, bl4, hashtable, resourceTreeManagerImpl, string, (String)object2, string5, string3);
                        string3 = (String)objectArray[0];
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                    }
                }
            } else {
                for (Object object3 : arrayListArray[addElement]) {
                    if (string2 != null && ((File)object3).getName().equalsIgnoreCase(string2)) continue;
                    try {
                        ResourceToolkit.FONT((File)object3, folder, addElement, bl2, bl6, bl4, hashtable, resourceTreeManagerImpl, string, (String)object2, string5, string3);
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                    }
                }
            }
            for (Object object3 : arrayListArray[addResource]) {
                if (string2 != null && ((File)object3).getName().equalsIgnoreCase(string2)) continue;
                try {
                    ResourceToolkit.FONT((File)object3, folder, addResource, bl2, bl6, bl4, hashtable, resourceTreeManagerImpl, string, (String)object2, string5, string3);
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
            }
        }
        return string3;
    }

    private static Object[] FONT(File file, Folder folder, int n, boolean bl, boolean bl2, boolean bl3, Hashtable hashtable, ResourceTreeManagerImpl resourceTreeManagerImpl, String string, String string2, String string3, String string4) throws IOException, NoPrivilegeException, NodeExistsException, JetRptReportIOException {
        Version version = null;
        if (n == addAll && !ReportEnv.isLive() && RefResource.isLiveReport(file.getPath())) {
            string4 = string4 == null ? "LR:" + file.getName() : string4 + "," + file.getName();
            ServiceLogger.logError(2620030, new Object[]{file.getPath(), folder.getName()}, 5);
        } else if (bl || !folder.hasChild(file.getName())) {
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            hashtable2.put("jrs.node_name", file.getName());
            if (n == add) {
                hashtable2.put("jrs.node_type", String.valueOf(2));
            } else if (n == addResource) {
                hashtable2.put("jrs.node_type", String.valueOf(5));
                if (hashtable == null || hashtable.get("jrs.node_status") == null) {
                    hashtable2.put("jrs.node_status", String.valueOf(1));
                } else {
                    hashtable2.put("jrs.node_status", (String)hashtable.get("jrs.node_status"));
                }
                if (string2 != null) {
                    hashtable2.put("jrs.enable.linked.catalog", String.valueOf(true));
                    hashtable2.put("jrs.linked.catalog", string2);
                }
            } else if (n == addElement) {
                hashtable2.put("jrs.node_type", String.valueOf(4));
                if (string2 != null) {
                    hashtable2.put("jrs.enable.linked.catalog", String.valueOf(true));
                    hashtable2.put("jrs.linked.catalog", string2);
                }
            } else {
                hashtable2.put("jrs.node_type", String.valueOf(0));
                if (hashtable == null || hashtable.get("jrs.node_status") == null) {
                    hashtable2.put("jrs.node_status", String.valueOf(1));
                } else {
                    hashtable2.put("jrs.node_status", (String)hashtable.get("jrs.node_status"));
                }
            }
            if (!bl2 && hashtable.get("jrs.permission_values") != null) {
                hashtable2.put("jrs.permission_values", (String)hashtable.get("jrs.permission_values"));
            }
            if (n == addAll && bl3) {
                ResourceInfo resourceInfo;
                String string5 = file.getCanonicalPath();
                Converter converter = ConverterFactory.getReportConverter();
                boolean bl4 = false;
                if (!string5.endsWith(".dsh")) {
                    try {
                        bl4 = converter.isNeedUpgrade(new File(string5));
                    }
                    catch (ConverterException converterException) {
                        ServiceLogger.logError(converterException, 3);
                    }
                }
                if (bl4) {
                    String string6 = ResourceToolkit.SEDU(string5);
                    if (string6 == null) {
                        string6 = ResourceToolkit.IRT_GMAPGEO(folder);
                    }
                    resourceInfo = ResourceToolkit.add(string5, string6, string, string3, resourceTreeManagerImpl, hashtable);
                } else {
                    resourceInfo = ResourceToolkit.STYLE(string5, string, string3, resourceTreeManagerImpl, hashtable);
                }
                version = resourceTreeManagerImpl.addResource(folder, hashtable2, resourceInfo, string);
                ConverterFactory.destroy();
            } else {
                ResourceInfo resourceInfo = ResourceToolkit.STYLE(file.getCanonicalPath(), string, string3, resourceTreeManagerImpl, hashtable);
                version = resourceTreeManagerImpl.addResource(folder, hashtable2, resourceInfo, string);
            }
        }
        return new Object[]{string4, version};
    }

    private static ArrayList[] GISINFO(File file) {
        File[] fileArray;
        ArrayList[] arrayListArray = new ArrayList[SEDU];
        for (int i = 0; i < SEDU; ++i) {
            arrayListArray[i] = new ArrayList();
        }
        for (File file2 : fileArray = file.listFiles()) {
            String string = file2.getName();
            if (file2.isDirectory()) {
                arrayListArray[STYLE].add(file2);
                continue;
            }
            if (CSUtil.isCatalogFile(string)) {
                arrayListArray[add].add(file2);
                continue;
            }
            if (CSUtil.isOrdinaryReportFile(string)) {
                arrayListArray[addAll].add(file2);
                continue;
            }
            if (CSUtil.isLCFile(string)) {
                arrayListArray[addElement].add(file2);
                continue;
            }
            if (!string.toLowerCase().endsWith(".va")) continue;
            arrayListArray[addResource].add(file2);
        }
        return arrayListArray;
    }

    private static String IRT_GMAPGEO(Folder folder) {
        Vector vector = folder.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            Resource resource;
            ResourceInfo resourceInfo;
            int n;
            Node node = (Node)vector.elementAt(i);
            byte by = node.getNodeType();
            if (by != 2 || (n = (resourceInfo = (resource = (Resource)node).getEntity()).getResourceType()) != 1) continue;
            return resourceInfo.getRealPath();
        }
        return null;
    }

    private static String SEDU(String string) {
        File file;
        String string2;
        File file2 = new File(string);
        if (file2.exists() && (string2 = file2.getParent()) != null && (file = new File(string2)).isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                String string3;
                try {
                    string3 = fileArray[i].getCanonicalPath();
                }
                catch (IOException iOException) {
                    continue;
                }
                if (!CSUtil.isCatalogFile(string3)) continue;
                return string3;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceInfo createResourceInfo(Hashtable hashtable, String string, Folder folder, boolean bl, ResourceTreeManagerImpl resourceTreeManagerImpl) throws UnknownResource {
        byte by = (byte)CSUtil.parseInt((String)hashtable.get("jrs.node_type"), -1);
        if (by == -1) {
            return null;
        }
        String string2 = (String)hashtable.get("jrs.node_name");
        if (string2 == null || string2.trim().length() == 0 || !CSUtil.isValidNodeName(string2)) {
            ServiceLogger.logError(JSvrResource.getMessage("RSC_ERROR4", string2), 3);
            return null;
        }
        if (hashtable != null) {
            ResourceToolkit.saveStyleFiles(WebSecurityUtil.validateFilePathStr((String)hashtable.get("jrs.deploy_local_style_dir")));
        }
        String string3 = null;
        String string4 = null;
        if ((by == 4 || by == 0) && (string3 = ResourceToolkit.IRT_GMAPGEO(folder)) != null) {
            string4 = new File(string3).getParent();
        }
        switch (by) {
            case 2: {
                CatalogInfoImpl catalogInfoImpl = new CatalogInfoImpl();
                catalogInfoImpl.setName(string2);
                String string5 = (String)hashtable.get("jrs.deploy_from_file");
                if (string5 == null || string5.trim().length() == 0) {
                    string5 = (String)hashtable.get("jrs.catalog");
                }
                if (string5 == null || string5.trim().length() == 0) {
                    return null;
                }
                File file = new File(string5);
                if (!file.exists() || !file.isFile()) {
                    return null;
                }
                catalogInfoImpl.setCatalog(ResourceToolkit.addSubFolder(string5, string, resourceTreeManagerImpl));
                return catalogInfoImpl;
            }
            case 4: {
                LCInfoImpl lCInfoImpl = new LCInfoImpl();
                lCInfoImpl.setName(string2);
                String string6 = (String)hashtable.get("jrs.deploy_from_file");
                if (string6 == null || string6.trim().length() == 0) {
                    string6 = (String)hashtable.get("jrs.lc");
                }
                if ((string6 = WebSecurityUtil.validateFilePathStr(string6)) == null || string6.trim().length() == 0) {
                    return null;
                }
                File file = new File(string6);
                if (!file.exists() || !file.isFile()) {
                    return null;
                }
                JetUUniverse jetUUniverse = null;
                try {
                    if (null != string3) {
                        try {
                            jetUUniverse = ServerResourceStoreFactory.getInstance().getResourceStoreByUser(string).getMemoryStore().loadCatalog(new File(string3));
                        }
                        catch (ResourceNotFoundException resourceNotFoundException) {
                            ServiceLogger.logError(resourceNotFoundException);
                        }
                        catch (ResourceLoadException resourceLoadException) {
                            ServiceLogger.logError(resourceLoadException);
                        }
                    }
                    LCObject lCObject = LCObjectIO.loadLCObject((File)file, jetUUniverse, (ResourceStore)ServerResourceStoreFactory.getInstance().getResourceStoreByUser(string));
                    lCInfoImpl.setAuthor(lCObject.getAuthor());
                    lCInfoImpl.setAuthorEmail(lCObject.getAuthorEMail());
                    lCInfoImpl.setBuildinDescription(lCObject.getDescription());
                    if (!string6.startsWith(ResourceToolkit.getHistDir())) {
                        lCInfoImpl.setLc(ResourceToolkit.append(lCObject, string6, string, null, null, string4, resourceTreeManagerImpl, hashtable));
                    } else {
                        lCInfoImpl.setLc(string6);
                    }
                }
                catch (ReadFailureException readFailureException) {
                    ServiceLogger.logError("read LC file " + file.getName() + " error! " + (Object)((Object)readFailureException));
                }
                catch (JUpgradeException jUpgradeException) {
                    ServiceLogger.logError("read LC file " + file.getName() + " error! " + (Object)((Object)jUpgradeException));
                }
                finally {
                    if (jetUUniverse != null) {
                        jetUUniverse.free();
                    }
                }
                return lCInfoImpl;
            }
            case 0: {
                if (bl) {
                    String string7 = "";
                    File file = null;
                    String string8 = ServerEnv.getReportHome();
                    string7 = !string8.endsWith(File.separator) ? string8 + File.separator + "temp" + File.separator + "convertFiles" : string8 + "temp" + File.separator + "convertFiles";
                    file = new File(string7);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    ReportInfoImpl reportInfoImpl = new ReportInfoImpl();
                    reportInfoImpl.setName(string2);
                    String string9 = (String)hashtable.get("jrs.deploy_from_file");
                    if (string9 == null || string9.trim().length() == 0) {
                        string9 = (String)hashtable.get("jrs.report");
                    }
                    if ((string9 = WebSecurityUtil.validateFilePathStr(string9)) == null || string9.trim().length() == 0) {
                        return null;
                    }
                    Converter converter = ConverterFactory.getReportConverter();
                    boolean bl2 = false;
                    try {
                        bl2 = converter.isNeedUpgrade(new File(string9));
                    }
                    catch (ConverterException converterException) {
                        ServiceLogger.logError(converterException, 3);
                    }
                    ConverterFactory.destroy();
                    if (bl2) {
                        File file2;
                        String string10 = ResourceToolkit.SEDU(string9);
                        if (string10 == null) {
                            string10 = ResourceToolkit.IRT_GMAPGEO(folder);
                        }
                        if (!(file2 = new File(string9)).exists() || !file2.isFile()) {
                            return null;
                        }
                        reportInfoImpl.setReportFile(ResourceToolkit.addAll(string9, string10, string, null, null, string4, resourceTreeManagerImpl, hashtable));
                        return reportInfoImpl;
                    }
                    File file3 = new File(string9);
                    if (!file3.exists() || !file3.isFile()) {
                        return null;
                    }
                    boolean bl3 = CSUtil.getBoolean((String)hashtable.get("jrs.report_from_adhoc"), false);
                    if (!bl3 || !string9.startsWith(ResourceToolkit.getHistDir())) {
                        reportInfoImpl.setReportFile(ResourceToolkit.contains(string9, string, null, null, string4, resourceTreeManagerImpl, hashtable));
                    } else {
                        reportInfoImpl.setReportFile(string9);
                    }
                    return reportInfoImpl;
                }
                ReportInfoImpl reportInfoImpl = new ReportInfoImpl();
                reportInfoImpl.setName(string2);
                String string11 = (String)hashtable.get("jrs.deploy_from_file");
                if (string11 == null || string11.trim().length() == 0) {
                    string11 = (String)hashtable.get("jrs.report");
                }
                if ((string11 = WebSecurityUtil.validateFilePathStr(string11)) == null || string11.trim().length() == 0) {
                    return null;
                }
                File file = new File(string11);
                if (!file.exists() || !file.isFile()) {
                    return null;
                }
                boolean bl4 = CSUtil.getBoolean((String)hashtable.get("jrs.report_from_adhoc"), false);
                if (!bl4 || !string11.startsWith(ResourceToolkit.getHistDir())) {
                    reportInfoImpl.setReportFile(ResourceToolkit.contains(string11, string, null, null, string4, resourceTreeManagerImpl, hashtable));
                } else {
                    reportInfoImpl.setReportFile(string11);
                }
                return reportInfoImpl;
            }
            case 1: {
                String string12;
                Object object;
                Object object2;
                ResultInfoImpl resultInfoImpl = new ResultInfoImpl();
                resultInfoImpl.setName(string2);
                int n = -1;
                String string13 = (String)hashtable.get("jrs.catalog");
                if (string13 != null && string13.trim().length() != 0) {
                    try {
                        int n2 = resourceTreeManagerImpl.getNodeByPath((String)hashtable.get("jrs.report"), string).getID();
                        resultInfoImpl.setReportResourceId(n2);
                        n = resourceTreeManagerImpl.getNodeByPath(string13, string).getID();
                        resultInfoImpl.setCatalogReourceId(n);
                    }
                    catch (NoPrivilegeException noPrivilegeException) {
                        ServiceLogger.logError(noPrivilegeException.getMessage());
                    }
                }
                resultInfoImpl.setParamFile((String)hashtable.get("jrs.param_file"));
                Enumeration enumeration = hashtable.keys();
                Hashtable<Object, ResultDetailedInfo> hashtable2 = new Hashtable<Object, ResultDetailedInfo>();
                long l = 0L;
                long l2 = 0L;
                ResultDetailedInfo resultDetailedInfo = null;
                while (enumeration.hasMoreElements()) {
                    String string14;
                    boolean bl5;
                    object2 = (String)enumeration.nextElement();
                    if (!((String)object2).startsWith("jrs.report_sheet$") || !(bl5 = CSUtil.getBoolean(string14 = (String)hashtable.get(object2), true))) continue;
                    object = object2 = ((String)object2).substring("jrs.report_sheet".length() + 1);
                    String string15 = (String)hashtable.get("SheetDisplayName:$" + (String)object2);
                    string12 = (String)hashtable.get(object2);
                    l = CSUtil.parseLong((String)hashtable.get("jrs.pls_result_fmts$" + (String)object2), 0L);
                    l2 = CSUtil.parseLong((String)hashtable.get("jrs.sec_constraint_fmts$" + (String)object2), 0L);
                    resultDetailedInfo = new ResultDetailedInfo((String)object, string15, string12, 0L, l, l2);
                    hashtable2.put(object2, resultDetailedInfo);
                }
                if (hashtable.get("jrs.rst_result") != null) {
                    string12 = (String)hashtable.get("jrs.rst_result");
                    l = CSUtil.parseLong((String)hashtable.get("jrs.pls_result_fmts$jrs.rst_result"), 0L);
                    l2 = CSUtil.parseLong((String)hashtable.get("jrs.sec_constraint_fmts$jrs.rst_result"), 0L);
                    resultDetailedInfo = new ResultDetailedInfo("jrs.rst_result", null, string12, 0L, l, l2);
                    hashtable2.put("jrs.rst_result", resultDetailedInfo);
                }
                if (hashtable.get("jrs.wst_result") != null) {
                    string12 = (String)hashtable.get("jrs.wst_result");
                    l = CSUtil.parseLong((String)hashtable.get("jrs.pls_result_fmts$jrs.wst_result"), 0L);
                    l2 = CSUtil.parseLong((String)hashtable.get("jrs.sec_constraint_fmts$jrs.wst_result"), 0L);
                    resultDetailedInfo = new ResultDetailedInfo("jrs.wst_result", null, string12, 0L, l, l2);
                    hashtable2.put("jrs.wst_result", resultDetailedInfo);
                }
                if (hashtable.get("jrs.rsd_result") != null) {
                    string12 = (String)hashtable.get("jrs.rsd_result");
                    l = CSUtil.parseLong((String)hashtable.get("jrs.pls_result_fmts$jrs.rsd_result"), 0L);
                    l2 = CSUtil.parseLong((String)hashtable.get("jrs.sec_constraint_fmts$jrs.rsd_result"), 0L);
                    resultDetailedInfo = new ResultDetailedInfo("jrs.rsd_result", null, string12, 0L, l, l2);
                    hashtable2.put("jrs.rsd_result", resultDetailedInfo);
                }
                if (hashtable.get("jrs.report_result") != null) {
                    string12 = (String)hashtable.get("jrs.report_result");
                    l = CSUtil.parseLong((String)hashtable.get("jrs.pls_result_fmts$jrs.report_result"), 0L);
                    l2 = CSUtil.parseLong((String)hashtable.get("jrs.sec_constraint_fmts$jrs.report_result"), 0L);
                    resultDetailedInfo = new ResultDetailedInfo("jrs.report_result", null, string12, 0L, l, l2);
                    hashtable2.put("jrs.report_result", resultDetailedInfo);
                }
                resultInfoImpl.setSheetsResultDetails(hashtable2);
                resultInfoImpl.setResultFile(WebSecurityUtil.validateSubPath((String)hashtable.get("jrs.result")));
                resultInfoImpl.setResultFormats(CSUtil.parseLong((String)hashtable.get("jrs.result_type"), 0L));
                resultInfoImpl.setReportAmount(CSUtil.parseInt((String)hashtable.get("jrs.result_report_amount"), -1));
                resultInfoImpl.setLaunchType(CSUtil.parseInt((String)hashtable.get("jrs.launch_type"), 0));
                resultInfoImpl.setTaskId((String)hashtable.get("jrs.task_id"));
                object2 = (Date)hashtable.get("jrs.expired_time");
                if (object2 != null) {
                    resultInfoImpl.setExpire(true);
                    resultInfoImpl.setExpireationTime((Date)object2);
                    resultInfoImpl.setExpireationMethod(CSUtil.parseInt((String)hashtable.get("jrs.auto_delete_method"), 1));
                } else {
                    object = new GregorianCalendar();
                    ((GregorianCalendar)object).add(1, 100);
                    resultInfoImpl.setExpireationTime(((Calendar)object).getTime());
                }
                object = (String)hashtable.get("jrs.archive_specified_destination");
                resultInfoImpl.setSpecifiedFolder((String)object);
                resultInfoImpl.setCatalogVerNum(CSUtil.parseInt((String)hashtable.get("jrs.cat_version"), 0));
                resultInfoImpl.setReportVerNum(CSUtil.parseInt((String)hashtable.get("jrs.rpt_version"), 0));
                return resultInfoImpl;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceInfo STYLE(String string, String string2, String string3, ResourceTreeManagerImpl resourceTreeManagerImpl, Map map) {
        int n = string.lastIndexOf(File.separator);
        String string4 = string.substring(n + 1);
        if (string4 == null || string4.trim().length() == 0 || !CSUtil.isValidNodeName(string4)) {
            ServiceLogger.logError(JSvrResource.getMessage("RSC_ERROR4", string4), 3);
            return null;
        }
        String string5 = null;
        if (string3 != null) {
            string5 = new File(string3).getParent();
        }
        if (CSUtil.isLCFile(string)) {
            LCInfoImpl lCInfoImpl = new LCInfoImpl();
            lCInfoImpl.setName(string4);
            File file = new File(string);
            JetUUniverse jetUUniverse = null;
            try {
                if (null != string3) {
                    try {
                        jetUUniverse = ServerResourceStoreFactory.getInstance().getResourceStoreByUser(string2).getMemoryStore().loadCatalog(new File(string3));
                    }
                    catch (ResourceNotFoundException resourceNotFoundException) {
                        ServiceLogger.logError(resourceNotFoundException);
                    }
                    catch (ResourceLoadException resourceLoadException) {
                        ServiceLogger.logError(resourceLoadException);
                    }
                }
                LCObject lCObject = LCObjectIO.loadLCObject((File)file, jetUUniverse, (ResourceStore)ServerResourceStoreFactory.getInstance().getResourceStoreByUser(string2));
                lCInfoImpl.setAuthor(lCObject.getAuthor());
                lCInfoImpl.setAuthorEmail(lCObject.getAuthorEMail());
                lCInfoImpl.setBuildinDescription(lCObject.getDescription());
                lCInfoImpl.setLc(ResourceToolkit.append(lCObject, string, string2, null, null, string5, resourceTreeManagerImpl, map));
            }
            catch (ReadFailureException readFailureException) {
                ServiceLogger.logError("read LC file " + file.getName() + " error! " + (Object)((Object)readFailureException));
            }
            catch (JUpgradeException jUpgradeException) {
                ServiceLogger.logError("read LC file " + file.getName() + " error! " + (Object)((Object)jUpgradeException));
            }
            finally {
                if (jetUUniverse != null) {
                    jetUUniverse.free();
                }
            }
            return lCInfoImpl;
        }
        if (string4.toUpperCase().endsWith(".CAT") || string4.toUpperCase().endsWith(".CAT.XML")) {
            String string6 = ResourceToolkit.addSubFolder(string, string2, resourceTreeManagerImpl);
            CatalogInfoImpl catalogInfoImpl = new CatalogInfoImpl();
            catalogInfoImpl.setName(string4);
            catalogInfoImpl.setCatalog(string6);
            return catalogInfoImpl;
        }
        String string7 = ResourceToolkit.contains(string, string2, null, null, string5, resourceTreeManagerImpl, map);
        ReportInfoImpl reportInfoImpl = new ReportInfoImpl();
        reportInfoImpl.setName(string4);
        reportInfoImpl.setReportFile(string7);
        return reportInfoImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceInfo add(String string, String string2, String string3, String string4, ResourceTreeManagerImpl resourceTreeManagerImpl, Map map) {
        int n = string.lastIndexOf(File.separator);
        String string5 = string.substring(n + 1);
        if (string5 == null || string5.trim().length() == 0 || !CSUtil.isValidNodeName(string5)) {
            ServiceLogger.logError(JSvrResource.getMessage("RSC_ERROR4", string5), 3);
            return null;
        }
        String string6 = null;
        if (string4 != null) {
            string6 = new File(string4).getParent();
        }
        if (CSUtil.isLCFile(string)) {
            LCInfoImpl lCInfoImpl = new LCInfoImpl();
            lCInfoImpl.setName(string5);
            File file = new File(string);
            JetUUniverse jetUUniverse = null;
            try {
                if (null != string4) {
                    try {
                        jetUUniverse = ServerResourceStoreFactory.getInstance().getResourceStoreByUser(string3).getMemoryStore().loadCatalog(new File(string4));
                    }
                    catch (ResourceNotFoundException resourceNotFoundException) {
                        ServiceLogger.logError(resourceNotFoundException);
                    }
                    catch (ResourceLoadException resourceLoadException) {
                        ServiceLogger.logError(resourceLoadException);
                    }
                }
                LCObject lCObject = LCObjectIO.loadLCObject((File)file, jetUUniverse, (ResourceStore)ServerResourceStoreFactory.getInstance().getResourceStoreByUser(string3));
                lCInfoImpl.setAuthor(lCObject.getAuthor());
                lCInfoImpl.setAuthorEmail(lCObject.getAuthorEMail());
                lCInfoImpl.setBuildinDescription(lCObject.getDescription());
                lCInfoImpl.setLc(ResourceToolkit.append(lCObject, string, string3, null, null, string6, resourceTreeManagerImpl, map));
            }
            catch (ReadFailureException readFailureException) {
                ServiceLogger.logError("read LC file " + file.getName() + " error! " + (Object)((Object)readFailureException));
            }
            catch (JUpgradeException jUpgradeException) {
                ServiceLogger.logError("read LC file " + file.getName() + " error! " + (Object)((Object)jUpgradeException));
            }
            finally {
                if (jetUUniverse != null) {
                    jetUUniverse.free();
                }
            }
            return lCInfoImpl;
        }
        if (string5.toUpperCase().endsWith(".CAT") || string5.toUpperCase().endsWith(".CAT.XML")) {
            String string7 = ResourceToolkit.addSubFolder(string, string3, resourceTreeManagerImpl);
            CatalogInfoImpl catalogInfoImpl = new CatalogInfoImpl();
            catalogInfoImpl.setName(string5);
            catalogInfoImpl.setCatalog(string7);
            return catalogInfoImpl;
        }
        String string8 = ResourceToolkit.addAll(string, string2, string3, null, null, string6, resourceTreeManagerImpl, map);
        ReportInfoImpl reportInfoImpl = new ReportInfoImpl();
        reportInfoImpl.setName(string5);
        reportInfoImpl.setReportFile(string8);
        return reportInfoImpl;
    }

    private static String addAll(String string, String string2, String string3, String string4, Vector vector, String string5, ResourceTreeManagerImpl resourceTreeManagerImpl, Map map) {
        String string6 = WebSecurityUtil.validateFilePathStr(string4);
        if (string6 == null) {
            string6 = resourceTreeManagerImpl.getVersionService().getArchivePath(string3);
        }
        if (!string6.endsWith(File.separator)) {
            string6 = string6 + File.separator;
        }
        int n = string.lastIndexOf(File.separator);
        String string7 = string.substring(n + 1);
        String string8 = string.substring(0, n);
        String string9 = null;
        if (!string.toLowerCase().endsWith(".dsh")) {
            string9 = ResourceToolkit.addResource(string, string2, string3);
        }
        if (string9 == null) {
            string9 = string;
        }
        SchdTools.copyFile(new File(string9), new File(string6, string7));
        try {
            if (string.endsWith(".cls") || string.endsWith(".rpt") || string.endsWith(".clx") || string.endsWith(".cls.xml") || string.endsWith(".wls") || string.endsWith(".dsh") || string.endsWith(".va")) {
                Vector[] vectorArray = RefResource.getRptFilesWithoutEnv(string, map);
                if (vectorArray != null) {
                    Vector vector2;
                    Vector vector3;
                    Vector vector4;
                    Vector vector5;
                    if (0 < vectorArray.length && vectorArray[0] != null) {
                        ResourceToolkit.addElement(string8, string6, vectorArray[0], string2, string3);
                    }
                    if (1 < vectorArray.length && vectorArray[1] != null) {
                        ResourceToolkit.copyRefFiles(string8, string6, vectorArray[1]);
                    }
                    if (4 < vectorArray.length && vectorArray[4] != null) {
                        ResourceToolkit.copyRefFiles(string8, string6, vectorArray[4]);
                    }
                    if (8 < vectorArray.length && vectorArray[8] != null) {
                        ResourceToolkit.copyRefFiles(string8, string5, vectorArray[8]);
                    }
                    if (6 < vectorArray.length && vectorArray[6] != null) {
                        ResourceToolkit.addElement(string8, string6, vectorArray[6], string2, string3);
                    }
                    ResourceToolkit.copyRefFiles(string8, string, map == null ? null : WebSecurityUtil.validateFilePathStr((String)map.get("jrs.deploy_local_font_dir")), vectorArray[2]);
                    Vector vector6 = vector5 = 3 < vectorArray.length ? vectorArray[3] : null;
                    if (vector5 != null && vector5.size() > 0) {
                        vector4 = map != null ? (String)map.get("jrs.deploy_local_style_dir") : null;
                        ResourceToolkit.copyFile(WebSecurityUtil.validateFilePathStr((String)((Object)vector4)), vector5, ServerEnv.stylePath);
                    }
                    Vector vector7 = vector4 = JReportUtil.IRT_GMAPGEO < vectorArray.length ? vectorArray[JReportUtil.IRT_GMAPGEO] : null;
                    if (vector4 != null && vector4.size() > 0) {
                        vector3 = map != null ? (String)map.get("jrs.deploy_local_gisinfo_dir") : null;
                        ResourceToolkit.copyFile((String)((Object)vector3), vector4, ServerEnv.getGisinfoPath());
                    }
                    if ((vector3 = vectorArray[0]) != null && vector3.size() > 0) {
                        if (vector == null) {
                            vector = new Vector();
                        }
                        for (int i = 0; i < vector3.size(); ++i) {
                            if (vector.contains(vector3.elementAt(i))) continue;
                            vector.add(vector3.elementAt(i));
                            ResourceToolkit.addAll(string8 + File.separator + (String)vector3.elementAt(i), string2, string3, string6, vector, string5, resourceTreeManagerImpl, map);
                        }
                    }
                    Vector vector8 = vector2 = 6 < vectorArray.length ? vectorArray[6] : null;
                    if (vector2 != null && vector2.size() > 0) {
                        if (vector == null) {
                            vector = new Vector();
                        }
                        for (int i = 0; i < vector2.size(); ++i) {
                            if (vector.contains(vector2.elementAt(i))) continue;
                            vector.add(vector2.elementAt(i));
                            ResourceToolkit.addAll(string8 + File.separator + (String)vector2.elementAt(i), string2, string3, string6, vector, string5, resourceTreeManagerImpl, map);
                        }
                    }
                }
            } else if (string.endsWith(".xpt") || string.endsWith(".xpt.xml")) {
                String string10 = string7.substring(0, string7.lastIndexOf(".xpt"));
                WildcardMatcher wildcardMatcher = new WildcardMatcher(string10 + ".*", false, 2);
                File file = new File(string8);
                String[] stringArray = file.list((FilenameFilter)wildcardMatcher);
                for (int i = 0; i < stringArray.length; ++i) {
                    SchdTools.copyFile(new File(file, stringArray[i]), new File(string6, stringArray[i]));
                }
            } else {
                SchdTools.copyFile(new File(string), new File(string6, string7));
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 2);
        }
        return string6 + string7;
    }

    private static void addElement(String string, String string2, Vector vector, String string3, String string4) {
        Converter converter = ConverterFactory.getReportConverter();
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        if (vector != null) {
            int n = vector.size();
            ReportConvertEnvImpl reportConvertEnvImpl = new ReportConvertEnvImpl((ResourceStore)JRServerResourceStoreFactory.getInstance().getResourceStoreByUser(string4), string3);
            for (int i = 0; i < n; ++i) {
                String string5 = (String)vector.elementAt(i);
                String string6 = string + string5;
                File file = new File(string6);
                boolean bl = false;
                if (!string6.toLowerCase().endsWith(".dsh")) {
                    try {
                        bl = converter.isNeedUpgrade(file);
                    }
                    catch (ConverterException converterException) {
                        ServiceLogger.logError(converterException, 3);
                    }
                }
                if (bl) {
                    String string7 = string2.endsWith(File.separator) ? string2 + string5 : string2 + File.separator + string5;
                    try {
                        converter.doUpgrade(file, file, (ConverterEnv)reportConvertEnvImpl);
                    }
                    catch (ConverterException converterException) {
                        ServiceLogger.logError(converterException);
                    }
                    ConverterFactory.destroy();
                    continue;
                }
                SchdTools.copyFile(new File(string, string5), new File(string2, string5));
            }
        }
    }

    private static String addResource(String string, String string2, String string3) {
        Converter converter = ConverterFactory.getReportConverter();
        String string4 = ServerEnv.getReportHome();
        String string5 = !string4.endsWith(File.separator) ? string4 + File.separator + "temp" + File.separator + "convertFiles" : string4 + "temp" + File.separator + "convertFiles";
        File file = new File(string5);
        if (!file.exists()) {
            file.mkdirs();
        }
        String string6 = new File(string).getName();
        String string7 = string5 + File.separator + string6;
        ReportConvertEnvImpl reportConvertEnvImpl = new ReportConvertEnvImpl((ResourceStore)JRServerResourceStoreFactory.getInstance().getResourceStoreByUser(string3), string2);
        try {
            converter.doUpgrade(new File(string), new File(string7), (ConverterEnv)reportConvertEnvImpl);
        }
        catch (ConverterException converterException) {
            ServiceLogger.logError(converterException);
            return null;
        }
        ConverterFactory.destroy();
        return string7;
    }

    public static void setHistDir(String string) {
        FONT = string;
    }

    public static void setReportHome(String string) {
    }

    protected static String getHistDir() {
        if (FONT == null) {
            if (ServerEnv.isSharedHistDir()) {
                FONT = ServerEnv.getSharedHistDir();
            } else {
                String string = ServerEnv.homePath;
                if (!string.endsWith(File.separator)) {
                    string = string + File.separator;
                }
                FONT = string + "history";
            }
        }
        if (!FONT.endsWith(File.separator)) {
            FONT = FONT + File.separator;
        }
        return FONT;
    }

    private static String addSubFolder(String string, String string2, ResourceTreeManagerImpl resourceTreeManagerImpl) {
        String string3 = resourceTreeManagerImpl.getVersionService().getArchivePath(string2);
        if (!string3.endsWith(File.separator)) {
            string3 = string3 + File.separator;
        }
        int n = string.lastIndexOf(File.separator);
        String string4 = string.substring(n + 1);
        String string5 = string.substring(0, n);
        try {
            String string6;
            Vector vector = RefResource.getCatRefFiles(string);
            if (vector != null) {
                string6 = string4.substring(0, string4.toLowerCase().lastIndexOf(".cat"));
                string6 = string6 + "_ref.*";
                for (int i = vector.size() - 1; i >= 0; --i) {
                    String string7 = (String)vector.get(i);
                    if (!WildcardMatcher.matchWildcard((String)string7, (String)string6, (boolean)false)) continue;
                    vector.remove(i);
                }
                ResourceToolkit.copyRefFiles(string5, string3, vector);
            }
            string6 = string4;
            try {
                ServerUtil.checkMLSAndFmlInCat(string3, string6);
            }
            catch (ReadFailureException readFailureException) {
                ServiceLogger.logError(readFailureException);
            }
            catch (UniverseFileException universeFileException) {
                ServiceLogger.logError(universeFileException);
            }
            catch (FMLFileException fMLFileException) {
                ServiceLogger.logError(fMLFileException);
            }
            catch (WriteFailureException writeFailureException) {
                ServiceLogger.logError(writeFailureException);
            }
            Vector vector2 = new Vector();
            if (RefResource.hasHierDataSource(string) && (vector2 = ResourceToolkit.checkMLSAndFmlInCat(string)) != null) {
                ResourceToolkit.copyRefFiles(string5, string3, vector2);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        return string3 + string4;
    }

    private static String append(LCObject lCObject, String string, String string2, String string3, List linkedList, String string4, ResourceTreeManagerImpl resourceTreeManagerImpl, Map map) {
        String string5 = string3;
        if (string5 == null) {
            string5 = resourceTreeManagerImpl.getVersionService().getArchivePath(string2);
        }
        if (!string5.endsWith(File.separator)) {
            string5 = string5 + File.separator;
        }
        int n = string.lastIndexOf(File.separator);
        String string6 = string.substring(n + 1);
        String string7 = string.substring(0, n);
        File file = new File(string);
        SchdTools.copyFile(file, new File(string5, string6));
        try {
            List<List<String>> list = RefResource.getLcRefFiles(lCObject, file, map);
            if (list != null) {
                LinkedList linkedList2;
                List<String> list2;
                List<String> list3;
                if (0 < list.size() && list.get(0) != null) {
                    ResourceToolkit.copyRefFiles(string7, string5, list.get(0));
                }
                if (1 < list.size() && list.get(1) != null) {
                    ResourceToolkit.copyRefFiles(string7, string5, list.get(1));
                }
                if (2 < list.size() && list.get(2) != null) {
                    ResourceToolkit.copyRefFiles(string7, string5, list.get(2));
                }
                if (3 < list.size() && list.get(3) != null) {
                    ResourceToolkit.copyRefFiles(string7, string5, list.get(3));
                }
                if (4 < list.size() && list.get(4) != null) {
                    ResourceToolkit.copyRefFiles(string7, string5, list.get(4));
                }
                if (5 < list.size() && list.get(5) != null) {
                    ResourceToolkit.copyRefFiles(string7, string5, list.get(5));
                }
                if (9 < list.size() && list.get(9) != null) {
                    ResourceToolkit.copyRefFiles(string7, string4, list.get(9));
                }
                ResourceToolkit.copyRefFiles(string7, string, map == null ? null : WebSecurityUtil.validateFilePathStr((String)map.get("jrs.deploy_local_font_dir")), list.get(6));
                List<String> list4 = list3 = 7 < list.size() ? list.get(7) : null;
                if (list3 != null && list3.size() > 0) {
                    list2 = map != null ? (String)map.get("jrs.deploy_local_style_dir") : null;
                    ResourceToolkit.copyFile(WebSecurityUtil.validateFilePathStr(list2), list3, ServerEnv.stylePath);
                }
                List<String> list5 = list2 = 8 < list.size() ? list.get(8) : null;
                if (list2 != null && list2.size() > 0) {
                    linkedList2 = map != null ? (String)map.get("jrs.deploy_local_gisinfo_dir") : null;
                    ResourceToolkit.copyFile(WebSecurityUtil.validateFilePathStr(linkedList2), list2, ServerEnv.getGisinfoPath());
                }
                linkedList2 = new LinkedList();
                if (list.get(0) != null) {
                    linkedList2.addAll(list.get(0));
                }
                if (list.get(1) != null) {
                    linkedList2.addAll(list.get(1));
                }
                if (list.get(2) != null) {
                    linkedList2.addAll(list.get(2));
                }
                if (linkedList == null) {
                    linkedList = new LinkedList<String>();
                }
                for (String string8 : linkedList2) {
                    if (linkedList.contains(string8)) continue;
                    linkedList.add(string8);
                    ResourceToolkit.contains(string7 + File.separator + string8, string2, string5, linkedList, string4, resourceTreeManagerImpl, map);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ServiceLogger.logError(exception, 3);
        }
        return string5 + string6;
    }

    private static Vector checkMLSAndFmlInCat(String string) throws Exception {
        Vector vector = new Vector();
        int n = string.lastIndexOf(File.separator);
        String string2 = string.substring(0, n);
        File file = new File(string2);
        if (file.exists() && file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || !stringArray[i].endsWith(".cls") && !stringArray[i].endsWith(".cls.xml") && !stringArray[i].endsWith(".wls") && !stringArray[i].endsWith(".dsh") && !stringArray[i].endsWith(".va")) continue;
                String string3 = string2 + File.separator + stringArray[i];
                Vector vector2 = null;
                vector2 = RefResource.getHdsFiles(string, string3);
                if (vector2 == null || vector2.size() <= 0) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    vector.addElement(vector2.elementAt(j));
                }
            }
        }
        return vector;
    }

    private static String contains(String string, String string2, String string3, List linkedList, String string4, ResourceTreeManagerImpl resourceTreeManagerImpl, Map map) {
        String string5 = string3;
        if (string5 == null) {
            string5 = resourceTreeManagerImpl.getVersionService().getArchivePath(string2);
        }
        if (!string5.endsWith(File.separator)) {
            string5 = string5 + File.separator;
        }
        int n = string.lastIndexOf(File.separator);
        String string6 = string.substring(n + 1);
        String string7 = string.substring(0, n);
        SchdTools.copyFile(new File(string), new File(string5, string6));
        try {
            Object object;
            Serializable serializable;
            if ((string.endsWith(".rpt") || string.endsWith(".clx")) && ((File)(serializable = new File(string7, (String)(object = string6.substring(0, string6.indexOf("."))) + ".auth"))).exists()) {
                SchdTools.copyFile(new File(string7, (String)object + ".auth"), new File(string5, (String)object + ".auth"));
            }
            if (string.endsWith(".cls") || string.endsWith(".rpt") || string.endsWith(".clx") || string.endsWith(".cls.xml") || string.endsWith(".wls") || string.endsWith(".dsh") || string.endsWith(".va")) {
                object = RefResource.getRptFilesWithoutEnv(string, map);
                if (object != null) {
                    LinkedList linkedList2;
                    Vector vector;
                    if (0 < ((Vector[])object).length && object[0] != null) {
                        ResourceToolkit.copyRefFiles(string7, string5, object[0]);
                    }
                    if (1 < ((Vector[])object).length && object[1] != null) {
                        ResourceToolkit.copyRefFiles(string7, string5, object[1]);
                    }
                    if (4 < ((Vector[])object).length && object[4] != null) {
                        ResourceToolkit.copyRefFiles(string7, string5, object[4]);
                    }
                    if (8 < ((Vector[])object).length && object[8] != null) {
                        ResourceToolkit.copyRefFiles(string7, string4, object[8]);
                    }
                    if (6 < ((Vector[])object).length && object[6] != null) {
                        ResourceToolkit.copyRefFiles(string7, string5, object[6]);
                    }
                    ResourceToolkit.copyRefFiles(string7, string, map == null ? null : WebSecurityUtil.validateFilePathStr((String)map.get("jrs.deploy_local_font_dir")), object[2]);
                    serializable = object[3];
                    if (serializable != null && ((Vector)serializable).size() > 0) {
                        vector = map != null ? (String)map.get("jrs.deploy_local_style_dir") : null;
                        ResourceToolkit.copyFile(WebSecurityUtil.validateFilePathStr((String)((Object)vector)), (List)((Object)serializable), ServerEnv.stylePath);
                    }
                    Vector vector2 = vector = JReportUtil.IRT_GMAPGEO < ((Vector[])object).length ? object[JReportUtil.IRT_GMAPGEO] : null;
                    if (vector != null && vector.size() > 0) {
                        linkedList2 = map != null ? (String)map.get("jrs.deploy_local_gisinfo_dir") : null;
                        ResourceToolkit.copyFile(linkedList2, vector, ServerEnv.getGisinfoPath());
                    }
                    linkedList2 = new LinkedList();
                    if (object[0] != null) {
                        linkedList2.addAll(object[0]);
                    }
                    if (object[6] != null) {
                        linkedList2.addAll(object[6]);
                    }
                    if (linkedList == null) {
                        linkedList = new LinkedList<String>();
                    }
                    for (String string8 : linkedList2) {
                        if (linkedList.contains(string8)) continue;
                        linkedList.add(string8);
                        ResourceToolkit.contains(string7 + File.separator + string8, string2, string5, linkedList, string4, resourceTreeManagerImpl, map);
                    }
                }
            } else if (string.endsWith(".xpt") || string.endsWith(".xpt.xml")) {
                object = string6.substring(0, string6.lastIndexOf(".xpt"));
                serializable = new WildcardMatcher((String)object + ".*", false, 2);
                File file = new File(string7);
                String[] stringArray = file.list((FilenameFilter)((Object)serializable));
                for (int i = 0; i < stringArray.length; ++i) {
                    SchdTools.copyFile(new File(file, stringArray[i]), new File(string5, stringArray[i]));
                }
            } else if (string.endsWith(".dsh")) {
                object = DashboardProvider.getDashboardResource(string);
                ResourceToolkit.copyRefFiles(string7, string5, (List)object);
            } else if (!string.endsWith(".va")) {
                SchdTools.copyFile(new File(string), new File(string5, string6));
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable, 2);
        }
        return string5 + string6;
    }

    static void copyRefFiles(String string, String string2, List list) {
        if (list != null) {
            for (String string3 : list) {
                File file = new File(string, string3);
                if (file.exists()) {
                    File file2 = new File(string2, string3);
                    File file3 = file2.getParentFile();
                    if (!file3.exists()) {
                        file3.mkdirs();
                    }
                    SchdTools.copyFile(new File(string, string3), new File(string2, string3));
                    continue;
                }
                ServiceLogger.logError(3620030, file.getAbsolutePath(), 3);
            }
        }
    }

    public static ExProperties getResources(String string) {
        String string2 = ServerEnv.realmsPath + string + File.separator + "resource.alias";
        ExProperties exProperties = new ExProperties();
        if (!new File(string2).exists()) {
            return null;
        }
        try {
            exProperties.load(string2);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        if (ServerEnv.getResourceRoot() != null) {
            exProperties.setProperty("/", ServerEnv.getResourceRoot());
        }
        return exProperties;
    }

    private static void copyFile(String string, List list, String string2) {
        if (string != null && string.trim().length() > 0) {
            File file = new File(string);
            boolean bl = string2.equals(ServerEnv.getFontPath());
            boolean bl2 = string2.equals(ServerEnv.stylePath);
            boolean bl3 = string2.equals(ServerEnv.getGisinfoPath());
            for (String string3 : list) {
                File file2 = new File(file, string3 = CSUtil.getFileNameOnly(string3));
                if (!file2.exists()) continue;
                SchdTools.copyFile(file2, new File(string2, string3));
                try {
                    if (bl) {
                        StorageEnv.getStorage().add(Storage.StorageRoot.FONT, string3, null);
                        continue;
                    }
                    if (bl2) {
                        StorageEnv.getStorage().add(Storage.StorageRoot.STYLE, string3, null);
                        continue;
                    }
                    if (!bl3) continue;
                    StorageEnv.getStorage().add(Storage.StorageRoot.GISINFO, string3, null);
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
            }
        }
    }

    public static void saveStyleFiles(String string) {
        if (string == null) {
            return;
        }
        try {
            Vector vector = new Vector();
            vector = RefResource.getStyleFilesByExt(string);
            if (vector != null && vector.size() > 0) {
                ResourceToolkit.copyFile(string, vector, ServerEnv.stylePath);
            }
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
    }

    private static void copyRefFiles(String string, String string2, String string3, List list) {
        if (string2 == null) {
            return;
        }
        try {
            if (list != null && list.size() > 0) {
                ResourceToolkit.copyFile(string3, list, ServerEnv.getFontPath());
            }
            if (string2.endsWith(".dsh") || string2.endsWith(".va")) {
                return;
            }
            Vector vector = RefResource.getFontFiles(string2, string3);
            if (vector != null && vector.size() > 0) {
                ResourceToolkit.copyFile(string3, vector, ServerEnv.getFontPath());
            }
            if (vector != null && vector.size() > 0 || list != null && list.size() > 0) {
                FontSets.reGetAllFonts();
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public static synchronized String convertingOldReport(String string, String string2) throws Exception {
        return ResourceToolkit.currentTimeMillis(string2, string, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String currentTimeMillis(String string, String string2, String object, Vector vector) throws Exception {
        ++IRT_GMAPGEO;
        String string3 = string + "[" + string2 + "]";
        String string4 = null;
        String string5 = null;
        Properties properties = GISINFO;
        synchronized (properties) {
            String string6;
            Object object2;
            string4 = GISINFO.getProperty(string3);
            if (string4 != null && string4.length() != 0) {
                object2 = new File(string4);
                if (object == null && ((File)object2).isFile() && CSUtil.isReportFile(string4)) {
                    return string4;
                }
                GISINFO.remove(string3);
            }
            if (object == null) {
                String string7;
                int n = string.indexOf("history");
                if (n != -1) {
                    string7 = string.substring(n + 8);
                    n = string7.lastIndexOf(File.separator);
                    string7 = string7.substring(0, n);
                } else {
                    string7 = String.valueOf(System.currentTimeMillis());
                }
                string6 = ServerEnv.getReportHome();
                object2 = !string6.endsWith(File.separator) ? string6 + File.separator + "temp" + File.separator + "runingConvertFiles" + string7 + "_" + IRT_GMAPGEO : string6 + "temp" + File.separator + "runingConvertFiles" + File.separator + string7 + "_" + IRT_GMAPGEO;
                object = object2;
            }
            if (!((File)(object2 = new File((String)object))).exists()) {
                ((File)object2).mkdirs();
            }
            int n = string.lastIndexOf(File.separator);
            String string8 = string.substring(n + 1);
            string6 = string.substring(0, n);
            Converter converter = ConverterFactory.getReportConverter();
            string5 = (String)object + File.separator + string8;
            ReportConvertEnvImpl reportConvertEnvImpl = new ReportConvertEnvImpl((ResourceStore)JRServerResourceStoreFactory.getInstance().getResourceStoreByResourcePath(string2), string2);
            ServiceLogger.logDebug(6620024, new Object[]{string, string2, string5}, 6);
            converter.doUpgrade(new File(string), new File(string5), (ConverterEnv)reportConvertEnvImpl);
            ServiceLogger.logDebug(6620025, string5, 6);
            ConverterFactory.destroy();
            if (string.endsWith(".cls") || string.endsWith(".rpt") || string.endsWith(".clx") || string.endsWith(".cls.xml") || string.endsWith(".wls") || string.endsWith(".dsh") || string.endsWith(".va")) {
                Vector[] vectorArray = RefResource.getRptFilesWithoutEnv(string, null);
                if (vectorArray != null) {
                    int n2;
                    Vector vector2;
                    if (vectorArray[0] != null && (vector2 = vectorArray[0]) != null && vector2.size() > 0) {
                        if (vector == null) {
                            vector = new Vector();
                        }
                        for (n2 = 0; n2 < vector2.size(); ++n2) {
                            if (vector.contains(vector2.elementAt(n2))) continue;
                            vector.add(vector2.elementAt(n2));
                            ResourceToolkit.currentTimeMillis(string6 + File.separator + vector2.elementAt(n2), string2, (String)object, vector);
                        }
                    }
                    if (6 < vectorArray.length && vectorArray[6] != null && (vector2 = vectorArray[6]) != null && vector2.size() > 0) {
                        if (vector == null) {
                            vector = new Vector();
                        }
                        for (n2 = 0; n2 < vector2.size(); ++n2) {
                            if (vector.contains(vector2.elementAt(n2))) continue;
                            vector.add(vector2.elementAt(n2));
                            ResourceToolkit.currentTimeMillis(string6 + File.separator + vector2.elementAt(n2), string2, (String)object, vector);
                        }
                    }
                    if (4 < vectorArray.length && vectorArray[4] != null) {
                        ResourceToolkit.copyRefFiles(string6, (String)object, vectorArray[4]);
                    }
                }
            } else if (string.endsWith(".xpt") || string.endsWith(".xpt.xml")) {
                String string9 = string8.substring(0, string8.lastIndexOf(".xpt"));
                WildcardMatcher wildcardMatcher = new WildcardMatcher(string9 + ".*", false, 2);
                File file = new File(string6);
                String[] stringArray = file.list((FilenameFilter)wildcardMatcher);
                for (int i = 0; i < stringArray.length; ++i) {
                    SchdTools.copyFile(new File(file, stringArray[i]), new File((String)object, stringArray[i]));
                }
            } else {
                SchdTools.copyFile(new File(string), new File((String)object, string8));
            }
            GISINFO.setProperty(string3, string5);
        }
        return string5;
    }
}

