/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource;

import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.api.ResultFiles;
import jet.server.api.ResultVersionRecord;
import jet.server.db.version.ResultDetailedInfo;
import jet.server.jrc.resource.VersionRecordImpl;
import jet.server.schedule.JRResultFiles;

public class ResultVersionRecordImpl
extends VersionRecordImpl
implements ResultVersionRecord {
    private String SEDU;
    private String add;
    private String containsKey;
    private String elementAt;
    private String endsWith;
    private long equals;
    private Date equalsIgnoreCase;
    private int get;
    private String getAllResultFiles;
    private int getCreatedTime;
    private Hashtable getCreator = null;
    private int getExtName = -1;

    public ResultVersionRecordImpl(String string, String string2, int n, String string3, String string4, String string5, String string6, String string7, String string8, long l, Date date, Date date2, int n2, String string9, int n3, int n4, Hashtable hashtable) {
        super(string, n, string2, date, string8, string6);
        Serializable serializable;
        this.SEDU = string3 == null ? "" : string3;
        this.add = string4 == null ? "" : string4;
        this.containsKey = string5 == null ? "" : string5;
        this.elementAt = string6 == null ? "" : string6;
        this.endsWith = string7 == null ? "" : string7;
        this.equals = l;
        if (date2 == null) {
            serializable = new GregorianCalendar();
            serializable.add(1, 100);
            this.equalsIgnoreCase = serializable.getTime();
        } else {
            this.equalsIgnoreCase = date2;
        }
        this.getCreatedTime = n3;
        this.get = n2;
        this.getAllResultFiles = string9;
        this.getExtName = n4;
        this.getCreator = new Hashtable();
        if (hashtable != null && hashtable.size() > 0) {
            this.SEDU(hashtable);
        } else if (string6 != null && string6.length() > 0) {
            serializable = null;
            serializable = l != 0L ? new JRResultFiles(string6, l, 0L, 0L, 0L, n4) : new JRResultFiles(CSUtil.getNameWithoutExt(string6), CSUtil.getExtName(string6));
            this.getCreator.put("jrs.report_result", serializable);
        }
    }

    @Override
    public String getCatalogFile() {
        return this.SEDU;
    }

    @Override
    public Date getExpirationTime() {
        return this.equalsIgnoreCase;
    }

    public int getLaunchType() {
        return this.get;
    }

    @Override
    public String getParamFile() {
        return this.containsKey;
    }

    @Override
    public String getReportFile() {
        return this.add;
    }

    @Override
    public String getResultFile() {
        ResultFiles resultFiles = this.getAllResultFiles();
        if (resultFiles != null) {
            Vector vector = resultFiles.getResultFileNames();
            return (String)vector.elementAt(0);
        }
        return null;
    }

    @Override
    public ResultFiles getAllResultFiles() {
        Enumeration enumeration = this.getCreator.keys();
        if (enumeration.hasMoreElements()) {
            Object v = this.getCreator.get("jrs.report_result");
            if (v == null) {
                v = this.getCreator.get("jrs.rst_result");
            }
            if (v == null) {
                v = this.getCreator.get("jrs.rsd_result");
            }
            if (v == null) {
                v = this.getCreator.get("jrs.wst_result");
            }
            if (v == null) {
                String string = (String)enumeration.nextElement();
                v = this.getCreator.get(string);
            }
            return (ResultFiles)v;
        }
        return null;
    }

    @Override
    public Hashtable getAllReportResultFiles() {
        return this.getCreator;
    }

    private void SEDU(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ResultDetailedInfo resultDetailedInfo = (ResultDetailedInfo)hashtable.get(string);
            String string2 = resultDetailedInfo.getResult();
            long l = resultDetailedInfo.getViewedFormats();
            long l2 = resultDetailedInfo.getPlsResultBits();
            long l3 = resultDetailedInfo.getSecConstraintBits();
            JRResultFiles jRResultFiles = null;
            if (string.equalsIgnoreCase("jrs.rst_result")) {
                if (string2.endsWith(".rst")) {
                    string2 = CSUtil.getNameWithoutExt(string2);
                }
                jRResultFiles = new JRResultFiles(string2, ".rst", l, l2, l3);
            } else if (string.equalsIgnoreCase("jrs.rsd_result")) {
                if (string2.endsWith(".rsd")) {
                    string2 = CSUtil.getNameWithoutExt(string2);
                }
                jRResultFiles = new JRResultFiles(string2, ".rsd", l, l2, l3);
            } else if (string.equalsIgnoreCase("jrs.wst_result")) {
                if (string2.endsWith(".wst")) {
                    string2 = CSUtil.getNameWithoutExt(string2);
                }
                jRResultFiles = new JRResultFiles(string2, ".wst", l, l2, l3);
            } else if (this.equals != 0L) {
                jRResultFiles = new JRResultFiles(string2, this.equals, l, l2, l3, this.getExtName);
                jRResultFiles.removeFormat(0);
                jRResultFiles.removeFormat(12);
                jRResultFiles.removeFormat(13);
                String string3 = this.add(resultDetailedInfo, string);
                jRResultFiles.setReportName(string);
                jRResultFiles.setReportDisplayName(string3);
            } else {
                jRResultFiles = new JRResultFiles(CSUtil.getNameWithoutExt(string2), CSUtil.getExtName(string2));
            }
            this.getCreator.put(string, jRResultFiles);
        }
    }

    private String add(ResultDetailedInfo resultDetailedInfo, String string) {
        String string2 = resultDetailedInfo.getReportDisplayname();
        if (string2 == null && !string.equalsIgnoreCase("jrs.rst_result") && !string.equalsIgnoreCase("jrs.rsd_result")) {
            string2 = string;
        }
        return string2;
    }

    @Override
    public String getSubmitter() {
        return this.getCreator();
    }

    public String getTaskID() {
        return this.endsWith;
    }

    @Override
    public Properties toProperties(Properties properties) {
        Properties properties2 = properties;
        if (properties2 == null) {
            properties2 = new Properties();
        }
        properties2.put("jrs.version_id", this.endsWith);
        properties2.put("jrs.catalog", this.SEDU);
        properties2.put("jrs.report", this.add);
        properties2.put("jrs.param_file", this.containsKey);
        if (this.getCreator.get("jrs.report_result") != null) {
            JRResultFiles jRResultFiles = (JRResultFiles)this.getAllResultFiles();
            if (jRResultFiles != null) {
                properties2.put("jrs.result", jRResultFiles == null ? null : jRResultFiles.getResultFileNames());
            }
        } else {
            Vector vector = new Vector();
            Enumeration enumeration = this.getCreator.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                JRResultFiles jRResultFiles = (JRResultFiles)this.getCreator.get(string);
                Vector vector2 = jRResultFiles.getResultFileNames();
                for (int i = 0; i < vector2.size(); ++i) {
                    vector.add(vector2.elementAt(i));
                }
            }
            properties2.put("jrs.result", vector);
        }
        properties2.put("jrs.created_time", String.valueOf(this.getCreatedTime().getTime()));
        properties2.put("jrs.expired_time", String.valueOf(this.equalsIgnoreCase.getTime()));
        properties2.put("jrs.uid", this.getCreator());
        properties2.put("jrs.version_number", String.valueOf(this.getVersionNumber()));
        properties2.put("jrs.version_name", this.getVersionName());
        return properties2;
    }

    @Override
    public String getResourcePath() {
        return this.getAllResultFiles;
    }

    @Override
    public String getRealPath() {
        return this.getResultFile();
    }

    @Override
    public int getExpirationMethod() {
        return this.getCreatedTime;
    }

    @Override
    public boolean hasOnlyRSDorWST() {
        boolean bl = false;
        if (this.getCreator.size() == 1 && (this.getCreator.containsKey("jrs.rsd_result") || this.getCreator.containsKey("jrs.wst_result"))) {
            return true;
        }
        Enumeration enumeration = this.getCreator.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals("jrs.rsd_result") || string.equals("jrs.wst_result") || string.equals("jrs.report")) {
                bl = true;
                continue;
            }
            Object v = this.getCreator.get(string);
            if (!(v instanceof ResultFiles)) continue;
            ResultFiles resultFiles = (ResultFiles)v;
            int n = resultFiles.getResultFileNames().size();
            if (n == 0 || n == 1 && (resultFiles.hasRsdFile() || resultFiles.hasWstFile())) {
                bl = true;
                continue;
            }
            return false;
        }
        return bl;
    }
}

