/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource.nls;

import java.io.Serializable;
import jet.cs.CSUtil;
import jet.server.api.nls.NLSType;
import jet.util.nls.NLSResource;

public class GlobalNLSRecord
implements Serializable {
    public static final int TYPE_LABEL = 0;
    public static final int TYPE_COLUMN = 1;
    public static final int TYPE_PROMPT = 2;
    public static final int TYPE_TOC = 3;
    public static final int TYPE_FONT = 4;
    public static final int TYPE_META = 5;
    public static final int TYPE_TITLE = 6;
    public static final int TYPE_DISP = 7;
    public static final int TYPE_FORMAT = 8;
    private static final int $SwitchMap$jet$server$api$nls$NLSType = 0;
    private static final int COLUMN = NLSResource.KEYPREFIXES.length - 1;
    public static final String CONCAT_CHAR = "_";
    public static final String WILDCARD_SIZE_CHAR = "*";
    private int id;
    private boolean isModified = false;
    private int type = -1;
    private String key = "";
    private String value = "";
    private String orginalFontFace = "";
    private int orginalFontSize;
    private String targetFontFace = "";
    private int targetFontSize;
    private boolean isRelativeFontSize;

    public static int getTypeIntValue(NLSType nLSType) {
        int n = 0;
        switch (nLSType) {
            case LABEL: {
                n = 0;
                break;
            }
            case COLUMN: {
                n = 1;
                break;
            }
            case PROMPT: {
                n = 2;
                break;
            }
            case TOC: {
                n = 3;
                break;
            }
            case META: {
                n = 5;
                break;
            }
            case TITLE: {
                n = 6;
                break;
            }
            case DISP: {
                n = 7;
                break;
            }
        }
        return n;
    }

    public static NLSType getTypeByIntValue(int n) {
        NLSType nLSType = NLSType.LABEL;
        switch (n) {
            case 0: {
                nLSType = NLSType.LABEL;
                break;
            }
            case 1: {
                nLSType = NLSType.COLUMN;
                break;
            }
            case 2: {
                nLSType = NLSType.PROMPT;
                break;
            }
            case 3: {
                nLSType = NLSType.TOC;
                break;
            }
            case 5: {
                nLSType = NLSType.META;
                break;
            }
            case 6: {
                nLSType = NLSType.TITLE;
                break;
            }
            case 7: {
                nLSType = NLSType.DISP;
                break;
            }
        }
        return nLSType;
    }

    private static String $SwitchMap$jet$server$api$nls$NLSType(int n) {
        switch (n) {
            case 0: {
                return "LBL_TXT_";
            }
            case 1: {
                return "COL_TXT_";
            }
            case 2: {
                return "PARAM_PROMPTTXT_";
            }
            case 3: {
                return "TOC_TXT_";
            }
            case 8: {
                return "FMT_TXT_";
            }
            case 4: {
                return "FONT_TXT_";
            }
            case 5: {
                return "UNV_METADATA_";
            }
            case 6: {
                return "OBJ_TITLE_";
            }
            case 7: {
                return "OBJ_DISP_";
            }
        }
        return n + CONCAT_CHAR;
    }

    public static GlobalNLSRecord parse(String string, String string2) {
        try {
            GlobalNLSRecord globalNLSRecord = new GlobalNLSRecord();
            if (globalNLSRecord.COLUMN(string) && globalNLSRecord.DISP(string2)) {
                return globalNLSRecord;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    public static String getPropKeyOfDisplay(int n, String string) {
        return GlobalNLSRecord.$SwitchMap$jet$server$api$nls$NLSType(n) + string;
    }

    public static String getPropKeyOfFormat(String string) {
        return GlobalNLSRecord.$SwitchMap$jet$server$api$nls$NLSType(8) + string;
    }

    public static String getPropKeyOfFont(String string, int n) {
        return GlobalNLSRecord.$SwitchMap$jet$server$api$nls$NLSType(4) + string + CONCAT_CHAR + (n == 0 ? WILDCARD_SIZE_CHAR : String.valueOf(n));
    }

    public static String getPropValueOfFont(String string, int n, boolean bl) {
        return string + CONCAT_CHAR + n + CONCAT_CHAR + bl;
    }

    public int getId() {
        return this.id;
    }

    protected void setId(int n) {
        this.id = n;
    }

    public boolean isModified() {
        return this.isModified;
    }

    protected void setIsModified(boolean bl) {
        this.isModified = bl;
    }

    private GlobalNLSRecord() {
    }

    public GlobalNLSRecord(int n, String string, String string2) {
        this();
        this.setType(n);
        this.setKey(string);
        this.setValue(string2);
    }

    public GlobalNLSRecord(String string, int n, String string2, int n2, boolean bl) {
        this();
        this.setType(4);
        this.setOrginalFontFace(string);
        this.setOrginalFontSize(n);
        this.setTargetFontFace(string2);
        this.setTargetFontSize(n2);
        this.setIsRelativeFontSize(bl);
    }

    public GlobalNLSRecord(String string, String string2) {
        this();
        this.setType(8);
        this.setKey(string);
        this.setValue(string2);
    }

    public String getPropKey() {
        if (this.isFontMap()) {
            return GlobalNLSRecord.getPropKeyOfFont(this.getOrginalFontFace(), this.getOrginalFontSize());
        }
        if (this.isFormatMap()) {
            return GlobalNLSRecord.getPropKeyOfFormat(this.getKey());
        }
        return GlobalNLSRecord.getPropKeyOfDisplay(this.getType(), this.getKey());
    }

    public String getPropValue() {
        String string = this.getValue();
        if (this.isFontMap()) {
            string = GlobalNLSRecord.getPropValueOfFont(this.getTargetFontFace(), this.getTargetFontSize(), this.isRelativeFontSize());
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    private boolean COLUMN(String string) {
        int n = -1;
        String string2 = null;
        if (string != null) {
            for (int i = 0; i <= COLUMN; ++i) {
                String string3 = GlobalNLSRecord.$SwitchMap$jet$server$api$nls$NLSType(i);
                if (!string.startsWith(string3)) continue;
                n = i;
                string2 = string.substring(string3.length());
                break;
            }
        }
        if (n > -1 && string2 != null) {
            if (n == 4) {
                String[] stringArray = string2.split(CONCAT_CHAR, 2);
                if (stringArray.length == 2) {
                    this.setType(n);
                    this.setOrginalFontFace(stringArray[0]);
                    this.setOrginalFontSize(CSUtil.parseInt(stringArray[1], 0));
                    return true;
                }
            } else {
                if (n == 8) {
                    this.setType(8);
                    this.setKey(string2);
                    return true;
                }
                this.setType(n);
                this.setKey(string2);
                return true;
            }
        }
        return false;
    }

    private boolean DISP(String string) {
        if (string == null) {
            return false;
        }
        if (this.isFontMap()) {
            String[] stringArray = string.split(CONCAT_CHAR, 3);
            if (stringArray.length == 3) {
                this.setTargetFontFace(stringArray[0]);
                this.setTargetFontSize(CSUtil.parseInt(stringArray[1], 0));
                this.setIsRelativeFontSize(CSUtil.getBoolean(stringArray[2], false));
                return true;
            }
        } else {
            if (this.isFormatMap()) {
                this.setValue(string);
                return true;
            }
            this.setValue(string);
            return true;
        }
        return false;
    }

    public String toString() {
        return "NLS#" + this.id + "[" + this.getPropKey() + "=" + this.getPropValue() + "]";
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof GlobalNLSRecord) {
            return this.id == ((GlobalNLSRecord)object).id;
        }
        return false;
    }

    public boolean equalsNLSKey(Object object) {
        if (object instanceof GlobalNLSRecord) {
            return this.getPropKey().equals(((GlobalNLSRecord)object).getPropKey());
        }
        return false;
    }

    public boolean equalsNLS(Object object) {
        return this.equalsNLSKey(object) && this.getPropValue().equals(((GlobalNLSRecord)object).getPropValue());
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.key = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.value = string;
    }

    public boolean isFontMap() {
        return this.type == 4;
    }

    public boolean isFormatMap() {
        return this.type == 8;
    }

    public String getOrginalFontFace() {
        return this.orginalFontFace;
    }

    public void setOrginalFontFace(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.orginalFontFace = string;
    }

    public int getOrginalFontSize() {
        return this.orginalFontSize;
    }

    public void setOrginalFontSize(int n) {
        this.orginalFontSize = n;
    }

    public String getTargetFontFace() {
        return this.targetFontFace;
    }

    public void setTargetFontFace(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.targetFontFace = string;
    }

    public void setTargetFontSize(int n) {
        this.targetFontSize = n;
    }

    public int getTargetFontSize() {
        return this.targetFontSize;
    }

    public int getAbsoluteTargetFontSize() {
        if (this.isRelativeFontSize) {
            return this.orginalFontSize + this.targetFontSize;
        }
        return this.targetFontSize;
    }

    public boolean isRelativeFontSize() {
        return this.isRelativeFontSize;
    }

    public void setIsRelativeFontSize(boolean bl) {
        this.isRelativeFontSize = bl;
    }
}

