/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource.nls;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jet.cs.CSUtil;
import jet.server.api.http.HttpUtil;
import jet.server.api.nls.FontNLSEntry;
import jet.server.api.nls.FormatNLSEntry;
import jet.server.api.nls.GlobalNLSLibrary;
import jet.server.api.nls.NLSEntry;
import jet.server.api.nls.TextNLSEntry;
import jet.server.intf.resource.NLSManager;
import jet.server.jrc.resource.nls.GlobalNLSRecord;
import jet.server.jrc.resource.nls.NLSUtil;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.log.ServiceLogger;
import jet.server.util.ServerUtil;

public class GlobalNLSWebPage {
    private static final Map SEDU = new HashMap();
    private static long t = 600000L;
    private String access$1000;
    public static final String CMD_CHANGE_LOCALE = "cmd.change_locale";
    public static final String CMD_ADD_LOCALE = "cmd.add_locale";
    public static final String CMD_IMPORT_LOCALE = "cmd.import_locale";
    public static final String CMD_DEL_LOCALE = "cmd.del_locale";
    public static final String CMD_SAVE = "cmd.saveNLS";
    public static final String CMD_CANCEL = "cmd.cancelNLS";
    public static final String CMD_SEARCH = "cmd.search";
    public static final String CMD_SORT = "cmd.sort";
    public static final String CMD_CHANGE_PAGE = "cmd.change_page";
    public static final String CMD_NEW_DISPLAY = "cmd.new_display";
    public static final String CMD_NEW_FONT = "cmd.new_font";
    public static final String CMD_DEL_DISPLAY = "cmd.del_display";
    public static final String CMD_DEL_FONT = "cmd.del_font";
    public static final String CMD_NEW_FORMAT = "cmd.new_format";
    public static final String CMD_DEL_FORMAT = "cmd.del_format";
    public static final String F_CMD = "nlsCmd";
    public static final String F_NLS_WEB_ID = "nlsWebId";
    public static final String F_ORGINAL_LOCALE = "orginalLocale";
    public static final String F_TARGET_LOCALE = "targetLocale";
    public static final String F_ADD_LOCALE = "addedLocale";
    public static final String F_IMPORT_NLS_LOCALE = "importLocale";
    public static final String F_IMPORT_NLS_RES = "importNLSResource";
    public static final String F_ACTIVE_TAB = "activeTab";
    public static final String F_SEARCH_BY = "seachBy";
    public static final String F_SORT_BY = "sortBy";
    public static final String F_PAGE_SIZE = "pageSize";
    public static final String F_PAGE_NUMBER = "pageNumber";
    public static final String COL_ID = "colId";
    public static final String COL_TYPE = "colType";
    public static final String COL_CHK = "colCheck";
    public static final String COL_KEY = "colKey";
    public static final String COL_VALUE = "colValue";
    public static final String COL_ORG_FACE = "colOrgFace";
    public static final String COL_ORG_SIZE = "colOrgSize";
    public static final String COL_TAR_FACE = "colTarFace";
    public static final String COL_TAR_SIZE = "colTarSize";
    public static final String COL_IS_RELATIVE = "colIsRelative";
    private boolean access$1100;
    private boolean access$1200 = false;
    private List access$1300;
    private List access$1400;
    private Map access$200;
    private String access$300;
    private Locale access$302;
    private List access$400;
    private LocaleNLSPager access$500;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlobalNLSWebPage getGlobalNLSWebPage(String string, HttpServletRequest httpServletRequest) {
        NLSWebKey nLSWebKey = GlobalNLSWebPage.SEDU(string, httpServletRequest);
        GlobalNLSWebPage globalNLSWebPage = null;
        Map map = SEDU;
        synchronized (map) {
            globalNLSWebPage = (GlobalNLSWebPage)SEDU.get(nLSWebKey);
            if (globalNLSWebPage == null) {
                globalNLSWebPage = new GlobalNLSWebPage(nLSWebKey.nlsWebId);
            }
            SEDU.put(nLSWebKey, globalNLSWebPage);
        }
        return globalNLSWebPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeGlobalNLSWebPage(String string, HttpServletRequest httpServletRequest) {
        Map map = SEDU;
        synchronized (map) {
            SEDU.remove(GlobalNLSWebPage.SEDU(string, httpServletRequest));
        }
    }

    private static NLSWebKey SEDU(String string, HttpServletRequest httpServletRequest) {
        String string2 = string = string == null ? httpServletRequest.getParameter(F_NLS_WEB_ID) : string;
        if (string == null) {
            string = httpServletRequest.getSession().getId() + "-" + System.currentTimeMillis();
        }
        return new NLSWebKey(string, httpServletRequest);
    }

    private GlobalNLSWebPage(String string) {
        this.access$1000 = string;
        this.access$1200();
    }

    private NLSManager access$1000() {
        return UserDataToolkit.getNLSManager();
    }

    private GlobalNLSLibrary access$1100() {
        return HttpUtil.getHttpRptServer().getGlobalNLSLibrary();
    }

    private void access$1200() {
        if (this.access$1200) {
            return;
        }
        this.access$1400 = new ArrayList();
        this.access$200 = new HashMap();
        List<Locale> list = this.access$1100().getAvailableLocales();
        for (Locale locale : list) {
            this.access$200.put(locale, new LocaleNLSPager(locale));
        }
        if (this.access$1300 == null) {
            this.access$1300 = new ArrayList();
            Locale[] localeArray = this.access$1000().getAvailableLocales();
            for (int i = 0; localeArray != null && i < localeArray.length; ++i) {
                this.access$1300.add(localeArray[i]);
            }
        }
        this.access$1100 = false;
        this.access$1200 = true;
    }

    private LocaleNLSPager access$1300(Locale locale) {
        if (!this.isValidLocale(locale)) {
            return null;
        }
        LocaleNLSPager localeNLSPager = (LocaleNLSPager)this.access$200.get(locale);
        if (localeNLSPager == null) {
            localeNLSPager = new LocaleNLSPager(locale);
            this.access$200.put(locale, localeNLSPager);
        }
        if (!this.access$1400.contains(locale) && !localeNLSPager.getKey) {
            localeNLSPager.loadNLS(this.access$1100().getLocale(locale));
        }
        return localeNLSPager;
    }

    private void access$1400(Locale locale) {
        if (locale == null) {
            return;
        }
        this.access$200.remove(locale);
        if (!this.access$1400.contains(locale)) {
            this.access$1400.add(locale);
        }
        this.access$1100 = true;
    }

    private boolean save() {
        if (!this.access$1100) {
            return false;
        }
        for (int i = 0; i < this.access$1400.size(); ++i) {
            this.access$1100().removeLocale((Locale)this.access$1400.get(i));
        }
        this.access$1400.clear();
        this.access$400 = new ArrayList();
        ArrayList<NLSEntry> arrayList = new ArrayList<NLSEntry>();
        for (Locale locale : this.access$200.keySet()) {
            LocaleNLSPager localeNLSPager = (LocaleNLSPager)this.access$200.get(locale);
            if (localeNLSPager == null || !localeNLSPager.getKeyFormat) continue;
            boolean bl = false;
            for (GlobalNLSRecord globalNLSRecord : localeNLSPager.access$1500.values()) {
                globalNLSRecord.setIsModified(false);
                NLSEntry nLSEntry = null;
                if (globalNLSRecord.isFontMap()) {
                    nLSEntry = new FontNLSEntry(globalNLSRecord.getOrginalFontFace(), globalNLSRecord.getOrginalFontSize(), globalNLSRecord.getTargetFontFace(), globalNLSRecord.getTargetFontSize(), globalNLSRecord.isRelativeFontSize());
                } else if (globalNLSRecord.isFormatMap()) {
                    if ("".equals(globalNLSRecord.getKey())) continue;
                    nLSEntry = new FormatNLSEntry(globalNLSRecord.getKey(), globalNLSRecord.getValue());
                } else {
                    nLSEntry = new TextNLSEntry(GlobalNLSRecord.getTypeByIntValue(globalNLSRecord.getType()), globalNLSRecord.getKey(), globalNLSRecord.getValue());
                }
                if (arrayList.contains(nLSEntry)) {
                    if (!this.access$400.contains(locale)) {
                        this.access$400.add(locale);
                    }
                    arrayList.remove(nLSEntry);
                    arrayList.add(nLSEntry);
                    bl = true;
                    break;
                }
                arrayList.add(nLSEntry);
            }
            if (bl) continue;
            this.access$1100().removeLocale(locale);
            this.access$1100().updateLocale(locale, arrayList);
            localeNLSPager.getKeyFormat = false;
            localeNLSPager.access$1500();
            localeNLSPager.loadNLS(arrayList);
        }
        if (this.access$400.size() == 0) {
            this.access$1100 = false;
        }
        return true;
    }

    private boolean cancel() {
        if (!this.access$1100) {
            return false;
        }
        this.access$1200 = false;
        this.access$1200();
        return true;
    }

    private static GlobalNLSRecord access$200(List list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            GlobalNLSRecord globalNLSRecord = (GlobalNLSRecord)list.get(i);
            if (!globalNLSRecord.getPropKey().equals(string)) continue;
            return globalNLSRecord;
        }
        return null;
    }

    public void processRequest(Properties properties) {
        Object object;
        this.access$302 = null;
        this.access$400 = null;
        String string = null;
        this.access$300 = properties.getProperty(F_CMD, "");
        boolean bl = false;
        Locale locale = null;
        Object object2 = null;
        string = properties.getProperty(F_ORGINAL_LOCALE);
        if (string != null) {
            locale = ServerUtil.getLocale(string);
        }
        if ((string = properties.getProperty(F_TARGET_LOCALE)) != null) {
            object2 = ServerUtil.getLocale(string);
        }
        Object object3 = object2 = object2 == null ? locale : object2;
        if (this.access$300.equals(CMD_DEL_LOCALE)) {
            object = locale;
            this.access$1400((Locale)object);
            object2 = null;
        } else if (this.isValidLocale(locale)) {
            object = this.access$1300(locale);
            ((LocaleNLSPager)object).updateRequest(properties);
            if (((LocaleNLSPager)object).getKeyFormat) {
                this.access$1100 = true;
            }
        } else {
            this.access$302 = locale;
        }
        if (this.access$300.equals(CMD_ADD_LOCALE)) {
            object = null;
            string = properties.getProperty(F_ADD_LOCALE);
            if (string != null) {
                object = ServerUtil.getLocale(string);
            }
            if (this.isValidLocale((Locale)object)) {
                LocaleNLSPager localeNLSPager = this.access$1300((Locale)object);
                object2 = object;
                localeNLSPager.getKeyFormat = true;
                this.access$1100 = true;
            } else {
                this.access$302 = object;
            }
        } else if (this.access$300.equals(CMD_IMPORT_LOCALE)) {
            object = ServerUtil.getLocale(properties.getProperty(F_IMPORT_NLS_LOCALE));
            if (this.isValidLocale((Locale)object)) {
                Properties properties2 = (Properties)properties.get(F_IMPORT_NLS_RES);
                LocaleNLSPager localeNLSPager = this.access$1300((Locale)object);
                localeNLSPager.importNLS(properties2);
                if (localeNLSPager.getKeyFormat) {
                    this.access$1100 = true;
                }
                object2 = object;
                bl = true;
            } else {
                this.access$302 = object;
            }
        } else if (this.access$300.equals(CMD_SAVE)) {
            this.save();
        } else if (this.access$300.equals(CMD_CANCEL)) {
            this.cancel();
        } else if (this.access$300.equals(CMD_NEW_DISPLAY) || this.access$300.equals(CMD_NEW_FONT) || this.access$300.equals(CMD_NEW_FORMAT)) {
            object = this.access$1300(locale);
            ((LocaleNLSPager)object).newNLS(this.access$300);
            if (this.access$300.equals(CMD_NEW_DISPLAY)) {
                bl = true;
            }
            this.access$1100 = true;
        }
        if (!this.access$200.containsKey(object2)) {
            object = this.getLocalesInLibrary();
            object2 = ((Locale[])object).length > 0 ? object[0] : null;
        }
        this.access$500 = null;
        if (this.isValidLocale((Locale)object2)) {
            this.access$500 = this.access$1300((Locale)object2);
            if (this.access$300.equals(CMD_SEARCH) || locale == null) {
                this.access$500.access$1600 = properties.getProperty(F_SEARCH_BY, this.access$500.access$1600);
                this.access$500.search();
            }
            if (this.access$300.equals(CMD_SORT) || locale == null) {
                this.access$500.add = properties.getProperty(F_SORT_BY, this.access$500.add).trim();
                this.access$500.sort();
            }
            if (this.access$300.equals(CMD_CHANGE_PAGE) || locale == null) {
                string = properties.getProperty(F_PAGE_SIZE, "");
                if (string.equalsIgnoreCase("all")) {
                    this.access$500.get = 0;
                } else {
                    int n = CSUtil.parseInt(string, this.access$500.get);
                    this.access$500.get = n >= 0 ? n : this.access$500.get;
                }
                this.access$500.getBoolean = CSUtil.parseInt(properties.getProperty(F_PAGE_NUMBER), this.access$500.getBoolean);
            }
            this.access$500.repage(bl);
        }
    }

    public String getNLSWebID() {
        return this.access$1000;
    }

    public boolean isValidLocale(Locale locale) {
        return this.access$1300.contains(locale);
    }

    public Locale[] getLocalesInLibrary() {
        Locale[] localeArray = this.access$200.keySet().toArray(new Locale[this.access$200.size()]);
        return NLSUtil.sortLocale(localeArray);
    }

    public Locale[] getLocalesOutOfLibrary() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.access$1300);
        arrayList.removeAll(this.access$200.keySet());
        return arrayList.toArray(new Locale[arrayList.size()]);
    }

    public boolean hasModified() {
        return this.access$1100;
    }

    public Locale getLocale() {
        return this.access$500 == null ? null : this.access$500.SEDU;
    }

    public List getFontMapInfos() {
        return this.access$500 == null ? new ArrayList() : this.access$500.addAll;
    }

    public List getDisplayNLS() {
        return this.access$500 == null ? new ArrayList() : this.access$500.equals;
    }

    public List getFormatNLS() {
        return this.access$500 == null ? new ArrayList() : this.access$500.clear;
    }

    public int getMaxPagerNumber() {
        return this.access$500 == null ? 1 : this.access$500.getId;
    }

    public int getPagerNumber() {
        return this.access$500 == null ? 1 : this.access$500.getBoolean;
    }

    public int getPageSize() {
        return this.access$500 == null ? 10 : this.access$500.get;
    }

    public String getSortBy() {
        return this.access$500 == null ? "" : this.access$500.add;
    }

    public String getSearchBy() {
        return this.access$500 == null ? "" : this.access$500.access$1600;
    }

    public Locale getInvalidLocale() {
        return this.access$302;
    }

    public List getDuplicateLocales() {
        return this.access$400;
    }

    public boolean hasModifiedOfLocale() {
        return this.access$500 == null ? false : this.access$500.getKeyFormat;
    }

    public String toString() {
        return super.toString() + "\n\t inited=" + this.access$1200 + "\n\t cmd=" + this.access$300 + "\n\t deletedLocales=" + this.access$1400 + "\n\t localeMap=" + this.access$200.values().size() + "\n\n\t curPager=" + this.access$500;
    }

    static {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Map map = SEDU;
                            synchronized (map) {
                                Iterator iterator = SEDU.keySet().iterator();
                                while (iterator.hasNext()) {
                                    NLSWebKey nLSWebKey = (NLSWebKey)iterator.next();
                                    if (!nLSWebKey.isSessionTimeout()) continue;
                                    ServiceLogger.logDebug("GlobalNLSWebPage:: remove timout NLS cache: " + nLSWebKey, 6);
                                    iterator.remove();
                                }
                            }
                            Thread.sleep(t);
                            Thread.yield();
                        }
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
        });
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
    }

    class LocaleNLSPager {
        private Locale SEDU;
        private Map access$1500 = new HashMap();
        private String access$1600 = "";
        private String add = "";
        private List addAll = new ArrayList();
        private List append = new ArrayList();
        private List clear = new ArrayList();
        private List equals = new ArrayList();
        private int get = 10;
        private int getBoolean = 0;
        private int getId = 0;
        private boolean getKey = false;
        private boolean getKeyFormat = false;
        private int getKeyText = 0;

        private int SEDU() {
            return this.getKeyText++;
        }

        public String toString() {
            return "LocaleNLSPager: locale=" + this.SEDU + ", hasLoaded=" + this.getKey + ", hasModified=" + this.getKeyFormat;
        }

        LocaleNLSPager(Locale locale) {
            this.SEDU = locale;
        }

        private void access$1500() {
            this.getKeyText = 0;
            this.access$1500.clear();
            this.addAll.clear();
            this.append.clear();
            this.clear.clear();
            this.equals.clear();
            this.getKeyFormat = false;
            this.getKey = false;
        }

        void loadNLS(List list) {
            if (this.getKey) {
                return;
            }
            if (list != null) {
                for (NLSEntry nLSEntry : list) {
                    NLSEntry nLSEntry2;
                    GlobalNLSRecord globalNLSRecord = null;
                    if (nLSEntry instanceof TextNLSEntry) {
                        nLSEntry2 = (TextNLSEntry)nLSEntry;
                        globalNLSRecord = new GlobalNLSRecord(GlobalNLSRecord.getTypeIntValue(((TextNLSEntry)nLSEntry2).getType()), ((TextNLSEntry)nLSEntry2).getKeyText(), ((TextNLSEntry)nLSEntry2).getValueText());
                    } else if (nLSEntry instanceof FormatNLSEntry) {
                        nLSEntry2 = (FormatNLSEntry)nLSEntry;
                        globalNLSRecord = new GlobalNLSRecord(((FormatNLSEntry)nLSEntry2).getKeyFormat(), ((FormatNLSEntry)nLSEntry2).getValueFormat());
                    } else {
                        nLSEntry2 = (FontNLSEntry)nLSEntry;
                        globalNLSRecord = new GlobalNLSRecord(((FontNLSEntry)nLSEntry2).getOrginalFace(), ((FontNLSEntry)nLSEntry2).getOrginalSize(), ((FontNLSEntry)nLSEntry2).getTargetFace(), ((FontNLSEntry)nLSEntry2).getTargetSize(), ((FontNLSEntry)nLSEntry2).isRelative());
                    }
                    if (globalNLSRecord == null) continue;
                    globalNLSRecord.setId(this.SEDU());
                    this.add(globalNLSRecord);
                }
            }
            this.getKey = true;
            this.append(this.addAll, 0, false);
            this.append(this.append, 0, false);
            this.append(this.clear, 0, false);
        }

        private GlobalNLSRecord access$1600(int n) {
            return (GlobalNLSRecord)this.access$1500.get(new Integer(n));
        }

        private void add(GlobalNLSRecord globalNLSRecord) {
            this.access$1500.put(new Integer(globalNLSRecord.getId()), globalNLSRecord);
            if (globalNLSRecord.isFontMap()) {
                this.addAll.add(globalNLSRecord);
            } else if (globalNLSRecord.isFormatMap()) {
                this.clear.add(globalNLSRecord);
            } else {
                this.append.add(globalNLSRecord);
            }
        }

        private void addAll(GlobalNLSRecord globalNLSRecord) {
            if (this.access$1500.remove(new Integer(globalNLSRecord.getId())) != null) {
                this.getKeyFormat = true;
            }
            if (globalNLSRecord.isFontMap()) {
                this.addAll.remove(globalNLSRecord);
            } else if (globalNLSRecord.isFormatMap()) {
                this.clear.remove(globalNLSRecord);
            } else {
                this.append.remove(globalNLSRecord);
            }
        }

        GlobalNLSRecord newNLS(String string) {
            GlobalNLSRecord globalNLSRecord = null;
            if (string.equals(GlobalNLSWebPage.CMD_NEW_FONT)) {
                globalNLSRecord = new GlobalNLSRecord("Default", 7, "Default", 7, false);
            } else if (string.equals(GlobalNLSWebPage.CMD_NEW_FORMAT)) {
                globalNLSRecord = new GlobalNLSRecord("", "");
            } else if (string.equals(GlobalNLSWebPage.CMD_NEW_DISPLAY)) {
                int n = 1;
                globalNLSRecord = new GlobalNLSRecord(0, "New1", "value");
                while (GlobalNLSWebPage.access$200(this.append, globalNLSRecord.getPropKey()) != null) {
                    globalNLSRecord.setKey("New" + ++n);
                }
            }
            globalNLSRecord.setId(this.SEDU());
            globalNLSRecord.setIsModified(true);
            this.add(globalNLSRecord);
            this.getKeyFormat = true;
            return globalNLSRecord;
        }

        /*
         * WARNING - void declaration
         */
        void importNLS(Properties properties) {
            for (String string : properties.keySet()) {
                void var3_12;
                String string2 = properties.getProperty(string);
                if (string == null || string2 == null) continue;
                int n = -1;
                if (string.startsWith("LBL_TXT_")) {
                    n = 0;
                    String string3 = string.substring("LBL_TXT_".length());
                } else if (string.startsWith("COL_TXT_")) {
                    n = 1;
                    String string4 = string.substring("COL_TXT_".length());
                } else if (string.startsWith("PARAM_PROMPTTXT_")) {
                    n = 2;
                    String string5 = string.substring("PARAM_PROMPTTXT_".length());
                } else if (string.startsWith("TOC_TXT_")) {
                    n = 3;
                    String string6 = string.substring("TOC_TXT_".length());
                } else if (string.startsWith("UNV_METADATA_")) {
                    n = 5;
                    String string7 = string.substring("UNV_METADATA_".length());
                } else if (string.startsWith("OBJ_TITLE_")) {
                    n = 6;
                    String string8 = string.substring("OBJ_TITLE_".length());
                } else {
                    if (!string.startsWith("OBJ_DISP_")) continue;
                    n = 7;
                    String string9 = string.substring("OBJ_DISP_".length());
                }
                String string10 = GlobalNLSRecord.getPropKeyOfDisplay(n, (String)var3_12);
                GlobalNLSRecord globalNLSRecord = GlobalNLSWebPage.access$200(this.append, string10);
                if (globalNLSRecord == null) {
                    globalNLSRecord = new GlobalNLSRecord(n, (String)var3_12, string2);
                    globalNLSRecord.setId(this.SEDU());
                    globalNLSRecord.setIsModified(true);
                    this.add(globalNLSRecord);
                    this.getKeyFormat = true;
                    continue;
                }
                if (string2.equals(globalNLSRecord.getValue())) continue;
                this.getKeyFormat = true;
                globalNLSRecord.setValue(string2);
                globalNLSRecord.setIsModified(true);
            }
        }

        void updateRequest(Properties properties) {
            boolean bl = GlobalNLSWebPage.this.access$300.equals(GlobalNLSWebPage.CMD_DEL_DISPLAY);
            boolean bl2 = GlobalNLSWebPage.this.access$300.equals(GlobalNLSWebPage.CMD_DEL_FONT);
            boolean bl3 = GlobalNLSWebPage.this.access$300.equals(GlobalNLSWebPage.CMD_DEL_FORMAT);
            for (int i = 0; i < this.getKeyText; ++i) {
                int n;
                GlobalNLSRecord globalNLSRecord;
                String string = properties.getProperty(GlobalNLSWebPage.COL_ID + i);
                GlobalNLSRecord globalNLSRecord2 = globalNLSRecord = string != null ? this.access$1600(i) : null;
                if (globalNLSRecord == null) continue;
                String string2 = properties.getProperty(GlobalNLSWebPage.COL_CHK + i);
                boolean bl4 = CSUtil.getBoolean(string2, false);
                if (bl4 && (bl || bl2 || bl3)) {
                    this.addAll(globalNLSRecord);
                    this.getKeyFormat = true;
                    continue;
                }
                if (globalNLSRecord.getType() == 4) {
                    boolean bl5;
                    string2 = properties.getProperty(GlobalNLSWebPage.COL_ORG_FACE + i);
                    if (string2 != null && !string2.equals(globalNLSRecord.getOrginalFontFace())) {
                        globalNLSRecord.setOrginalFontFace(string2);
                        globalNLSRecord.setIsModified(true);
                        this.getKeyFormat = true;
                    }
                    string2 = properties.getProperty(GlobalNLSWebPage.COL_ORG_SIZE + i);
                    n = globalNLSRecord.getOrginalFontSize();
                    n = string2 != null && string2.equals("*") ? 0 : CSUtil.parseInt(string2, n);
                    if (n != globalNLSRecord.getOrginalFontSize()) {
                        globalNLSRecord.setOrginalFontSize(n);
                        globalNLSRecord.setIsModified(true);
                        this.getKeyFormat = true;
                    }
                    if ((string2 = properties.getProperty(GlobalNLSWebPage.COL_TAR_FACE + i)) != null && !string2.equals(globalNLSRecord.getTargetFontFace())) {
                        globalNLSRecord.setTargetFontFace(string2);
                        globalNLSRecord.setIsModified(true);
                        this.getKeyFormat = true;
                    }
                    if ((n = CSUtil.parseInt(string2 = properties.getProperty(GlobalNLSWebPage.COL_TAR_SIZE + i), globalNLSRecord.getTargetFontSize())) != globalNLSRecord.getTargetFontSize()) {
                        globalNLSRecord.setTargetFontSize(n);
                        globalNLSRecord.setIsModified(true);
                        this.getKeyFormat = true;
                    }
                    if ((bl5 = CSUtil.getBoolean(string2 = properties.getProperty(GlobalNLSWebPage.COL_IS_RELATIVE + i), false)) == globalNLSRecord.isRelativeFontSize()) continue;
                    globalNLSRecord.setIsRelativeFontSize(bl5);
                    globalNLSRecord.setIsModified(true);
                    this.getKeyFormat = true;
                    continue;
                }
                string2 = properties.getProperty(GlobalNLSWebPage.COL_TYPE + i);
                n = CSUtil.parseInt(string2, globalNLSRecord.getType());
                if (n != globalNLSRecord.getType()) {
                    globalNLSRecord.setType(n);
                    globalNLSRecord.setIsModified(true);
                    this.getKeyFormat = true;
                }
                if ((string2 = properties.getProperty(GlobalNLSWebPage.COL_KEY + i)) != null && !string2.equals(globalNLSRecord.getKey())) {
                    globalNLSRecord.setKey(string2);
                    globalNLSRecord.setIsModified(true);
                    this.getKeyFormat = true;
                }
                if ((string2 = properties.getProperty(GlobalNLSWebPage.COL_VALUE + i)) == null || string2.equals(globalNLSRecord.getValue())) continue;
                globalNLSRecord.setValue(string2);
                globalNLSRecord.setIsModified(true);
                this.getKeyFormat = true;
            }
        }

        void search() {
            this.append.clear();
            String string = this.access$1600.toLowerCase();
            boolean bl = string.length() == 0;
            for (GlobalNLSRecord globalNLSRecord : this.access$1500.values()) {
                if (globalNLSRecord.isFontMap() || globalNLSRecord.isFormatMap()) continue;
                if (bl) {
                    this.append.add(globalNLSRecord);
                    continue;
                }
                if (globalNLSRecord.getKey().toLowerCase().indexOf(string) == -1 && globalNLSRecord.getValue().toLowerCase().indexOf(string) == -1) continue;
                this.append.add(globalNLSRecord);
            }
            this.sort();
        }

        void sort() {
            int n = 0;
            boolean bl = false;
            int n2 = this.add.indexOf("_");
            if (n2 > 0) {
                String string = this.add.substring(0, n2);
                if (string.equals(GlobalNLSWebPage.COL_TYPE)) {
                    n = 1;
                } else if (string.equals(GlobalNLSWebPage.COL_KEY)) {
                    n = 2;
                } else if (string.equals(GlobalNLSWebPage.COL_VALUE)) {
                    n = 3;
                }
                bl = CSUtil.getBoolean(this.add.substring(n2 + 1), false);
            }
            this.append(this.append, n, bl);
        }

        private void append(List list, final int n, final boolean bl) {
            Collections.sort(list, new Comparator(){

                public int compare(Object object, Object object2) {
                    GlobalNLSRecord globalNLSRecord = (GlobalNLSRecord)object;
                    GlobalNLSRecord globalNLSRecord2 = (GlobalNLSRecord)object2;
                    if (bl) {
                        globalNLSRecord = globalNLSRecord2;
                        globalNLSRecord2 = (GlobalNLSRecord)object;
                    }
                    int n2 = 0;
                    switch (n) {
                        case 0: {
                            n2 = globalNLSRecord.getType() < globalNLSRecord2.getType() ? -1 : (globalNLSRecord.getType() == globalNLSRecord2.getType() ? 0 : 1);
                            n2 = n2 == 0 ? globalNLSRecord.getPropKey().compareTo(globalNLSRecord2.getPropKey()) : n2;
                            break;
                        }
                        case 1: {
                            n2 = globalNLSRecord.getType() < globalNLSRecord2.getType() ? -1 : (globalNLSRecord.getType() == globalNLSRecord2.getType() ? 0 : 1);
                            break;
                        }
                        case 2: {
                            n2 = globalNLSRecord.getKey().compareTo(globalNLSRecord2.getKey());
                            break;
                        }
                        case 3: {
                            n2 = globalNLSRecord.getValue().compareTo(globalNLSRecord2.getValue());
                        }
                    }
                    return n2;
                }
            });
        }

        void repage(boolean bl) {
            int n;
            this.equals.clear();
            if (this.get == 0) {
                this.getId = 1;
            } else {
                n = this.append.size();
                this.getId = n / this.get;
                this.getId += n % this.get > 0 ? 1 : 0;
                int n2 = this.getId = this.getId < 1 ? 1 : this.getId;
            }
            if (bl) {
                this.getBoolean = this.getId;
            }
            this.getBoolean = this.between(this.getBoolean, 1, this.getId);
            if (this.get == 0) {
                this.equals.addAll(this.append.subList(0, this.append.size()));
            } else {
                n = this.getBoolean - 1;
                int n3 = n * this.get;
                int n4 = n3 + this.get;
                n3 = this.between(n3, 0, this.append.size());
                n4 = this.between(n4, n3, this.append.size());
                this.equals.addAll(this.append.subList(n3, n4));
            }
        }

        private int between(int n, int n2, int n3) {
            n2 = n2 > n3 ? n3 : n2;
            n = n < n2 ? n2 : n;
            n = n > n3 ? n3 : n;
            return n;
        }
    }

    private static class NLSWebKey {
        String nlsWebId;
        Reference sessionRef;
        boolean isSameSession;

        NLSWebKey(String string, HttpServletRequest httpServletRequest) {
            this.nlsWebId = string;
            this.sessionRef = new SoftReference<HttpSession>(httpServletRequest.getSession());
            this.isSameSession = string.startsWith(httpServletRequest.getSession().getId());
        }

        boolean isSessionTimeout() {
            return this.sessionRef.get() == null;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof NLSWebKey) {
                return this.nlsWebId.equals(((NLSWebKey)object).nlsWebId);
            }
            return false;
        }

        public String toString() {
            return this.nlsWebId;
        }

        public int hashCode() {
            return this.nlsWebId.hashCode();
        }
    }
}

