/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource.nls;

import java.io.File;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import jet.controls.JetObject;
import jet.cs.util.APIUtil;
import jet.report.onTheFlyFormula.JetRptFlyFormula;
import jet.report.onTheFlyFormula.JetRptFlyMeasure;
import jet.reportLogic.objectLogic.BasicComponentLogic;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportset.JetRptReportSet;
import jet.server.api.PathInfo;
import jet.server.api.RptServerException;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.api.nls.FontNLSEntry;
import jet.server.api.nls.FormatNLSEntry;
import jet.server.api.nls.NLSEntry;
import jet.server.api.nls.NLSType;
import jet.server.api.nls.TextNLSEntry;
import jet.server.intf.resource.NLSManager;
import jet.server.jrc.resource.nls.FontNameComparator;
import jet.server.jrc.resource.nls.GlobalNLSDictionary;
import jet.server.jrc.resource.nls.GlobalNLSRecord;
import jet.server.jrc.resource.nls.NLSComparator;
import jet.server.jrc.resource.nls.NLSContent;
import jet.server.jrc.resource.nls.NLSFontInfo;
import jet.server.jrc.resource.nls.NLSFontMap;
import jet.server.jrc.resource.nls.NLSSorter;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.log.ServiceLogger;
import jet.server.util.RefResource;
import jet.server.util.ServerUtil;
import jet.server.util.nls.PropertyMessageResourcesFactory;
import jet.util.FontSets;
import jet.util.NLSResourceBundle;
import jet.util.NLSResourceBundleManager;
import jet.util.nls.NLSApplyParam;
import jet.util.nls.NLSBundle;
import jet.util.nls.NLSDictionary;
import jet.util.nls.NLSToolKit;
import jet.util.nls.NLSValue;

public class NLSUtil {
    public static String VALUES_CONCAT_CHAR = ",";
    public static String CMD_FONT_MAP_EDIT = "edit_nls_font_map";
    public static String CMD_FONT_MAP_NEW = "new_nls_font_map";
    public static String NLS_ENCODING = "nls_server_properties_encoding";
    public static String CATEGORY_KEY_CONCAT_CHAR = "_";
    public static int NLS_SUB_REPORT_VERSION_NUMBER = -1117;
    public static String RPT_FILE_EXTENSION = ".rpt";
    public static String CLS_FILE_EXTENSION = ".cls";
    public static String XML_FILE_EXTENSION = ".xml";
    public static String FILENAME_CONCAT_CHAR = "_";
    public static String CONTROLLER_NAME_CHAR = "controller";
    private static List $SwitchMap$jet$server$api$nls$NLSType;
    private static final String COLUMN = "NLS";
    private static final String DISP = ".properties";
    private static final boolean LABEL;

    public static String getLocaleName(Locale locale) {
        return ServerUtil.getLocaleName(locale);
    }

    public static Locale getLocale(String string) {
        return ServerUtil.getLocale(string);
    }

    public static Properties getFontMapInfo(Locale locale) {
        Properties properties = new Properties();
        NLSManager nLSManager = UserDataToolkit.getNLSManager();
        NLSFontMap nLSFontMap = nLSManager.getFontMap(locale, "admin");
        if (nLSFontMap == null) {
            return null;
        }
        Object object = nLSFontMap.getFontInfos();
        Enumeration enumeration = ((Hashtable)object).elements();
        while (enumeration.hasMoreElements()) {
            NLSFontInfo nLSFontInfo = (NLSFontInfo)enumeration.nextElement();
            String string = nLSFontInfo.getOriginalFontFace() + CATEGORY_KEY_CONCAT_CHAR + nLSFontInfo.getOriginalFontSize();
            if (nLSFontInfo.isIgnoreSize()) {
                string = nLSFontInfo.getOriginalFontFace() + CATEGORY_KEY_CONCAT_CHAR + "*";
            }
            String string2 = nLSFontInfo.getTargetFontFace() + CATEGORY_KEY_CONCAT_CHAR + nLSFontInfo.getTargetFontSize() + CATEGORY_KEY_CONCAT_CHAR + nLSFontInfo.isRelative();
            properties.put(string, string2);
        }
        object = nLSFontMap.getEncoding();
        properties.setProperty(NLS_ENCODING, (String)object);
        return properties;
    }

    public static String getNLSControllerFileNameFromReportName(String string, Locale locale) {
        string = string.endsWith(CLS_FILE_EXTENSION) ? string.substring(0, string.length() - CLS_FILE_EXTENSION.length()) : (string.endsWith(RPT_FILE_EXTENSION) ? string.substring(0, string.length() - RPT_FILE_EXTENSION.length()) : string.substring(0, string.indexOf(".")));
        return string + FILENAME_CONCAT_CHAR + locale + FILENAME_CONCAT_CHAR + CONTROLLER_NAME_CHAR + XML_FILE_EXTENSION;
    }

    public static String getNLSPropertyDisplayName(String string, int n) {
        return string;
    }

    public static String getNLSPropertyDisplayName(String string, int n, Map map) {
        if (map != null && map.containsKey(string)) {
            return (String)map.get(string);
        }
        return string;
    }

    private static int $SwitchMap$jet$server$api$nls$NLSType(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 9;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 10;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
        }
        return 0;
    }

    public static String getTypeName(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "Label";
                break;
            }
            case 3: {
                string = "Column";
                break;
            }
            case 4: {
                string = "Prompt";
                break;
            }
            case 5: {
                string = "TOC";
                break;
            }
            case 6: {
                string = "Metadata";
                break;
            }
            case 7: {
                string = "Title";
                break;
            }
            case 8: {
                string = "DisplayName";
                break;
            }
            case 1: {
                string = "Format";
                break;
            }
            case 2: {
                string = "FontFace/Name";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public static Map clearEmptyProperty(Map map, int n) {
        Hashtable hashtable = new Hashtable();
        if (map != null) {
            Set set = map.keySet();
            for (String string : set) {
                if (string.length() == 0) continue;
                hashtable.put(string, map.get(string));
            }
        }
        return hashtable;
    }

    public static Properties getHtmlNavNLS(Locale locale) {
        NLSManager nLSManager = UserDataToolkit.getNLSManager();
        return nLSManager.getHtmlNavNLS(locale);
    }

    public static String fetchDisplayFromGlobal(Locale locale, int n, String string) {
        n = NLSUtil.$SwitchMap$jet$server$api$nls$NLSType(n);
        switch (n) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 5: {
                n = 2;
                break;
            }
            case 6: {
                n = 3;
                break;
            }
            case 9: {
                n = 5;
                break;
            }
            case 7: {
                n = 6;
                break;
            }
            case 10: {
                n = 7;
            }
        }
        TextNLSEntry textNLSEntry = UserDataToolkit.getNLSManager().getGlobalNLS(locale, n, string);
        ServiceLogger.logDebug("NLSUtil::fetchDisplayFromGlobal(): locale=" + locale + ", type=" + n + ", text=" + string + ", ret=" + textNLSEntry);
        return null == textNLSEntry ? null : textNLSEntry.getValueText();
    }

    public static String fetchFormatFromGlobal(Locale locale, String string) {
        FormatNLSEntry formatNLSEntry = UserDataToolkit.getNLSManager().getGlobalNLS(locale, string);
        ServiceLogger.logDebug("NLSUtil::fetchFormatFromGlobal(): locale=" + locale + ", format=" + string + ", ret=" + formatNLSEntry);
        return null == formatNLSEntry ? null : formatNLSEntry.getValueFormat();
    }

    public static String[] fetchFontFromGlobal(Locale locale, String string, int n) {
        FontNLSEntry fontNLSEntry = UserDataToolkit.getNLSManager().getGlobalNLS(locale, string, n);
        GlobalNLSRecord globalNLSRecord = null == fontNLSEntry ? null : new GlobalNLSRecord(fontNLSEntry.getOrginalFace(), fontNLSEntry.getOrginalSize(), fontNLSEntry.getTargetFace(), fontNLSEntry.getTargetSize(), fontNLSEntry.isRelative());
        String[] stringArray = null;
        if (globalNLSRecord != null) {
            stringArray = new String[]{globalNLSRecord.getTargetFontFace(), String.valueOf(globalNLSRecord.getAbsoluteTargetFontSize())};
        }
        String string2 = stringArray == null ? "null" : "[" + (String)stringArray[0] + "," + stringArray[1] + "]";
        ServiceLogger.logDebug("NLSUtil::fetchFontFromGlobal(): locale=" + locale + ", orginalFace=" + string + ", orginalPointSize=" + n + ", ret=" + string2);
        return stringArray;
    }

    public static void addDisplayToGlobal(Locale locale, int n, String string, String string2) {
        n = NLSUtil.$SwitchMap$jet$server$api$nls$NLSType(n);
        switch (n) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 5: {
                n = 2;
                break;
            }
            case 6: {
                n = 3;
                break;
            }
            case 9: {
                n = 5;
                break;
            }
            case 7: {
                n = 6;
                break;
            }
            case 10: {
                n = 7;
            }
        }
        ServiceLogger.logDebug("NLSUtil::addDisplayToGlobal(): locale=" + locale + ", type=" + n + ", text=" + string + ", value=" + string2);
        TextNLSEntry textNLSEntry = new TextNLSEntry(GlobalNLSRecord.getTypeByIntValue(n), string, string2);
        HttpUtil.getHttpRptServer().getGlobalNLSLibrary().updateTextNLSEntry(locale, textNLSEntry);
    }

    public static void addFormatToGlobal(Locale locale, String string, String string2) {
        ServiceLogger.logDebug("NLSUtil::addFormatToGlobal(): locale=" + locale + ", format=" + string + ", value=" + string2);
        FormatNLSEntry formatNLSEntry = new FormatNLSEntry(string, string2);
        HttpUtil.getHttpRptServer().getGlobalNLSLibrary().updateFormatNLSEntry(locale, formatNLSEntry);
    }

    public static void addFontToGlobal(Locale locale, String string, int n, String string2, int n2) {
        ServiceLogger.logDebug("NLSUtil::addFontToGlobal(): locale=" + locale + ", orginalFace=" + string + ", orginalPointSize=" + n + ", targetFace=" + string2 + ", targetPointSize=" + n2);
        FontNLSEntry fontNLSEntry = new FontNLSEntry(string, n, string2, n2, false);
        HttpUtil.getHttpRptServer().getGlobalNLSLibrary().updateFontNLSEntry(locale, fontNLSEntry);
    }

    public static NLSDictionary getGlobalNLSDictionary() {
        NLSManager nLSManager = UserDataToolkit.getNLSManager();
        return GlobalNLSDictionary.getInstance(nLSManager);
    }

    public static boolean isReportNationalLanguageSupport(String string) {
        return RefResource.isNationalLanguageSupport(string);
    }

    public static Locale[] sortLocale(Locale[] localeArray) {
        return ServerUtil.sortLocale(localeArray);
    }

    public static Locale fileName2Locale(String string) {
        int n = COLUMN.length();
        int n2 = DISP.length();
        if (string.length() >= n + n2 && (LABEL ? string.startsWith(COLUMN) : string.substring(0, n).equalsIgnoreCase(COLUMN)) && (LABEL ? string.endsWith(DISP) : string.substring(string.length() - n2).equalsIgnoreCase(DISP))) {
            Locale locale;
            String string2 = string.substring(COLUMN.length(), string.length() - DISP.length());
            if (string2.length() > 0) {
                if (string2.charAt(0) != '_') {
                    return null;
                }
                string2 = string2.substring(1);
            }
            if ((locale = ServerUtil.getLocale(string2)) != null) {
                String string3 = NLSUtil.locale2FileName(locale);
                if (LABEL ? string3.equals(string) : string3.equalsIgnoreCase(string)) {
                    return locale;
                }
            }
        }
        return null;
    }

    public static Locale catalogFileName2Locale(String string) {
        if (null == string) {
            return null;
        }
        int n = string.indexOf(".cat_");
        if (-1 == n) {
            return null;
        }
        String string2 = string.substring(0, n + 4);
        int n2 = string2.length();
        int n3 = DISP.length();
        if (string.length() >= n2 + n3 && (LABEL ? string.startsWith(string2) : string.substring(0, n2).equalsIgnoreCase(string2)) && (LABEL ? string.endsWith(DISP) : string.substring(string.length() - n3).equalsIgnoreCase(DISP))) {
            Locale locale;
            String string3 = string.substring(string2.length(), string.length() - DISP.length());
            if (string3.length() > 0) {
                if (string3.charAt(0) != '_') {
                    return null;
                }
                string3 = string3.substring(1);
            }
            if ((locale = ServerUtil.getLocale(string3)) != null) {
                String string4 = locale.toString();
                if (string4.length() > 0) {
                    string4 = "_" + string4;
                }
                String string5 = string2 + string4 + DISP;
                if (LABEL ? string5.equals(string) : string5.equalsIgnoreCase(string)) {
                    return locale;
                }
            }
        }
        return null;
    }

    public static String locale2FileName(Locale locale) {
        String string = locale.toString();
        if (string.length() > 0) {
            string = "_" + string;
        }
        return COLUMN + string + DISP;
    }

    public static Locale fileName2Locale(String string, String string2) {
        int n = string2.length();
        int n2 = DISP.length();
        if (string.length() >= n + n2 && (LABEL ? string.startsWith(string2) : string.substring(0, n).equalsIgnoreCase(string2)) && (LABEL ? string.endsWith(DISP) : string.substring(string.length() - n2).equalsIgnoreCase(DISP))) {
            Locale locale;
            String string3 = string.substring(string2.length(), string.length() - DISP.length());
            if (string3.length() > 0) {
                if (string3.charAt(0) != '_') {
                    return null;
                }
                string3 = string3.substring(1);
            }
            if ((locale = ServerUtil.getLocale(string3)) != null) {
                String string4 = NLSUtil.locale2FileName(locale, string2);
                if (LABEL ? string4.equals(string) : string4.equalsIgnoreCase(string)) {
                    return locale;
                }
            }
        }
        return null;
    }

    public static String locale2FileName(Locale locale, String string) {
        String string2 = locale.toString();
        if (string2.length() > 0) {
            string2 = "_" + string2;
        }
        return string + string2 + DISP;
    }

    public static Locale getParentLocale(Locale locale) {
        if (locale == null) {
            return null;
        }
        if (locale.getVariant().length() > 0) {
            return new Locale(locale.getLanguage(), locale.getCountry());
        }
        if (locale.getCountry().length() > 0) {
            return new Locale(locale.getLanguage());
        }
        if (locale.getLanguage().length() > 0) {
            return new Locale("", "");
        }
        return null;
    }

    static List getDynamicResource(JetRptReportSet jetRptReportSet) {
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList();
        BasicComponentLogic basicComponentLogic = ObjectLogicFactory.getBasicComponentLogic();
        basicComponentLogic.getAllPosterityComponentByClass((JetObject)jetRptReportSet, JetRptFlyFormula.class, arrayList2);
        for (Object object2 : arrayList2) {
            if (object2.isAnonymousFormula()) continue;
            arrayList.add(object2.getDisplayName());
        }
        ArrayList arrayList3 = new ArrayList();
        basicComponentLogic.getAllPosterityComponentByClass((JetObject)jetRptReportSet, JetRptFlyMeasure.class, (List)arrayList3);
        object2 = arrayList3.iterator();
        while (object2.hasNext()) {
            JetRptFlyMeasure jetRptFlyMeasure = (JetRptFlyMeasure)object2.next();
            arrayList.add(jetRptFlyMeasure.getDisplayName());
        }
        arrayList.add("Dynamic Resources");
        arrayList.add("Formulas");
        arrayList.add("Add Formula");
        arrayList.add("Aggregations");
        arrayList.add("Add Aggregation");
        arrayList.add("Add Measure");
        return arrayList;
    }

    private static NLSValue CATEGORY_KEY_CONCAT_CHAR(NLSValue nLSValue, NLSValue nLSValue2, Locale locale) {
        if (nLSValue.isEmptyValue()) {
            return nLSValue2;
        }
        if (nLSValue2.isEmptyValue()) {
            return nLSValue;
        }
        if (nLSValue.getValuePrority() == NLSToolKit.parsePrority((Locale)locale) || nLSValue.getValuePrority() <= nLSValue2.getValuePrority()) {
            return nLSValue;
        }
        return nLSValue2;
    }

    public static Map getNLSReportTabNames(String string, Locale locale, Map map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NLSResourceBundle nLSResourceBundle = NLSResourceBundleManager.loadReportNLSResourceBundle((File)new File(string), (Locale)locale, null);
        NLSApplyParam nLSApplyParam = new NLSApplyParam();
        nLSApplyParam.setNLSBundle((NLSBundle)nLSResourceBundle);
        NLSDictionary nLSDictionary = NLSUtil.getGlobalNLSDictionary();
        nLSApplyParam.setDictionary(nLSDictionary);
        int n = 10;
        for (String string2 : map.keySet()) {
            NLSValue nLSValue;
            String string3 = (String)map.get(string2);
            if (nLSResourceBundle != null) {
                NLSValue nLSValue2;
                nLSValue = nLSResourceBundle.getText(n, string2);
                if (nLSDictionary != null && nLSValue != (nLSValue2 = NLSUtil.CATEGORY_KEY_CONCAT_CHAR(nLSValue, nLSDictionary.getText(locale, n, string2), locale))) {
                    nLSValue = nLSValue2;
                }
                hashMap.put(string2, nLSValue.isEmptyValue() ? string3 : nLSValue.getStringValue());
                continue;
            }
            if (nLSDictionary != null) {
                nLSValue = nLSDictionary.getText(locale, n, string2);
                hashMap.put(string2, nLSValue.isEmptyValue() ? string3 : nLSValue.getStringValue());
                continue;
            }
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    public static List getAvailableLocalesOfNLS() {
        Locale locale;
        if ($SwitchMap$jet$server$api$nls$NLSType != null) {
            return $SwitchMap$jet$server$api$nls$NLSType;
        }
        List<Locale> list = Arrays.asList(NLSUtil.sortLocale(Locale.getAvailableLocales()));
        ArrayList<Locale> arrayList = new ArrayList<Locale>(list);
        if (!arrayList.contains(locale = new Locale("", "", ""))) {
            arrayList.add(0, locale);
        }
        $SwitchMap$jet$server$api$nls$NLSType = arrayList;
        return arrayList;
    }

    public static String[] getAvailableEncodings() {
        return UserDataToolkit.getNLSManager().getAvailableEncoding();
    }

    public static Locale[] getAllAvailableLocales() {
        NLSManager nLSManager = UserDataToolkit.getNLSManager();
        return nLSManager.getAvailableLocales();
    }

    public static double getPointSize(double d) {
        double d2 = d * 72.0 / 5760.0;
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(d2));
        BigDecimal bigDecimal2 = bigDecimal.setScale(1, 4);
        d2 = bigDecimal2.doubleValue();
        String string = String.valueOf(d2);
        String string2 = string.substring(string.indexOf(".") + 1);
        String string3 = string.substring(0, string.indexOf("."));
        int n = Integer.parseInt(string2);
        int n2 = Integer.parseInt(string3);
        double d3 = 0.0;
        if (n < 5) {
            d3 = Double.parseDouble(string3);
        }
        if (n == 5) {
            d3 = Double.parseDouble(string3 + "." + "5");
        }
        if (n > 5) {
            String string4 = String.valueOf(n2 + 1);
            d3 = Double.parseDouble(string4);
        }
        return d3;
    }

    public static long getUnit(double d) {
        return Math.round(d * 5760.0 / 72.0);
    }

    public static String mergeFontContext(String string, String string2) {
        return string.concat(",").concat(string2);
    }

    public static String[] parseFontContext(String string) {
        return NLSResourceBundle.parseFontValueTexts((String)string);
    }

    public static List getSizeList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 7; i < 73; ++i) {
            arrayList.add(String.valueOf(i));
        }
        return arrayList;
    }

    public static List getFaceList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = FontSets.getAllFonts();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        if (!arrayList.contains("Default")) {
            arrayList.add("Default");
            FontNameComparator fontNameComparator = new FontNameComparator();
            NLSSorter.sort(arrayList, (NLSComparator)fontNameComparator);
        }
        return arrayList;
    }

    public static void nlsEntriesToNLSContent(List list, NLSContent nLSContent) {
        Map[] mapArray = nLSContent.getContent();
        Map map = null;
        for (NLSEntry nLSEntry : list) {
            Object object;
            if (nLSEntry instanceof TextNLSEntry) {
                object = ((TextNLSEntry)nLSEntry).getType();
                String string = ((TextNLSEntry)nLSEntry).getKeyText();
                String string2 = ((TextNLSEntry)nLSEntry).getValueText();
                switch (1.$SwitchMap$jet$server$api$nls$NLSType[((Enum)object).ordinal()]) {
                    case 1: {
                        map = mapArray[0];
                        break;
                    }
                    case 2: {
                        map = mapArray[3];
                        break;
                    }
                    case 3: {
                        map = mapArray[4];
                        break;
                    }
                    case 4: {
                        map = mapArray[5];
                        break;
                    }
                    case 5: {
                        map = mapArray[6];
                        break;
                    }
                    case 6: {
                        map = mapArray[7];
                        break;
                    }
                    case 7: {
                        map = mapArray[8];
                    }
                }
                map.put(string, string2);
                continue;
            }
            if (nLSEntry instanceof FormatNLSEntry) {
                object = ((FormatNLSEntry)nLSEntry).getKeyFormat();
                String string = ((FormatNLSEntry)nLSEntry).getValueFormat();
                map = mapArray[1];
                map.put(object, string);
                continue;
            }
            object = ((FontNLSEntry)nLSEntry).getOrginalFace();
            long l = NLSUtil.getUnit(((FontNLSEntry)nLSEntry).getOrginalSize());
            String string = ((FontNLSEntry)nLSEntry).getTargetFace();
            long l2 = NLSUtil.getUnit(((FontNLSEntry)nLSEntry).getTargetSize());
            String string3 = NLSUtil.mergeFontContext((String)object, String.valueOf(l));
            String string4 = NLSUtil.mergeFontContext(string, String.valueOf(l2));
            map = mapArray[2];
            map.put(string3, string4);
        }
    }

    public static List nlsContentToNLSEntries(NLSContent nLSContent) {
        Object object;
        String string;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Map[] mapArray = nLSContent.getContent();
        Map map = mapArray[0];
        for (String string2 : map.keySet()) {
            string = (String)map.get(string2);
            object = new TextNLSEntry(NLSType.LABEL, string2, string);
            arrayList.add(object);
        }
        map = mapArray[1];
        for (String string2 : map.keySet()) {
            string = (String)map.get(string2);
            object = new FormatNLSEntry(string2, string);
            arrayList.add(object);
        }
        map = mapArray[2];
        for (String string2 : map.keySet()) {
            string = (String)map.get(string2);
            object = NLSUtil.parseFontContext(string2);
            double d = NLSUtil.getPointSize(Integer.parseInt(object[1]));
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
            decimalFormat.applyPattern("####");
            String string3 = decimalFormat.format(d);
            String[] stringArray = NLSUtil.parseFontContext(string);
            double d2 = NLSUtil.getPointSize(Integer.parseInt(stringArray[1]));
            String string4 = decimalFormat.format(d2);
            FontNLSEntry fontNLSEntry = new FontNLSEntry(object[0], Integer.parseInt(string3), stringArray[0], Integer.parseInt(string4), false);
            arrayList.add(fontNLSEntry);
        }
        map = mapArray[3];
        for (String string2 : map.keySet()) {
            string = (String)map.get(string2);
            object = new TextNLSEntry(NLSType.COLUMN, string2, string);
            arrayList.add(object);
        }
        map = mapArray[4];
        for (String string2 : map.keySet()) {
            string = (String)map.get(string2);
            object = new TextNLSEntry(NLSType.PROMPT, string2, string);
            arrayList.add(object);
        }
        map = mapArray[5];
        for (String string2 : map.keySet()) {
            string = (String)map.get(string2);
            object = new TextNLSEntry(NLSType.TOC, string2, string);
            arrayList.add(object);
        }
        map = mapArray[6];
        for (String string2 : map.keySet()) {
            string = (String)map.get(string2);
            object = new TextNLSEntry(NLSType.META, string2, string);
            arrayList.add(object);
        }
        map = mapArray[7];
        for (String string2 : map.keySet()) {
            string = (String)map.get(string2);
            object = new TextNLSEntry(NLSType.TITLE, string2, string);
            arrayList.add(object);
        }
        map = mapArray[8];
        for (String string2 : map.keySet()) {
            string = (String)map.get(string2);
            object = new TextNLSEntry(NLSType.DISP, string2, string);
            arrayList.add(object);
        }
        return arrayList;
    }

    public static Object[] getRootPaths4Path(String string, Locale locale) {
        String[] stringArray = APIUtil.parsePrincipalDisplayName(string);
        String string2 = APIUtil.getVirtualResourcePathPrefix(stringArray[0]);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = "";
        arrayList.add(string2 + "/COMPONENT_LIB" + "/USERFOLDERPATH" + "/" + stringArray[1]);
        hashMap.put(string2 + "/COMPONENT_LIB" + "/USERFOLDERPATH" + "/" + stringArray[1], "22221072");
        arrayList.add(string2 + "/USERFOLDERPATH" + "/" + stringArray[1]);
        hashMap.put(string2 + "/USERFOLDERPATH" + "/" + stringArray[1], "2220407");
        arrayList.add("/COMPONENT_LIB");
        hashMap.put("/COMPONENT_LIB", "22221073");
        if (stringArray[0] != null) {
            arrayList.add(string2 + "/COMPONENT_LIB");
            hashMap.put(string2 + "/COMPONENT_LIB", "22221413");
            arrayList.add(string2 + "/");
            hashMap.put(string2 + "/", "22221412");
        }
        arrayList.add(string3);
        hashMap.put(string3, "2220408");
        Object[] objectArray = new Object[]{arrayList, hashMap};
        return objectArray;
    }

    public static String getRootNodeDisplayName(PathInfo pathInfo, String string, Locale locale, String string2, PropertyMessageResourcesFactory propertyMessageResourcesFactory) {
        String string3 = null;
        if (pathInfo != null) {
            string3 = pathInfo.getDisplay(locale);
        }
        if (string3 == null) {
            string3 = propertyMessageResourcesFactory.getMessage(string2);
        }
        return string3;
    }

    public static String getDisplayName(PathInfo pathInfo, Locale locale) {
        String string = pathInfo.getDisplay(locale);
        if (string == null) {
            string = pathInfo.getName();
        }
        return string;
    }

    public static String getDisplayName(HttpRptServer httpRptServer, String string, String string2, Locale locale) {
        try {
            PathInfo pathInfo = httpRptServer.getResourceManager().getPathInfo(string2, string);
            return NLSUtil.getDisplayName(pathInfo, locale);
        }
        catch (RptServerException rptServerException) {
            if (!string.endsWith("/")) {
                return string.substring(string.lastIndexOf("/"));
            }
            return "";
        }
    }

    public static String getRootNodeDisplayName(HttpRptServer httpRptServer, String string, String string2, Locale locale, String string3, PropertyMessageResourcesFactory propertyMessageResourcesFactory) {
        Object var6_6 = null;
        if (string.length() == 0) {
            string = "/";
        }
        PathInfo pathInfo = null;
        try {
            pathInfo = httpRptServer.getResourceManager().getPathInfo(string2, string);
        }
        catch (RptServerException rptServerException) {
            ServiceLogger.logError((Throwable)((Object)rptServerException), 3);
        }
        return NLSUtil.getRootNodeDisplayName(pathInfo, string2, locale, string3, propertyMessageResourcesFactory);
    }

    public static String getDisplayPath(HttpRptServer httpRptServer, String string, String string2, Locale locale, PropertyMessageResourcesFactory propertyMessageResourcesFactory) {
        String string3;
        String string4 = "/";
        Object[] objectArray = NLSUtil.getRootPaths4Path(string2, locale);
        ArrayList arrayList = (ArrayList)objectArray[0];
        HashMap hashMap = (HashMap)objectArray[1];
        String string5 = "";
        Object object = arrayList.iterator();
        while (object.hasNext() && !string.startsWith(string5 = (string3 = (String)object.next()))) {
        }
        object = string.substring(string5.length());
        StringTokenizer stringTokenizer = new StringTokenizer((String)object, "/", false);
        if (stringTokenizer.hasMoreElements()) {
            string4 = string4 + NLSUtil.getRootNodeDisplayName(httpRptServer, string5, string2, locale, (String)hashMap.get(string5), propertyMessageResourcesFactory);
            if (string5.endsWith("/")) {
                string5 = string5.substring(0, string5.length() - 1);
            }
            while (stringTokenizer.hasMoreElements()) {
                String string6 = stringTokenizer.nextToken();
                string5 = string5 + "/" + string6;
                string4 = string4 + "/" + NLSUtil.getDisplayName(httpRptServer, string5, string2, locale);
            }
        } else {
            string4 = string4 + NLSUtil.getRootNodeDisplayName(httpRptServer, string5, string2, locale, (String)hashMap.get(string5), propertyMessageResourcesFactory);
        }
        return string4;
    }

    public static Locale parseLanguageTagToLocale(String string) {
        if (null == string || 0 == string.trim().length()) {
            return null;
        }
        string = string.replaceAll("_", "-");
        String[] stringArray = string.split("-");
        String string2 = "";
        String string3 = "";
        String string4 = "";
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (String string5 : stringArray) {
            if (!bl && string5.matches("^[a-zA-Z]{2,8}$")) {
                string2 = string5;
                bl = true;
                continue;
            }
            if (!bl2 && string5.matches("^[a-zA-Z]{3}$")) {
                string2 = string5;
                bl2 = true;
                continue;
            }
            if (!bl3 && string5.matches("^([a-zA-Z]{2})|([0-9]{3})$")) {
                string3 = string5;
                bl3 = true;
                continue;
            }
            if (!string5.matches("^([0-9][0-9a-zA-Z]{3})|([0-9a-zA-Z]{5,8})$")) continue;
            if (0 == stringBuffer.length()) {
                stringBuffer.append(string5);
                continue;
            }
            stringBuffer.append("-");
            stringBuffer.append(string5);
        }
        string4 = stringBuffer.toString();
        return new Locale(string2, string3, string4);
    }

    static {
        LABEL = !new File("A").equals(new File("a"));
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$jet$server$api$nls$NLSType;

        static {
            $SwitchMap$jet$server$api$nls$NLSType = new int[NLSType.values().length];
            try {
                1.$SwitchMap$jet$server$api$nls$NLSType[NLSType.LABEL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$jet$server$api$nls$NLSType[NLSType.COLUMN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$jet$server$api$nls$NLSType[NLSType.PROMPT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$jet$server$api$nls$NLSType[NLSType.TOC.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$jet$server$api$nls$NLSType[NLSType.META.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$jet$server$api$nls$NLSType[NLSType.TITLE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$jet$server$api$nls$NLSType[NLSType.DISP.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

