/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.JSvrResource;
import jet.cs.jacl.BaseRole;
import jet.cs.jacl.BaseUser;
import jet.cs.jacl.JAcl;
import jet.cs.jacl.JAclEntry;
import jet.cs.jacl.JPrivilege;
import jet.server.api.custom.JRCustomerException;
import jet.server.api.custom.security.SecurityListener;
import jet.server.api.custom.security.group.GroupPermissionProvider;
import jet.server.api.custom.security.group.GroupPrivilegeProvider;
import jet.server.api.custom.security.role.RolePermissionProvider;
import jet.server.api.custom.security.role.RolePrivilegeProvider;
import jet.server.api.custom.security.user.UserPermissionProvider;
import jet.server.api.custom.security.user.UserPrivilegeProvider;
import jet.server.api.exception.NoSuchAclException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.intf.security.SecurityWebUIController;
import jet.server.jrc.security.AclExistException;
import jet.server.jrc.security.ExCachedSecurityDataImpl;
import jet.server.jrc.security.NoSuchAclEntryException;
import jet.server.jrc.security.PermissionUtil;
import jet.server.jrc.security.cache.CachedSecurityDataImpl;
import jet.server.jrc.security.custom.SecurityListenerSynImpl;
import jet.server.log.ServiceLogger;

public class AclDataManager {
    private CachedSecurityDataImpl SEDU;
    private String add;
    private SecurityListener addElement;
    protected UserPermissionProvider userPermissionProvider;
    protected UserPrivilegeProvider userPrivilegeProvider;
    protected GroupPermissionProvider groupPermissionProvider;
    protected GroupPrivilegeProvider groupPrivilegeProvider;
    protected RolePermissionProvider rolePermissionProvider;
    protected RolePrivilegeProvider rolePrivilegeProvider;
    boolean isEnableEditUserPermissions = true;
    boolean isEnableEditRolePermissions = true;
    boolean isEnableEditGroupPermissions = true;
    boolean isEnableEditUserPrivileges = true;
    boolean isEnableEditRolePrivileges = true;
    boolean isEnableEditGroupPrivileges = true;

    public AclDataManager(ExCachedSecurityDataImpl exCachedSecurityDataImpl, SecurityWebUIController securityWebUIController) {
        this.SEDU = exCachedSecurityDataImpl;
        this.add = exCachedSecurityDataImpl.getRealmName();
        this.isEnableEditUserPermissions = securityWebUIController.isEditing(11);
        this.isEnableEditRolePermissions = securityWebUIController.isEditing(12);
        this.isEnableEditGroupPermissions = securityWebUIController.isEditing(13);
        this.isEnableEditUserPrivileges = securityWebUIController.isEditing(14);
        this.isEnableEditRolePrivileges = securityWebUIController.isEditing(15);
        this.isEnableEditGroupPrivileges = securityWebUIController.isEditing(16);
        this.userPermissionProvider = exCachedSecurityDataImpl.getUserPermissionProvider();
        this.userPrivilegeProvider = exCachedSecurityDataImpl.getUserPrivilegeProvider();
        this.groupPermissionProvider = exCachedSecurityDataImpl.getGroupPermissionProvider();
        this.groupPrivilegeProvider = exCachedSecurityDataImpl.getGroupPrivilegeProvider();
        this.rolePermissionProvider = exCachedSecurityDataImpl.getRolePermissionProvider();
        this.rolePrivilegeProvider = exCachedSecurityDataImpl.getRolePrivilegeProvider();
        this.addElement = new SecurityListenerSynImpl(exCachedSecurityDataImpl);
    }

    public AclDataManager(ExCachedSecurityDataImpl exCachedSecurityDataImpl) {
        this.SEDU = exCachedSecurityDataImpl;
        this.add = exCachedSecurityDataImpl.getRealmName();
        this.userPermissionProvider = exCachedSecurityDataImpl.getUserPermissionProvider();
        this.userPrivilegeProvider = exCachedSecurityDataImpl.getUserPrivilegeProvider();
        this.groupPermissionProvider = exCachedSecurityDataImpl.getGroupPermissionProvider();
        this.groupPrivilegeProvider = exCachedSecurityDataImpl.getGroupPrivilegeProvider();
        this.rolePermissionProvider = exCachedSecurityDataImpl.getRolePermissionProvider();
        this.rolePrivilegeProvider = exCachedSecurityDataImpl.getRolePrivilegeProvider();
        this.addElement = new SecurityListenerSynImpl(exCachedSecurityDataImpl);
    }

    public synchronized JAcl getDefaultAcl() throws NoSuchAclException {
        JAcl jAcl = this.SEDU.getAcl("/", -1);
        if (jAcl == null) {
            throw new NoSuchAclException(630007);
        }
        return jAcl;
    }

    public synchronized JAcl getAcl(String string, int n) throws NoSuchAclException {
        JAcl jAcl = this.SEDU.getAcl(string, n);
        if (jAcl == null) {
            throw new NoSuchAclException(630006, (Object[])new String[]{string + "[" + n + "]"}, null);
        }
        return jAcl;
    }

    public synchronized void addAcl(String string, String string2, int n, Hashtable[] hashtableArray) throws AclExistException {
        String string3;
        Principal principal;
        String string4;
        Enumeration enumeration;
        if (hashtableArray[0] != null && this.isEnableEditUserPermissions) {
            enumeration = hashtableArray[0].keys();
            while (enumeration.hasMoreElements()) {
                string4 = (String)enumeration.nextElement();
                principal = this.SEDU.getUser(string4);
                if (principal == null || (string3 = (String)hashtableArray[0].get(string4)) == null) continue;
                try {
                    this.userPermissionProvider.setUserPermissions(this.add, string4, string2, n, string3);
                }
                catch (NoSuchUserException noSuchUserException) {
                }
                catch (JRCustomerException jRCustomerException) {
                    ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                }
            }
        }
        if (hashtableArray[1] != null && this.isEnableEditRolePermissions) {
            enumeration = hashtableArray[1].keys();
            while (enumeration.hasMoreElements()) {
                string4 = (String)enumeration.nextElement();
                principal = this.SEDU.getRole(string4);
                if (principal == null || (string3 = (String)hashtableArray[1].get(string4)) == null) continue;
                try {
                    this.rolePermissionProvider.setRolePermissions(this.add, string4, string2, n, string3);
                }
                catch (NoSuchRoleException noSuchRoleException) {
                }
                catch (JRCustomerException jRCustomerException) {
                    ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                }
            }
        }
        if (hashtableArray[2] != null && this.isEnableEditGroupPermissions) {
            enumeration = hashtableArray[2].keys();
            while (enumeration.hasMoreElements()) {
                string4 = (String)enumeration.nextElement();
                principal = this.SEDU.getGroup(string4);
                if (principal == null || (string3 = (String)hashtableArray[2].get(string4)) == null) continue;
                try {
                    this.groupPermissionProvider.setGroupPermissions(this.add, string4, string2, n, string3);
                }
                catch (NoSuchGroupException noSuchGroupException) {
                }
                catch (JRCustomerException jRCustomerException) {
                    ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                }
            }
        }
        this.addElement.updatePermissons(this.add, string2, n);
    }

    public synchronized boolean removeAcl(String string, int n) {
        Object object;
        Object object2;
        Object object3;
        try {
            this.getAcl(string, n);
        }
        catch (NoSuchAclException noSuchAclException) {
            return false;
        }
        Hashtable hashtable = null;
        if (this.isEnableEditUserPermissions) {
            try {
                hashtable = this.userPermissionProvider.getUserPermissions(this.add, string, n);
            }
            catch (JRCustomerException jRCustomerException) {
                ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            }
            if (hashtable != null) {
                object3 = hashtable.keys();
                while (object3.hasMoreElements()) {
                    object2 = (String)object3.nextElement();
                    if (object2 == null) continue;
                    try {
                        this.userPermissionProvider.setUserPermissions(this.add, (String)object2, string, n, null);
                    }
                    catch (NoSuchUserException noSuchUserException) {
                    }
                    catch (JRCustomerException jRCustomerException) {
                        ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                    }
                }
            }
        }
        object3 = null;
        if (this.isEnableEditGroupPermissions) {
            try {
                object3 = this.groupPermissionProvider.getGroupPermissions(this.add, string, n);
            }
            catch (JRCustomerException jRCustomerException) {
                ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            }
            if (object3 != null) {
                object2 = ((Hashtable)object3).keys();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    if (object == null) continue;
                    try {
                        this.groupPermissionProvider.setGroupPermissions(this.add, (String)object, string, n, null);
                    }
                    catch (NoSuchGroupException noSuchGroupException) {
                    }
                    catch (JRCustomerException jRCustomerException) {
                        ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                    }
                }
            }
        }
        if (this.isEnableEditRolePermissions) {
            object2 = null;
            try {
                object2 = this.rolePermissionProvider.getRolePermissions(this.add, string, n);
            }
            catch (JRCustomerException jRCustomerException) {
                ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            }
            if (object2 != null) {
                object = ((Hashtable)object2).keys();
                while (object.hasMoreElements()) {
                    String string2 = (String)object.nextElement();
                    if (string2 == null) continue;
                    try {
                        this.rolePermissionProvider.setRolePermissions(this.add, string2, string, n, null);
                    }
                    catch (NoSuchRoleException noSuchRoleException) {
                    }
                    catch (JRCustomerException jRCustomerException) {
                        ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                    }
                }
            }
        }
        this.addElement.updatePermissons(this.add, string, n);
        return true;
    }

    public synchronized JAclEntry getAclEntry(String string, int n, Principal principal, boolean bl) throws NoSuchAclException, NoSuchAclEntryException {
        JAcl jAcl = this.getAcl(string, n);
        if (jAcl == null) {
            throw new NoSuchAclException(630006, (Object[])new String[]{string + "[" + n + "]"}, null);
        }
        JAclEntry jAclEntry = jAcl.getJAclEntry(principal, bl);
        if (jAclEntry == null) {
            throw new NoSuchAclEntryException(630080, (Object[])new String[]{principal.getName()}, null);
        }
        return jAclEntry;
    }

    public synchronized boolean remove(String string, int n, Principal principal) throws NoSuchAclEntryException, NoSuchAclException {
        JAcl jAcl = this.getAcl(string, n);
        String string2 = principal.getName();
        boolean bl = true;
        if (principal instanceof BaseUser && this.isEnableEditUserPermissions) {
            try {
                this.userPermissionProvider.setUserPermissions(this.add, string2, string, n, null);
            }
            catch (NoSuchUserException noSuchUserException) {
                ServiceLogger.logError((Throwable)((Object)noSuchUserException));
                bl = false;
            }
            catch (JRCustomerException jRCustomerException) {
                ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                bl = false;
            }
        } else if (principal instanceof BaseRole && this.isEnableEditRolePermissions) {
            try {
                this.rolePermissionProvider.setRolePermissions(this.add, string2, string, n, null);
            }
            catch (NoSuchRoleException noSuchRoleException) {
                ServiceLogger.logError((Throwable)((Object)noSuchRoleException));
                bl = false;
            }
            catch (JRCustomerException jRCustomerException) {
                ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                bl = false;
            }
        } else if (this.isEnableEditGroupPermissions) {
            try {
                this.groupPermissionProvider.setGroupPermissions(this.add, string2, string, n, null);
            }
            catch (NoSuchGroupException noSuchGroupException) {
                ServiceLogger.logError((Throwable)((Object)noSuchGroupException));
                bl = false;
            }
            catch (JRCustomerException jRCustomerException) {
                ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                bl = false;
            }
        }
        if (bl) {
            jAcl.removeJAclEntry(principal, true);
            jAcl.removeJAclEntry(principal, false);
            this.addElement.updatePermissons(this.add, string, n);
            return true;
        }
        ServiceLogger.logError(3630073, string2, 3);
        return false;
    }

    public JAcl getExtendAcl() throws NoSuchAclException {
        JAcl jAcl = this.SEDU.getExtendAcl();
        if (jAcl == null) {
            throw new NoSuchAclException(630007);
        }
        return jAcl;
    }

    public String addExtendAclEntry(JAclEntry jAclEntry) {
        Principal principal = jAclEntry.getPrincipal();
        String string = principal.getName();
        int n = PermissionUtil.turnPrivilegesToCode(jAclEntry);
        String[] stringArray = PermissionUtil.getPrivilegesFromPrivilegesCode(n);
        if (principal instanceof BaseUser && this.isEnableEditUserPrivileges) {
            try {
                this.userPrivilegeProvider.setUserPrivileges(this.add, string, stringArray);
                this.addElement.updatePrivileges(this.add, string, 1);
            }
            catch (NoSuchUserException noSuchUserException) {
                ServiceLogger.logError((Throwable)((Object)noSuchUserException));
                return JSvrResource.getMessage("SVR_93", string);
            }
            catch (JRCustomerException jRCustomerException) {
                ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                return JSvrResource.getMessage("SECURITY_M_03001", string);
            }
        }
        if (principal instanceof BaseRole && this.isEnableEditRolePrivileges) {
            try {
                this.rolePrivilegeProvider.setRolePrivileges(this.add, string, stringArray);
                this.addElement.updatePrivileges(this.add, string, 2);
            }
            catch (NoSuchRoleException noSuchRoleException) {
                ServiceLogger.logError((Throwable)((Object)noSuchRoleException));
                return JSvrResource.getMessage("SECURITY_ERR_13_ROLE_NOT_EXIST", string);
            }
            catch (JRCustomerException jRCustomerException) {
                ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                return JSvrResource.getMessage("SECURITY_M_03002", string);
            }
        }
        if (this.isEnableEditGroupPrivileges) {
            try {
                this.groupPrivilegeProvider.setGroupPrivileges(this.add, string, stringArray);
                this.addElement.updatePrivileges(this.add, string, 3);
            }
            catch (NoSuchGroupException noSuchGroupException) {
                ServiceLogger.logError((Throwable)((Object)noSuchGroupException));
                return JSvrResource.getMessage("SEUCRITY_ERR_63_GROUP_NOT_EXIST", string);
            }
            catch (JRCustomerException jRCustomerException) {
                ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                return JSvrResource.getMessage("SECURITY_M_03003", string);
            }
        }
        return null;
    }

    public Vector getPrivilegedUsers(JPrivilege jPrivilege) {
        Vector<String> vector = new Vector<String>();
        Hashtable hashtable = null;
        try {
            hashtable = this.userPrivilegeProvider.getUserPrivileges(this.add);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            return vector;
        }
        if (hashtable != null && hashtable.size() != 0) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                int n;
                String string = (String)enumeration.nextElement();
                String[] stringArray = (String[])hashtable.get(string);
                if (stringArray == null || !PermissionUtil.checkPermissionCode(n = PermissionUtil.getPrivilegesCodeFromPrivilegeNames(stringArray), jPrivilege)) continue;
                vector.addElement(string);
            }
        }
        return vector;
    }

    public Vector getPrivilegedRoles(JPrivilege jPrivilege) {
        Vector<String> vector = new Vector<String>();
        Hashtable hashtable = null;
        try {
            hashtable = this.rolePrivilegeProvider.getRolePrivileges(this.add);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            return vector;
        }
        if (hashtable != null && hashtable.size() != 0) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                int n;
                String string = (String)enumeration.nextElement();
                String[] stringArray = (String[])hashtable.get(string);
                if (stringArray == null || !PermissionUtil.checkPermissionCode(n = PermissionUtil.getPrivilegesCodeFromPrivilegeNames(stringArray), jPrivilege)) continue;
                vector.addElement(string);
            }
        }
        return vector;
    }

    public Vector getPrivilegedGroups(JPrivilege jPrivilege) {
        Vector<String> vector = new Vector<String>();
        Hashtable hashtable = null;
        try {
            hashtable = this.groupPrivilegeProvider.getGroupPrivileges(this.add);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            return vector;
        }
        if (hashtable != null && hashtable.size() != 0) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                int n;
                String string = (String)enumeration.nextElement();
                String[] stringArray = (String[])hashtable.get(string);
                if (stringArray == null || !PermissionUtil.checkPermissionCode(n = PermissionUtil.getPrivilegesCodeFromPrivilegeNames(stringArray), jPrivilege)) continue;
                vector.addElement(string);
            }
        }
        return vector;
    }

    public void addPrivilegedUsers(JPrivilege jPrivilege, Vector vector) {
        this.SEDU(jPrivilege, vector, (byte)1);
    }

    public void addPrivilegedRoles(JPrivilege jPrivilege, Vector vector) {
        this.SEDU(jPrivilege, vector, (byte)2);
    }

    public void addPrivilegedGroups(JPrivilege jPrivilege, Vector vector) {
        this.SEDU(jPrivilege, vector, (byte)3);
    }

    private void SEDU(JPrivilege jPrivilege, Vector vector, byte by) {
        Hashtable hashtable = null;
        switch (by) {
            case 1: {
                if (!this.isEnableEditUserPrivileges) break;
                try {
                    hashtable = this.userPrivilegeProvider.getUserPrivileges(this.add);
                }
                catch (JRCustomerException jRCustomerException) {
                    ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                    return;
                }
                if (hashtable != null) {
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        String[] stringArray = (String[])hashtable.get(string);
                        int n = 0;
                        if (stringArray != null) {
                            n = PermissionUtil.getPrivilegesCodeFromPrivilegeNames(stringArray);
                            n = PermissionUtil.addPrivilegeToCode(n, jPrivilege);
                        } else {
                            n = PermissionUtil.addPrivilegeToCode(0, jPrivilege);
                        }
                        String[] stringArray2 = PermissionUtil.getPrivilegesFromPrivilegesCode(n);
                        try {
                            this.userPrivilegeProvider.setUserPrivileges(this.add, string, stringArray2);
                            this.addElement.updatePrivileges(this.add, string, 1);
                        }
                        catch (NoSuchUserException noSuchUserException) {
                            ServiceLogger.logError((Throwable)((Object)noSuchUserException));
                        }
                        catch (JRCustomerException jRCustomerException) {
                            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                        }
                    }
                } else {
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        int n = 0;
                        n = PermissionUtil.addPrivilegeToCode(n, jPrivilege);
                        String[] stringArray = PermissionUtil.getPrivilegesFromPrivilegesCode(n);
                        try {
                            this.userPrivilegeProvider.setUserPrivileges(this.add, string, stringArray);
                            this.addElement.updatePrivileges(this.add, string, 1);
                        }
                        catch (NoSuchUserException noSuchUserException) {
                            ServiceLogger.logError((Throwable)((Object)noSuchUserException));
                        }
                        catch (JRCustomerException jRCustomerException) {
                            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                        }
                    }
                }
                break;
            }
            case 2: {
                if (!this.isEnableEditRolePrivileges) break;
                try {
                    hashtable = this.rolePrivilegeProvider.getRolePrivileges(this.add);
                }
                catch (JRCustomerException jRCustomerException) {
                    ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                    return;
                }
                if (hashtable != null) {
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        String[] stringArray = (String[])hashtable.get(string);
                        int n = 0;
                        if (stringArray != null) {
                            n = PermissionUtil.getPrivilegesCodeFromPrivilegeNames(stringArray);
                            n = PermissionUtil.addPrivilegeToCode(n, jPrivilege);
                        } else {
                            n = PermissionUtil.addPrivilegeToCode(0, jPrivilege);
                        }
                        String[] stringArray3 = PermissionUtil.getPrivilegesFromPrivilegesCode(n);
                        try {
                            this.rolePrivilegeProvider.setRolePrivileges(this.add, string, stringArray3);
                            this.addElement.updatePrivileges(this.add, string, 2);
                        }
                        catch (NoSuchRoleException noSuchRoleException) {
                            ServiceLogger.logError((Throwable)((Object)noSuchRoleException));
                        }
                        catch (JRCustomerException jRCustomerException) {
                            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                        }
                    }
                } else {
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        int n = 0;
                        n = PermissionUtil.addPrivilegeToCode(n, jPrivilege);
                        String[] stringArray = PermissionUtil.getPrivilegesFromPrivilegesCode(n);
                        try {
                            this.rolePrivilegeProvider.setRolePrivileges(this.add, string, stringArray);
                            this.addElement.updatePrivileges(this.add, string, 2);
                        }
                        catch (NoSuchRoleException noSuchRoleException) {
                            ServiceLogger.logError((Throwable)((Object)noSuchRoleException));
                        }
                        catch (JRCustomerException jRCustomerException) {
                            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                        }
                    }
                }
                break;
            }
            case 3: {
                if (!this.isEnableEditGroupPrivileges) break;
                try {
                    hashtable = this.groupPrivilegeProvider.getGroupPrivileges(this.add);
                }
                catch (JRCustomerException jRCustomerException) {
                    ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                    return;
                }
                if (hashtable != null) {
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        String[] stringArray = (String[])hashtable.get(string);
                        int n = 0;
                        if (stringArray != null) {
                            n = PermissionUtil.getPrivilegesCodeFromPrivilegeNames(stringArray);
                            n = PermissionUtil.addPrivilegeToCode(n, jPrivilege);
                        } else {
                            n = PermissionUtil.addPrivilegeToCode(0, jPrivilege);
                        }
                        String[] stringArray4 = PermissionUtil.getPrivilegesFromPrivilegesCode(n);
                        try {
                            this.groupPrivilegeProvider.setGroupPrivileges(this.add, string, stringArray4);
                            this.addElement.updatePrivileges(this.add, string, 3);
                        }
                        catch (NoSuchGroupException noSuchGroupException) {
                            ServiceLogger.logError((Throwable)((Object)noSuchGroupException));
                        }
                        catch (JRCustomerException jRCustomerException) {
                            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                        }
                    }
                } else {
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        int n = 0;
                        n = PermissionUtil.addPrivilegeToCode(n, jPrivilege);
                        String[] stringArray = PermissionUtil.getPrivilegesFromPrivilegesCode(n);
                        try {
                            this.groupPrivilegeProvider.setGroupPrivileges(this.add, string, stringArray);
                            this.addElement.updatePrivileges(this.add, string, 3);
                        }
                        catch (NoSuchGroupException noSuchGroupException) {
                            ServiceLogger.logError((Throwable)((Object)noSuchGroupException));
                        }
                        catch (JRCustomerException jRCustomerException) {
                            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                        }
                    }
                }
                break;
            }
        }
    }

    public String removePrivilegedUsers(JPrivilege jPrivilege, Vector vector) {
        return this.removePrivilegedPrincipals(jPrivilege, vector, (byte)1);
    }

    public String removePrivilegedRoles(JPrivilege jPrivilege, Vector vector) {
        return this.removePrivilegedPrincipals(jPrivilege, vector, (byte)2);
    }

    public String removePrivilegedGroups(JPrivilege jPrivilege, Vector vector) {
        return this.removePrivilegedPrincipals(jPrivilege, vector, (byte)3);
    }

    public String removePrivilegedPrincipals(JPrivilege jPrivilege, Vector vector, byte by) {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = vector.elements();
        switch (by) {
            case 1: {
                Hashtable hashtable;
                if (!this.isEnableEditUserPrivileges) break;
                try {
                    hashtable = this.userPrivilegeProvider.getUserPrivileges(this.add);
                }
                catch (JRCustomerException jRCustomerException) {
                    ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                    return JSvrResource.getMessage("SECYRITY_M_03012");
                }
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    String[] stringArray = new String[]{};
                    if (hashtable != null) {
                        stringArray = (String[])hashtable.get(string2);
                    }
                    Vector<String> vector2 = new Vector<String>();
                    String[] stringArray2 = null;
                    String string3 = PermissionUtil.turnPrivilegeToString(jPrivilege);
                    if (stringArray != null) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            String string4 = stringArray[i];
                            if (string4.equals(string3)) continue;
                            vector2.add(string4);
                        }
                    } else {
                        return null;
                    }
                    stringArray2 = vector2.toArray(new String[vector2.size()]);
                    try {
                        this.userPrivilegeProvider.setUserPrivileges(this.add, string2, stringArray2);
                        this.addElement.updatePrivileges(this.add, string2, 1);
                    }
                    catch (NoSuchUserException noSuchUserException) {
                        ServiceLogger.logError((Throwable)((Object)noSuchUserException));
                        stringBuffer.append(string2).append(", ");
                    }
                    catch (JRCustomerException jRCustomerException) {
                        ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                        stringBuffer.append(string2).append(", ");
                    }
                }
                break;
            }
            case 2: {
                Hashtable hashtable;
                if (!this.isEnableEditRolePrivileges) break;
                try {
                    hashtable = this.rolePrivilegeProvider.getRolePrivileges(this.add);
                }
                catch (JRCustomerException jRCustomerException) {
                    ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                    return JSvrResource.getMessage("SECYRITY_M_03012");
                }
                while (enumeration.hasMoreElements()) {
                    String string5 = (String)enumeration.nextElement();
                    String[] stringArray = new String[]{};
                    if (hashtable != null) {
                        stringArray = (String[])hashtable.get(string5);
                    }
                    Vector<String> vector3 = new Vector<String>();
                    String[] stringArray3 = null;
                    String string6 = PermissionUtil.turnPrivilegeToString(jPrivilege);
                    if (stringArray != null) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            String string7 = stringArray[i];
                            if (string7.equals(string6)) continue;
                            vector3.add(string7);
                        }
                    } else {
                        return null;
                    }
                    stringArray3 = vector3.toArray(new String[vector3.size()]);
                    try {
                        this.rolePrivilegeProvider.setRolePrivileges(this.add, string5, stringArray3);
                        this.addElement.updatePrivileges(this.add, string5, 2);
                    }
                    catch (NoSuchRoleException noSuchRoleException) {
                        ServiceLogger.logError((Throwable)((Object)noSuchRoleException));
                        stringBuffer.append(string5).append(", ");
                    }
                    catch (JRCustomerException jRCustomerException) {
                        ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                        stringBuffer.append(string5).append(", ");
                    }
                }
                break;
            }
            case 3: {
                Hashtable hashtable;
                if (!this.isEnableEditGroupPrivileges) break;
                try {
                    hashtable = this.groupPrivilegeProvider.getGroupPrivileges(this.add);
                }
                catch (JRCustomerException jRCustomerException) {
                    ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                    return JSvrResource.getMessage("SECYRITY_M_03012");
                }
                while (enumeration.hasMoreElements()) {
                    String string8 = (String)enumeration.nextElement();
                    String[] stringArray = new String[]{};
                    if (hashtable != null) {
                        stringArray = (String[])hashtable.get(string8);
                    }
                    Vector<String> vector4 = new Vector<String>();
                    String[] stringArray4 = null;
                    String string9 = PermissionUtil.turnPrivilegeToString(jPrivilege);
                    if (stringArray != null) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            String string10 = stringArray[i];
                            if (string10.equals(string9)) continue;
                            vector4.add(string10);
                        }
                    } else {
                        return null;
                    }
                    stringArray4 = vector4.toArray(new String[vector4.size()]);
                    try {
                        this.groupPrivilegeProvider.setGroupPrivileges(this.add, string8, stringArray4);
                        this.addElement.updatePrivileges(this.add, string8, 3);
                    }
                    catch (NoSuchGroupException noSuchGroupException) {
                        ServiceLogger.logError((Throwable)((Object)noSuchGroupException));
                        stringBuffer.append(string8).append(", ");
                    }
                    catch (JRCustomerException jRCustomerException) {
                        ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                        stringBuffer.append(string8).append(", ");
                    }
                }
                break;
            }
        }
        if (stringBuffer.length() != 0) {
            string = "Remote [" + stringBuffer.toString() + "] error!";
        }
        return string;
    }
}

