/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.cs.jacl.BaseGroup;
import jet.server.ServerEnv;
import jet.server.api.custom.JRCustomerException;
import jet.server.api.custom.security.SecurityListener;
import jet.server.api.custom.security.group.GroupProvider;
import jet.server.api.custom.security.relation.RoleGroupRelationProvider;
import jet.server.api.exception.GroupExistsException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.intf.security.Group;
import jet.server.intf.security.SecurityWebUIController;
import jet.server.jrc.security.ExCachedSecurityDataImpl;
import jet.server.jrc.security.cache.CachedSecurityDataImpl;
import jet.server.jrc.security.custom.SecurityListenerSynImpl;
import jet.server.jrc.security.custom.db.group.GroupProviderDBImpl;
import jet.server.log.ServiceLogger;

public class GroupDataManager {
    private String SEDU;
    private CachedSecurityDataImpl TAG_GROUP_DB_TYPE;
    private GroupProvider add;
    protected RoleGroupRelationProvider roleGroupRelationProvider;
    private SecurityListener addGroup;
    boolean isEnableEditGroup = true;
    boolean isEnableAddGroup = true;
    boolean isEnableRemoveGroup = true;
    boolean isEnableEditGroupSubGroupRelation = true;

    public GroupDataManager(ExCachedSecurityDataImpl exCachedSecurityDataImpl, SecurityWebUIController securityWebUIController) {
        this.TAG_GROUP_DB_TYPE = exCachedSecurityDataImpl;
        this.SEDU = exCachedSecurityDataImpl.getRealmName();
        this.isEnableEditGroup = securityWebUIController.isEditing(8);
        this.isEnableAddGroup = securityWebUIController.isEditing(10);
        this.isEnableRemoveGroup = securityWebUIController.isEditing(9);
        this.isEnableEditGroupSubGroupRelation = securityWebUIController.isEditing(20);
        this.add = exCachedSecurityDataImpl.getGroupProvider();
        this.roleGroupRelationProvider = exCachedSecurityDataImpl.getRoleGroupRelationProvider();
        this.addGroup = new SecurityListenerSynImpl(exCachedSecurityDataImpl);
    }

    public GroupDataManager(ExCachedSecurityDataImpl exCachedSecurityDataImpl) {
        this.TAG_GROUP_DB_TYPE = exCachedSecurityDataImpl;
        this.SEDU = exCachedSecurityDataImpl.getRealmName();
        this.add = exCachedSecurityDataImpl.getGroupProvider();
        this.roleGroupRelationProvider = exCachedSecurityDataImpl.getRoleGroupRelationProvider();
        this.addGroup = new SecurityListenerSynImpl(exCachedSecurityDataImpl);
    }

    public synchronized String addNewGroup(String string, String string2, int n) throws GroupExistsException {
        if (!this.isEnableAddGroup) {
            return "SECURITY_ERR_GROUP_PROVIDER_ADD";
        }
        try {
            this.getBaseGroup(string);
            throw new GroupExistsException(630042, (Object[])new String[]{string}, null);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            ServiceLogger.logError((Throwable)((Object)noSuchGroupException), 3);
            Properties properties = new Properties();
            properties.setProperty("group_name", string);
            properties.setProperty("group_description", string2);
            properties.setProperty(GroupProviderDBImpl.TAG_GROUP_DB_TYPE, String.valueOf(n));
            try {
                this.add.addGroup(this.SEDU, properties);
            }
            catch (JRCustomerException jRCustomerException) {
                ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                return "SECURITY_M_02001";
            }
            this.addGroup.addPrincipal(this.SEDU, string, 3);
            return null;
        }
    }

    public synchronized String removeGroup(String string) throws NoSuchGroupException {
        if (!this.isEnableRemoveGroup) {
            return "SECURITY_ERR_GROUP_PROVIDER_REMOVE";
        }
        this.getBaseGroup(string);
        try {
            this.add.removeGroup(this.SEDU, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            return "SECURITY_M_02002";
        }
        this.addGroup.removePrincipal(this.SEDU, string, 3);
        return null;
    }

    public Group getGroup(String string) throws NoSuchGroupException {
        Group group = this.TAG_GROUP_DB_TYPE.getIntegrityGroup(string);
        if (group == null) {
            throw new NoSuchGroupException(630001, (Object[])new String[]{string}, null);
        }
        return group;
    }

    public BaseGroup getBaseGroup(String string) throws NoSuchGroupException {
        BaseGroup baseGroup = this.TAG_GROUP_DB_TYPE.getGroup(string);
        if (baseGroup == null) {
            throw new NoSuchGroupException(630001, (Object[])new String[]{string}, null);
        }
        return baseGroup;
    }

    public synchronized String removeGroupFromParentGroup(String string, String string2) throws NoSuchGroupException {
        if (!this.isEnableEditGroupSubGroupRelation) {
            return "SECURITY_ERR_GROUP_SUBGROUP_SUBROLE_PROVIDER_EDIT";
        }
        BaseGroup baseGroup = this.getBaseGroup(string);
        BaseGroup baseGroup2 = this.getBaseGroup(string2);
        if (!baseGroup.getParentGroupNames().contains(string2)) {
            return "SECURITY_ERR_67_HAVE_NOT_PARENTGROUP";
        }
        if (!baseGroup2.getSubGroupNames().contains(string)) {
            return "SECURITY_ERR_68_HAVE_NOT_SUBGROUP";
        }
        try {
            this.add.removeSubGroup(this.SEDU, string2, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            return "SECURITY_M_04015";
        }
        this.addGroup.removeRelation(this.SEDU, string2, 3, string, 3);
        return null;
    }

    public synchronized String addGroupIntoParentGroup(String string, String string2) throws NoSuchGroupException {
        if (!this.isEnableEditGroupSubGroupRelation) {
            return "SECURITY_ERR_GROUP_SUBGROUP_SUBROLE_PROVIDER_EDIT";
        }
        BaseGroup baseGroup = this.getBaseGroup(string);
        BaseGroup baseGroup2 = this.getBaseGroup(string2);
        if (baseGroup.getParentGroupNames().contains(string2)) {
            String[] stringArray = new String[]{string, string2};
            return "SECURITY_ERR_70_HAVE_PARENTGROUP";
        }
        if (baseGroup2.getSubGroupNames().contains(string)) {
            return "SECURITY_ERR_71_HAVE_SUBGROUP";
        }
        if (ServerEnv.isEnableMultipleOrganization()) {
            String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
            String[] stringArray2 = CSUtil.parsePrincipalDisplayName(string2);
            if (stringArray2[0] != null) {
                if (stringArray[0] == null) {
                    return "SECURITY_ERR_110_NOT_BELONG_ORG_GROUP";
                }
                if (!stringArray2[0].equals(stringArray[0])) {
                    return "SECURITY_ERR_111_CROSS_ORG";
                }
            }
        }
        try {
            this.add.addSubGroup(this.SEDU, string2, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            return "SECURITY_M_04016";
        }
        catch (GroupExistsException groupExistsException) {
            ServiceLogger.logError((Throwable)((Object)groupExistsException));
            return "SECURITY_M_04028";
        }
        this.addGroup.addRelation(this.SEDU, string2, 3, string, 3);
        return null;
    }

    public Enumeration getAllGroups() {
        Group[] groupArray = this.TAG_GROUP_DB_TYPE.getAllGroups();
        Vector<Group> vector = new Vector<Group>();
        for (int i = 0; i < groupArray.length; ++i) {
            Group group = groupArray[i];
            vector.add(group);
        }
        return vector.elements();
    }

    public Enumeration getAllGroupNames() {
        Group[] groupArray = this.TAG_GROUP_DB_TYPE.getAllGroups();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < groupArray.length; ++i) {
            Group group = groupArray[i];
            vector.add(group.getName());
        }
        return vector.elements();
    }
}

