/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.util.Enumeration;
import java.util.Vector;
import jet.server.api.exception.GroupExistsException;
import jet.server.api.exception.InUseException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.intf.security.Group;
import jet.server.intf.security.GroupManager;
import jet.server.jrc.security.GroupDataManager;
import jet.server.jrc.security.custom.db.user.UserProviderDBImpl;

public class GroupManagerImpl
implements GroupManager {
    private GroupDataManager SEDU = null;

    public GroupManagerImpl(GroupDataManager groupDataManager) {
        this.SEDU = groupDataManager;
    }

    @Override
    public String addNewGroup(String string, String string2, String string3, int n) throws GroupExistsException {
        if (string2 == null || string2.length() == 0) {
            return "SECURITY_ERR_73_GROUP_NAME_NULL";
        }
        if (!this.isValidName(string2)) {
            return "SECURITY_ERR_GROUP_NAME_INVALID";
        }
        return this.SEDU.addNewGroup(string == null ? string2 : string + "\\" + string2, string3, n);
    }

    @Override
    public String removeGroup(String string) throws NoSuchGroupException, InUseException {
        Group group = this.getGroup(string);
        int n = group.getSubGroupNames().size();
        int n2 = group.getParentGroupNames().size();
        int n3 = group.getUserNames().size();
        int n4 = group.getRoleNames().size();
        if (n2 > 0) {
            throw new InUseException(630030, (Object[])new String[]{string}, null);
        }
        if (n > 0) {
            throw new InUseException(630031, (Object[])new String[]{string}, null);
        }
        if (n3 > 0) {
            throw new InUseException(630032, (Object[])new String[]{string}, null);
        }
        if (n4 > 0) {
            throw new InUseException(630033, (Object[])new String[]{string}, null);
        }
        return this.SEDU.removeGroup(string);
    }

    @Override
    public Group getGroup(String string) throws NoSuchGroupException {
        Group group = this.SEDU.getGroup(string);
        return group;
    }

    @Override
    public String removeGroupFromParentGroup(String string, String string2) throws NoSuchGroupException {
        return this.SEDU.removeGroupFromParentGroup(string, string2);
    }

    @Override
    public String addGroupIntoParentGroup(String string, String string2) throws NoSuchGroupException {
        this.getGroup(string);
        Group group = this.getGroup(string2);
        if (string.equals(string2)) {
            return "SECURITY_ERR_76_SAME_PARENT_GROUP_NAME";
        }
        if (this.SEDU(string, string2)) {
            String string3 = "SECURITY_ERR_77_IN_GROUP_POSTERITY";
            return string3;
        }
        Vector vector = group.getSubGroupNames();
        for (int i = 0; i < vector.size(); ++i) {
            String string4 = (String)vector.elementAt(i);
            if (!string.equals(string4)) continue;
            return "SECURITY_ERR_78_IS_GROUP_SON";
        }
        return this.SEDU.addGroupIntoParentGroup(string, string2);
    }

    private synchronized boolean SEDU(String string, String string2) {
        Group group;
        try {
            group = this.getGroup(string);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            return false;
        }
        Vector vector = group.getSubGroupNames();
        for (int i = 0; i < vector.size(); ++i) {
            String string3 = (String)vector.elementAt(i);
            if (string2.equalsIgnoreCase(string3)) {
                return true;
            }
            try {
                Group group2 = this.getGroup(string3);
                String string4 = group2.getName();
                if (!this.SEDU(string4, string2)) continue;
                return true;
            }
            catch (NoSuchGroupException noSuchGroupException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public Enumeration getAllGroups() {
        return this.SEDU.getAllGroups();
    }

    @Override
    public Enumeration getAllGroupNames() {
        return this.SEDU.getAllGroupNames();
    }

    public boolean isValidName(String string) {
        if (string.length() <= 0 || string.length() > 32) {
            return false;
        }
        return UserProviderDBImpl.isValidPrincipalName(string);
    }
}

