/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.io.File;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.api.cluster.ClusterException;
import jet.server.api.exception.BadRealmException;
import jet.server.api.exception.NoSuchRealmException;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapFactory;
import jet.server.cluster.blocks.MapFlags;
import jet.server.cluster.blocks.MapListenerAdapter;
import jet.server.jrc.security.SharedPasswordRealm2;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrc.security.custom.db.SecurityDBEnv;
import jet.server.log.ServiceLogger;

public class Realm {
    public static final int SCHEME_BASIC = 0;
    public static final int SCHEME_DIGEST = 1;
    protected static Vector realms = new Vector();
    protected String name;
    protected File realmDir;
    protected int scheme = 0;

    public Realm() {
        this("");
    }

    public Realm(String string) {
        this.name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector list() {
        Class<Realm> clazz = Realm.class;
        synchronized (Realm.class) {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < realms.size(); ++i) {
                vector.addElement(((Realm)realms.elementAt(i)).getName());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return vector;
        }
    }

    public synchronized void setScheme(int n) {
        this.scheme = n;
        if (this.scheme != 0 && this.scheme != 1) {
            this.scheme = 0;
        }
    }

    public int getScheme() {
        return this.scheme;
    }

    public static void clearAll() {
        realms.removeAllElements();
    }

    public static Realm get(String string) throws NoSuchRealmException, BadRealmException {
        Class<Realm> clazz = Realm.class;
        synchronized (Realm.class) {
            for (int i = 0; i < realms.size(); ++i) {
                Realm realm = (Realm)realms.elementAt(i);
                if (!realm.getName().equalsIgnoreCase(string)) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return realm;
            }
            throw new NoSuchRealmException(620003, new Object[]{string}, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(Realm realm) {
        Class<Realm> clazz = Realm.class;
        synchronized (Realm.class) {
            try {
                Realm.get(realm.getName());
            }
            catch (NoSuchRealmException noSuchRealmException) {
                realms.addElement(realm);
                RealmClusterMapListener.getInstance().addRealmNotify(realm);
            }
            catch (BadRealmException badRealmException) {
                ServiceLogger.logError((Throwable)((Object)badRealmException));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(String string) {
        Class<Realm> clazz = Realm.class;
        synchronized (Realm.class) {
            try {
                Realm realm = Realm.get(string);
                realms.removeElement(realm);
                RealmClusterMapListener.getInstance().removeRealmNotify(realm);
            }
            catch (NoSuchRealmException noSuchRealmException) {
                ServiceLogger.logError((Throwable)((Object)noSuchRealmException), 3);
            }
            catch (BadRealmException badRealmException) {
                ServiceLogger.logError((Throwable)((Object)badRealmException), 3);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator getRealmNames() {
        Class<Realm> clazz = Realm.class;
        synchronized (Realm.class) {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < realms.size(); ++i) {
                Realm realm = (Realm)realms.elementAt(i);
                vector.addElement(realm.getName());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return vector.iterator();
        }
    }

    public final String getName() {
        return this.name;
    }

    protected final synchronized void setName(String string) {
        this.name = string;
    }

    protected synchronized void init(Properties properties) throws BadRealmException, NoSuchRealmException {
    }

    protected synchronized void setRealmDir(File file) {
        this.realmDir = file;
    }

    public synchronized File getRealmDir() {
        return this.realmDir;
    }

    public String toString() {
        return "Realm:" + this.hashCode() + " " + this.name;
    }

    public static class RealmClusterMapListener
    extends MapListenerAdapter {
        private static RealmClusterMapListener ALL_REALMS_INFO;
        private ClusterMap SEDU;

        public static RealmClusterMapListener getInstance() {
            if (ALL_REALMS_INFO == null) {
                ALL_REALMS_INFO = new RealmClusterMapListener();
            }
            return ALL_REALMS_INFO;
        }

        private RealmClusterMapListener() {
            try {
                this.SEDU = MapFactory.getMap(MapAttr.ALL_REALMS_INFO);
                this.SEDU.addListener(this);
            }
            catch (ClusterException clusterException) {
                ServiceLogger.logError((Throwable)((Object)clusterException));
            }
        }

        public void afterPut(String string, int n, String string2, Properties properties, Properties properties2, MapFlags mapFlags) {
            if (RealmClusterMapListener.isLocalEvent(n)) {
                return;
            }
            if (properties2 == null) {
                this.clusterAddedRealm(properties);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clusterAddedRealm(Properties properties) {
            String string = properties.getProperty("name");
            int n = CSUtil.parseInt(properties.getProperty("scheme"), 0);
            ServiceLogger.logDebug("Realm:: cluster added realm: " + string);
            Class<Realm> clazz = Realm.class;
            synchronized (Realm.class) {
                try {
                    Realm.get(string);
                    ServiceLogger.logDebug("Realm:: local exists realm: " + string);
                }
                catch (NoSuchRealmException noSuchRealmException) {
                    SharedPasswordRealm2 sharedPasswordRealm2 = new SharedPasswordRealm2(string);
                    sharedPasswordRealm2.setScheme(n);
                    realms.add(sharedPasswordRealm2);
                    sharedPasswordRealm2.save();
                    SecurityDBEnv.addOriginalDBGetter(string);
                    try {
                        UserDataToolkit.addAllManager(string);
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
                catch (BadRealmException badRealmException) {
                    ServiceLogger.logError((Throwable)((Object)badRealmException));
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void afterRemove(String string, int n, String string2, Properties properties, MapFlags mapFlags) {
            if (RealmClusterMapListener.isLocalEvent(n)) {
                return;
            }
            if (properties == null) return;
            String string3 = properties.getProperty("name");
            ServiceLogger.logDebug("Realm:: cluster removed realm: " + string3);
            Class<Realm> clazz = Realm.class;
            synchronized (Realm.class) {
                try {
                    Realm realm = Realm.get(string3);
                    realms.remove(realm);
                    UserDataToolkit.deleteRealmData(string3);
                    UserDataToolkit.removeManager(string3);
                }
                catch (NoSuchRealmException noSuchRealmException) {
                    ServiceLogger.logDebug("Realm:: local not exists realm: " + string3);
                }
                catch (BadRealmException badRealmException) {
                    ServiceLogger.logError((Throwable)((Object)badRealmException));
                }
                return;
            }
        }

        void addRealmNotify(Realm realm) {
            ServiceLogger.logDebug("Realm:: local added realm: " + realm.getName());
            Properties properties = new Properties();
            properties.put("name", realm.getName());
            properties.put("scheme", realm.getName());
            this.SEDU.put(realm.getName().toLowerCase(), properties);
        }

        void removeRealmNotify(Realm realm) {
            ServiceLogger.logDebug("Realm:: local removed realm: " + realm.getName());
            this.SEDU.remove(realm.getName().toLowerCase());
        }
    }
}

