/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.security.Principal;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.cs.jacl.BaseGroup;
import jet.cs.jacl.BaseRole;
import jet.cs.jacl.BaseUser;
import jet.cs.jacl.JAcl;
import jet.cs.jacl.JAclEntry;
import jet.cs.jacl.JAclEntryImpl;
import jet.cs.jacl.JAclImpl;
import jet.server.api.admin.security.JOrganization;
import jet.server.api.db.Database;
import jet.server.api.exception.NoSuchUserException;
import jet.server.db.UpdateDetailsTableImpl;
import jet.server.db.security2.AclEntryRecord;
import jet.server.db.security2.AclEntryTable;
import jet.server.db.security2.AclEntryTableImpl;
import jet.server.db.security2.AclRecord;
import jet.server.db.security2.AclTable;
import jet.server.db.security2.AclTableImpl;
import jet.server.db.security2.ExtendAclEntryRecord;
import jet.server.db.security2.ExtendAclEntryTable;
import jet.server.db.security2.ExtendAclEntryTableImpl;
import jet.server.db.security2.GUProfileTable;
import jet.server.db.security2.GUProfileTableImpl;
import jet.server.db.security2.GroupProfileTable;
import jet.server.db.security2.GroupProfileTableImpl;
import jet.server.db.security2.GroupRecord;
import jet.server.db.security2.GroupTable;
import jet.server.db.security2.GroupTableImpl;
import jet.server.db.security2.RGProfileTable;
import jet.server.db.security2.RGProfileTableImpl;
import jet.server.db.security2.RoleProfileTable;
import jet.server.db.security2.RoleProfileTableImpl;
import jet.server.db.security2.RoleRecord;
import jet.server.db.security2.RoleTable;
import jet.server.db.security2.RoleTableImpl;
import jet.server.db.security2.UserProfileRecord;
import jet.server.db.security2.UserProfileTable;
import jet.server.db.security2.UserProfileTableImpl;
import jet.server.db.security2.UserRecord;
import jet.server.db.security2.UserTable;
import jet.server.db.security2.UserTableImpl;
import jet.server.intf.security.ExSecurityData;
import jet.server.intf.security.Group;
import jet.server.intf.security.Role;
import jet.server.intf.security.User;
import jet.server.jrc.JRDataService;
import jet.server.jrc.security.GroupImpl;
import jet.server.jrc.security.PermissionUtil;
import jet.server.jrc.security.RoleImpl;
import jet.server.jrc.security.UserImpl;
import jet.server.log.ServiceLogger;
import jet.server.util.ServerUtil;

public class SecurityDataImpl
implements ExSecurityData {
    public static final String NULL_PASSWORD = "NullPassword.jinfonet";
    JRDataService dataService = null;
    private UserTable SEDU = null;
    private UserProfileTable add = null;
    private RoleTable addEntry = null;
    private AclTable addGroup = null;
    private AclEntryTable addParentGroup = null;
    private RoleProfileTable addParentRole = null;
    private GroupTable addPermissionToAclEntry = null;
    private GroupProfileTable addPrivilegeToAclEntry = null;
    private RGProfileTable addRecord = null;
    private GUProfileTable addRole = null;
    private Hashtable addSubGroup = new Hashtable();
    private Hashtable addSubRole = new Hashtable();
    private Hashtable addSubUser = new Hashtable();
    private Hashtable addUser = new Hashtable();
    private Hashtable append = new Hashtable();
    private Hashtable contains = new Hashtable();
    private Hashtable currentTimeMillis = new Hashtable();
    private Hashtable elementAt = new Hashtable();
    private Hashtable elements = new Hashtable();
    private Hashtable encode = new Hashtable();
    private Hashtable equals = new Hashtable();
    private Hashtable get = new Hashtable();
    private Hashtable getAclEntryRecords = new Hashtable();
    private Hashtable getAclEntryTable = new Hashtable();
    private ExtendAclEntryTable getAclTable = null;
    private JAcl getAllAclID = null;
    public int defaultAclID;

    public SecurityDataImpl(JRDataService jRDataService) {
        this.dataService = jRDataService;
        this.add();
        this.addGroup();
        this.addPrivilegeToAclEntry();
        this.addSubUser();
        this.addEntry();
        this.addParentGroup();
        this.addRecord();
        this.addSubGroup();
        this.elementAt();
        this.addUser();
    }

    public SecurityDataImpl(Database database) {
        this.SEDU(database);
        this.addGroup();
        this.addPrivilegeToAclEntry();
        this.addSubUser();
        this.addEntry();
        this.addParentGroup();
        this.addRecord();
        this.addUser();
    }

    private void SEDU(Database database) {
        UpdateDetailsTableImpl updateDetailsTableImpl = UpdateDetailsTableImpl.newInstance(database);
        this.SEDU = UserTableImpl.newInstance(database, updateDetailsTableImpl);
        this.add = UserProfileTableImpl.newInstance(database, updateDetailsTableImpl);
        this.addEntry = RoleTableImpl.newInstance(database, updateDetailsTableImpl);
        this.addGroup = AclTableImpl.newInstance(database, updateDetailsTableImpl);
        this.addParentGroup = AclEntryTableImpl.newInstance(database, updateDetailsTableImpl);
        this.addPermissionToAclEntry = GroupTableImpl.newInstance(database, updateDetailsTableImpl);
        this.addPrivilegeToAclEntry = GroupProfileTableImpl.newInstance(database, updateDetailsTableImpl);
        this.addRecord = RGProfileTableImpl.newInstance(database, updateDetailsTableImpl);
        this.addRole = GUProfileTableImpl.newInstance(database, updateDetailsTableImpl);
        this.addParentRole = RoleProfileTableImpl.newInstance(database, updateDetailsTableImpl);
        this.getAclTable = ExtendAclEntryTableImpl.newInstance(database, updateDetailsTableImpl);
    }

    private void add() {
        this.SEDU = this.dataService.getUserTable();
        this.add = this.dataService.getUserProfileTable();
        this.addEntry = this.dataService.getRoleTable();
        this.addGroup = this.dataService.getAclTable();
        this.addParentGroup = this.dataService.getAclEntryTable();
        this.addPermissionToAclEntry = this.dataService.getGroupTable();
        this.addPrivilegeToAclEntry = this.dataService.getGroupProfileTable();
        this.addRecord = this.dataService.getRGProfileTable();
        this.addRole = this.dataService.getGUProfileTable();
        this.addParentRole = this.dataService.getRoleProfileTable();
        this.getAclTable = this.dataService.getExtendAclEntryTable();
    }

    public Hashtable getUsersHT() {
        return this.equals;
    }

    public Hashtable getRolesHT() {
        return this.get;
    }

    public Hashtable getAclsHT() {
        return this.getAclEntryTable;
    }

    public Hashtable getGroupsHT() {
        return this.getAclEntryRecords;
    }

    private void addEntry() {
        Hashtable[] hashtableArray = this.add.getAllRecords();
        this.addSubGroup = hashtableArray[0];
        this.addSubUser = hashtableArray[1];
        Hashtable[] hashtableArray2 = this.addParentRole.getAllRecords();
        this.append = hashtableArray2[0];
        this.contains = hashtableArray2[1];
        Hashtable[] hashtableArray3 = this.addRecord.getAllRecords();
        this.addUser = hashtableArray3[0];
        this.elementAt = hashtableArray3[1];
        Hashtable[] hashtableArray4 = this.addRole.getAllRecords();
        this.currentTimeMillis = hashtableArray4[0];
        this.addSubRole = hashtableArray4[1];
        Hashtable[] hashtableArray5 = this.addPrivilegeToAclEntry.getAllRecords();
        this.elements = hashtableArray5[0];
        this.encode = hashtableArray5[1];
    }

    private void addGroup() {
        try {
            this.addPermissionToAclEntry("admin");
        }
        catch (NoSuchUserException noSuchUserException) {
            this.SEDU.addRecord("admin", "admin", "SystemBuild", "", new Date(System.currentTimeMillis()), ServerUtil.encode("admin"), true, true, 6, new Date(System.currentTimeMillis()), true, 30, false, true, true, true, true, false, 0, 0);
        }
        try {
            this.addPermissionToAclEntry("guest");
        }
        catch (NoSuchUserException noSuchUserException) {
            this.SEDU.addRecord("guest", "guest", "SystemBuild", "", new Date(System.currentTimeMillis()), ServerUtil.encode(NULL_PASSWORD), true, true, 6, new Date(System.currentTimeMillis()), true, 30, false, true, true, true, true, false, 0, 0);
        }
    }

    private void addParentGroup() {
        Vector vector = this.SEDU.getAllUsers();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector2;
            UserRecord userRecord = (UserRecord)enumeration.nextElement();
            User user = this.addParentRole(userRecord);
            String string = user.getName();
            Vector vector3 = (Vector)this.addSubGroup.get(string);
            if (vector3 != null) {
                for (int i = 0; i < vector3.size(); ++i) {
                    String string2 = (String)vector3.elementAt(i);
                    user.addParentRole(string2);
                }
            }
            if ((vector2 = (Vector)this.addSubRole.get(string)) != null) {
                for (int i = 0; i < vector2.size(); ++i) {
                    String string3 = (String)vector2.elementAt(i);
                    user.addGroup(string3);
                }
            }
            this.equals.put(string, user);
        }
    }

    private User addParentRole(UserRecord userRecord) {
        UserImpl userImpl = new UserImpl();
        userImpl.setName(userRecord.getName());
        userImpl.setFullName(userRecord.getFullName());
        userImpl.setDescription(userRecord.getDescription());
        userImpl.setEmail(userRecord.getEmail());
        userImpl.setBuildin(userRecord.isBuiltin());
        userImpl.setPassword(userRecord.getPassword());
        userImpl.setEnableNullPS(userRecord.isEnableNullPS());
        userImpl.setMinPSLength(userRecord.getMinPSLength());
        userImpl.setNeverExpire(userRecord.isNeverExpire());
        userImpl.setLastModifyTime(userRecord.getLastModifyTime());
        userImpl.setExpireTime(userRecord.getExpireTime());
        userImpl.setAccountDisable(userRecord.isAccountDisable());
        userImpl.setAccessEventSuc(userRecord.isAccessedEventSuc());
        userImpl.setAccessEventFail(userRecord.isAccessedEventFail());
        userImpl.setManagementEventSuc(userRecord.isManagementEventSuc());
        userImpl.setManagementEventFail(userRecord.isManagementEventFail());
        userImpl.setNoAudit(userRecord.isNoAudit());
        userImpl.setAuthType(userRecord.getAuthType());
        userImpl.setLdapType(userRecord.getLdapType());
        return userImpl;
    }

    private User addPermissionToAclEntry(String string) throws NoSuchUserException {
        UserRecord userRecord = this.SEDU.getUserRecordbyUN(string);
        if (userRecord == null) {
            throw new NoSuchUserException(630003, (Object[])new String[]{string}, null);
        }
        UserImpl userImpl = new UserImpl();
        userImpl.setName(userRecord.getName());
        userImpl.setFullName(userRecord.getFullName());
        userImpl.setDescription(userRecord.getDescription());
        userImpl.setEmail(userRecord.getEmail());
        userImpl.setPassword(userRecord.getPassword());
        userImpl.setCreateTime(userRecord.getCreateTime());
        userImpl.setBuildin(userRecord.isBuiltin());
        userImpl.setEnableNullPS(userRecord.isEnableNullPS());
        userImpl.setMinPSLength(userRecord.getMinPSLength());
        userImpl.setNeverExpire(userRecord.isNeverExpire());
        userImpl.setLastModifyTime(userRecord.getLastModifyTime());
        userImpl.setExpireTime(userRecord.getExpireTime());
        userImpl.setAccountDisable(userRecord.isAccountDisable());
        userImpl.setAccessEventSuc(userRecord.isAccessedEventSuc());
        userImpl.setAccessEventFail(userRecord.isAccessedEventFail());
        userImpl.setManagementEventSuc(userRecord.isManagementEventSuc());
        userImpl.setManagementEventFail(userRecord.isManagementEventFail());
        userImpl.setNoAudit(userRecord.isNoAudit());
        userImpl.setAuthType(userRecord.getAuthType());
        userImpl.setLdapType(userRecord.getLdapType());
        return userImpl;
    }

    private void addPrivilegeToAclEntry() {
        UserProfileRecord userProfileRecord;
        RoleRecord roleRecord;
        RoleRecord roleRecord2 = this.addEntry.getRole("administrators");
        if (roleRecord2 == null) {
            this.addEntry.addRecord("administrators", true, "SystemBuild", 0);
        }
        if ((roleRecord = this.addEntry.getRole("everyone")) == null) {
            this.addEntry.addRecord("everyone", true, "SystemBuild", 0);
            userProfileRecord = this.add.getRecord("guest", "everyone");
            if (userProfileRecord == null) {
                this.add.addRecord("guest", "everyone");
            }
            if ((userProfileRecord = this.add.getRecord("admin", "everyone")) == null) {
                this.add.addRecord("admin", "everyone");
            }
        }
        if ((userProfileRecord = this.add.getRecord("admin", "administrators")) == null) {
            this.add.addRecord("admin", "administrators");
        }
    }

    private void addRecord() {
        Vector vector = this.addEntry.getAllRoles();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            Vector vector2;
            Object object2;
            RoleRecord roleRecord = (RoleRecord)enumeration.nextElement();
            Role role = this.addRole(roleRecord);
            String string = role.getName();
            Vector vector3 = (Vector)this.addSubUser.get(string);
            if (vector3 != null) {
                for (int i = 0; i < vector3.size(); ++i) {
                    object2 = (String)vector3.get(i);
                    role.addSubUser((String)object2);
                }
            }
            if ((vector2 = (Vector)this.addUser.get(string)) != null) {
                for (int i = 0; i < vector2.size(); ++i) {
                    object = (String)vector2.elementAt(i);
                    role.addGroup((String)object);
                }
            }
            if ((object2 = (Vector)this.append.get(string)) != null) {
                for (int i = 0; i < ((Vector)object2).size(); ++i) {
                    String string2 = (String)((Vector)object2).get(i);
                    role.addSubRole(string2);
                }
            }
            if ((object = (Vector)this.contains.get(string)) != null) {
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    String string3 = (String)((Vector)object).get(i);
                    role.addParentRole(string3);
                }
            }
            this.get.put(string, role);
        }
    }

    private Role addRole(RoleRecord roleRecord) {
        RoleImpl roleImpl = new RoleImpl(roleRecord.getName(), roleRecord.isBuiltin(), roleRecord.getDescription(), roleRecord.getType());
        return roleImpl;
    }

    private void addSubGroup() {
        Vector vector = this.addPermissionToAclEntry.getAllGroups();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            Vector vector2;
            Object object2;
            GroupRecord groupRecord = (GroupRecord)enumeration.nextElement();
            Group group = this.addSubRole(groupRecord);
            String string = group.getName();
            Vector vector3 = (Vector)this.currentTimeMillis.get(string);
            if (vector3 != null) {
                for (int i = 0; i < vector3.size(); ++i) {
                    object2 = (String)vector3.get(i);
                    group.addUser((String)object2);
                }
            }
            if ((vector2 = (Vector)this.elementAt.get(string)) != null) {
                for (int i = 0; i < vector2.size(); ++i) {
                    object = (String)vector2.elementAt(i);
                    group.addRole((String)object);
                }
            }
            if ((object2 = (Vector)this.elements.get(string)) != null) {
                for (int i = 0; i < ((Vector)object2).size(); ++i) {
                    String string2 = (String)((Vector)object2).elementAt(i);
                    group.addSubGroup(string2);
                }
            }
            if ((object = (Vector)this.encode.get(string)) != null) {
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    String string3 = (String)((Vector)object).elementAt(i);
                    group.addParentGroup(string3);
                }
            }
            this.getAclEntryRecords.put(string, group);
        }
    }

    private Group addSubRole(GroupRecord groupRecord) {
        GroupImpl groupImpl = new GroupImpl(groupRecord.getName(), groupRecord.isBuiltin(), groupRecord.getDescription(), groupRecord.getType());
        return groupImpl;
    }

    @Override
    public BaseRole getRole(String string) {
        return (BaseRole)this.get.get(string);
    }

    @Override
    public BaseUser getUser(String string) {
        return (BaseUser)this.equals.get(string);
    }

    private void addSubUser() {
        AclRecord aclRecord = this.addGroup.getRecordByName("defaultAcl");
        if (aclRecord != null) {
            this.defaultAclID = aclRecord.getID();
            return;
        }
        AclRecord aclRecord2 = this.addGroup.addRecord("defaultAcl", "System", new Date(System.currentTimeMillis()), false);
        this.defaultAclID = aclRecord2.getID();
        byte by = 2;
        this.addParentGroup.addRecord(this.defaultAclID, by, "everyone", true, 3);
    }

    private void addUser() {
        Vector vector = this.addGroup.getAllAclID();
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            int n;
            String string = (String)enumeration.nextElement();
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                ServiceLogger.logError(numberFormatException);
                continue;
            }
            JAcl jAcl = this.append(n);
            if (jAcl == null) continue;
            this.getAclEntryTable.put(string, jAcl);
        }
        this.initExtendAcl();
    }

    public JAcl initExtendAcl() {
        this.getAllAclID = this.defaultAclID();
        return this.getAllAclID;
    }

    private JAcl append(int n) {
        Vector vector = this.addParentGroup.getAclEntryRecords(n);
        AclRecord aclRecord = this.addGroup.getRecordByID(n);
        if (aclRecord == null) {
            return null;
        }
        String string = aclRecord.getName();
        JAclImpl jAclImpl = new JAclImpl(string, this);
        if (vector == null) {
            return jAclImpl;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Principal principal;
            AclEntryRecord aclEntryRecord = (AclEntryRecord)enumeration.nextElement();
            int n2 = aclEntryRecord.getPermissions();
            boolean bl = aclEntryRecord.isPositive();
            byte by = aclEntryRecord.getPrincipalType();
            String string2 = aclEntryRecord.getPrincipalName();
            JAclEntry jAclEntry = new JAclEntryImpl(string2, this);
            if (!bl) {
                jAclEntry.setNegativePermissions();
            }
            if (by == 1) {
                principal = this.getUser(string2);
                if (principal == null) continue;
                jAclEntry.setPrincipal(principal);
            } else if (by == 2) {
                principal = this.getRole(string2);
                if (principal == null) continue;
                jAclEntry.setPrincipal(principal);
            } else {
                principal = this.getGroup(string2);
                if (principal == null) continue;
                jAclEntry.setPrincipal(principal);
            }
            principal = null;
            jAclEntry = PermissionUtil.addPermissionToAclEntry(jAclEntry, n2);
            try {
                jAclImpl.addEntry(principal, jAclEntry);
            }
            catch (NotOwnerException notOwnerException) {
                ServiceLogger.logError(notOwnerException);
            }
        }
        return jAclImpl;
    }

    public UserTable getUserTable() {
        return this.SEDU;
    }

    public UserProfileTable getUserProfileTable() {
        return this.add;
    }

    public RoleTable getRoleTable() {
        return this.addEntry;
    }

    public AclTable getAclTable() {
        return this.addGroup;
    }

    public AclEntryTable getAclEntryTable() {
        return this.addParentGroup;
    }

    public RoleProfileTable getRoleProfileTable() {
        return this.addParentRole;
    }

    public ExtendAclEntryTable getExtendAclEntryTable() {
        return this.getAclTable;
    }

    @Override
    public Vector getAllUsers(String string) {
        Vector vector = new Vector();
        if (this.isAdminUser(string)) {
            Enumeration enumeration = this.equals.elements();
            while (enumeration.hasMoreElements()) {
                vector.add(enumeration.nextElement());
            }
        }
        return vector;
    }

    @Override
    public Vector getAllRoles(String string) {
        Vector vector = new Vector();
        if (this.isAdminUser(string)) {
            Enumeration enumeration = this.get.elements();
            while (enumeration.hasMoreElements()) {
                vector.add(enumeration.nextElement());
            }
        }
        return vector;
    }

    private boolean isAdminUser(String string) {
        Vector vector;
        try {
            vector = this.contains(string);
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError((Throwable)((Object)noSuchUserException));
            return false;
        }
        return vector.contains("administrators");
    }

    private Vector contains(String string) throws NoSuchUserException {
        Object object;
        Vector<String> vector = new Vector<String>();
        BaseUser baseUser = this.getUser(string);
        if (baseUser == null) {
            throw new NoSuchUserException(630003, (Object[])new String[]{string}, null);
        }
        Vector vector2 = baseUser.getGroupNames();
        Vector vector3 = baseUser.getParentRoleNames();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            this.dataService((String)object, vector);
        }
        object = vector3.elements();
        while (object.hasMoreElements()) {
            String string2 = (String)object.nextElement();
            vector.add(string2);
            this.currentTimeMillis(string2, vector);
        }
        return vector;
    }

    private void currentTimeMillis(String string, Vector vector) {
        BaseRole baseRole = this.getRole(string);
        if (baseRole == null) {
            return;
        }
        Vector vector2 = baseRole.getParentRoleNames();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            vector.add(string2);
            this.currentTimeMillis(string2, vector);
        }
    }

    private void dataService(String string, Vector vector) {
        Object object;
        BaseGroup baseGroup = this.getGroup(string);
        if (baseGroup == null) {
            return;
        }
        Vector vector2 = baseGroup.getRoleNames();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            vector.add(object);
            this.currentTimeMillis((String)object, vector);
        }
        object = baseGroup.getParentGroupNames();
        Enumeration enumeration2 = ((Vector)object).elements();
        while (enumeration2.hasMoreElements()) {
            String string2 = (String)enumeration2.nextElement();
            this.dataService(string2, vector);
        }
    }

    public GroupTable getGroupTable() {
        return this.addPermissionToAclEntry;
    }

    public GroupProfileTable getGroupProfileTable() {
        return this.addPrivilegeToAclEntry;
    }

    public RGProfileTable getRGProfileTable() {
        return this.addRecord;
    }

    public GUProfileTable getGUProfileTable() {
        return this.addRole;
    }

    @Override
    public Vector getAllGroups(String string) {
        Vector vector = new Vector();
        if (this.isAdminUser(string)) {
            Enumeration enumeration = this.getAclEntryRecords.elements();
            while (enumeration.hasMoreElements()) {
                vector.add(enumeration.nextElement());
            }
        }
        return vector;
    }

    @Override
    public User[] getAllUsers() {
        return new User[0];
    }

    @Override
    public Role[] getAllRoles() {
        return new Role[0];
    }

    @Override
    public Group[] getAllGroups() {
        return new Group[0];
    }

    @Override
    public JAcl getAcl(String string, int n) {
        return null;
    }

    @Override
    public BaseGroup getGroup(String string) {
        return (BaseGroup)this.getAclEntryRecords.get(string);
    }

    @Override
    public JAcl getExtendAcl() {
        return this.getAllAclID;
    }

    @Override
    public Permission[] getUserPermissions(String string, String string2, int n) {
        return new Permission[0];
    }

    private JAcl defaultAclID() {
        JAclImpl jAclImpl = new JAclImpl("extendAcl", this);
        Vector vector = this.getAclTable.getExtendAclEntryRecords();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Principal principal;
            ExtendAclEntryRecord extendAclEntryRecord = (ExtendAclEntryRecord)enumeration.nextElement();
            String string = extendAclEntryRecord.getPrincipalName();
            byte by = extendAclEntryRecord.getPrincipalType();
            JAclEntry jAclEntry = new JAclEntryImpl(string + "_" + by, this);
            if (by == 1) {
                principal = this.getUser(string);
                if (principal == null) continue;
                jAclEntry.setPrincipal(principal);
            } else if (by == 2) {
                principal = this.getRole(string);
                if (principal == null) continue;
                jAclEntry.setPrincipal(principal);
            } else {
                principal = this.getGroup(string);
                if (principal == null) continue;
                jAclEntry.setPrincipal(principal);
            }
            principal = null;
            int n = extendAclEntryRecord.getPermissions();
            jAclEntry = PermissionUtil.addPrivilegeToAclEntry(jAclEntry, n);
            try {
                jAclImpl.addEntry(principal, jAclEntry);
            }
            catch (NotOwnerException notOwnerException) {
                ServiceLogger.logError(notOwnerException);
            }
        }
        return jAclImpl;
    }

    private void elementAt() {
        Object object;
        Enumeration enumeration = this.equals.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!((String)object).equals("admin") || this.getAclTable.getExtendAclEntryRecord((String)object, (byte)1) != null) continue;
            this.getAclTable.addRecord((String)object, (byte)1, Integer.MAX_VALUE);
        }
        object = this.get.keys();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            if (!string.equals("administrators") || this.getAclTable.getExtendAclEntryRecord(string, (byte)2) != null) continue;
            this.getAclTable.addRecord(string, (byte)2, Integer.MAX_VALUE);
        }
    }

    @Override
    public JOrganization[] getAllOrganizations() {
        return new JOrganization[0];
    }
}

