/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jet.server.api.admin.security.JOrganization;
import jet.server.api.custom.security.AuthenticationProvider;
import jet.server.api.custom.security.AuthorizationProvider;
import jet.server.api.exception.InvalidUserException;
import jet.server.api.exception.NoSuchAclException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchOrganizationException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.OrganizationExistsException;
import jet.server.intf.resource.Node;
import jet.server.intf.resource.Version;
import jet.server.intf.security.ExSecurityData;
import jet.server.intf.security.Group;
import jet.server.intf.security.PrincipalListener;
import jet.server.intf.security.Role;
import jet.server.intf.security.SecurityService;
import jet.server.intf.security.User;
import jet.server.jrc.security.AclExistException;
import jet.server.jrc.security.NoSuchAclEntryException;
import jet.server.jrc.security.SecurityDataImplForAPI;
import jet.server.jrc.security.UserImpl;
import jet.server.log.ServiceLogger;

public class SecurityServiceImpl2
implements SecurityService {
    private AuthenticationProvider SEDU;
    private AuthorizationProvider changePassword;
    private PrincipalListener checkPrivilege;
    private String equals;
    private ExSecurityData getAbsolutePath;

    public SecurityServiceImpl2(String string, AuthenticationProvider authenticationProvider, AuthorizationProvider authorizationProvider) {
        this.equals = string;
        this.SEDU = authenticationProvider;
        this.changePassword = authorizationProvider;
        this.getAbsolutePath = new SecurityDataImplForAPI(this);
    }

    @Override
    public boolean isValidUser(String string, String string2) {
        return this.SEDU.isValidUser(this.equals, string, string2);
    }

    @Override
    public boolean isValidUserEx(String string, String string2) throws InvalidUserException {
        return false;
    }

    @Override
    public boolean isAdminUser(String string) {
        return this.SEDU.isAdminUser(this.equals, string);
    }

    @Override
    public User getUser(String string) throws NoSuchUserException {
        return new UserImpl(string);
    }

    @Override
    public User getIntegrityUser(String string) throws NoSuchUserException {
        return new UserImpl(string);
    }

    @Override
    public Vector getAllUsers() {
        return null;
    }

    public Vector getUsersByRole(String string) throws NoSuchRoleException {
        return null;
    }

    @Override
    public Role getRole(String string) throws NoSuchRoleException {
        return null;
    }

    @Override
    public Vector getAllRoles() {
        return null;
    }

    public Vector getRolesByUser(String string) throws NoSuchUserException {
        return null;
    }

    @Override
    public String changePassword(boolean bl, String string, String string2, String string3, String string4) throws NoSuchUserException {
        if (!bl) {
            if (!(string.equals(string3) && this.isValidUser(string, string2) && this.isAdminUser(string))) {
                return "SECURITY_ERR_27_USER_NO_POWER_CHANGE_PS";
            }
        } else if (!this.isValidUser(string, string2) || !this.isAdminUser(string)) {
            return "SECURITY_ERR_28_NOT_ADMIN";
        }
        return this.SEDU.changePassword(this.equals, string, string3, string2, string4);
    }

    @Override
    public String changePasswordEx(boolean bl, String string, String string2, String string3, String string4) throws NoSuchUserException {
        return this.changePassword(bl, string, string2, string3, string4);
    }

    @Override
    public boolean getAuditState(String string, int n, boolean bl) throws NoSuchUserException {
        return false;
    }

    @Override
    public Vector getAllUsersName() {
        return new Vector();
    }

    @Override
    public Vector getAllRolesName() {
        return null;
    }

    @Override
    public void addPrincipalListener(PrincipalListener principalListener) {
        this.checkPrivilege = principalListener;
    }

    @Override
    public Vector getReferUsers(String string) throws NoSuchUserException {
        return null;
    }

    @Override
    public Vector getReferRoles(String string) throws NoSuchUserException {
        return null;
    }

    public boolean checkPermission(String string, int n, String string2, Permission permission) {
        boolean bl = this.changePassword.isPermissionOk(this.equals, string2, string, n, permission);
        ServiceLogger.logDebug(6630001, new Object[]{string, String.valueOf(n), string2, permission, String.valueOf(bl)}, 6);
        return bl;
    }

    @Override
    public boolean checkPermission(Node node, String string, Permission permission) {
        int n = -1;
        boolean bl = false;
        if (node.getNodeType() == 3) {
            bl = true;
            n = ((Version)node).getVersionNumber();
        }
        boolean bl2 = false;
        if (bl) {
            bl2 = this.changePassword.isPermissionOk(this.equals, string, node.getParent().getAbsolutePath(), n, permission);
            ServiceLogger.logDebug(6630002, new Object[]{node.getParent().getAbsolutePath(), string, permission, String.valueOf(bl2)}, 6);
        } else {
            bl2 = this.changePassword.isPermissionOk(this.equals, string, node.getAbsolutePath(), n, permission);
            ServiceLogger.logDebug(6630002, new Object[]{node.getParent().getAbsolutePath(), string, permission, String.valueOf(bl2)}, 6);
        }
        return bl2;
    }

    @Override
    public boolean checkPrivilege(String string, String string2) {
        return this.changePassword.checkPrivilege(this.equals, string, string2);
    }

    @Override
    public void clearPermissions(Node node) {
    }

    @Override
    public Hashtable[] getPermissions(Node node) {
        return null;
    }

    public Hashtable[] getAccessPermissions(Node node) throws NotOwnerException, NoSuchAclException {
        return new Hashtable[0];
    }

    @Override
    public int setPermissions(Node node, String string, Hashtable[] hashtableArray) throws NoSuchAclException, NotOwnerException, AclExistException {
        return -1;
    }

    public void setAccessPermissions(Node node, String string, Hashtable[] hashtableArray) throws NoSuchAclException {
    }

    @Override
    public boolean removeUserPermissions(Node node, String string) throws NoSuchAclException, NoSuchAclEntryException {
        return false;
    }

    @Override
    public boolean removeRolePermissions(Node node, String string) throws NoSuchAclException, NoSuchAclEntryException {
        return false;
    }

    @Override
    public boolean removeGroupPermissions(Node node, String string) throws NoSuchAclException, NoSuchAclEntryException {
        return false;
    }

    @Override
    public int getDefaultAclID() {
        return 0;
    }

    @Override
    public ExSecurityData getSecurityData() {
        return this.getAbsolutePath;
    }

    @Override
    public Vector getUsersNameByRole(String string) throws NoSuchRoleException {
        return null;
    }

    @Override
    public Vector getRolesNameByUser(String string) throws NoSuchUserException {
        return null;
    }

    @Override
    public Group getGroup(String string) throws NoSuchGroupException {
        return null;
    }

    @Override
    public Vector getAllGroups() {
        return null;
    }

    @Override
    public Vector getGroupsNameByUser(String string) throws NoSuchUserException {
        return null;
    }

    @Override
    public Vector getUsersNameByGroup(String string) throws NoSuchGroupException {
        return null;
    }

    @Override
    public Vector getAllGroupsName() {
        return null;
    }

    @Override
    public Vector getReferGroups(String string) throws NoSuchUserException {
        return null;
    }

    @Override
    public String getPassword(String string) throws NoSuchUserException {
        return null;
    }

    @Override
    public boolean isExpired(String string) {
        return false;
    }

    @Override
    public boolean isEditing(int n) {
        return true;
    }

    @Override
    public String[] getAllInheritRoleNames(String string) throws NoSuchUserException {
        return new String[0];
    }

    @Override
    public String[] getAllInheritGroupNames(String string) throws NoSuchUserException {
        return new String[0];
    }

    @Override
    public Vector getAllUserNamesByReferedRole(String string) throws NoSuchRoleException, NoSuchGroupException {
        return new Vector();
    }

    @Override
    public Vector getAllContainedUserNamesByGroup(String string) throws NoSuchGroupException {
        return new Vector();
    }

    @Override
    public JOrganization getOrganization(String string) {
        return null;
    }

    @Override
    public List getOrganizations() {
        return null;
    }

    @Override
    public String addOrganization(String string, String string2, int n, String string3) throws OrganizationExistsException {
        return null;
    }

    @Override
    public String updateOrganization(String string, String string2, int n, String string3) throws NoSuchOrganizationException {
        return null;
    }

    @Override
    public String removeOrganization(String string, String string2) throws NoSuchOrganizationException {
        return null;
    }

    @Override
    public List getAllUsers(String string) throws NoSuchOrganizationException {
        return null;
    }

    @Override
    public List getAllRoles(String string) throws NoSuchOrganizationException {
        return null;
    }

    @Override
    public List getAllGroups(String string) throws NoSuchOrganizationException {
        return null;
    }

    @Override
    public boolean isOrganizationAdminUser(String string) {
        return false;
    }

    @Override
    public boolean isAdminUser(Node node, String string) {
        return false;
    }

    @Override
    public List getAllParentRolesNameByUser(String string) {
        return null;
    }

    @Override
    public List getAllParentGroupsNameByUser(String string) {
        return null;
    }
}

