/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import jet.JSvrResource;
import jet.cs.CSUtil;
import jet.cs.jacl.BaseGroup;
import jet.cs.jacl.BaseRole;
import jet.cs.jacl.BaseUser;
import jet.server.ServerEnv;
import jet.server.api.custom.JRCustomerException;
import jet.server.api.custom.security.AuthenticationProvider;
import jet.server.api.custom.security.SecurityListener;
import jet.server.api.custom.security.relation.GroupUserRelationProvider;
import jet.server.api.custom.security.relation.RoleUserRelationProvider;
import jet.server.api.custom.security.role.RoleProvider;
import jet.server.api.custom.security.user.UserProvider;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.UserExistsException;
import jet.server.intf.security.SecurityWebUIController;
import jet.server.intf.security.User;
import jet.server.jrc.security.ExCachedSecurityDataImpl;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrc.security.cache.CachedSecurityDataImpl;
import jet.server.jrc.security.custom.SecurityListenerSynImpl;
import jet.server.log.ServiceLogger;
import jet.server.userman.JReportImplementation;

public class UserDataManager {
    private UserProvider SEDU;
    private RoleProvider add;
    private GroupUserRelationProvider addPrincipal;
    private RoleUserRelationProvider addRelation;
    private AuthenticationProvider addUser;
    private CachedSecurityDataImpl addUserToGroup;
    private SecurityListener addUserToRole;
    private String append;
    boolean isEnableEditUser = true;
    boolean isEnableAddUser = true;
    boolean isEnableRemoveUser = true;
    boolean isEnableEditGroupUserRelation = true;
    boolean isEnableEditRoleUserRelation = true;
    boolean isEnableChangePassword = true;

    public UserDataManager(ExCachedSecurityDataImpl exCachedSecurityDataImpl, SecurityWebUIController securityWebUIController) {
        this.addUserToGroup = exCachedSecurityDataImpl;
        this.append = exCachedSecurityDataImpl.getRealmName();
        this.isEnableEditUser = securityWebUIController.isEditing(1);
        this.isEnableAddUser = securityWebUIController.isEditing(4);
        this.isEnableRemoveUser = securityWebUIController.isEditing(3);
        this.isEnableEditGroupUserRelation = securityWebUIController.isEditing(19);
        this.isEnableEditRoleUserRelation = securityWebUIController.isEditing(17);
        this.isEnableChangePassword = securityWebUIController.isEditing(0);
        this.SEDU = exCachedSecurityDataImpl.getUserProvider();
        this.add = exCachedSecurityDataImpl.getRoleProvider();
        this.addPrincipal = exCachedSecurityDataImpl.getGroupUserRelationProvider();
        this.addRelation = exCachedSecurityDataImpl.getRoleUserRelationProvider();
        this.addUser = exCachedSecurityDataImpl.getAuthenticationProvider();
        this.addUserToRole = new SecurityListenerSynImpl(exCachedSecurityDataImpl);
    }

    public UserDataManager(ExCachedSecurityDataImpl exCachedSecurityDataImpl) {
        this.addUserToGroup = exCachedSecurityDataImpl;
        this.append = exCachedSecurityDataImpl.getRealmName();
        this.SEDU = exCachedSecurityDataImpl.getUserProvider();
        this.addPrincipal = exCachedSecurityDataImpl.getGroupUserRelationProvider();
        this.addRelation = exCachedSecurityDataImpl.getRoleUserRelationProvider();
        this.addUser = exCachedSecurityDataImpl.getAuthenticationProvider();
        this.addUserToRole = new SecurityListenerSynImpl(exCachedSecurityDataImpl);
    }

    public synchronized User getUser(String string) throws NoSuchUserException {
        User user = this.addUserToGroup.getIntegrityUser(string);
        if (user == null) {
            throw new NoSuchUserException(JSvrResource.getMessage("SVR_93", string));
        }
        return user;
    }

    public synchronized BaseUser getBaseUser(String string) throws NoSuchUserException {
        BaseUser baseUser = this.addUserToGroup.getUser(string);
        if (baseUser == null) {
            throw new NoSuchUserException(JSvrResource.getMessage("SVR_93", string));
        }
        return baseUser;
    }

    public synchronized String addNewUser(String string, String string2, String string3, String string4, String string5, Date date, String string6, boolean bl, int n, Date date2, boolean bl2, int n2, boolean bl3, boolean bl4) throws UserExistsException {
        if (!this.isEnableAddUser) {
            return "SECURITY_ERR_USER_PROVIDER_ADD";
        }
        String string7 = string == null ? string2 : string + "\\" + string2;
        try {
            this.getBaseUser(string7);
            throw new UserExistsException(630083, (Object[])new String[]{string7}, null);
        }
        catch (NoSuchUserException noSuchUserException) {
            int n3 = 0;
            if (bl4) {
                n3 = 1;
            }
            Properties properties = new Properties();
            properties.setProperty("user_name", string7);
            properties.setProperty("user_password", string6);
            properties.setProperty("user_db_ldapType", "false");
            properties.setProperty("user_fullname", string3);
            properties.setProperty("user_description", string4);
            properties.setProperty("user_email", string5);
            properties.put("user_create_time", new Date(System.currentTimeMillis()));
            properties.setProperty("user_enable_null_pwd", String.valueOf(bl));
            properties.setProperty("user_min_pwd_length", String.valueOf(n));
            properties.put("user_last_modify_time", new Date(System.currentTimeMillis()));
            properties.setProperty("user_never_expire", String.valueOf(bl2));
            properties.setProperty("user_expire_time", String.valueOf(n2));
            properties.setProperty("user_disabled_account", String.valueOf(bl3));
            properties.setProperty("user_db_ldapType", String.valueOf(n3));
            try {
                this.SEDU.addUser(this.append, properties);
                this.addUserToRole.addPrincipal(this.append, string7, 1);
            }
            catch (JRCustomerException jRCustomerException) {
                ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                return "SECURITY_M_00001";
            }
            if (this.add instanceof JReportImplementation) {
                Properties properties2 = null;
                String string8 = string == null ? "everyone" : string + "\\" + "everyone";
                try {
                    properties2 = this.add.getRoleProperties(this.append, string8);
                }
                catch (NoSuchRoleException noSuchRoleException) {
                    ServiceLogger.logError((Throwable)((Object)noSuchRoleException), 3);
                }
                catch (JRCustomerException jRCustomerException) {
                    ServiceLogger.logError((Throwable)((Object)jRCustomerException), 3);
                }
                if (properties2 != null && properties2.size() != 0 && this.isEnableEditRoleUserRelation) {
                    try {
                        this.addRelation.addUserToRole(this.append, string8, string7);
                        this.addUserToRole.addRelation(this.append, string8, 2, string7, 1);
                    }
                    catch (NoSuchRoleException noSuchRoleException) {
                        ServiceLogger.logError((Throwable)((Object)noSuchRoleException));
                    }
                    catch (NoSuchUserException noSuchUserException2) {
                        ServiceLogger.logError((Throwable)((Object)noSuchUserException2));
                    }
                    catch (JRCustomerException jRCustomerException) {
                        ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                    }
                }
            }
            return null;
        }
    }

    public synchronized String removeUser(String string) throws NoSuchUserException {
        if (!this.isEnableRemoveUser) {
            return "SECURITY_ERR_USER_PROVIDER_REMOVE";
        }
        this.getBaseUser(string);
        try {
            this.SEDU.removeUser(this.append, string);
            UserDataToolkit.getAdhocResourceManager().removeUpload(this.append, string);
        }
        catch (JRCustomerException jRCustomerException) {
            return "SECURITY_M_00002";
        }
        this.addUserToRole.removePrincipal(this.append, string, 1);
        return null;
    }

    public synchronized Vector getParentRoleNames(String string) throws NoSuchUserException {
        BaseUser baseUser = this.getBaseUser(string);
        return baseUser.getParentRoleNames();
    }

    public synchronized String updataAttributes(String string, String string2, String string3, String string4, boolean bl, int n, Date date, boolean bl2, int n2, boolean bl3) throws NoSuchUserException {
        if (!this.isEnableEditUser) {
            return "SECURITY_ERR_USER_PROPERTIES_PROVIDER_EDIT";
        }
        User user = this.getUser(string);
        int n3 = user.getAuthType();
        boolean bl4 = user.isAccessEventSuc();
        boolean bl5 = user.isAccessEventFail();
        boolean bl6 = user.isManagementEventSuc();
        boolean bl7 = user.isManagementEventFail();
        boolean bl8 = user.isNoAudit();
        Properties properties = new Properties();
        properties.setProperty("user_name", string);
        properties.setProperty("user_db_ldapType", "false");
        properties.setProperty("user_fullname", string2);
        properties.setProperty("user_description", string3);
        properties.setProperty("user_email", string4);
        properties.put("user_create_time", new Date(System.currentTimeMillis()));
        properties.setProperty("user_enable_null_pwd", String.valueOf(bl));
        properties.setProperty("user_min_pwd_length", String.valueOf(n));
        properties.put("user_last_modify_time", new Date(System.currentTimeMillis()));
        properties.setProperty("user_never_expire", String.valueOf(bl2));
        properties.setProperty("user_expire_time", String.valueOf(n2));
        properties.setProperty("user_disabled_account", String.valueOf(bl3));
        properties.setProperty("user_db_ldapType", String.valueOf(n3));
        properties.setProperty("user_db_access_event_suc", String.valueOf(bl4));
        properties.setProperty("user_db_access_event_fail", String.valueOf(bl5));
        properties.setProperty("user_db_management_event_suc", String.valueOf(bl6));
        properties.setProperty("user_db_management_event_fail", String.valueOf(bl7));
        properties.setProperty("user_db_noAudit", String.valueOf(bl8));
        try {
            this.SEDU.setUser(this.append, properties);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            return "SECURITY_M_00003";
        }
        return null;
    }

    public synchronized String updataEvent(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws NoSuchUserException {
        if (!this.isEnableEditUser) {
            return "SECURITY_ERR_USER_PROPERTIES_PROVIDER_EDIT";
        }
        User user = this.getUser(string);
        Properties properties = new Properties();
        properties.setProperty("user_name", string);
        properties.setProperty("user_db_ldapType", "false");
        properties.setProperty("user_fullname", user.getFullName());
        properties.setProperty("user_description", user.getDescription());
        properties.setProperty("user_email", user.getEmail());
        properties.put("user_create_time", user.getCreateTime());
        properties.setProperty("user_enable_null_pwd", String.valueOf(user.isEnableNullPS()));
        properties.setProperty("user_min_pwd_length", String.valueOf(user.getMinPSLength()));
        properties.put("user_last_modify_time", new Date(System.currentTimeMillis()));
        properties.setProperty("user_never_expire", String.valueOf(user.isNeverExpire()));
        properties.setProperty("user_expire_time", String.valueOf(user.getExpireTime()));
        properties.setProperty("user_disabled_account", String.valueOf(user.isAccountDisable()));
        properties.setProperty("user_db_ldapType", String.valueOf(user.getAuthType()));
        properties.setProperty("user_db_access_event_suc", String.valueOf(bl));
        properties.setProperty("user_db_access_event_fail", String.valueOf(bl2));
        properties.setProperty("user_db_management_event_suc", String.valueOf(bl3));
        properties.setProperty("user_db_management_event_fail", String.valueOf(bl4));
        properties.setProperty("user_db_noAudit", String.valueOf(bl5));
        try {
            this.SEDU.setUser(this.append, properties);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            return "SECURITY_M_00004";
        }
        return null;
    }

    public synchronized String changePassword(String string, String string2, String string3) throws NoSuchUserException {
        if (this.isEnableChangePassword) {
            return "Can not edit the user's password when the AuthenticationProvider isEnableEdit() method return false";
        }
        User user = this.getUser(string2);
        String string4 = user.getPassword();
        String string5 = null;
        string5 = this.addUser.changePassword(this.append, string, string2, string4, string3);
        return string5;
    }

    public synchronized String getPassword(String string) throws NoSuchUserException {
        User user = this.getUser(string);
        String string2 = user.getPassword();
        return string2;
    }

    public synchronized String addUserToParentRole(String string, String string2) throws NoSuchUserException, NoSuchRoleException {
        if (!this.isEnableEditRoleUserRelation) {
            return "SECURITY_ERR_USER_ROLE_PROVIDER_EDIT";
        }
        BaseUser baseUser = this.getBaseUser(string);
        if (baseUser.getParentRoleNames().contains(string2)) {
            return "SECURITY_ERR_43_USER_EXIST_PARENT_ROLE";
        }
        BaseRole baseRole = this.SEDU(string2);
        if (baseRole.getSubUserNames().contains(string)) {
            return "SECURITY_ERR_44_ROLE_EXIST_SUB_USER";
        }
        if (ServerEnv.isEnableMultipleOrganization()) {
            String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
            String[] stringArray2 = CSUtil.parsePrincipalDisplayName(string2);
            if (stringArray2[0] != null) {
                if (stringArray[0] == null) {
                    return "SECURITY_ERR_106_NOT_BELONG_ORG_ROLE";
                }
                if (!stringArray2[0].equals(stringArray[0])) {
                    return "SECURITY_ERR_107_CROSS_ORG";
                }
            }
        }
        try {
            this.addRelation.addUserToRole(this.append, string2, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            return "SECURITY_M_04001";
        }
        catch (UserExistsException userExistsException) {
            ServiceLogger.logError((Throwable)((Object)userExistsException));
            return "SECURITY_M_04020";
        }
        this.addUserToRole.addRelation(this.append, string2, 2, string, 1);
        return null;
    }

    public synchronized String removeUserFromParentRole(String string, String string2) throws NoSuchUserException, NoSuchRoleException {
        if (!this.isEnableEditRoleUserRelation) {
            return "SECURITY_ERR_USER_ROLE_PROVIDER_EDIT";
        }
        if (string.equals("admin") && string2.equals("administrators")) {
            return "SECURITY_ERR_49_REMOVE_ADMIN_FROM_ADMINROLE";
        }
        BaseUser baseUser = this.getBaseUser(string);
        if (!baseUser.getParentRoleNames().contains(string2)) {
            return "SECURITY_ERR_46_USER_HAVE_NOT_PARENT_ROLE";
        }
        BaseRole baseRole = this.SEDU(string2);
        if (!baseRole.getSubUserNames().contains(string)) {
            return "SECURITY_ERR_47_ROLE_NOT_EXIST_SUB_USER";
        }
        try {
            this.addRelation.removeUserFromRole(this.append, string2, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            return "SECURITY_M_04002";
        }
        this.addUserToRole.removeRelation(this.append, string2, 2, string, 1);
        return null;
    }

    public synchronized String addUserToGroup(String string, String string2) throws NoSuchUserException, NoSuchGroupException {
        if (!this.isEnableEditGroupUserRelation) {
            return "SECURITY_ERR_USER_GROUP_PROVIDER_EDIT";
        }
        BaseUser baseUser = this.getBaseUser(string);
        if (baseUser.getGroupNames().contains(string2)) {
            return "SECURITY_ERR_80_USER_EXIST_PARENT_GROUP";
        }
        BaseGroup baseGroup = this.add(string2);
        if (baseGroup.getUserNames().contains(string)) {
            return "SECURITY_ERR_81_GROUP_EXIST_SUB_USER";
        }
        if (ServerEnv.isEnableMultipleOrganization()) {
            String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
            String[] stringArray2 = CSUtil.parsePrincipalDisplayName(string2);
            if (stringArray2[0] != null) {
                if (stringArray[0] == null) {
                    return "SECURITY_ERR_108_NOT_BELONG_ORG_GROUP";
                }
                if (!stringArray2[0].equals(stringArray[0])) {
                    return "SECURITY_ERR_109_CROSS_ORG";
                }
            }
        }
        try {
            this.addPrincipal.addUserToGroup(this.append, string2, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            return "SECURITY_M_04003";
        }
        catch (UserExistsException userExistsException) {
            ServiceLogger.logError((Throwable)((Object)userExistsException));
            return "SECURITY_M_04022";
        }
        this.addUserToRole.addRelation(this.append, string2, 3, string, 1);
        return null;
    }

    public synchronized String removeUserFromGroup(String string, String string2) throws NoSuchUserException, NoSuchGroupException {
        if (!this.isEnableEditGroupUserRelation) {
            return "SECURITY_ERR_USER_GROUP_PROVIDER_EDIT";
        }
        BaseUser baseUser = this.getBaseUser(string);
        if (!baseUser.getGroupNames().contains(string2)) {
            return "SECURITY_ERR_83_USER_HAVE_NOT_PARENT_GROUP";
        }
        BaseGroup baseGroup = this.add(string2);
        if (!baseGroup.getUserNames().contains(string)) {
            return "SECURITY_ERR_84_GROUP_NOT_EXIST_SUB_USER";
        }
        try {
            this.addPrincipal.removeUserFromGroup(this.append, string2, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            return "SECURITY_M_04004";
        }
        this.addUserToRole.removeRelation(this.append, string2, 3, string, 1);
        return null;
    }

    public Enumeration getAllUsers() {
        User[] userArray = this.addUserToGroup.getAllUsers();
        Vector<User> vector = new Vector<User>();
        for (int i = 0; i < userArray.length; ++i) {
            User user = userArray[i];
            vector.add(user);
        }
        return vector.elements();
    }

    public Enumeration getAllUserNames() {
        User[] userArray = this.addUserToGroup.getAllUsers();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < userArray.length; ++i) {
            User user = userArray[i];
            vector.add(user.getName());
        }
        return vector.elements();
    }

    public int getParentRolesCount(String string) throws NoSuchUserException {
        BaseUser baseUser = this.getBaseUser(string);
        return baseUser.getParentRoleNames().size();
    }

    private BaseRole SEDU(String string) throws NoSuchRoleException {
        BaseRole baseRole = this.addUserToGroup.getRole(string);
        if (baseRole == null) {
            throw new NoSuchRoleException(630005, (Object[])new String[]{string}, null);
        }
        return baseRole;
    }

    private BaseGroup add(String string) throws NoSuchGroupException {
        BaseGroup baseGroup = this.addUserToGroup.getGroup(string);
        if (baseGroup == null) {
            throw new NoSuchGroupException(630001, (Object[])new String[]{string}, null);
        }
        return baseGroup;
    }
}

