/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import jet.JSvrResource;
import jet.cs.CSUtil;
import jet.server.api.admin.AdvancedPasswordRule;
import jet.server.api.exception.InUseException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.UserExistsException;
import jet.server.intf.security.User;
import jet.server.jrc.security.UserDataManager;
import jet.server.jrc.security.custom.db.user.UserProviderDBImpl;
import jet.server.log.ServiceLogger;
import jet.util.MiscTools;

public class UserManager {
    private UserDataManager SEDU;
    private AdvancedPasswordRule addNewUser;

    public UserManager(UserDataManager userDataManager, AdvancedPasswordRule advancedPasswordRule) {
        this.SEDU = userDataManager;
        this.addNewUser = advancedPasswordRule;
    }

    public User getUser(String string) throws NoSuchUserException {
        return this.SEDU.getUser(string);
    }

    public String addNewUser(String string, String string2, String string3, String string4, String string5, Date date, String string6, boolean bl, int n, Date date2, boolean bl2, int n2, boolean bl3, boolean bl4) throws UserExistsException {
        String string7 = null;
        if (string6 == null) {
            string6 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        if (string4 == null) {
            string4 = "";
        }
        if (string5 == null) {
            string5 = "";
        }
        if (string2 == null || string2.trim().length() == 0) {
            string7 = "SVR_21";
        } else if (!UserManager.isValidName(string2)) {
            string7 = "SECURITY_ERR_USER_NAME_INVALID";
        } else if (MiscTools.containChar((String)string3, (String)":")) {
            string7 = "SVR_23";
        } else if (MiscTools.containChar((String)string4, (String)":")) {
            string7 = "SVR_24";
        } else if (MiscTools.containChar((String)string5, (String)":")) {
            string7 = "SVR_73";
        } else if (!bl2 && n2 < 0) {
            string7 = "SVR_29";
        } else if (!bl) {
            if (n < 0) {
                string7 = "SVR_31";
            }
            if (string6.length() < n) {
                string7 = "SVR_32";
            }
        }
        if (string7 != null) {
            return string7;
        }
        string7 = this.SEDU.addNewUser(string, string2, string3, string4, string5, date, string6, bl, n, date2, bl2, n2, bl3, bl4);
        return string7;
    }

    public static boolean isValidName(String string) {
        if (string.length() <= 0 || string.length() > 255) {
            return false;
        }
        return UserProviderDBImpl.isValidPrincipalName(string);
    }

    public String removeUser(String string) throws InUseException, NoSuchUserException {
        if (string.equals("admin") || string.endsWith("\\admin")) {
            return JSvrResource.getMessage("SECURITY_ERR_52_REMOVE_ADMIN_USER");
        }
        if (string.equals("guest")) {
            return JSvrResource.getMessage("SECURITY_ERR_51_REMOVE_GUSET_USER");
        }
        User user = this.getUser(string);
        int n = user.getGroupNames().size();
        if (n > 0) {
            throw new InUseException(630039, (Object[])new String[]{string}, null);
        }
        int n2 = user.getParentRoleNames().size();
        if (n2 > 1) {
            throw new InUseException(630038, (Object[])new String[]{string}, null);
        }
        if (n2 == 1) {
            String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
            String string2 = stringArray[0] != null ? stringArray[0] + "\\" + "everyone" : "everyone";
            String string3 = (String)user.getParentRoleNames().elementAt(0);
            if (string3.equals(string2)) {
                String string4 = null;
                try {
                    string4 = this.SEDU.removeUserFromParentRole(string, string2);
                }
                catch (NoSuchRoleException noSuchRoleException) {
                    ServiceLogger.logError((Throwable)((Object)noSuchRoleException));
                }
                if (string4 != null) {
                    return string4;
                }
            } else {
                throw new InUseException(630038, (Object[])new String[]{string}, null);
            }
        }
        return this.SEDU.removeUser(string);
    }

    public Vector getParentRoleNames(String string) throws NoSuchUserException {
        User user = this.getUser(string);
        return user.getParentRoleNames();
    }

    public String updataAttributes(String string, String string2, String string3, String string4, boolean bl, int n, Date date, boolean bl2, int n2, boolean bl3) throws NoSuchUserException {
        return this.SEDU.updataAttributes(string, string2, string3, string4, bl, n, date, bl2, n2, bl3);
    }

    public String updataEvent(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws NoSuchUserException {
        return this.SEDU.updataEvent(string, bl, bl2, bl3, bl4, bl5);
    }

    public String changePassword(String string, String string2, String string3) throws NoSuchUserException {
        User user = this.getUser(string2);
        String string4 = null;
        if (MiscTools.containChar((String)string3, (String)" :")) {
            return JSvrResource.getMessage("SVR_26", "space and ':'");
        }
        boolean bl = user.isEnableNullPS();
        if (!bl) {
            if (string3 == null || string3.trim().length() == 0) {
                string4 = JSvrResource.getMessage("SVR_27");
            } else {
                int n = user.getMinPSLength();
                if (string3.length() < n) {
                    string4 = JSvrResource.getMessage("SVR_32", "" + n);
                }
            }
        }
        if (string4 == null) {
            string4 = this.SEDU.changePassword(string, string2, string3);
        }
        return string4;
    }

    public String getPassword(String string) throws NoSuchUserException {
        return this.SEDU.getPassword(string);
    }

    public String addUserToParentRole(String string, String string2) throws NoSuchUserException, NoSuchRoleException {
        return this.SEDU.addUserToParentRole(string, string2);
    }

    public String removeUserFromParentRole(String string, String string2) throws NoSuchUserException, NoSuchRoleException {
        return this.SEDU.removeUserFromParentRole(string, string2);
    }

    public String addUserToGroup(String string, String string2) throws NoSuchUserException, NoSuchGroupException {
        return this.SEDU.addUserToGroup(string, string2);
    }

    public String removeUserFromGroup(String string, String string2) throws NoSuchUserException, NoSuchGroupException {
        return this.SEDU.removeUserFromGroup(string, string2);
    }

    public Enumeration getAllUsers() {
        return this.SEDU.getAllUsers();
    }

    public Enumeration getAllUserNames() {
        return this.SEDU.getAllUserNames();
    }

    public int getParentRolesCount(String string) throws NoSuchUserException {
        return this.SEDU.getParentRolesCount(string);
    }

    public AdvancedPasswordRule getPasswordRule() {
        return this.addNewUser;
    }
}

