/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.cache;

import java.util.HashMap;
import jet.cs.jacl.JAcl;
import jet.server.ServerEnv;
import jet.server.api.admin.security.JOrganization;
import jet.server.cache.CacheManagement;
import jet.server.cache.core.CacheAttributesImpl;
import jet.server.cache.core.CacheElementImpl;
import jet.server.cache.core.ElementAttributesImpl;
import jet.server.cache.core.intf.Cache;
import jet.server.cache.core.intf.CacheElement;
import jet.server.intf.security.Group;
import jet.server.intf.security.Role;
import jet.server.intf.security.User;
import jet.server.jrc.security.admin.JOrganizationImpl;
import jet.server.log.ServiceLogger;

public class SecurityCache {
    private CacheManagement SEDU;
    private final String append = "security_user_cache";
    private final String clear = "security_role_cache";
    private final String dispose = "security_group_cache";
    private final String equals = "security_acl_cache";
    private final int get = 1000;
    private final int getCache = 50;
    private final int getKeys = 50;
    private final int getName = 100;
    private int getQuiet = 300;
    private int getSecurityCacheExpireTime = 180;
    private int getVal = 600;
    private int keySet = 300;
    Cache userCache;
    Cache roleCache;
    Cache groupCache;
    Cache aclCache;
    HashMap orgCache;

    public SecurityCache() {
        this.SEDU(1000, 50, 50, 100);
    }

    public SecurityCache(int n, int n2, int n3, int n4) {
        this.SEDU(n, n2, n3, n4);
    }

    private void SEDU(int n, int n2, int n3, int n4) {
        this.getSecurityCacheExpireTime = ServerEnv.getSecurityCacheExpireTime();
        this.getVal = ServerEnv.getSecurityCacheExpireTime();
        this.keySet = ServerEnv.getSecurityCacheExpireTime();
        this.getQuiet = ServerEnv.getSecurityCacheExpireTime();
        this.SEDU = new CacheManagement();
        CacheAttributesImpl cacheAttributesImpl = new CacheAttributesImpl("security_user_cache", n, true, this.getSecurityCacheExpireTime, this.getQuiet);
        this.userCache = this.SEDU.getCache(cacheAttributesImpl, true);
        CacheAttributesImpl cacheAttributesImpl2 = new CacheAttributesImpl("security_role_cache", n2, true, this.getSecurityCacheExpireTime, this.getQuiet);
        this.roleCache = this.SEDU.getCache(cacheAttributesImpl2, true);
        CacheAttributesImpl cacheAttributesImpl3 = new CacheAttributesImpl("security_group_cache", n3, true, this.getSecurityCacheExpireTime, this.getQuiet);
        this.groupCache = this.SEDU.getCache(cacheAttributesImpl3, true);
        CacheAttributesImpl cacheAttributesImpl4 = new CacheAttributesImpl("security_acl_cache", n4, true, this.getSecurityCacheExpireTime, this.getQuiet);
        this.aclCache = this.SEDU.getCache(cacheAttributesImpl4, true);
        this.orgCache = new HashMap();
    }

    public User getUser(String string) {
        return this.aclCache(string, false);
    }

    public User getQuietUser(String string) {
        return this.aclCache(string, true);
    }

    private User aclCache(String string, boolean bl) {
        User user = null;
        CacheElement cacheElement = null;
        cacheElement = bl ? this.userCache.getQuiet(string) : this.userCache.get(string);
        if (cacheElement != null && !string.equals((user = (User)cacheElement.getVal()).getName())) {
            ServiceLogger.logError("mismatched user in cache: name: " + string + ", cached user: " + user.getName(), 3);
            user = null;
        }
        return user;
    }

    public String[] getAllUserNames() {
        Object[] objectArray = this.userCache.getKeys();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            stringArray[i] = (String)object;
        }
        return stringArray;
    }

    public void updateUser(User user) {
        if (user == null) {
            return;
        }
        ElementAttributesImpl elementAttributesImpl = new ElementAttributesImpl(this.getVal, this.keySet, true);
        CacheElementImpl cacheElementImpl = new CacheElementImpl("security_user_cache", elementAttributesImpl, user.getName(), user);
        this.userCache.update(cacheElementImpl);
    }

    public void removeUser(String string) {
        this.userCache.remove(string);
    }

    public Role getRole(String string) {
        return this.append(string, false);
    }

    public Role getQuietRole(String string) {
        return this.append(string, true);
    }

    private Role append(String string, boolean bl) {
        Role role = null;
        CacheElement cacheElement = null;
        cacheElement = bl ? this.roleCache.getQuiet(string) : this.roleCache.get(string);
        if (cacheElement != null && !string.equals((role = (Role)cacheElement.getVal()).getName())) {
            ServiceLogger.logError("mismatched role in cache: name: " + string + ", cached role: " + role.getName(), 3);
            role = null;
        }
        return role;
    }

    public String[] getAllRoleNames() {
        Object[] objectArray = this.roleCache.getKeys();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            stringArray[i] = (String)object;
        }
        return stringArray;
    }

    public void updateRole(Role role) {
        if (role == null) {
            return;
        }
        ElementAttributesImpl elementAttributesImpl = new ElementAttributesImpl(this.getVal, this.keySet, true);
        CacheElementImpl cacheElementImpl = new CacheElementImpl("security_user_cache", elementAttributesImpl, role.getName(), role);
        this.roleCache.update(cacheElementImpl);
    }

    public void removeRole(String string) {
        this.roleCache.remove(string);
    }

    public Group getGroup(String string) {
        return this.clear(string, false);
    }

    public Group getQuietGroup(String string) {
        return this.clear(string, true);
    }

    private Group clear(String string, boolean bl) {
        Group group = null;
        CacheElement cacheElement = null;
        cacheElement = bl ? this.groupCache.getQuiet(string) : this.groupCache.get(string);
        if (cacheElement != null && !string.equals((group = (Group)cacheElement.getVal()).getName())) {
            ServiceLogger.logError("mismatched group in cache: name: " + string + ", cached group: " + group.getName(), 3);
            group = null;
        }
        return group;
    }

    public String[] getAllGroupNames() {
        Object[] objectArray = this.groupCache.getKeys();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            stringArray[i] = (String)object;
        }
        return stringArray;
    }

    public void updateGroup(Group group) {
        if (group == null) {
            return;
        }
        ElementAttributesImpl elementAttributesImpl = new ElementAttributesImpl(this.getVal, this.keySet, true);
        CacheElementImpl cacheElementImpl = new CacheElementImpl("security_group_cache", elementAttributesImpl, group.getName(), group);
        this.groupCache.update(cacheElementImpl);
    }

    public void removeGroup(String string) {
        this.groupCache.remove(string);
    }

    public JAcl getAcl(String string) {
        return this.dispose(string, false);
    }

    public JAcl getQuietAcl(String string) {
        return this.dispose(string, true);
    }

    private JAcl dispose(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        JAcl jAcl = null;
        String string2 = string;
        CacheElement cacheElement = null;
        cacheElement = bl ? this.aclCache.getQuiet(string2) : this.aclCache.get(string2);
        if (cacheElement != null) {
            jAcl = (JAcl)cacheElement.getVal();
        }
        return jAcl;
    }

    public void updateAcl(JAcl jAcl) {
        if (jAcl == null || jAcl.getName() == null) {
            return;
        }
        String string = jAcl.getName();
        ElementAttributesImpl elementAttributesImpl = new ElementAttributesImpl(this.getVal, this.keySet, true);
        CacheElementImpl cacheElementImpl = new CacheElementImpl("security_acl_cache", elementAttributesImpl, string, jAcl);
        this.aclCache.update(cacheElementImpl);
    }

    public void removeAcl(String string) {
        if (string == null) {
            return;
        }
        String string2 = string;
        this.aclCache.remove(string2);
    }

    public JAcl getExtendAcl() {
        return this.equals(false);
    }

    public JAcl getQuietExtendAcl() {
        return this.equals(true);
    }

    private JAcl equals(boolean bl) {
        JAcl jAcl = null;
        String string = "JAcl{extendAcl}";
        CacheElement cacheElement = null;
        cacheElement = bl ? this.aclCache.getQuiet(string) : this.aclCache.get(string);
        if (cacheElement != null) {
            jAcl = (JAcl)cacheElement.getVal();
        }
        return jAcl;
    }

    public void updateExtendAcl(JAcl jAcl) {
        String string = "JAcl{extendAcl}";
        ElementAttributesImpl elementAttributesImpl = new ElementAttributesImpl(this.getVal, this.keySet, true);
        CacheElementImpl cacheElementImpl = new CacheElementImpl("security_acl_cache", elementAttributesImpl, string, jAcl);
        this.aclCache.update(cacheElementImpl);
    }

    public void removeExtendAcl() {
        String string = "JAcl{extendAcl}";
        this.aclCache.remove(string);
    }

    public String[] getAllAclNames() {
        Object[] objectArray = this.aclCache.getKeys();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            stringArray[i] = (String)object;
        }
        return stringArray;
    }

    public String[] getAllOrganizationNames() {
        String[] stringArray = this.orgCache.keySet().toArray(new String[0]);
        return stringArray;
    }

    public JOrganizationImpl getOrganization(String string) {
        return (JOrganizationImpl)this.orgCache.get(string);
    }

    public void updateOrganization(JOrganization jOrganization) {
        if (jOrganization != null) {
            this.orgCache.put(jOrganization.getName(), (JOrganizationImpl)jOrganization);
        }
    }

    public void removeOrganization(String string) {
        this.orgCache.remove(string);
    }

    public void clear() {
        this.userCache.removeAll();
        this.roleCache.removeAll();
        this.groupCache.removeAll();
        this.aclCache.removeAll();
        this.orgCache.clear();
    }

    public void dispose() {
        this.userCache.dispose();
        this.roleCache.dispose();
        this.groupCache.dispose();
        this.aclCache.dispose();
        this.orgCache.clear();
    }
}

