/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.config;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.custom.security.AuthenticationProvider;
import jet.server.api.custom.security.AuthorizationProvider;
import jet.server.api.custom.security.group.GroupPermissionProvider;
import jet.server.api.custom.security.group.GroupPrivilegeProvider;
import jet.server.api.custom.security.group.GroupProvider;
import jet.server.api.custom.security.organization.OrganizationProvider;
import jet.server.api.custom.security.relation.GroupUserRelationProvider;
import jet.server.api.custom.security.relation.RoleGroupRelationProvider;
import jet.server.api.custom.security.relation.RoleUserRelationProvider;
import jet.server.api.custom.security.role.RolePermissionProvider;
import jet.server.api.custom.security.role.RolePrivilegeProvider;
import jet.server.api.custom.security.role.RoleProvider;
import jet.server.api.custom.security.user.UserPermissionProvider;
import jet.server.api.custom.security.user.UserPrivilegeProvider;
import jet.server.api.custom.security.user.UserProvider;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.jrc.security.config.intf.SecurityConfiguration;
import jet.server.jrc.security.config.intf.SecurityProvidersManager;
import jet.server.jrc.security.custom.db.role.RoleProviderDBImpl;
import jet.server.jrc.security.custom.db.user.UserProviderDBImpl;
import jet.server.log.ServiceLogger;
import jet.server.userman.JReportImplementation;

public class SecurityProvidersManagerImpl
implements SecurityProvidersManager {
    SecurityConfiguration securityConfiguration;
    private Hashtable SEDU;

    public SecurityProvidersManagerImpl(SecurityConfiguration securityConfiguration, String string, String string2) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.securityConfiguration = securityConfiguration;
        this.SEDU(string, string2);
    }

    private void SEDU(String string, String string2) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String[] stringArray = this.securityConfiguration.getAllNames();
        String[] stringArray2 = this.securityConfiguration.getDefaultClasses();
        Hashtable hashtable = new Hashtable();
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>(15);
        for (int i = 0; i < stringArray.length; ++i) {
            if (hashtable2.containsKey(stringArray[i])) continue;
            String string3 = this.securityConfiguration.getClassName(stringArray[i]);
            if (string3 == null) {
                string3 = stringArray2[i];
            }
            if (!hashtable.containsKey(string3)) {
                Object obj = Class.forName(string3).newInstance();
                hashtable2.put(stringArray[i], obj);
                hashtable.put(string3, obj);
                continue;
            }
            hashtable2.put(stringArray[i], hashtable.get(string3));
        }
        if (!ServerEnv.isEnableMultipleOrganization()) {
            this.containsKey(hashtable2);
        } else {
            this.SEDU = hashtable2;
        }
        if (string != null && (!this.securityConfiguration.useBuiltinAPI() || this.securityConfiguration.isLDAPClasses(stringArray2))) {
            this.clear(string, string2);
        }
        hashtable.clear();
    }

    private void clear(String string, String string2) {
        String string3 = "authentication_provider";
        AuthenticationProviderInvocationHander authenticationProviderInvocationHander = new AuthenticationProviderInvocationHander(string, string2, this.SEDU.get(string3));
        AuthenticationProvider authenticationProvider = (AuthenticationProvider)Proxy.newProxyInstance(AuthenticationProvider.class.getClassLoader(), new Class[]{AuthenticationProvider.class}, (InvocationHandler)authenticationProviderInvocationHander);
        this.SEDU.put(string3, authenticationProvider);
    }

    private void containsKey(Hashtable hashtable) {
        this.SEDU = new Hashtable(hashtable.size());
        for (String string : hashtable.keySet()) {
            Object object;
            Object object2;
            ProviderInvocationHandler providerInvocationHandler;
            if (string.equals("organization_provider")) {
                providerInvocationHandler = new OrganizationProviderInvocationHandler(hashtable.get(string));
                object2 = (Class[])Proxy.newProxyInstance(OrganizationProvider.class.getClassLoader(), new Class[]{OrganizationProvider.class}, (InvocationHandler)providerInvocationHandler);
                this.SEDU.put(string, object2);
                continue;
            }
            if (string.equals("user_provider")) {
                providerInvocationHandler = new UserProviderInvocationHandler(hashtable.get(string));
                object2 = null;
                object2 = hashtable.get(string) instanceof UserProviderDBImpl ? new Class[]{UserProvider.class, JReportImplementation.class} : new Class[]{UserProvider.class};
                object = (UserProvider)Proxy.newProxyInstance(UserProvider.class.getClassLoader(), object2, (InvocationHandler)providerInvocationHandler);
                this.SEDU.put(string, object);
                continue;
            }
            if (string.equals("user_permission_provider")) {
                providerInvocationHandler = new PermissionProviderInvocationHandler(hashtable.get(string), "getUserPermissions");
                object2 = (UserPermissionProvider)Proxy.newProxyInstance(UserPermissionProvider.class.getClassLoader(), new Class[]{UserPermissionProvider.class}, (InvocationHandler)providerInvocationHandler);
                this.SEDU.put(string, object2);
                continue;
            }
            if (string.equals("user_privilege_provider")) {
                providerInvocationHandler = new PermissionProviderInvocationHandler(hashtable.get(string), "getUserPrivileges");
                object2 = (UserPrivilegeProvider)Proxy.newProxyInstance(UserPrivilegeProvider.class.getClassLoader(), new Class[]{UserPrivilegeProvider.class}, (InvocationHandler)providerInvocationHandler);
                this.SEDU.put(string, object2);
                continue;
            }
            if (string.equals("role_provider")) {
                providerInvocationHandler = new RoleProviderInvocationHandler(hashtable.get(string));
                object2 = null;
                object2 = hashtable.get(string) instanceof RoleProviderDBImpl ? new Class[]{RoleProvider.class, JReportImplementation.class} : new Class[]{RoleProvider.class};
                object = (RoleProvider)Proxy.newProxyInstance(RoleProvider.class.getClassLoader(), object2, (InvocationHandler)providerInvocationHandler);
                this.SEDU.put(string, object);
                continue;
            }
            if (string.equals("role_permission_provider")) {
                providerInvocationHandler = new PermissionProviderInvocationHandler(hashtable.get(string), "getRolePermissions");
                object2 = (RolePermissionProvider)Proxy.newProxyInstance(RolePermissionProvider.class.getClassLoader(), new Class[]{RolePermissionProvider.class}, (InvocationHandler)providerInvocationHandler);
                this.SEDU.put(string, object2);
                continue;
            }
            if (string.equals("role_privilege_provider")) {
                providerInvocationHandler = new PermissionProviderInvocationHandler(hashtable.get(string), "getRolePrivileges");
                object2 = (RolePrivilegeProvider)Proxy.newProxyInstance(RolePrivilegeProvider.class.getClassLoader(), new Class[]{RolePrivilegeProvider.class}, (InvocationHandler)providerInvocationHandler);
                this.SEDU.put(string, object2);
                continue;
            }
            if (string.equals("group_provider")) {
                providerInvocationHandler = new GroupProviderInvocationHandler(hashtable.get(string));
                object2 = (GroupProvider)Proxy.newProxyInstance(GroupProvider.class.getClassLoader(), new Class[]{GroupProvider.class}, (InvocationHandler)providerInvocationHandler);
                this.SEDU.put(string, object2);
                continue;
            }
            if (string.equals("group_permission_provider")) {
                providerInvocationHandler = new PermissionProviderInvocationHandler(hashtable.get(string), "getGroupPermissions");
                object2 = (GroupPermissionProvider)Proxy.newProxyInstance(GroupPermissionProvider.class.getClassLoader(), new Class[]{GroupPermissionProvider.class}, (InvocationHandler)providerInvocationHandler);
                this.SEDU.put(string, object2);
                continue;
            }
            if (string.equals("group_privilege_provider")) {
                providerInvocationHandler = new PermissionProviderInvocationHandler(hashtable.get(string), "getGroupPrivileges");
                object2 = (GroupPrivilegeProvider)Proxy.newProxyInstance(GroupPrivilegeProvider.class.getClassLoader(), new Class[]{GroupPrivilegeProvider.class}, (InvocationHandler)providerInvocationHandler);
                this.SEDU.put(string, object2);
                continue;
            }
            if (string.equals("group_user_relation_provider")) {
                providerInvocationHandler = new RelationProviderInvocationHandler(hashtable.get(string), "getSubUsers", 1);
                object2 = (GroupUserRelationProvider)Proxy.newProxyInstance(GroupUserRelationProvider.class.getClassLoader(), new Class[]{GroupUserRelationProvider.class}, (InvocationHandler)providerInvocationHandler);
                this.SEDU.put(string, object2);
                continue;
            }
            if (string.equals("role_group_relation_provider")) {
                providerInvocationHandler = new RelationProviderInvocationHandler(hashtable.get(string), "getGroupsByRole", 2);
                object2 = (RoleGroupRelationProvider)Proxy.newProxyInstance(RoleGroupRelationProvider.class.getClassLoader(), new Class[]{RoleGroupRelationProvider.class}, (InvocationHandler)providerInvocationHandler);
                this.SEDU.put(string, object2);
                continue;
            }
            if (string.equals("role_user_relation_provider")) {
                providerInvocationHandler = new RelationProviderInvocationHandler(hashtable.get(string), "getUsersByRole", 2);
                object2 = (RoleUserRelationProvider)Proxy.newProxyInstance(RoleUserRelationProvider.class.getClassLoader(), new Class[]{RoleUserRelationProvider.class}, (InvocationHandler)providerInvocationHandler);
                this.SEDU.put(string, object2);
                continue;
            }
            this.SEDU.put(string, hashtable.get(string));
        }
    }

    @Override
    public AuthenticationProvider getAuthenticationProvider() throws ClassCastException {
        return (AuthenticationProvider)this.SEDU.get("authentication_provider");
    }

    @Override
    public AuthorizationProvider getAuthorizationProvider() throws ClassCastException {
        return (AuthorizationProvider)this.SEDU.get("authorization_provider");
    }

    @Override
    public UserPermissionProvider getUserPermissionProvider() throws ClassCastException {
        return (UserPermissionProvider)this.SEDU.get("user_permission_provider");
    }

    @Override
    public UserPrivilegeProvider getUserPrivilegeProvider() throws ClassCastException {
        return (UserPrivilegeProvider)this.SEDU.get("user_privilege_provider");
    }

    @Override
    public UserProvider getUserProvider() throws ClassCastException {
        return (UserProvider)this.SEDU.get("user_provider");
    }

    @Override
    public GroupPermissionProvider getGroupPermissinProvider() throws ClassCastException {
        return (GroupPermissionProvider)this.SEDU.get("group_permission_provider");
    }

    @Override
    public GroupPrivilegeProvider getGroupPrivilegeProvider() throws ClassCastException {
        return (GroupPrivilegeProvider)this.SEDU.get("group_privilege_provider");
    }

    @Override
    public GroupProvider getGroupProvider() throws ClassCastException {
        return (GroupProvider)this.SEDU.get("group_provider");
    }

    @Override
    public RolePermissionProvider getRolePermissionProvider() throws ClassCastException {
        return (RolePermissionProvider)this.SEDU.get("role_permission_provider");
    }

    @Override
    public RolePrivilegeProvider getRolePrivilegeProvider() throws ClassCastException {
        return (RolePrivilegeProvider)this.SEDU.get("role_privilege_provider");
    }

    @Override
    public RoleProvider getRoleProvider() throws ClassCastException {
        return (RoleProvider)this.SEDU.get("role_provider");
    }

    @Override
    public GroupUserRelationProvider getGroupUserRelationProvider() throws ClassCastException {
        return (GroupUserRelationProvider)this.SEDU.get("group_user_relation_provider");
    }

    @Override
    public RoleGroupRelationProvider getRoleGroupRelationProvider() throws ClassCastException {
        return (RoleGroupRelationProvider)this.SEDU.get("role_group_relation_provider");
    }

    @Override
    public RoleUserRelationProvider getRoleUserRelationProvider() throws ClassCastException {
        return (RoleUserRelationProvider)this.SEDU.get("role_user_relation_provider");
    }

    @Override
    public OrganizationProvider getOrganizationProvider() throws ClassCastException {
        return (OrganizationProvider)this.SEDU.get("organization_provider");
    }

    class RelationProviderInvocationHandler
    extends ProviderInvocationHandler {
        String getMethod;
        int principalType;

        RelationProviderInvocationHandler(Object object, String string, int n) {
            super(object);
            this.principalType = 0;
            this.getMethod = string;
            this.principalType = n;
        }

        @Override
        public Object _invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            if (string.equals(this.getMethod)) {
                String string2 = (String)objectArray[1];
                if (CSUtil.isBelongOrganization(string2)) {
                    throw this.generateNoPrincipalException(this.principalType, new Object[]{string2});
                }
                Object object2 = method.invoke(this.obj, objectArray);
                return this.filterPrincipals((Iterator)object2);
            }
            return method.invoke(this.obj, objectArray);
        }
    }

    class PermissionProviderInvocationHandler
    extends ProviderInvocationHandler {
        String getMethod;

        PermissionProviderInvocationHandler(Object object, String string) {
            super(object);
            this.getMethod = string;
        }

        @Override
        public Object _invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            Object object2 = method.invoke(this.obj, objectArray);
            if (string.equals(this.getMethod) && object2 != null) {
                Hashtable hashtable = (Hashtable)object2;
                Hashtable hashtable2 = new Hashtable();
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    if (CSUtil.isBelongOrganization(string2)) continue;
                    hashtable2.put(string2, hashtable.get(string2));
                }
                return hashtable2;
            }
            return object2;
        }
    }

    class GroupProviderInvocationHandler
    extends ProviderInvocationHandler {
        GroupProviderInvocationHandler(Object object) {
            super(object);
        }

        @Override
        public Object _invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            if (string.equals("getGroupProperties") || string.equals("getSubGroups")) {
                String string2 = (String)objectArray[1];
                if (CSUtil.isBelongOrganization(string2)) {
                    throw new NoSuchGroupException(630001, new Object[]{string2}, null);
                }
                Object object2 = method.invoke(this.obj, objectArray);
                if (string.equals("getSubGroups")) {
                    return this.filterPrincipals((Iterator)object2);
                }
                return object2;
            }
            Object object3 = method.invoke(this.obj, objectArray);
            if (string.equals("getAllGroups")) {
                return this.filterPrincipals((Iterator)object3);
            }
            return object3;
        }
    }

    class RoleProviderInvocationHandler
    extends ProviderInvocationHandler {
        RoleProviderInvocationHandler(Object object) {
            super(object);
        }

        @Override
        public Object _invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            if (string.equals("getRoleProperties") || string.equals("getSubRoles")) {
                String string2 = (String)objectArray[1];
                if (CSUtil.isBelongOrganization(string2)) {
                    throw new NoSuchRoleException(630002, new Object[]{string2}, null);
                }
                Object object2 = method.invoke(this.obj, objectArray);
                if (string.equals("getSubRoles")) {
                    return this.filterPrincipals((Iterator)object2);
                }
                return object2;
            }
            Object object3 = method.invoke(this.obj, objectArray);
            if (string.equals("getAllRoles")) {
                return this.filterPrincipals((Iterator)object3);
            }
            return object3;
        }
    }

    class UserProviderInvocationHandler
    extends ProviderInvocationHandler {
        UserProviderInvocationHandler(Object object) {
            super(object);
        }

        @Override
        public Object _invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            if (string.equals("getUserProperties")) {
                String string2 = (String)objectArray[1];
                if (CSUtil.isBelongOrganization(string2)) {
                    throw new NoSuchUserException(630003, new Object[]{string2}, null);
                }
                return method.invoke(this.obj, objectArray);
            }
            Object object2 = method.invoke(this.obj, objectArray);
            if (string.equals("getAllUsers")) {
                return this.filterPrincipals((Iterator)object2);
            }
            return object2;
        }
    }

    class OrganizationProviderInvocationHandler
    extends ProviderInvocationHandler {
        OrganizationProviderInvocationHandler(Object object) {
            super(object);
        }

        @Override
        public Object _invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            if (string.equals("getAllOrganizations")) {
                return null;
            }
            if (string.equals("getOrganizationProperties")) {
                return new Properties();
            }
            return method.invoke(this.obj, objectArray);
        }
    }

    abstract class ProviderInvocationHandler
    implements InvocationHandler {
        Object obj;

        Exception generateNoPrincipalException(int n, Object[] objectArray) {
            switch (n) {
                case 1: {
                    return new NoSuchGroupException(630001, objectArray, null);
                }
                case 2: {
                    return new NoSuchRoleException(630002, objectArray, null);
                }
                case 0: {
                    return new NoSuchUserException(630003, objectArray, null);
                }
            }
            return null;
        }

        ProviderInvocationHandler(Object object) {
            this.obj = object;
        }

        Iterator filterPrincipals(Iterator iterator) {
            if (iterator == null) {
                return iterator;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (CSUtil.isBelongOrganization(string)) continue;
                arrayList.add(string);
            }
            return arrayList.iterator();
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            try {
                return this._invoke(object, method, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
        }

        abstract Object _invoke(Object var1, Method var2, Object[] var3) throws Throwable;
    }

    class AuthenticationProviderInvocationHander
    implements InvocationHandler {
        private String SEDU = null;
        private String equals = null;
        private AuthenticationProvider forName;
        private Object getName;

        AuthenticationProviderInvocationHander(String string, String string2, Object object) {
            this.SEDU = string;
            this.equals = string2;
            try {
                this.forName = (AuthenticationProvider)Class.forName("jet.server.jrc.security.custom.db.AuthenticationProviderDBImpl").newInstance();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 2);
            }
            this.getName = object;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            if ((string.equals("isValidUser") || string.equals("isAdminUser")) && objectArray[1].equals(this.SEDU)) {
                if (string.equals("isAdminUser")) {
                    return true;
                }
                if (string.equals("isValidUser") && this.equals.equals(objectArray[2])) {
                    return true;
                }
            }
            return method.invoke(this.getName, objectArray);
        }
    }
}

