/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.custom;

import java.rmi.RemoteException;
import java.util.Properties;
import jet.server.ServerEnv;
import jet.server.api.custom.security.SecurityListener;
import jet.server.jrc.security.event.AddOrganizationEvent;
import jet.server.jrc.security.event.AddPrincipalEvent;
import jet.server.jrc.security.event.AddRelationEvent;
import jet.server.jrc.security.event.RemoveOrganizationEvent;
import jet.server.jrc.security.event.RemovePrincipalEvent;
import jet.server.jrc.security.event.RemoveRelationEvent;
import jet.server.jrc.security.event.UpdateAllEvent;
import jet.server.jrc.security.event.UpdatePermissionsEvent;
import jet.server.jrc.security.event.UpdatePrivilegesEvent;
import jet.server.log.ServiceLogger;

public class SecurityListenerImpl
implements SecurityListener {
    @Override
    public void updateAll(String string) {
        Properties properties = new Properties();
        UpdateAllEvent updateAllEvent = new UpdateAllEvent(string);
        try {
            ServerEnv.getEventQueue().postEvent(updateAllEvent.getTopic(), 0, properties, updateAllEvent.getLevel());
            return;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return;
        }
    }

    @Override
    public void addPrincipal(String string, String string2, int n) {
        Properties properties = new Properties();
        AddPrincipalEvent addPrincipalEvent = new AddPrincipalEvent(string);
        properties.setProperty("security_event_para_principal", string2);
        properties.setProperty("security_event_para_principal_type", String.valueOf(n));
        try {
            ServerEnv.getEventQueue().postEvent(addPrincipalEvent.getTopic(), 1, properties, addPrincipalEvent.getLevel());
            return;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return;
        }
    }

    @Override
    public void removePrincipal(String string, String string2, int n) {
        Properties properties = new Properties();
        RemovePrincipalEvent removePrincipalEvent = new RemovePrincipalEvent(string);
        properties.setProperty("security_event_para_principal", string2);
        properties.setProperty("security_event_para_principal_type", String.valueOf(n));
        try {
            ServerEnv.getEventQueue().postEvent(removePrincipalEvent.getTopic(), 2, properties, removePrincipalEvent.getLevel());
            return;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return;
        }
    }

    @Override
    public void addRelation(String string, String string2, int n, String string3, int n2) {
        Properties properties = new Properties();
        AddRelationEvent addRelationEvent = new AddRelationEvent(string);
        properties.setProperty("security_event_para_parent_principal", string2);
        properties.setProperty("security_event_para_parent_principal_type", String.valueOf(n));
        properties.setProperty("security_event_para_sub_principal", string3);
        properties.setProperty("security_event_para_sub_principal_type", String.valueOf(n2));
        try {
            ServerEnv.getEventQueue().postEvent(addRelationEvent.getTopic(), 3, properties, addRelationEvent.getLevel());
            return;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return;
        }
    }

    @Override
    public void removeRelation(String string, String string2, int n, String string3, int n2) {
        Properties properties = new Properties();
        RemoveRelationEvent removeRelationEvent = new RemoveRelationEvent(string);
        properties.setProperty("security_event_para_parent_principal", string2);
        properties.setProperty("security_event_para_parent_principal_type", String.valueOf(n));
        properties.setProperty("security_event_para_sub_principal", string3);
        properties.setProperty("security_event_para_sub_principal_type", String.valueOf(n2));
        try {
            ServerEnv.getEventQueue().postEvent(removeRelationEvent.getTopic(), 4, properties, removeRelationEvent.getLevel());
            return;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return;
        }
    }

    @Override
    public void updatePermissons(String string, String string2, int n) {
        Properties properties = new Properties();
        UpdatePermissionsEvent updatePermissionsEvent = new UpdatePermissionsEvent(string);
        properties.setProperty("security_event_para_resource_path", string2);
        properties.setProperty("security_event_para_version_number", String.valueOf(n));
        try {
            ServerEnv.getEventQueue().postEvent(updatePermissionsEvent.getTopic(), 5, properties, updatePermissionsEvent.getLevel());
            return;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return;
        }
    }

    @Override
    public void updatePrivileges(String string, String string2, int n) {
        Properties properties = new Properties();
        UpdatePrivilegesEvent updatePrivilegesEvent = new UpdatePrivilegesEvent(string);
        properties.setProperty("security_event_para_principal", string2);
        properties.setProperty("security_event_para_principal_type", String.valueOf(n));
        try {
            ServerEnv.getEventQueue().postEvent(updatePrivilegesEvent.getTopic(), 6, properties, updatePrivilegesEvent.getLevel());
            return;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return;
        }
    }

    @Override
    public void addOrganization(String string, String string2) {
        Properties properties = new Properties();
        AddOrganizationEvent addOrganizationEvent = new AddOrganizationEvent(string);
        properties.setProperty("security_event_para_organization", string2);
        try {
            ServerEnv.getEventQueue().postEvent(addOrganizationEvent.getTopic(), 7, properties, addOrganizationEvent.getLevel());
            return;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return;
        }
    }

    @Override
    public void removeOrganization(String string, String string2) {
        Properties properties = new Properties();
        RemoveOrganizationEvent removeOrganizationEvent = new RemoveOrganizationEvent(string);
        properties.setProperty("security_event_para_organization", string2);
        try {
            ServerEnv.getEventQueue().postEvent(removeOrganizationEvent.getTopic(), 8, properties, removeOrganizationEvent.getLevel());
            return;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return;
        }
    }
}

