/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.custom.db.organization;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import jet.server.api.custom.JRCustomerException;
import jet.server.api.custom.security.organization.OrganizationProvider;
import jet.server.api.exception.NoSuchOrganizationException;
import jet.server.api.exception.OrganizationExistsException;
import jet.server.db.security2.ExtendAclEntryRecord;
import jet.server.db.security2.ExtendAclEntryTable;
import jet.server.db.security2.OrganizationRecord;
import jet.server.db.security2.OrganizationTable;
import jet.server.db.security2.RoleProfileRecord;
import jet.server.db.security2.RoleProfileTable;
import jet.server.db.security2.RoleRecord;
import jet.server.db.security2.RoleTable;
import jet.server.db.security2.UserProfileRecord;
import jet.server.db.security2.UserProfileTable;
import jet.server.db.security2.UserRecord;
import jet.server.db.security2.UserTable;
import jet.server.jrc.security.custom.db.SecurityDBBasic;
import jet.server.jrc.security.custom.db.SecurityDBEnv;
import jet.server.util.ServerUtil;

public class OrganizationProviderDBImpl
implements OrganizationProvider {
    private static final String SEDU = "\\";
    private static final char[] Z = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '-', '_', '.', '&', ' '};
    private static final int add = 32;

    public Iterator getAllOrganizations(String string) throws JRCustomerException {
        SecurityDBBasic securityDBBasic = this.append(string);
        List list = securityDBBasic.getOrganizationTable().getAllRecords();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (OrganizationRecord organizationRecord : list) {
            arrayList.add(organizationRecord.getName());
        }
        return arrayList.iterator();
    }

    @Override
    public Properties getOrganizationProperties(String string, String string2) throws NoSuchOrganizationException, JRCustomerException {
        SecurityDBBasic securityDBBasic = this.append(string);
        OrganizationRecord organizationRecord = securityDBBasic.getOrganizationTable().getRecord(string2);
        Properties properties = new Properties();
        if (!SecurityDBEnv.isBuiltinAPI) {
            properties.put("organization_name", string2);
            return properties;
        }
        if (organizationRecord == null) {
            throw new NoSuchOrganizationException(630097, new Object[]{string2}, null);
        }
        properties.put("organization_name", string2);
        properties.put("organization_desc", organizationRecord.getDescription());
        properties.put("organization_maxuser", String.valueOf(organizationRecord.getUserAmount()));
        return properties;
    }

    @Override
    public void addOrganization(String string, Properties properties) throws OrganizationExistsException, JRCustomerException {
        int n;
        if (properties == null || properties.size() == 0) {
            throw new JRCustomerException(630098);
        }
        String string2 = properties.getProperty("organization_name");
        if (!OrganizationProviderDBImpl.isValidName(string2)) {
            throw new JRCustomerException(630105, new Object[]{string2}, null);
        }
        SecurityDBBasic securityDBBasic = this.append(string);
        OrganizationTable organizationTable = securityDBBasic.getOrganizationTable();
        OrganizationRecord organizationRecord = organizationTable.getRecord(string2);
        if (organizationRecord != null) {
            throw new OrganizationExistsException(630099, (Object[])new String[]{string2}, null);
        }
        String string3 = properties.getProperty("organization_desc", "");
        organizationRecord = organizationTable.addRecord(string2, string3, n = this.addRecord(properties));
        if (organizationRecord == null) {
            throw new JRCustomerException(630101);
        }
        UserTable userTable = securityDBBasic.getUserTable();
        RoleTable roleTable = securityDBBasic.getRoleTable();
        UserProfileTable userProfileTable = securityDBBasic.getUserProfileTable();
        RoleProfileTable roleProfileTable = securityDBBasic.getRoleProfileTable();
        ExtendAclEntryTable extendAclEntryTable = securityDBBasic.getExAclEntrTable();
        this.SEDU(string2, userTable);
        this.Z(string2, roleTable, userProfileTable, roleProfileTable);
        this.add(string2, extendAclEntryTable);
    }

    private void SEDU(String string, UserTable userTable) {
        String string2 = string + SEDU + "admin";
        UserRecord userRecord = userTable.getUserRecordbyUN(string2);
        if (userRecord == null) {
            userTable.addRecord(string2, "Organization Administrator", "SystemBuild", "", new Date(System.currentTimeMillis()), ServerUtil.encode("admin"), true, true, 6, new Date(System.currentTimeMillis()), true, 30, false, true, true, true, true, false, 0, 0);
        }
    }

    private void Z(String string, RoleTable roleTable, UserProfileTable userProfileTable, RoleProfileTable roleProfileTable) {
        Object object;
        String string2 = string + SEDU + "admin";
        String string3 = string + SEDU + "administrators";
        String string4 = string + SEDU + "everyone";
        RoleRecord roleRecord = roleTable.getRole(string3);
        if (roleRecord == null) {
            roleTable.addRecord(string3, true, "SystemBuild", 0);
            object = userProfileTable.getRecord(string2, string3);
            if (object == null) {
                userProfileTable.addRecord(string2, string3);
            }
        }
        if ((object = roleTable.getRole(string4)) == null) {
            RoleProfileRecord roleProfileRecord;
            roleTable.addRecord(string4, true, "SystemBuild", 0);
            UserProfileRecord userProfileRecord = userProfileTable.getRecord(string2, string4);
            if (userProfileRecord == null) {
                userProfileTable.addRecord(string2, string4);
            }
            if ((roleProfileRecord = roleProfileTable.getRecord("everyone", string4)) == null) {
                roleProfileTable.addRecord("everyone", string4);
            }
        }
    }

    private void add(String string, ExtendAclEntryTable extendAclEntryTable) {
        String string2 = string + SEDU + "administrators";
        ExtendAclEntryRecord extendAclEntryRecord = extendAclEntryTable.getExtendAclEntryRecord(string2, (byte)2);
        if (extendAclEntryRecord == null) {
            extendAclEntryTable.addRecord(string2, (byte)2, 15);
        }
    }

    @Override
    public void setOrganization(String string, Properties properties) throws NoSuchOrganizationException, JRCustomerException {
        int n;
        if (properties == null || properties.size() == 0) {
            throw new JRCustomerException(630098);
        }
        String string2 = properties.getProperty("organization_name");
        SecurityDBBasic securityDBBasic = this.append(string);
        OrganizationTable organizationTable = securityDBBasic.getOrganizationTable();
        OrganizationRecord organizationRecord = organizationTable.getRecord(string2);
        if (organizationRecord == null) {
            throw new NoSuchOrganizationException(630097, new Object[]{string2}, null);
        }
        String string3 = properties.getProperty("organization_desc", "");
        boolean bl = organizationTable.updateRecord(string2, string3, n = this.addRecord(properties));
        if (!bl) {
            throw new JRCustomerException(630102);
        }
    }

    @Override
    public void removeOrganization(String string, String string2) throws NoSuchOrganizationException, JRCustomerException {
        SecurityDBBasic securityDBBasic = this.append(string);
        OrganizationTable organizationTable = securityDBBasic.getOrganizationTable();
        OrganizationRecord organizationRecord = organizationTable.getRecord(string2);
        if (organizationRecord == null) {
            throw new NoSuchOrganizationException(630097, new Object[]{string2}, null);
        }
        if (!organizationTable.deleteRecord(string2)) {
            throw new JRCustomerException(630103, (Object[])new String[]{string2}, null);
        }
        securityDBBasic.getAclEntryTable().deleteRecordByOrganization(string2);
        securityDBBasic.getExAclEntrTable().deleteRecordByOrganization(string2);
        securityDBBasic.getGroupProfileTable().deleteRecordByOrganization(string2);
        securityDBBasic.getGroupTable().deleteRecordByOrganization(string2);
        securityDBBasic.getGuProfileTable().deleteRecordByOrganization(string2);
        securityDBBasic.getRgProfileTable().deleteRecordByOrganization(string2);
        securityDBBasic.getRoleProfileTable().deleteRecordByOrganization(string2);
        securityDBBasic.getRoleTable().deleteRecordByOrganization(string2);
        securityDBBasic.getUserProfileTable().deleteRecordByOrganization(string2);
        securityDBBasic.getUserTable().deleteRecordByOrganization(string2);
    }

    @Override
    public boolean isEnableEdit() {
        return true;
    }

    private int addRecord(Properties properties) throws JRCustomerException {
        int n = 0;
        String string = properties.getProperty("organization_maxuser");
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JRCustomerException(630100);
        }
        return n;
    }

    public static boolean isValidName(String string) {
        if (string.length() != string.trim().length() || string.length() > 32) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            boolean bl = false;
            char c = string.charAt(i);
            for (char c2 : Z) {
                if (c != c2) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private SecurityDBBasic append(String string) throws JRCustomerException {
        if (string == null || string.length() == 0) {
            throw new JRCustomerException(630043);
        }
        SecurityDBBasic securityDBBasic = SecurityDBEnv.getSecurityDBBasic(string);
        if (securityDBBasic == null) {
            throw new JRCustomerException(630044, (Object[])new String[]{string}, null);
        }
        return securityDBBasic;
    }
}

