/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.custom.ldap;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.naming.NamingException;
import jet.cs.jacl.BaseGroup;
import jet.cs.jacl.BaseRole;
import jet.cs.jacl.BaseUser;
import jet.server.api.custom.security.AuthenticationProvider;
import jet.server.api.custom.security.SecurityListener;
import jet.server.jrc.security.ExCachedSecurityDataImpl;
import jet.server.jrc.security.Realm;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrc.security.ldap.intf.LDAPManager;
import jet.server.jrc.security.ldap.intf.LDAPUser;

public class AuthenticationProviderLDAPImpl
implements AuthenticationProvider {
    LDAPManager ldapManager = UserDataToolkit.getLdapManager();

    @Override
    public boolean isValidUser(String string, String string2, String string3) {
        if (!this.ldapManager.isLDAPEnable()) {
            return false;
        }
        try {
            LDAPUser lDAPUser = this.ldapManager.getLDAPUser(string2);
            if (lDAPUser == null) {
                return false;
            }
            String string4 = lDAPUser.getProperty("ldapuser_dn");
            return this.ldapManager.isValidLdapUserByDN(string2, string4, string3);
        }
        catch (NamingException namingException) {
            return this.ldapManager.isValidLdapUser(string2, string3);
        }
    }

    @Override
    public boolean isAdminUser(String string, String string2) {
        ExCachedSecurityDataImpl exCachedSecurityDataImpl = UserDataToolkit.getSecurityCache(string);
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        BaseUser baseUser = exCachedSecurityDataImpl.getUser(string2);
        if (baseUser == null) {
            return false;
        }
        Vector vector = this.SEDU(string, string2);
        if (vector != null && vector.contains("administrators")) {
            return true;
        }
        String string3 = this.ldapManager.getAdminGroupName();
        Vector vector2 = this.elementAt(string, string2);
        return vector2 != null && vector2.contains(string3);
    }

    private Vector SEDU(String string, String string2) {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        ExCachedSecurityDataImpl exCachedSecurityDataImpl = UserDataToolkit.getSecurityCache(string);
        if (exCachedSecurityDataImpl == null) {
            return vector;
        }
        BaseUser baseUser = exCachedSecurityDataImpl.getUser(string2);
        if (baseUser == null) {
            return vector;
        }
        Vector vector2 = baseUser.getParentRoleNames();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            vector.add(object);
            this.add(string, (String)object, vector);
        }
        object = baseUser.getGroupNames();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            String string3 = (String)((Vector)object).elementAt(i);
            this.contains(string, string3, vector);
        }
        return vector;
    }

    private void add(String string, String string2, Vector vector) {
        ExCachedSecurityDataImpl exCachedSecurityDataImpl = UserDataToolkit.getSecurityCache(string);
        if (exCachedSecurityDataImpl == null) {
            return;
        }
        BaseRole baseRole = exCachedSecurityDataImpl.getRole(string2);
        if (baseRole == null) {
            return;
        }
        Vector vector2 = baseRole.getParentRoleNames();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            vector.add(string3);
            this.add(string, string3, vector);
        }
    }

    private void contains(String string, String string2, Vector vector) {
        Object object;
        ExCachedSecurityDataImpl exCachedSecurityDataImpl = UserDataToolkit.getSecurityCache(string);
        if (exCachedSecurityDataImpl == null) {
            return;
        }
        BaseGroup baseGroup = exCachedSecurityDataImpl.getGroup(string2);
        Vector vector2 = baseGroup.getRoleNames();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            vector.add(object);
            this.add(string, (String)object, vector);
        }
        object = baseGroup.getParentGroupNames();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            String string3 = (String)((Vector)object).elementAt(i);
            this.contains(string, string3, vector);
        }
    }

    private Vector elementAt(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        ExCachedSecurityDataImpl exCachedSecurityDataImpl = UserDataToolkit.getSecurityCache(string);
        if (exCachedSecurityDataImpl == null) {
            return vector;
        }
        BaseUser baseUser = exCachedSecurityDataImpl.getUser(string2);
        Vector vector2 = baseUser.getGroupNames();
        for (int i = 0; i < vector2.size(); ++i) {
            String string3 = (String)vector2.elementAt(i);
            vector.add(string3);
            this.elements(string, string3, vector);
        }
        return vector;
    }

    private void elements(String string, String string2, Vector vector) {
        ExCachedSecurityDataImpl exCachedSecurityDataImpl = UserDataToolkit.getSecurityCache(string);
        if (exCachedSecurityDataImpl == null) {
            return;
        }
        BaseGroup baseGroup = exCachedSecurityDataImpl.getGroup(string2);
        Vector vector2 = baseGroup.getParentGroupNames();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            vector.add(string3);
            this.elements(string, string3, vector);
        }
    }

    @Override
    public String changePassword(String string, String string2, String string3, String string4, String string5) {
        return "SECURITY_ERR_USER_PASSWORD_LDAP_CHANGE";
    }

    public Iterator getRealmNames() {
        return Realm.getRealmNames();
    }

    @Override
    public void addSecurityListener(SecurityListener securityListener) {
    }

    @Override
    public boolean isEnableEdit() {
        return false;
    }
}

