/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.custom.ldap.group;

import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingException;
import jet.server.api.custom.JRCustomerException;
import jet.server.api.custom.security.group.GroupProvider;
import jet.server.api.exception.GroupExistsException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrc.security.custom.db.group.GroupProviderDBImpl;
import jet.server.jrc.security.ldap.intf.LDAPGroup;
import jet.server.jrc.security.ldap.intf.LDAPManager;

public class GroupProviderLDAPImpl
implements GroupProvider {
    LDAPManager ldapManager = UserDataToolkit.getLdapManager();

    @Override
    public Iterator getAllGroups(String string) throws JRCustomerException {
        Vector<String> vector = new Vector<String>();
        try {
            Vector vector2 = this.ldapManager.getAllLDAPGroups();
            for (int i = 0; i < vector2.size(); ++i) {
                LDAPGroup lDAPGroup = (LDAPGroup)vector2.elementAt(i);
                vector.add(lDAPGroup.getName());
            }
        }
        catch (NamingException namingException) {
            throw new JRCustomerException(namingException);
        }
        return vector.iterator();
    }

    @Override
    public Properties getGroupProperties(String string, String string2) throws NoSuchGroupException, JRCustomerException {
        LDAPGroup lDAPGroup = this.SEDU(string2);
        Properties properties = new Properties();
        properties.setProperty("group_name", string2);
        properties.setProperty("group_description", lDAPGroup.getProperty("description"));
        properties.put(GroupProviderDBImpl.TAG_GROUP_DB_TYPE, "true");
        return properties;
    }

    @Override
    public Iterator getSubGroups(String string, String string2) throws NoSuchGroupException, JRCustomerException {
        LDAPGroup lDAPGroup = this.SEDU(string2);
        Vector vector = lDAPGroup.getSubGroupNames();
        return vector.iterator();
    }

    private LDAPGroup SEDU(String string) throws NoSuchGroupException, JRCustomerException {
        if (string == null || string.length() == 0) {
            throw new JRCustomerException(630069);
        }
        Vector[] vectorArray = null;
        try {
            vectorArray = this.ldapManager.getLDAPGroup(string);
        }
        catch (NamingException namingException) {
            throw new JRCustomerException(namingException);
        }
        if (vectorArray == null || vectorArray[0] == null || vectorArray[0].size() == 0) {
            throw new NoSuchGroupException(630001, (Object[])new String[]{string}, null);
        }
        LDAPGroup lDAPGroup = (LDAPGroup)vectorArray[0].elementAt(0);
        return lDAPGroup;
    }

    @Override
    public void addGroup(String string, Properties properties) throws GroupExistsException, JRCustomerException {
        throw new JRCustomerException(630047, (Object[])new String[]{"GroupProviderLDAPImpl:addGroup()"}, null);
    }

    @Override
    public void removeGroup(String string, String string2) throws NoSuchGroupException, JRCustomerException {
        throw new JRCustomerException(630047, (Object[])new String[]{"GroupProviderLDAPImpl:removeGroup()"}, null);
    }

    @Override
    public void addSubGroup(String string, String string2, String string3) throws NoSuchGroupException, GroupExistsException, JRCustomerException {
        throw new JRCustomerException(630047, (Object[])new String[]{"GroupProviderLDAPImpl:addSubGroup()"}, null);
    }

    @Override
    public void removeSubGroup(String string, String string2, String string3) throws NoSuchGroupException, JRCustomerException {
        throw new JRCustomerException(630047, (Object[])new String[]{"GroupProviderLDAPImpl:removeSubGroup()"}, null);
    }

    @Override
    public boolean isEnableEdit() {
        return false;
    }
}

