/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.custom.ldap.relation;

import java.util.Iterator;
import java.util.Vector;
import javax.naming.NamingException;
import jet.server.api.custom.JRCustomerException;
import jet.server.api.custom.security.relation.RoleUserRelationProvider;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.UserExistsException;
import jet.server.db.security2.UserProfileRecord;
import jet.server.db.security2.UserProfileTable;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrc.security.custom.db.SecurityDBBasic;
import jet.server.jrc.security.custom.db.SecurityDBEnv;
import jet.server.jrc.security.ldap.intf.LDAPManager;
import jet.server.jrc.security.ldap.intf.LDAPUser;
import jet.server.log.ServiceLogger;

public class RoleUserRelationProviderLDAPImpl
implements RoleUserRelationProvider {
    private LDAPManager SEDU = UserDataToolkit.getLdapManager();

    @Override
    public Iterator getUsersByRole(String string, String string2) throws NoSuchRoleException, JRCustomerException {
        Object object;
        UserProfileTable userProfileTable = this.SEDU(string, string2);
        Vector vector = userProfileTable.getSubUsers(string2);
        Vector<Object> vector2 = new Vector<Object>();
        for (int i = 0; i < vector.size(); ++i) {
            object = (UserProfileRecord)vector.elementAt(i);
            vector2.add(((UserProfileRecord)object).getUserName());
        }
        Iterator iterator = this.add(string2);
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (vector2.contains(object)) continue;
            vector2.add(object);
            userProfileTable.addRecord((String)object, string2);
        }
        object = vector2.iterator();
        return object;
    }

    @Override
    public void addUserToRole(String string, String string2, String string3) throws NoSuchRoleException, NoSuchUserException, UserExistsException, JRCustomerException {
        if (string3 == null || string3.length() == 0) {
            throw new JRCustomerException(630062);
        }
        UserProfileTable userProfileTable = this.SEDU(string, string2);
        UserProfileRecord userProfileRecord = userProfileTable.getRecord(string3, string2);
        if (userProfileRecord != null) {
            Object[] objectArray = new String[]{string3, string2};
            throw new UserExistsException(630084, objectArray, null);
        }
        UserProfileRecord userProfileRecord2 = userProfileTable.addRecord(string3, string2);
        if (userProfileRecord2 == null) {
            Object[] objectArray = new String[]{string3, string2};
            throw new JRCustomerException(630063, objectArray, null);
        }
    }

    @Override
    public void removeUserFromRole(String string, String string2, String string3) throws NoSuchRoleException, NoSuchUserException, JRCustomerException {
        if (string3 == null || string3.length() == 0) {
            throw new JRCustomerException(630062);
        }
        UserProfileTable userProfileTable = this.SEDU(string, string2);
        if (!userProfileTable.deleteRecord(string3, string2)) {
            Object[] objectArray = new String[]{string3, string2};
            throw new JRCustomerException(630064, objectArray, null);
        }
    }

    private UserProfileTable SEDU(String string, String string2) throws JRCustomerException {
        if (string == null || string.length() == 0) {
            throw new JRCustomerException(630043);
        }
        SecurityDBBasic securityDBBasic = SecurityDBEnv.getSecurityDBBasic(string);
        if (securityDBBasic == null) {
            throw new JRCustomerException(630044, (Object[])new String[]{string}, null);
        }
        if (string2 == null || string2.length() == 0) {
            throw new JRCustomerException(630061, (Object[])new String[]{string2}, null);
        }
        UserProfileTable userProfileTable = securityDBBasic.getUserProfileTable();
        return userProfileTable;
    }

    @Override
    public boolean isEnableEdit() {
        return true;
    }

    private Iterator add(String string) {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = new Vector();
        try {
            vector2 = this.SEDU.getAllLDAPUsers();
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
        }
        for (int i = 0; i < vector2.size(); ++i) {
            LDAPUser lDAPUser = (LDAPUser)vector2.elementAt(i);
            String string2 = lDAPUser.getName();
            Vector vector3 = this.SEDU.getRoleNamsByFilter(string2);
            if (!vector3.contains(string)) continue;
            vector.add(string2);
        }
        return vector.iterator();
    }
}

