/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.ldap;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import jet.server.jrc.security.ldap.LDAPData;
import jet.server.jrc.security.ldap.RelaxedX509TrustManager;
import jet.server.log.ServiceLogger;

public class JSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory SEDU;

    public JSocketFactory() throws Exception {
        TrustManager[] trustManagerArray = new TrustManager[]{new RelaxedX509TrustManager()};
        SSLContext sSLContext = SSLContext.getInstance("SSL");
        sSLContext.init(null, trustManagerArray, new SecureRandom());
        this.SEDU = sSLContext.getSocketFactory();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.SEDU.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.SEDU.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        Socket socket = this.SEDU.createSocket(string, n);
        this.SEDU(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        Socket socket = this.SEDU.createSocket(inetAddress, n);
        this.SEDU(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        Socket socket = this.SEDU.createSocket(string, n, inetAddress, n2);
        this.SEDU(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        Socket socket = this.SEDU.createSocket(inetAddress, n, inetAddress2, n2);
        this.SEDU(socket);
        return socket;
    }

    public static SocketFactory getDefault() {
        try {
            return new JSocketFactory();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return SSLSocketFactory.getDefault();
        }
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        Socket socket2 = this.SEDU.createSocket(socket, string, n, bl);
        this.SEDU(socket2);
        return socket;
    }

    private void SEDU(Socket socket) throws IOException {
        socket.setSoLinger(true, this.getInstance());
    }

    private int getInstance() {
        int n = 0;
        String string = LDAPData.getProperty("socketTime");
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            n = 10;
        }
        return n * 1000;
    }
}

