/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.ldap;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import jet.cs.CSUtil;
import jet.server.jrc.security.ldap.LDAPAttributeUtil;
import jet.server.jrc.security.ldap.LDAPEnvironments;
import jet.server.jrc.security.ldap.LDAPGroupImpl;
import jet.server.jrc.security.ldap.LDAPUserImpl;
import jet.server.jrc.security.ldap.intf.LDAPConnection;
import jet.server.jrc.security.ldap.intf.LDAPUser;
import jet.server.log.ServiceLogger;

public class LDAPConnectionImpl
implements LDAPConnection {
    private DirContext SEDU = null;
    private Hashtable add = null;
    private LDAPEnvironments addElement;
    private LDAPAttributeUtil addSubGroup;
    private boolean addSubGroupDN = false;
    private boolean addUser = true;
    private Hashtable addUserDN = null;
    private Hashtable append = null;
    private Hashtable charAt = null;
    private long clear = 0L;
    private long clone = 0L;
    private long close = 180000L;
    private String connect = null;
    private String containsKey = null;
    private String currentTimeMillis = null;
    private long disconnect = 0L;
    private String elements = null;
    private String equals = null;
    private LDAPUser equalsIgnoreCase = null;
    private long get = 0L;

    public LDAPConnectionImpl(LDAPEnvironments lDAPEnvironments) {
        this.addElement = lDAPEnvironments;
        this.addSubGroup = new LDAPAttributeUtil(lDAPEnvironments);
        this.add = lDAPEnvironments.getLDAPEnv();
    }

    @Override
    public synchronized boolean connect() {
        try {
            InitialDirContext initialDirContext = new InitialDirContext(this.add);
            this.addSubGroupDN = true;
            this.SEDU = initialDirContext;
        }
        catch (Exception exception) {
            return this.SEDU();
        }
        return this.addSubGroupDN;
    }

    @Override
    public synchronized boolean reconnect(LDAPEnvironments lDAPEnvironments) {
        this.addElement = lDAPEnvironments;
        this.addSubGroup = new LDAPAttributeUtil(lDAPEnvironments);
        this.add = lDAPEnvironments.getLDAPEnv();
        if (this.SEDU != null) {
            try {
                this.SEDU.close();
            }
            catch (NamingException namingException) {
                return this.SEDU();
            }
        }
        this.addSubGroupDN = false;
        this.addUser = true;
        return this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean SEDU() {
        try {
            if (!this.addSubGroupDN) {
                ConnectionCreator connectionCreator = new ConnectionCreator(this, "connect LDAP[" + System.currentTimeMillis() + "]");
                connectionCreator.start();
                ConnectionCreator connectionCreator2 = connectionCreator;
                synchronized (connectionCreator2) {
                    this.wait(this.clear());
                }
                if (this.addUser) {
                    if (connectionCreator.isAlive()) {
                        connectionCreator.interrupt();
                    }
                    throw new NamingException("Wrong LDAP server port type!(SSL and plain)");
                }
            }
            return this.addSubGroupDN;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            this.SEDU = null;
            return false;
        }
    }

    @Override
    public synchronized boolean disconnect() {
        try {
            if (this.SEDU != null) {
                this.SEDU.close();
                this.SEDU = null;
            }
        }
        catch (NamingException namingException) {
            this.SEDU = null;
            return false;
        }
        return true;
    }

    @Override
    public synchronized DirContext getLdapContext() {
        ServiceLogger.logDebug("Get DirContext...");
        if (this.SEDU == null) {
            this.connect();
        }
        String string = this.addSubGroup.getUserDN();
        try {
            if (this.SEDU != null) {
                this.SEDU.search(string, null);
            }
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            this.disconnect();
            this.connect();
        }
        return this.SEDU;
    }

    @Override
    public synchronized boolean isValidLDAPUser(String string, String string2) {
        String string3 = this.addSubGroup.getUserDN();
        long l = System.currentTimeMillis();
        if (null != this.addUserDN && l - this.clear < this.close) {
            LDAPUser lDAPUser = (LDAPUser)this.addUserDN.get(string);
            return null != lDAPUser;
        }
        return this.add(string, string3, string2, false);
    }

    @Override
    public synchronized boolean isValidLDAPUserByDN(String string, String string2, String string3) {
        ServiceLogger.logDebug(4630087, new Object[]{string, string2}, 4);
        return this.add(string, string2, string3, true);
    }

    private synchronized boolean add(String string, String string2, String string3, boolean bl) {
        boolean bl2;
        long l;
        String string4 = "";
        if (string2 == null || string == null) {
            return false;
        }
        if (string3 == null) {
            string3 = "";
        }
        if (null != this.connect && (l = System.currentTimeMillis()) - this.disconnect < 10000L && this.connect.equals(string) && this.containsKey.equals(string2) && this.currentTimeMillis.equals(string3)) {
            return true;
        }
        DirContext dirContext = this.getLdapContext();
        if (dirContext == null) {
            return false;
        }
        try {
            Object object;
            String string5;
            String string6;
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            String string7 = this.addElement.getProperty("userAN");
            if (string7 == null) {
                return false;
            }
            String string8 = "(&(" + string7 + "=" + string + "))";
            String string9 = string2;
            if (bl) {
                string9 = this.addElement.getProperty("userDN");
            }
            if (string9 == null) {
                return false;
            }
            NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(string9, string8, searchControls);
            if (!namingEnumeration.hasMore()) {
                return false;
            }
            SearchResult searchResult = namingEnumeration.next();
            Attributes attributes = searchResult.getAttributes();
            LDAPAttributeUtil lDAPAttributeUtil = new LDAPAttributeUtil(this.addElement);
            lDAPAttributeUtil.setAttributes(attributes);
            String string10 = lDAPAttributeUtil.getUserPassword();
            if (string10 != null && string3.equalsIgnoreCase("")) {
                return string10.equals("") && string3.equals("");
            }
            Hashtable hashtable = new Hashtable();
            String string11 = this.addElement.getProperty("rootEntry");
            if (bl) {
                string6 = "com.sun.jndi.ldap.LdapCtxFactory";
                hashtable.put("java.naming.factory.initial", string6);
                hashtable.put("java.naming.security.authentication", "simple");
                hashtable.put("java.naming.security.principal", string2);
            } else {
                hashtable = (Hashtable)this.add.clone();
                string6 = string7 + "=" + string;
                string5 = string2 != null && !string2.equals("") ? string6 + "," + this.addElement.getProperty("userDN") : string6;
                if (string11 != null && string11.length() != 0) {
                    string5 = string5 + "," + string11;
                }
                hashtable.put("java.naming.security.principal", string5);
            }
            hashtable.put("java.naming.security.credentials", string3);
            string6 = this.addElement.getProperty("ldapVersion");
            if (string6 != null) {
                hashtable.put("java.naming.ldap.version", string6);
            }
            string5 = this.addElement.getProperty("url");
            String string12 = this.addElement.getProperty("serverPort");
            if (string5 == null || string12 == null) {
                return false;
            }
            string4 = string4 + string5 + ":" + string12;
            hashtable.put("java.naming.provider.url", string4);
            if (this.addElement.getProperty("isUsingSSL") != null && this.addElement.getProperty("isUsingSSL").equals("true")) {
                hashtable.put("java.naming.security.protocol", "ssl");
                hashtable.put("java.naming.ldap.factory.socket", "jet.server.jrc.security.ldap.JSocketFactory");
            }
            InitialDirContext initialDirContext = new InitialDirContext(hashtable);
            if (string3 == null || string3.length() == 0) {
                object = new SearchControls();
                ((SearchControls)object).setSearchScope(1);
                initialDirContext.search(string11, "(CN=*)", (SearchControls)object);
            }
            if ((object = this.getLDAPUser(string)) == null) {
                return false;
            }
            namingEnumeration.close();
            this.connect = string;
            this.containsKey = string2;
            this.currentTimeMillis = string3;
            this.disconnect = System.currentTimeMillis();
            bl2 = true;
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            return false;
        }
        catch (NullPointerException nullPointerException) {
            ServiceLogger.logError(nullPointerException);
            return false;
        }
        return bl2;
    }

    @Override
    public synchronized LDAPUser getLDAPUser(String string) throws NamingException {
        long l = System.currentTimeMillis();
        if (null != this.addUserDN && l - this.clear < this.close) {
            LDAPUser lDAPUser = (LDAPUser)this.addUserDN.get(string);
            return lDAPUser;
        }
        String string2 = this.addSubGroup.getUserDN();
        return this.addElement(string2, string, false);
    }

    public synchronized LDAPUser getLDAPUserByDN(String string) throws NamingException {
        return this.addElement(string, null, true);
    }

    private synchronized LDAPUser addElement(String string, String string2, boolean bl) throws NamingException {
        Object object;
        String string3;
        long l;
        if (null != this.equalsIgnoreCase && (l = System.currentTimeMillis()) - this.get < 10000L && this.elements.equals(string) && this.equals.equals(string2)) {
            return this.equalsIgnoreCase;
        }
        Object object2 = this.getLdapContext();
        if (object2 == null) {
            throw new NamingException("Null LDAP context error!");
        }
        Hashtable hashtable = (Hashtable)this.add.clone();
        if (bl) {
            string3 = "com.sun.jndi.ldap.LdapCtxFactory";
            hashtable.put("java.naming.factory.initial", string3);
            hashtable.put("java.naming.provider.url", this.addElement.getProperty("url") + ":" + this.addElement.getProperty("serverPort"));
            hashtable.put("java.naming.security.principal", this.addElement.getProperty("directoryManagerDN"));
            hashtable.put("java.naming.security.credentials", this.addElement.getProperty("password"));
            if (this.addElement.getProperty("isUsingSSL") != null && this.addElement.getProperty("isUsingSSL").equals("true")) {
                hashtable.put("java.naming.security.protocol", "ssl");
                hashtable.put("java.naming.ldap.factory.socket", "jet.server.jrc.security.ldap.JSocketFactory");
            }
            object2 = object = new InitialDirContext(hashtable);
        }
        string3 = this.addElement.getProperty("userAN");
        object = this.addElement.getProperty("rootEntry");
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        String string4 = bl ? "(" + string3 + "=*)" : "(&(" + string3 + "=" + string2 + "))";
        NamingEnumeration<SearchResult> namingEnumeration = object2.search(string, string4, searchControls);
        LDAPUserImpl lDAPUserImpl = null;
        if (namingEnumeration.hasMore() && (lDAPUserImpl = this.addSubGroup(namingEnumeration, string, (String)object)) == null) {
            namingEnumeration.close();
            return null;
        }
        namingEnumeration.close();
        if (null != string && null != string2) {
            this.elements = string;
            this.equals = string2;
            this.equalsIgnoreCase = lDAPUserImpl;
            this.get = System.currentTimeMillis();
        }
        return lDAPUserImpl;
    }

    @Override
    public synchronized Hashtable getAllLDAPUsers() throws NamingException {
        if (null == this.addUserDN) {
            this.addUserDN = new Hashtable();
        } else {
            long l = System.currentTimeMillis();
            if (l - this.clear < this.close) {
                return this.addUserDN;
            }
            this.addUserDN.clear();
            this.clear = System.currentTimeMillis();
        }
        DirContext dirContext = this.getLdapContext();
        if (dirContext == null) {
            this.addUserDN = null;
            throw new NamingException("Null LDAP context error!");
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        String string = this.addElement.getProperty("userFilter");
        String string2 = this.addElement.getProperty("userCN");
        String string3 = this.addElement.getProperty("rootEntry");
        String string4 = this.addSubGroup.getUserDN();
        String string5 = string.equalsIgnoreCase("") ? "(&(" + string2 + "=*))" : string;
        NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(string4, string5, searchControls);
        while (namingEnumeration.hasMore()) {
            LDAPUserImpl lDAPUserImpl = this.addSubGroup(namingEnumeration, string4, string3);
            if (lDAPUserImpl == null) continue;
            String string6 = lDAPUserImpl.getName();
            this.addUserDN.put(string6, lDAPUserImpl);
        }
        namingEnumeration.close();
        this.clear = System.currentTimeMillis();
        return this.addUserDN;
    }

    private synchronized LDAPUserImpl addSubGroup(NamingEnumeration namingEnumeration, String string, String string2) throws NamingException {
        String string3;
        LDAPUserImpl lDAPUserImpl = new LDAPUserImpl();
        SearchResult searchResult = (SearchResult)namingEnumeration.next();
        if (searchResult.getName().trim().length() == 0) {
            string3 = string.trim();
        } else {
            string3 = searchResult.getName().trim();
            if (string.trim() != null && string.trim().length() != 0) {
                string3 = string3 + "," + string.trim();
            }
            if (string2.trim() != null && string2.trim().length() != 0) {
                string3 = string3 + "," + string2.trim();
            }
        }
        this.addSubGroup.setAttributes(searchResult.getAttributes());
        String string4 = this.addSubGroup.getUserName();
        if (string4 == null || string4.length() == 0) {
            return null;
        }
        lDAPUserImpl.setName(string4);
        lDAPUserImpl.setProperties("full_name", this.addSubGroup.getUserFullname());
        lDAPUserImpl.setProperties("email", this.addSubGroup.getUserEmail());
        lDAPUserImpl.setProperties("ldapuser_dn", string3);
        String string5 = this.addSubGroup.getMemberOf();
        if (null != string5 && 0 != string5.length()) {
            String[] stringArray = string5.split(";");
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                String string6 = this.addUserDN(stringArray[i], true);
                stringBuffer.append(";").append(string6);
            }
            lDAPUserImpl.setProperties("memberOf", stringBuffer.substring(1));
        }
        ServiceLogger.logDebug(4630080, new Object[]{string4, string}, 4);
        ServiceLogger.logDebug(4630081, new Object[]{string3}, 4);
        return lDAPUserImpl;
    }

    @Override
    public synchronized Vector[] getLDAPGroup(String string) throws NamingException {
        long l = System.currentTimeMillis();
        if (null != this.append && l - this.clone < this.close) {
            Vector[] vectorArray = (Vector[])this.charAt.get(string);
            return vectorArray;
        }
        Hashtable hashtable = this.getAllLDAPUsers();
        Vector[] vectorArray = new Vector[]{new Vector(), new Vector()};
        DirContext dirContext = this.getLdapContext();
        if (dirContext == null) {
            throw new NamingException("Null LDAP context error!");
        }
        SearchControls searchControls = new SearchControls();
        String string2 = this.addElement.getProperty("rootEntry");
        searchControls.setSearchScope(2);
        String string3 = this.addElement.getProperty("groupCN");
        String string4 = this.addSubGroup.getGroupDN();
        String string5 = "(&(" + string3 + "=" + string + "))";
        NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(string4, string5, searchControls);
        try {
            if (namingEnumeration.hasMore()) {
                Vector[] vectorArray2 = this.addSubGroupDN(namingEnumeration, string4, string2, hashtable);
                if (vectorArray2 == null) {
                    return vectorArray;
                }
                vectorArray = vectorArray2;
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        namingEnumeration.close();
        return vectorArray;
    }

    @Override
    public synchronized Hashtable getAllLDAPGroups() throws NamingException {
        Hashtable hashtable = this.getAllLDAPUsers();
        if (null == this.append) {
            this.append = new Hashtable();
            this.charAt = new Hashtable();
        } else {
            long l = System.currentTimeMillis();
            if (l - this.clone < this.close) {
                return this.append;
            }
            this.append.clear();
            this.charAt.clear();
        }
        DirContext dirContext = this.getLdapContext();
        if (dirContext == null) {
            this.append = null;
            this.charAt = null;
            throw new NamingException("Null LDAP context error!");
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        String string = this.addElement.getProperty("rootEntry");
        String string2 = this.addElement.getProperty("groupFilter");
        String string3 = this.addElement.getProperty("groupCN");
        String string4 = this.addSubGroup.getGroupDN();
        String string5 = string2.equalsIgnoreCase("") ? "(&(" + string3 + "=*))" : string2;
        NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(string4, string5, searchControls);
        try {
            while (namingEnumeration.hasMore()) {
                LDAPGroupImpl lDAPGroupImpl;
                Vector[] vectorArray = this.addSubGroupDN(namingEnumeration, string4, string, hashtable);
                if (vectorArray == null || (lDAPGroupImpl = (LDAPGroupImpl)vectorArray[0].get(0)) == null) continue;
                String string6 = lDAPGroupImpl.getName();
                this.append.put(string6, lDAPGroupImpl);
                this.charAt.put(string6, vectorArray);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        namingEnumeration.close();
        this.clone = System.currentTimeMillis();
        return this.append;
    }

    private synchronized Vector[] addSubGroupDN(NamingEnumeration namingEnumeration, String string, String string2, Hashtable hashtable) throws NamingException {
        String string3;
        Vector[] vectorArray = new Vector[]{new Vector(), new Vector()};
        LDAPGroupImpl lDAPGroupImpl = new LDAPGroupImpl();
        SearchResult searchResult = (SearchResult)namingEnumeration.next();
        if (searchResult.getName().trim().length() == 0) {
            string3 = string.trim();
        } else {
            string3 = searchResult.getName().trim();
            if (string.trim() != null && string.trim().length() != 0) {
                string3 = string3 + "," + string.trim();
            }
            if (string2.trim() != null && string2.trim().length() != 0) {
                string3 = string3 + "," + string2.trim();
            }
        }
        Attributes attributes = searchResult.getAttributes();
        this.addSubGroup.setAttributes(attributes);
        String string4 = this.addSubGroup.getGroupName();
        if (string4 == null || string4.length() == 0) {
            return null;
        }
        lDAPGroupImpl.setName(string4);
        lDAPGroupImpl.setProperties("description", this.addSubGroup.getGroupDescription());
        lDAPGroupImpl.setProperties("group_dn", string3);
        if (this.addSubGroup.hasMembers()) {
            Object object;
            Object object2;
            String[] stringArray;
            Object object3;
            Vector[] vectorArray2 = this.addUser(attributes);
            Enumeration enumeration = vectorArray2[0].elements();
            while (enumeration.hasMoreElements()) {
                object3 = (String[])enumeration.nextElement();
                stringArray = object3[0];
                object2 = object3[1];
                object = null;
                if (hashtable != null) {
                    object = (LDAPUser)hashtable.get(stringArray);
                    if (null == object) {
                        boolean bl = false;
                        LDAPUser lDAPUser = null;
                        for (String string5 : hashtable.keySet()) {
                            lDAPUser = (LDAPUser)hashtable.get(string5);
                            String string6 = lDAPUser.getProperty("ldapuser_dn");
                            if (!((String)object2).equalsIgnoreCase(string6)) continue;
                            bl = true;
                            break;
                        }
                        if (bl) {
                            object = lDAPUser;
                        }
                    }
                } else {
                    try {
                        object = this.getLDAPUserByDN((String)object2);
                    }
                    catch (NamingException namingException) {
                        ServiceLogger.logError(namingException);
                    }
                }
                if (object == null) continue;
                ServiceLogger.logDebug("Add Sub User: " + (String)stringArray + ", " + ((LDAPUserImpl)object).getName());
                vectorArray[1].add(object);
                lDAPGroupImpl.addUser(((LDAPUserImpl)object).getName());
                lDAPGroupImpl.addUserDN((String)object2);
            }
            object3 = vectorArray2[1].elements();
            while (object3.hasMoreElements()) {
                stringArray = (String[])object3.nextElement();
                object2 = stringArray[0];
                object = stringArray[1];
                lDAPGroupImpl.addSubGroup((String)object2);
                lDAPGroupImpl.addSubGroupDN((String)object);
            }
        }
        vectorArray[0].add(lDAPGroupImpl);
        return vectorArray;
    }

    private synchronized Vector[] addUser(Attributes attributes) throws NamingException {
        Vector[] vectorArray = new Vector[2];
        try {
            Vector<String[]> vector = new Vector<String[]>();
            Vector<String[]> vector2 = new Vector<String[]>();
            String string = this.addElement.getProperty("groupMemberType");
            Attribute attribute = attributes.get(string);
            this.addSubGroup.setAttributes(attributes);
            if (attribute != null) {
                NamingEnumeration<?> namingEnumeration = attribute.getAll();
                while (namingEnumeration.hasMoreElements()) {
                    String[] stringArray;
                    String string2;
                    String string3 = (String)namingEnumeration.nextElement();
                    if (string3.toUpperCase().indexOf(this.addSubGroup.getUserDN().toUpperCase()) != -1 && (string2 = this.addUserDN(string3, false)) != null) {
                        string2 = string2.trim();
                        string2 = string2.replaceAll("\\\\,", ",");
                        stringArray = new String[]{string2, string3};
                        vector.addElement(stringArray);
                    }
                    if (string3.toUpperCase().indexOf(this.addSubGroup.getGroupDN().toUpperCase()) == -1 || (string2 = this.addUserDN(string3, true)) == null) continue;
                    string2 = string2.trim();
                    stringArray = new String[]{string2, string3};
                    vector2.addElement(stringArray);
                }
            }
            vectorArray[0] = vector;
            vectorArray[1] = vector2;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return vectorArray;
    }

    private synchronized String addUserDN(String string, boolean bl) {
        String string2;
        String string3 = this.addElement.getProperty("url") + ":" + this.addElement.getProperty("serverPort") + "/";
        String string4 = this.addElement.getProperty("groupCN");
        String string5 = this.addElement.getProperty("userAN");
        boolean bl2 = CSUtil.getBoolean(this.addElement.getProperty("userEnableSAN"), false);
        if (bl2) {
            string5 = this.addElement.getProperty("userSAN");
        }
        Properties properties = this.append(string);
        try {
            string2 = !bl ? (String)properties.get(string5) : (String)properties.get(string4);
        }
        catch (Exception exception) {
            return null;
        }
        if (string2 != null) {
            return string2.trim();
        }
        return null;
    }

    private Properties append(String string) {
        String string2 = string;
        Properties properties = new Properties();
        Vector<String> vector = new Vector<String>();
        while (null != string && !string.isEmpty()) {
            int n = string.indexOf(",");
            if (-1 == n) {
                vector.add(string);
                string = null;
                continue;
            }
            int n2 = n - 1;
            while (0 <= n2 && string.charAt(n2) == '\\') {
                n = string.indexOf(",", n + 1);
                n2 = n - 1;
            }
            vector.add(string.substring(0, n));
            string = string.substring(n + 1);
        }
        for (String string3 : vector) {
            if (string3.isEmpty()) continue;
            int n = string3.indexOf("=");
            int n3 = string3.lastIndexOf("=");
            if (-1 != n) {
                String string4 = null;
                String string5 = null;
                if (n == n3) {
                    string4 = string3.substring(0, n);
                    string5 = string3.substring(n + 1);
                } else {
                    int n4 = n - 1;
                    while (0 <= n4 && string3.charAt(n4) == '\\') {
                        n = string3.indexOf("=", n + 1);
                        n4 = n - 1;
                    }
                    string4 = string3.substring(0, n);
                    string5 = string3.substring(n + 1);
                }
                if (properties.containsKey(string4)) continue;
                properties.put(string4, string5);
                continue;
            }
            ServiceLogger.logError("Invalid token:[" + string3 + "], entry:[" + string2 + "], tokens=" + vector, 3);
        }
        return properties;
    }

    @Override
    public synchronized Vector getLDAPUserParentGroupNames(String string) throws NamingException {
        Vector<String> vector = new Vector<String>();
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        String string2 = this.addElement.getProperty("groupFilter");
        String string3 = this.addElement.getProperty("groupCN");
        String string4 = this.addElement.getProperty("rootEntry");
        String string5 = this.addElement.getProperty("userAN");
        String[] stringArray = new String[]{string3};
        searchControls.setReturningAttributes(stringArray);
        String string6 = this.addElement.getProperty("groupMemberType");
        String string7 = this.addSubGroup.getGroupDN();
        String string8 = this.addSubGroup.getUserDN();
        String string9 = "(" + string6 + "=" + string5 + "=" + string + "," + string8 + "," + string4 + ")";
        String string10 = string2.equalsIgnoreCase("") ? "(&(" + string3 + "=*)" + string9 + ")" : "(&" + string2 + string9 + ")";
        DirContext dirContext = this.getLdapContext();
        if (dirContext == null) {
            return vector;
        }
        NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(string7, string10, searchControls);
        while (namingEnumeration != null && namingEnumeration.hasMore()) {
            SearchResult searchResult = namingEnumeration.next();
            Attributes attributes = searchResult.getAttributes();
            this.addSubGroup.setAttributes(attributes);
            String string11 = this.addSubGroup.getGroupName();
            vector.add(string11);
        }
        if (namingEnumeration != null) {
            namingEnumeration.close();
        }
        return vector;
    }

    @Override
    public String testFilter(String string) throws NamingException {
        DirContext dirContext = this.getLdapContext();
        if (dirContext == null) {
            return "LDAP_M_00010";
        }
        String string2 = this.addElement.getProperty("userAN");
        String string3 = "(" + string2 + "=*)";
        int n = this.charAt(dirContext, string, string3);
        if (n == 1) {
            return "SECURITY_ERR_55_LDAP_ROLEMAP_TEST_SUCESS";
        }
        return "SECURITY_ERR_56_LDAP_ROLEMAP_TEST_NOUSER";
    }

    @Override
    public boolean isInFilter(String string, String string2) throws NamingException {
        DirContext dirContext = this.getLdapContext();
        if (dirContext == null) {
            return false;
        }
        String string3 = this.addElement.getProperty("userAN");
        String string4 = "(" + string3 + "=" + string2 + ")";
        int n = this.charAt(dirContext, string, string4);
        return n == 1;
    }

    private int charAt(DirContext dirContext, String string, String string2) throws NamingException {
        String string3 = this.addSubGroup.getUserDN();
        String string4 = this.addElement.getProperty("userFilter");
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        String string5 = "(&" + string + string2 + string4 + ")";
        String[] stringArray = new String[]{};
        searchControls.setReturningAttributes(stringArray);
        searchControls.setCountLimit(1L);
        searchControls.setTimeLimit(10000);
        ServiceLogger.logDebug("filter=" + string + ", tempFilter=" + string2 + ", baseFilter=" + string4 + ", userDN=" + string3 + ", searchFilter=" + string5, 6);
        NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(string3, string5, searchControls);
        int n = 0;
        if (namingEnumeration != null && namingEnumeration.hasMore()) {
            ++n;
            namingEnumeration.close();
        }
        return n;
    }

    private int clear() {
        int n;
        String string = this.addElement.getProperty("socketTime");
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
            n = 10;
        }
        return n * 1000;
    }

    class ConnectionCreator
    extends Thread {
        LDAPConnectionImpl connection;

        public ConnectionCreator(LDAPConnectionImpl lDAPConnectionImpl2, String string) {
            super(string);
            this.connection = lDAPConnectionImpl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                InitialDirContext initialDirContext = new InitialDirContext(LDAPConnectionImpl.this.add);
                LDAPConnectionImpl.this.addSubGroupDN = true;
                LDAPConnectionImpl.this.SEDU = initialDirContext;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
                LDAPConnectionImpl.this.SEDU = null;
                LDAPConnectionImpl.this.addSubGroupDN = false;
            }
            finally {
                LDAPConnectionImpl.this.addUser = false;
            }
        }
    }
}

