/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.ldap;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jet.server.jrc.security.ldap.RoleMapImpl;
import jet.server.util.ServerUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LDAPXMLReader {
    private static String SEDU;
    private static Node append;
    private static Hashtable close;
    private static Hashtable containsKey;
    private static String decode;
    private static String equals;
    public static final String LDAP = "LDAP";
    public static final String LDAP_CONFIGURATION = "LDAP-configuration";
    public static final String LDAP_NAME = "LDAP-name";
    public static final String LDAP_BASEINFO = "LDAP-baseInfo";
    public static final String LDAP_USERINFO = "LDAP-userSchemaInfo";
    public static final String LDAP_GROUPINFO = "LDAP-groupSchemaInfo";
    public static final String LDAP_ROLEMAPS = "LDAP-roleMaps";
    public static final String ROLEMAP = "roleMap";
    public static final String ROLEMAP_NAME = "roleMap-name";
    public static final String ROLEMAP_SEARCHFILTER = "roleMap-searchFilter";
    public static final String ROLEMAP_BINDINGROLENAME = "roleMap-bindingRoleName";
    public static final String LDAP_SCHEDULE_TASK_ID = "LDAP-scheduleTaskID";
    public static final String LDAP_ENCODE = "LDAP-encode";
    public static final String NULL_LDAP_PASSWORD = "jinfonet_ldap_null";

    public static void setPath(String string) {
        SEDU = string + "LDAPProperties.xml";
    }

    public static Hashtable getLDAPConfig() {
        return close;
    }

    public static String getTaskID() {
        return decode;
    }

    public static Hashtable getRoleMaps() {
        return containsKey;
    }

    public static void read() throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(new File(SEDU)));
        Document document = documentBuilder.parse(bufferedInputStream);
        bufferedInputStream.close();
        append = document.getDocumentElement();
        LDAPXMLReader.SEDU();
    }

    private static void SEDU() {
        NodeList nodeList = append.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String string = node.getNodeName();
            if (string == null) continue;
            if (string.equals(LDAP_CONFIGURATION)) {
                LDAPXMLReader.append(node);
                continue;
            }
            if (string.equals(LDAP_SCHEDULE_TASK_ID)) {
                LDAPXMLReader.close(node);
                continue;
            }
            if (string.equals(LDAP_ENCODE)) {
                LDAPXMLReader.setEncode(node);
                continue;
            }
            if (!string.equals(LDAP_ROLEMAPS)) continue;
            LDAPXMLReader.containsKey(node);
        }
    }

    private static void append(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals(LDAP_NAME) || string.equals(LDAP_BASEINFO) || string.equals(LDAP_USERINFO) || string.equals(LDAP_GROUPINFO)) {
                LDAPXMLReader.append(node2);
                continue;
            }
            if (node2.getNodeType() != 1) continue;
            Node node3 = node2.getFirstChild();
            string = string.substring(4);
            if (node3 != null) {
                String string2 = node3.getNodeValue();
                if (string.equals("password") && (string2 = ServerUtil.decode(string2)).equals(NULL_LDAP_PASSWORD)) {
                    string2 = "";
                }
                close.put(string, string2);
                continue;
            }
            close.put(string, "");
        }
    }

    private static void close(Node node) {
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return;
        }
        decode = node2.getNodeValue();
    }

    private static void containsKey(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2 == null || !node2.getNodeName().equals(ROLEMAP)) continue;
            LDAPXMLReader.decode(node2);
        }
    }

    private static void decode(Node node) {
        NodeList nodeList = node.getChildNodes();
        RoleMapImpl roleMapImpl = new RoleMapImpl();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node2 = nodeList.item(i);
            if (node2 == null || node2.getNodeType() != 1) continue;
            String string2 = node2.getNodeName();
            Node node3 = node2.getFirstChild();
            if (node3 == null || (string = node3.getNodeValue()) == null || string.length() == 0) continue;
            if (string2.equals(ROLEMAP_NAME)) {
                roleMapImpl.setName(string);
            } else if (string2.equals(ROLEMAP_SEARCHFILTER)) {
                roleMapImpl.setSearchFilter(string);
            } else if (string2.equals(ROLEMAP_BINDINGROLENAME)) {
                roleMapImpl.setRoleName(string);
            }
            if (containsKey.containsKey(roleMapImpl.getName())) continue;
            containsKey.put(roleMapImpl.getName(), roleMapImpl);
        }
    }

    public static String getEncode() {
        return equals;
    }

    public static void setEncode(Node node) {
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return;
        }
        equals = node2.getNodeValue();
    }

    static {
        close = new Hashtable();
        containsKey = new Hashtable();
        decode = "";
        equals = "";
    }
}

