/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.ldap;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jet.server.jrc.security.ldap.intf.RoleMap;
import jet.server.log.ServiceLogger;
import jet.server.util.ServerUtil;
import jet.server.util.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class LDAPXMLWriter {
    private static File SEDU;
    private static Document append;
    private static Node appendChild;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPath(String string) {
        SEDU = new File(string + "LDAPProperties.xml");
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(SEDU));
            LDAPXMLWriter.append(bufferedInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LDAPXMLWriter.SEDU();
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }
    }

    private static void SEDU() {
        Object object;
        try {
            object = SEDU.getParentFile();
            if (!((File)object).exists()) {
                ((File)object).mkdirs();
            }
            SEDU.createNewFile();
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
            return;
        }
        object = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            append = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ServiceLogger.logError(parserConfigurationException);
        }
        appendChild = append.createElement("LDAP");
        append.appendChild(appendChild);
        LDAPXMLWriter.writeLDAPConfigInfo(new Hashtable());
        LDAPXMLWriter.writeLDAPScheduleTaskID("");
        LDAPXMLWriter.writeLDAPRoleMap(new Hashtable());
    }

    private static void append(InputStream inputStream) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            append = documentBuilder.parse(inputStream);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ServiceLogger.logError(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            ServiceLogger.logError(sAXException);
            LDAPXMLWriter.SEDU();
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
        appendChild = append.getDocumentElement();
    }

    public static boolean writeLDAPConfigInfo(Hashtable hashtable) {
        Node node;
        Node node2 = null;
        Node node3 = null;
        Node node4 = null;
        NodeList nodeList = appendChild.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                node = nodeList.item(i);
                String string = node.getNodeName();
                if (string.equals("LDAP-scheduleTaskID")) {
                    node3 = node;
                    continue;
                }
                if (string.equals("LDAP-roleMaps")) {
                    node2 = node;
                    continue;
                }
                if (!string.equals("LDAP-encode")) continue;
                node4 = node;
            }
        }
        Element element = append.createElement("LDAP");
        node = LDAPXMLWriter.appendChild(hashtable);
        element.appendChild(node);
        if (node3 == null) {
            node3 = append.createElement("LDAP-scheduleTaskID");
        }
        element.appendChild(node3);
        if (node4 == null) {
            node4 = append.createElement("LDAP-encode");
        }
        element.appendChild(node4);
        if (node2 == null) {
            node2 = append.createElement("LDAP-roleMaps");
        }
        element.appendChild(node2);
        append.removeChild(appendChild);
        append.appendChild(element);
        appendChild = append.getDocumentElement();
        return LDAPXMLWriter.createTextNode();
    }

    private static Node appendChild(Hashtable hashtable) {
        Element element = append.createElement("LDAP-configuration");
        LDAPXMLWriter.close(element, "LDAP-name", "defaultLDAP");
        Element element2 = append.createElement("LDAP-baseInfo");
        element.appendChild(element2);
        String string = (String)hashtable.get("enableLDAPSupport");
        string = string == null ? "" : string;
        LDAPXMLWriter.close(element2, "env-enableLDAPSupport", string);
        String string2 = (String)hashtable.get("ldapVersion");
        string2 = string2 == null ? "" : string2;
        LDAPXMLWriter.close(element2, "env-ldapVersion", string2);
        String string3 = (String)hashtable.get("enableNoneImportedLDAPSupport");
        string3 = string3 == null ? "" : string3;
        LDAPXMLWriter.close(element2, "env-enableNoneImportedLDAPSupport", string3);
        String string4 = (String)hashtable.get("enableAutoImportLDAPUser");
        string4 = string4 == null ? "" : string4;
        LDAPXMLWriter.close(element2, "env-enableAutoImportLDAPUser", string4);
        String string5 = (String)hashtable.get("url");
        string5 = string5 == null ? "" : string5;
        LDAPXMLWriter.close(element2, "env-url", string5);
        String string6 = (String)hashtable.get("serverPort");
        string6 = string6 == null ? "" : string6;
        LDAPXMLWriter.close(element2, "env-serverPort", string6);
        String string7 = (String)hashtable.get("rootEntry");
        string7 = string7 == null ? "" : string7;
        LDAPXMLWriter.close(element2, "env-rootEntry", string7);
        String string8 = (String)hashtable.get("isUsingSSL");
        string8 = string8 == null ? "" : string8;
        LDAPXMLWriter.close(element2, "env-isUsingSSL", string8);
        String string9 = (String)hashtable.get("directoryManagerDN");
        string9 = string9 == null ? "" : string9;
        LDAPXMLWriter.close(element2, "env-directoryManagerDN", string9);
        String string10 = (String)hashtable.get("password");
        string10 = string10 == null || string10.length() == 0 ? ServerUtil.encode("jinfonet_ldap_null") : ServerUtil.encode(string10);
        try {
            string10 = new String(string10.getBytes(System.getProperty("file.encoding")), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ServiceLogger.logError(unsupportedEncodingException);
        }
        LDAPXMLWriter.close(element2, "env-password", string10);
        String string11 = (String)hashtable.get("socketTime");
        string11 = string11 == null ? "10" : string11;
        LDAPXMLWriter.close(element2, "env-socketTime", string11);
        String string12 = (String)hashtable.get("importGroupType");
        string12 = string12 == null ? "role" : string12;
        LDAPXMLWriter.close(element2, "env-importGroupType", string12);
        Element element3 = append.createElement("LDAP-userSchemaInfo");
        element.appendChild(element3);
        String string13 = (String)hashtable.get("userAN");
        string13 = string13 == null ? "" : string13;
        LDAPXMLWriter.close(element3, "env-userAN", string13);
        String string14 = (String)hashtable.get("userCN");
        string14 = string14 == null ? "" : string14;
        LDAPXMLWriter.close(element3, "env-userCN", string14);
        String string15 = (String)hashtable.get("userEnableSAN");
        string15 = string15 == null ? "" : string15;
        LDAPXMLWriter.close(element3, "env-userEnableSAN", string15);
        String string16 = (String)hashtable.get("userSAN");
        string16 = string16 == null ? "" : string16;
        LDAPXMLWriter.close(element3, "env-userSAN", string16);
        String string17 = (String)hashtable.get("userPassword");
        string17 = string17 == null ? "" : string17;
        LDAPXMLWriter.close(element3, "env-userPassword", string17);
        String string18 = (String)hashtable.get("userDN");
        string18 = string18 == null ? "" : string18;
        LDAPXMLWriter.close(element3, "env-userDN", string18);
        String string19 = (String)hashtable.get("userFilter");
        string19 = string19 == null ? "" : string19;
        LDAPXMLWriter.close(element3, "env-userFilter", string19);
        Element element4 = append.createElement("LDAP-groupSchemaInfo");
        element.appendChild(element4);
        String string20 = (String)hashtable.get("groupCN");
        string20 = string20 == null ? "" : string20;
        LDAPXMLWriter.close(element4, "env-groupCN", string20);
        String string21 = (String)hashtable.get("groupEnableSAN");
        string21 = string21 == null ? "" : string21;
        LDAPXMLWriter.close(element4, "env-groupEnableSAN", string21);
        String string22 = (String)hashtable.get("groupSAN");
        string22 = string22 == null ? "" : string22;
        LDAPXMLWriter.close(element4, "env-groupSAN", string22);
        String string23 = (String)hashtable.get("groupMemberType");
        string23 = string23 == null ? "" : string23;
        LDAPXMLWriter.close(element4, "env-groupMemberType", string23);
        String string24 = (String)hashtable.get("groupFilter");
        string24 = string24 == null ? "" : string24;
        LDAPXMLWriter.close(element4, "env-groupFilter", string24);
        String string25 = (String)hashtable.get("groupDN");
        string25 = string25 == null ? "" : string25;
        LDAPXMLWriter.close(element4, "env-groupDN", string25);
        String string26 = (String)hashtable.get("groupAdminGroup");
        string26 = string26 == null ? "" : string26;
        LDAPXMLWriter.close(element4, "env-groupAdminGroup", string26);
        return element;
    }

    private static void close(Node node, String string, String string2) {
        Element element = append.createElement(string);
        node.appendChild(element);
        Text text = append.createTextNode(string2);
        element.appendChild(text);
    }

    public static boolean writeLDAPScheduleTaskID(String string) {
        Node node;
        NodeList nodeList = appendChild.getChildNodes();
        Node node2 = null;
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                node = nodeList.item(i);
                if (!node.getNodeName().equals("LDAP-configuration")) continue;
                node2 = node;
            }
        }
        Element element = append.createElement("LDAP");
        if (node2 == null) {
            node2 = LDAPXMLWriter.appendChild(new Hashtable());
        }
        element.appendChild(node2);
        append.removeChild(appendChild);
        append.appendChild(element);
        appendChild = append.getDocumentElement();
        node = LDAPXMLWriter.createNewTaskIDNode(string);
        element.appendChild(node);
        return LDAPXMLWriter.createTextNode();
    }

    public static Node createNewTaskIDNode(String string) {
        return LDAPXMLWriter.createNewFile("LDAP-scheduleTaskID", string);
    }

    public static boolean editTaskID(String string) {
        NodeList nodeList = append.getElementsByTagName("LDAP-scheduleTaskID");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!node.getNodeName().equals("LDAP-scheduleTaskID")) continue;
            Node node2 = node.getFirstChild();
            Text text = append.createTextNode(string);
            if (node2 == null) {
                node.appendChild(text);
                continue;
            }
            node.replaceChild(text, node2);
        }
        return LDAPXMLWriter.createTextNode();
    }

    public static boolean writeLDAPEncode(String string) {
        Node node;
        NodeList nodeList = appendChild.getChildNodes();
        Node node2 = null;
        Node node3 = null;
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                node = nodeList.item(i);
                String string2 = node.getNodeName();
                if (string2.equals("LDAP-configuration")) {
                    node2 = node;
                    continue;
                }
                if (!string2.equals("LDAP-scheduleTaskID")) continue;
                node3 = node;
            }
        }
        Element element = append.createElement("LDAP");
        if (node2 == null) {
            node2 = LDAPXMLWriter.appendChild(new Hashtable());
        }
        if (node3 == null) {
            node3 = LDAPXMLWriter.createElement(null);
        }
        element.appendChild(node2);
        element.appendChild(node3);
        append.removeChild(appendChild);
        append.appendChild(element);
        appendChild = append.getDocumentElement();
        node = LDAPXMLWriter.createNewTaskIDNode(string);
        element.appendChild(node);
        return LDAPXMLWriter.createTextNode();
    }

    private static Node createElement(String string) {
        return LDAPXMLWriter.createNewFile("LDAP-encode", string);
    }

    private static Node createNewFile(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        Element element = append.createElement(string);
        Text text = append.createTextNode(string2);
        element.appendChild(text);
        return element;
    }

    public static boolean editEncode(String string) {
        NodeList nodeList = append.getElementsByTagName("LDAP-encode");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!node.getNodeName().equals("LDAP-encode")) continue;
            Node node2 = node.getFirstChild();
            Text text = append.createTextNode(string);
            if (node2 == null) {
                node.appendChild(text);
                continue;
            }
            node.replaceChild(text, node2);
        }
        return LDAPXMLWriter.createTextNode();
    }

    public static boolean writeLDAPRoleMap(Hashtable hashtable) {
        Object object;
        Node node;
        NodeList nodeList = appendChild.getChildNodes();
        Node node2 = null;
        Node node3 = null;
        Node node4 = null;
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                node = nodeList.item(i);
                object = node.getNodeName();
                if (((String)object).equals("LDAP-configuration")) {
                    node2 = node;
                    continue;
                }
                if (((String)object).equals("LDAP-scheduleTaskID")) {
                    node3 = node;
                    continue;
                }
                if (!((String)object).equals("LDAP-encode")) continue;
                node4 = node;
            }
        }
        Element element = append.createElement("LDAP");
        if (node2 == null) {
            node2 = LDAPXMLWriter.appendChild(new Hashtable());
        }
        if (node3 == null) {
            node3 = LDAPXMLWriter.createNewTaskIDNode(null);
        }
        if (node4 == null) {
            node4 = LDAPXMLWriter.createElement(null);
        }
        element.appendChild(node2);
        element.appendChild(node3);
        element.appendChild(node4);
        node = append.createElement("LDAP-roleMaps");
        element.appendChild(node);
        append.removeChild(appendChild);
        append.appendChild(element);
        appendChild = append.getDocumentElement();
        object = hashtable.keys();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            RoleMap roleMap = (RoleMap)hashtable.get(string);
            String string2 = roleMap.getName();
            if (string2 == null) continue;
            Node node5 = LDAPXMLWriter.createNewTaskIDNode(roleMap);
            node.appendChild(node5);
        }
        return LDAPXMLWriter.createTextNode();
    }

    public static boolean addNewRoleMap(RoleMap roleMap) {
        Node node;
        Node node2;
        String string = roleMap.getName();
        NodeList nodeList = append.getElementsByTagName("roleMap-name");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string2;
            node2 = nodeList.item(i);
            node = node2.getFirstChild();
            if (node == null || (string2 = node.getNodeValue()) == null || !string2.equals(string)) continue;
            return false;
        }
        NodeList nodeList2 = append.getElementsByTagName("LDAP-roleMaps");
        if (nodeList2.getLength() != 1) {
            return false;
        }
        node2 = nodeList2.item(0);
        node = LDAPXMLWriter.createNewTaskIDNode(roleMap);
        node2.appendChild(node);
        return LDAPXMLWriter.createTextNode();
    }

    public static boolean editRoleMap(String string, String string2, String string3) {
        String string4;
        Node node;
        NodeList nodeList = append.getElementsByTagName("roleMap-name");
        Node node2 = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            node = node3.getFirstChild();
            if (node == null || (string4 = node.getNodeValue()) == null || !string4.equals(string)) continue;
            node2 = node3.getParentNode();
            break;
        }
        if (node2 != null) {
            NodeList nodeList2 = node2.getChildNodes();
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Text text;
                Node node4;
                node = nodeList2.item(i);
                if (node == null || node.getNodeType() != 1) continue;
                string4 = node.getNodeName();
                if (string4.equals("roleMap-searchFilter")) {
                    node4 = node.getFirstChild();
                    text = append.createTextNode(string2);
                    if (node4 == null) {
                        node.appendChild(text);
                    }
                    node.replaceChild(text, node4);
                }
                if (!string4.equals("roleMap-bindingRoleName")) continue;
                node4 = node.getFirstChild();
                text = append.createTextNode(string3);
                if (node4 == null) {
                    node.appendChild(text);
                }
                node.replaceChild(text, node4);
            }
            return LDAPXMLWriter.createTextNode();
        }
        return false;
    }

    public static boolean removeRoleMap(String string) {
        NodeList nodeList = append.getElementsByTagName("roleMap-name");
        NodeList nodeList2 = append.getElementsByTagName("LDAP-roleMaps");
        if (nodeList2.getLength() != 1) {
            return false;
        }
        Node node = nodeList2.item(0);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string2;
            Node node2 = nodeList.item(i);
            Node node3 = node2.getFirstChild();
            if (node3 == null || (string2 = node3.getNodeValue()) == null || !string2.equals(string)) continue;
            node.removeChild(node2.getParentNode());
            return LDAPXMLWriter.createTextNode();
        }
        return false;
    }

    public static boolean setLDAPProperties(String string, String string2) {
        String string3 = "env-" + string;
        NodeList nodeList = append.getElementsByTagName(string3);
        if (nodeList.getLength() != 1) {
            return false;
        }
        Node node = nodeList.item(0);
        if (node != null) {
            Text text = append.createTextNode(string2);
            if (node.getFirstChild() != null) {
                node.replaceChild(text, node.getFirstChild());
            } else {
                node.appendChild(text);
            }
        }
        return LDAPXMLWriter.createTextNode();
    }

    private static Node createNewTaskIDNode(RoleMap roleMap) {
        Element element = append.createElement("roleMap");
        Element element2 = append.createElement("roleMap-name");
        element.appendChild(element2);
        Text text = append.createTextNode(roleMap.getName());
        element2.appendChild(text);
        Element element3 = append.createElement("roleMap-searchFilter");
        element.appendChild(element3);
        Text text2 = append.createTextNode(roleMap.getSearchFilter());
        element3.appendChild(text2);
        Element element4 = append.createElement("roleMap-bindingRoleName");
        element.appendChild(element4);
        Text text3 = append.createTextNode(roleMap.getRoleName());
        element4.appendChild(text3);
        return element;
    }

    private static boolean createTextNode() {
        try {
            XMLWriter.write(append, SEDU.getAbsolutePath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }
}

