/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.ldap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import jet.server.ServerEnv;
import jet.server.log.ServiceLogger;

public class RelaxedX509TrustManager
implements X509TrustManager {
    private TrustManager SEDU = null;
    private static boolean add = false;
    private static boolean aliases = false;
    private char[] append;
    private String checkServerTrusted;
    private static String close = null;
    private static char[] delete;
    private FileInputStream equals = null;
    private KeyStore equalsIgnoreCase = null;

    RelaxedX509TrustManager() throws Exception {
        Properties properties;
        Object object;
        String string = "SunX509";
        String string2 = System.getProperty("java.vm.vendor");
        if (string2.equalsIgnoreCase("IBM Corporation")) {
            string = "ibmX509";
        }
        this.checkServerTrusted = System.getProperty("javax.net.ssl.trustStore");
        String string3 = System.getProperty("javax.net.ssl.trustStorePassword");
        if (this.checkServerTrusted == null) {
            this.checkServerTrusted = ServerEnv.propertiesPath + "LDAPKeyStore.keystore";
        }
        this.append = string3 == null ? "jinfonet".toCharArray() : string3.toCharArray();
        if (!"".equals(this.checkServerTrusted)) {
            close = this.checkServerTrusted;
            delete = this.append;
        }
        try {
            object = new File(this.checkServerTrusted);
            if (!((File)object).exists()) {
                properties = System.getProperties();
                properties.remove("javax.net.ssl.trustStore");
                properties.remove("javax.net.ssl.trustStorePassword");
                System.setProperties(properties);
            }
        }
        catch (SecurityException securityException) {
            ServiceLogger.logError(securityException, 3);
        }
        try {
            object = TrustManagerFactory.getInstance(string);
            ((TrustManagerFactory)object).init((KeyStore)null);
            this.SEDU = ((TrustManagerFactory)object).getTrustManagers()[0];
            ServiceLogger.logDebug("The Trust Manager Factory is " + string + ".", 6);
        }
        catch (Exception exception) {
            properties = System.getProperties();
            properties.remove("javax.net.ssl.trustStore");
            properties.remove("javax.net.ssl.trustStorePassword");
            System.setProperties(properties);
            File file = new File(this.checkServerTrusted);
            file.delete();
        }
        if (this.SEDU == null) {
            throw new SSLException("Could not get default TrustManager instance.");
        }
        try {
            this.equals = new FileInputStream(this.checkServerTrusted);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.equals = null;
        }
        try {
            this.equalsIgnoreCase = KeyStore.getInstance(KeyStore.getDefaultType());
            this.equalsIgnoreCase.load(this.equals, this.append);
        }
        catch (KeyStoreException keyStoreException) {
            this.equalsIgnoreCase = null;
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray;
        X509Certificate[] x509CertificateArray2 = x509CertificateArray = ((X509TrustManager)this.SEDU).getAcceptedIssuers();
        if (this.equalsIgnoreCase != null) {
            try {
                Enumeration<String> enumeration = this.equalsIgnoreCase.aliases();
                Vector<Certificate> vector = new Vector<Certificate>();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    vector.add(this.equalsIgnoreCase.getCertificate(string.toString()));
                }
                int n = x509CertificateArray.length + vector.size();
                x509CertificateArray2 = new X509Certificate[n];
                Iterator iterator = vector.iterator();
                for (int i = 0; i < n; ++i) {
                    x509CertificateArray2[i] = i < x509CertificateArray.length ? x509CertificateArray[i] : (X509Certificate)iterator.next();
                }
            }
            catch (KeyStoreException keyStoreException) {
                ServiceLogger.logError(keyStoreException, 3);
            }
        }
        return x509CertificateArray2;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.SEDU(x509CertificateArray, string);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.SEDU(x509CertificateArray, string);
    }

    private void SEDU(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        try {
            ((X509TrustManager)this.SEDU).checkServerTrusted(x509CertificateArray, string);
        }
        catch (CertificateException certificateException) {
            if ("false".equals(System.getProperty("RelaxedX509TrustManager"))) {
                Properties properties = System.getProperties();
                properties.remove("RelaxedX509TrustManager");
                System.setProperties(properties);
                aliases = false;
                add = false;
            }
            if (aliases) {
                throw certificateException;
            }
            if (this.equalsIgnoreCase == null || x509CertificateArray == null || x509CertificateArray.length == 0) {
                throw certificateException;
            }
            if (add) {
                return;
            }
            try {
                boolean bl = false;
                if (bl) {
                    add = true;
                } else {
                    for (int i = 0; i < x509CertificateArray.length; ++i) {
                        this.equalsIgnoreCase.setCertificateEntry(((Object)x509CertificateArray[i].getSubjectDN()).toString(), x509CertificateArray[i]);
                    }
                    File file = new File(close.substring(0, close.lastIndexOf(File.separator)));
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(close);
                    this.equalsIgnoreCase.store(fileOutputStream, delete);
                    fileOutputStream.close();
                    fileOutputStream = null;
                    Properties properties = System.getProperties();
                    properties.put("javax.net.ssl.trustStore", close);
                    properties.put("javax.net.ssl.trustStorePassword", new String(delete));
                    System.setProperties(properties);
                }
            }
            catch (Exception exception) {
                throw certificateException;
            }
        }
    }
}

