/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.track;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jet.server.jrc.track.TaskStatusMBean;
import jet.server.log.ServiceLogger;

public class TaskStatus
implements TaskStatusMBean {
    static final String[] Task_Type = new String[]{"", "OnDemand", "Schedule", "Bursting(main)", "Bursting(sub)"};
    private int SEDU = 0;
    private int addFailedTask = 0;
    private int addFinishedTask = 0;
    private int addQueuingTask = 0;
    private int addRunningTask = 0;
    private int addWaitingTask = 0;
    private Map clear = Collections.synchronizedMap(new HashMap());
    private Map containsKey = Collections.synchronizedMap(new HashMap());
    private Map currentThread = Collections.synchronizedMap(new HashMap());

    @Override
    public int getRunningOnDemandReports() {
        return this.SEDU;
    }

    @Override
    public int getRunningScheduleReports() {
        return this.addFailedTask;
    }

    @Override
    public int getWaitingOnDemandReports() {
        return this.addFinishedTask;
    }

    @Override
    public int getWaitingScheduleReports() {
        return this.addQueuingTask;
    }

    @Override
    public int getQueuingOnDemandReports() {
        return this.addRunningTask;
    }

    @Override
    public int getQueuingScheduleReports() {
        return this.addWaitingTask;
    }

    synchronized void addWaitingTask(int n, String string) {
        if (n == 1) {
            ++this.addFinishedTask;
        } else if (n == 2 || n == 3 || n == 4) {
            ++this.addQueuingTask;
        }
        this.containsKey.put(string, new Integer(n));
    }

    synchronized void addRunningTask(String string) {
        if (this.containsKey.containsKey(string)) {
            Object v = this.containsKey.get(string);
            int n = (Integer)v;
            if (n == 1) {
                --this.addFinishedTask;
                ++this.SEDU;
            } else if (n == 2 || n == 3 || n == 4) {
                --this.addQueuingTask;
                ++this.addFailedTask;
            }
            this.containsKey.remove(string);
            this.clear.put(string, v);
        } else if (this.currentThread.containsKey(string)) {
            Object v = this.currentThread.get(string);
            int n = (Integer)v;
            if (n == 1) {
                --this.addRunningTask;
                ++this.SEDU;
            } else if (n == 2 || n == 3 || n == 4) {
                --this.addWaitingTask;
                ++this.addFailedTask;
            }
            this.currentThread.remove(string);
            this.clear.put(string, v);
        }
    }

    synchronized void addQueuingTask(String string) {
        if (this.containsKey.containsKey(string)) {
            Object v = this.containsKey.get(string);
            int n = (Integer)v;
            if (n == 1) {
                --this.addFinishedTask;
                ++this.addRunningTask;
            } else if (n == 2 || n == 3 || n == 4) {
                --this.addQueuingTask;
                ++this.addWaitingTask;
            }
            this.containsKey.remove(string);
            this.currentThread.put(string, v);
        }
    }

    synchronized void addFinishedTask(String string) {
        if (this.clear.containsKey(string)) {
            int n = (Integer)this.clear.get(string);
            if (n == 1) {
                --this.SEDU;
            } else if (n == 2 || n == 3 || n == 4) {
                --this.addFailedTask;
            }
            this.clear.remove(string);
        }
    }

    synchronized void addFailedTask(String string) {
        if (this.clear.containsKey(string)) {
            int n = (Integer)this.clear.get(string);
            if (n == 1) {
                --this.SEDU;
            } else if (n == 2 || n == 3 || n == 4) {
                --this.addFailedTask;
            }
            this.clear.remove(string);
        } else if (this.containsKey.containsKey(string)) {
            int n = (Integer)this.containsKey.get(string);
            if (n == 1) {
                --this.addFinishedTask;
            } else if (n == 2 || n == 3 || n == 4) {
                --this.addQueuingTask;
            }
            this.containsKey.remove(string);
        } else if (this.currentThread.containsKey(string)) {
            int n = (Integer)this.currentThread.get(string);
            if (n == 1) {
                --this.addRunningTask;
            } else if (n == 2 || n == 3 || n == 4) {
                --this.addWaitingTask;
            }
            this.currentThread.remove(string);
        }
    }

    public void addWaitingTask(String string, String string2, String string3, int n, String string4, long l, String string5, String string6, int n2) {
        if (n2 == 1 || n2 == 2) {
            this.addWaitingTask(n, string);
        } else if (n2 == 3) {
            this.addQueuingTask(string);
        }
        if (ServiceLogger.isLoggable(6, 5)) {
            if (n2 == 1 || n2 == 2) {
                ServiceLogger.logDump(5600153, new Object[]{string, string2, string3, Task_Type[n], string5, n2 == 2 ? "UNLAUNCH" : "SUBMIT"}, 5);
            } else {
                ServiceLogger.logDump(5600154, new Object[]{string, n2 == 3 ? "TASK_QUEUE" : "SUBMIT"}, 5);
            }
        }
    }

    public void addRunningTask(String string, String string2, String string3, String string4, long l, int n) {
        if (n == 5) {
            this.addRunningTask(string);
        }
        if (ServiceLogger.isLoggable(6, 5)) {
            if (n == 5) {
                ServiceLogger.logDump(5600155, new Object[]{string, Thread.currentThread().getName(), string3, string4, "INIT_ENGINE"}, 5);
            } else {
                ServiceLogger.logDump(5600156, new Object[]{string, n == 6 ? "LOAD_REPORT" : (n == 7 ? "EXPORTING" : (n == 8 ? "EXIT_ENGINE" : "Running"))}, 5);
            }
        }
    }

    public void dumpRunningReport(String string, String string2, String string3, String string4, long l, int n, String string5, String string6) {
        if (ServiceLogger.isLoggable(6, 5)) {
            if (n == 5) {
                ServiceLogger.logDump(5600155, new Object[]{string, Thread.currentThread().getName(), string3, string4, "INIT_ENGINE"}, 5);
            } else {
                ServiceLogger.logDump(5600162, new Object[]{string, string6, string5, n == 6 ? "LOAD_REPORT" : (n == 7 ? "EXPORTING" : (n == 8 ? "EXIT_ENGINE" : "Running"))}, 5);
            }
        }
    }

    public void addFinishedTask(String string, String string2, String string3, String string4, long l, int n, String string5, String string6, String string7) {
        this.addFinishedTask(string);
        if (ServiceLogger.isLoggable(6, 5)) {
            ServiceLogger.logDump(5600157, new Object[]{string, String.valueOf(n), string5}, 5);
        }
    }

    public void addFailedTask(String string, String string2, String string3) {
        this.addFailedTask(string);
        if ("The task has been stoped!".equals(string3)) {
            return;
        }
        if (ServiceLogger.isLoggable(6, 5)) {
            ServiceLogger.logDump(5600158, new Object[]{string, string3}, 5);
        }
    }

    public void release() {
        this.clear.clear();
        this.clear = null;
        this.containsKey.clear();
        this.containsKey = null;
        this.currentThread.clear();
        this.currentThread = null;
    }
}

