/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrrmisvr;

import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Properties;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.ExportedFileList;
import jet.server.api.RptServer;
import jet.server.api.cluster.ClusterException;
import jet.server.api.cluster.Member;
import jet.server.api.rmi.ReportServerRMIWrapper;
import jet.server.jrserver.JRRptServer;

public class JRReportServerRMIWrapper
extends UnicastRemoteObject
implements ReportServerRMIWrapper {
    private RptServer SEDU = null;

    public JRReportServerRMIWrapper(RptServer rptServer) throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        this.SEDU = rptServer;
    }

    public RptServer getRptServer() throws RemoteException {
        return this.SEDU;
    }

    @Override
    public void shutdown() throws RemoteException {
        if ("true".equals(System.getProperty("jrs.isMyServer"))) {
            this.SEDU.shutdown();
            System.exit(0);
        }
    }

    @Override
    public String runReport(String string, String string2, String string3, Properties properties) throws RemoteException {
        try {
            return this.SEDU.runReport(string, string2, string3, properties);
        }
        catch (Exception exception) {
            throw new ServerException("", exception);
        }
    }

    @Override
    public String runReportWithTimeouts(String string, String string2, String string3, Properties properties, long l) throws RemoteException {
        try {
            return this.SEDU.runReportWithTimeouts(string, string2, string3, properties, l);
        }
        catch (Exception exception) {
            throw new ServerException("", exception);
        }
    }

    @Override
    public boolean isTempResultReady(String string) throws RemoteException {
        try {
            return this.SEDU.isTempResultReady(string);
        }
        catch (Exception exception) {
            throw new ServerException("", exception);
        }
    }

    @Override
    public String waitTempResultReady(String string) throws RemoteException {
        try {
            return this.SEDU.waitTempResultReady(string);
        }
        catch (InterruptedException interruptedException) {
            throw new ServerException("", interruptedException);
        }
    }

    @Override
    public ExportedFileList exportResult(String string, String string2, Properties properties) throws RemoteException {
        try {
            return this.SEDU.exportResult(string, string2, properties);
        }
        catch (Exception exception) {
            throw new ServerException("", exception);
        }
    }

    @Override
    public String submitScheduledTask(String string, Properties properties) throws RemoteException {
        try {
            return this.SEDU.submitScheduledTask(string, properties);
        }
        catch (Exception exception) {
            throw new ServerException("", exception);
        }
    }

    @Override
    public Vector getScheduledTasks() throws RemoteException {
        return this.SEDU.getScheduledTasks();
    }

    @Override
    public Properties getScheduledTask(String string) throws RemoteException {
        return this.SEDU.getScheduledTask(string);
    }

    @Override
    public boolean removeScheduledTask(String string) throws RemoteException {
        return this.SEDU.removeScheduledTask(string);
    }

    @Override
    public void removeLargeReport(String string, boolean bl) throws RemoteException {
        this.SEDU.getLargeReportManager().removeLargeReport(string, bl);
    }

    @Override
    public Member[] getPredefinedServers() throws RemoteException {
        if (this.SEDU.getAdminService().getClusterAdminService() != null) {
            return this.SEDU.getAdminService().getClusterAdminService().getPredefinedServers();
        }
        return null;
    }

    @Override
    public Member[] getAllMembers() throws RemoteException {
        try {
            if (this.SEDU.getClusterService() != null) {
                return this.SEDU.getClusterService().getAllMembers();
            }
        }
        catch (ClusterException clusterException) {
            throw new ServerException("", (Exception)((Object)clusterException));
        }
        return null;
    }

    @Override
    public int getServerStatus() throws RemoteException {
        try {
            return ((JRRptServer)this.SEDU).getServerStatus();
        }
        catch (Exception exception) {
            return -1;
        }
    }
}

