/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrrmisvr.cluster;

import java.rmi.RemoteException;
import jet.server.api.cluster.ClusterException;
import jet.server.api.cluster.ClusterService;
import jet.server.api.cluster.LoadBalancer;
import jet.server.api.cluster.Member;
import jet.server.api.rmi.cluster.RemoteClusterService;
import jet.server.jrrmisvr.ServiceLogger;
import jet.server.jrrmisvr.cluster.JRLoadBalancer;
import jet.server.jrserver.rmi.cluster.JRRemoteLoadBalancer;

public class JRClusterService
implements ClusterService {
    private RemoteClusterService SEDU = null;

    public JRClusterService(RemoteClusterService remoteClusterService) {
        this.SEDU = remoteClusterService;
    }

    @Override
    public String getClusterName() {
        try {
            return this.SEDU.getClusterName();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    @Override
    public Member[] getAllMembers() throws ClusterException {
        try {
            return this.SEDU.getAllMembers();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new ClusterException(remoteException);
        }
    }

    @Override
    public Member getLocalMember() {
        try {
            return this.SEDU.getLocalMember();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    @Override
    public Member getAdminMember() throws ClusterException {
        try {
            return this.SEDU.getAdminMember();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new ClusterException(remoteException);
        }
    }

    @Override
    public LoadBalancer getDefaultLoadBalancer() {
        try {
            return new JRLoadBalancer(this.SEDU.getDefaultLoadBalancer());
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    @Override
    public void setDefaultLoadBalancer(LoadBalancer loadBalancer) {
        try {
            this.SEDU.setDefaultLoadBalancer(new JRRemoteLoadBalancer(loadBalancer));
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public synchronized Member getMember() {
        try {
            return this.SEDU.getMember();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    @Override
    public void registerLocalMember() throws ClusterException {
        try {
            this.SEDU.registerLocalMember();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new ClusterException(remoteException);
        }
    }

    @Override
    public void removeLocalMember() throws ClusterException {
        try {
            this.SEDU.removeLocalMember();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new ClusterException(remoteException);
        }
    }

    @Override
    public boolean isAdminServerCrashed() {
        try {
            return this.SEDU.isAdminServerCrashed();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return true;
        }
    }

    @Override
    public boolean isTaskQueueFull(int n) {
        try {
            return this.SEDU.isTaskQueueFull(n);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        catch (ClusterException clusterException) {
            ServiceLogger.logError((Throwable)((Object)clusterException));
        }
        return false;
    }
}

