/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrrmisvr.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jet.JCliResource;
import jet.cs.CSUtil;
import jet.server.api.TooManyUsersException;
import jet.server.api.exception.InvalidUserException;
import jet.server.api.http.BaseHttpUtil;
import jet.server.api.http.HttpExternalAuthorized;
import jet.server.api.http.HttpUserSessionManager;
import jet.server.api.http.HttpUtil;
import jet.server.api.http.TooManyTimesException;
import jet.server.api.rmi.RemoteUserSessionManager;
import jet.server.intf.security.SecurityAdapter;
import jet.server.jrrmisvr.JRUserSessionManager;
import jet.server.jrrmisvr.ServiceLogger;
import jet.server.jrrmisvr.http.AuthInfo;
import jet.server.jrrmisvr.http.LogoutReg;
import jet.server.jrrmisvr.http.MD5Info;
import jet.server.jrrmisvr.http.RawUserSession;
import jet.server.jrserver.JRUserSession;
import jet.server.monitor.api.InvalidUserSessionException;
import jet.server.monitor.api.UserSession;
import jet.server.rmi.RemoteObjectFactory;
import jet.server.util.ServerUtil;
import jet.server.util.WebSecurityUtil;
import jet.server.util.nls.NlsClientResource;
import jet.server.util.nls.PropertyMessageResourcesFactory;
import jet.util.Base64;

public class JRHttpUserSessionManager
extends JRUserSessionManager
implements HttpUserSessionManager {
    public static final String TAG_JRSESSION = "jrs.userssn";
    public static final String TAG_RAWSESSION = "jrs.rawssn";
    private int SEDU = 5;
    private Hashtable add = new Hashtable();
    private long append = 86400000L;
    private int askInvalidate = 1024;
    private HttpExternalAuthorized checkAdminLogin = null;
    private boolean checkAdminLoginEx = true;
    private SecurityAdapter checkLogin = null;
    private jet.server.monitor.api.http.HttpUserSessionManager checkLoginEx;
    private boolean clear = true;
    private String[] contains = new String[0];
    private String containsKey = null;
    private boolean currentTimeMillis = true;

    public JRHttpUserSessionManager(RemoteUserSessionManager remoteUserSessionManager, String string, String string2, boolean bl, boolean bl2) {
        super(remoteUserSessionManager);
        String string3;
        this.currentTimeMillis = bl;
        this.clear = bl2;
        try {
            this.checkLogin = (SecurityAdapter)RemoteObjectFactory.getRemoteObject(string, Integer.parseInt(string2), "securityAdapter");
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        String string4 = System.getProperty("jrs.httpExternalAuthorized");
        if (string4 != null && string4.trim().length() > 0) {
            try {
                this.checkAdminLogin = (HttpExternalAuthorized)Class.forName(string4.trim()).newInstance();
            }
            catch (Throwable throwable) {
                ServiceLogger.logError("Error in loading user's HttpExternalAuthorized class: " + string4);
                ServiceLogger.logError(throwable);
            }
        }
        if (bl2 && (string3 = System.getProperty("jreport.server.csrf.whitelist")) != null && string3.trim().length() > 0) {
            this.contains = string3.split(";");
        }
    }

    @Override
    public String getUser(HttpServletRequest httpServletRequest) {
        String string = null;
        jet.server.api.UserSession userSession = this.getUserSession(httpServletRequest);
        if (userSession != null) {
            string = userSession.getUserID();
        }
        return string == null ? "" : string;
    }

    @Override
    public jet.server.api.UserSession getUserSession(HttpServletRequest httpServletRequest) {
        jet.server.api.UserSession userSession = null;
        if (this.checkLoginEx != null) {
            userSession = this.SEDU(this.checkLoginEx.getUserSession(httpServletRequest));
            return userSession;
        }
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            try {
                userSession = this.getUserSession((String)httpSession.getValue(TAG_JRSESSION));
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        return userSession;
    }

    private JRUserSession SEDU(UserSession userSession) {
        if (userSession == null) {
            return null;
        }
        JRUserSession jRUserSession = new JRUserSession(userSession.getRealm(), userSession.getUserID(), false, userSession.getID());
        return jRUserSession;
    }

    @Override
    public void setHttpExternalAuthorized(HttpExternalAuthorized httpExternalAuthorized) {
        this.checkAdminLogin = httpExternalAuthorized;
    }

    @Override
    public HttpExternalAuthorized getHttpExternalAuthorized() {
        return this.checkAdminLogin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExpiredUserSessions(HttpServletRequest httpServletRequest) {
        try {
            jet.server.api.UserSession userSession = null;
            String string = null;
            Hashtable hashtable = this.htSessions;
            synchronized (hashtable) {
                boolean bl;
                Enumeration enumeration = this.getAllUserSessions();
                while (enumeration.hasMoreElements()) {
                    userSession = (jet.server.api.UserSession)enumeration.nextElement();
                    string = userSession.getID();
                    if (!this.htSessions.containsKey(string) || System.currentTimeMillis() - this.getLastAccessTime(string) <= (long)userSession.getMaxInactiveInterval()) continue;
                    if (this.checkAdminLogin != null) {
                        bl = this.checkAdminLogin.askInvalidate(userSession);
                        if (userSession.isExternalAuthorized() && !bl) continue;
                        this.logout(httpServletRequest, userSession);
                        continue;
                    }
                    this.logout(httpServletRequest, userSession);
                }
                enumeration = this.getAllWaitUserSessions();
                while (enumeration.hasMoreElements()) {
                    userSession = (jet.server.api.UserSession)enumeration.nextElement();
                    string = userSession.getID();
                    if (!this.htSessions.containsKey(string) || System.currentTimeMillis() - this.getLastAccessTime(userSession.getID()) <= (long)userSession.getMaxInactiveInterval()) continue;
                    if (this.checkAdminLogin != null) {
                        bl = this.checkAdminLogin.askInvalidate(userSession);
                        if (userSession.isExternalAuthorized() && !bl) continue;
                        this.logout(httpServletRequest, userSession);
                        continue;
                    }
                    this.logout(httpServletRequest, userSession);
                }
            }
            userSession = this.getUserSession(httpServletRequest);
            if (userSession != null) {
                this.putSessions(userSession);
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
    }

    @Override
    public jet.server.api.UserSession loginMD5(String string, String string2, String string3, String string4, String string5, String string6, Object object) throws TooManyUsersException {
        return this.loginMD5(string, string2, string3, string4, string5, string6, object, false);
    }

    @Override
    public jet.server.api.UserSession loginMD5(String string, String string2, String string3, String string4, String string5, String string6, Object object, boolean bl) throws TooManyUsersException {
        jet.server.api.UserSession userSession = null;
        String string7 = null;
        try {
            if (this.checkLogin != null) {
                string7 = this.checkLogin.getPassword(string, string2);
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            string7 = "";
        }
        if (string7 == null) {
            string7 = "";
        }
        if (string3.equals(CSUtil.getH(CSUtil.getH(string2 + ":" + string + ":", string7) + ":" + string4 + ":" + CSUtil.getH(string6 + ":" + string5, null), null))) {
            userSession = this.login(string, string2, string7, object, false, bl);
        }
        return userSession;
    }

    @Override
    public boolean checkLogin(HttpServletRequest httpServletRequest, String string, Properties properties) throws TooManyUsersException, TooManyTimesException, IOException {
        try {
            return this.checkLoginEx(httpServletRequest, string, properties);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean checkLoginEx(HttpServletRequest httpServletRequest, String string, Properties properties) throws TooManyUsersException, TooManyTimesException, IOException, InvalidUserException {
        jet.server.api.UserSession userSession = this.getUserSession(httpServletRequest);
        if (userSession == null) {
            if (this.checkLoginEx != null) {
                try {
                    return this.checkLoginEx.checkLoginEx(httpServletRequest, string, properties);
                }
                catch (InvalidUserSessionException invalidUserSessionException) {
                    return false;
                }
            }
            RawUserSession rawUserSession = this.currentTimeMillis(httpServletRequest);
            if (rawUserSession != null && rawUserSession.retry >= this.SEDU) {
                throw new TooManyTimesException(630085);
            }
            if (!this.needSecurity()) {
                String string2 = (String)properties.get("isWait");
                boolean bl = string2 == null ? false : string2.equals("true");
                userSession = this.login(string, "", "", userSession, false, bl);
            } else {
                userSession = this.equalsIgnoreCase(httpServletRequest, string, properties);
            }
            if (userSession != null) {
                this.contains(httpServletRequest, userSession);
                return true;
            }
            return false;
        }
        if (this.clear) {
            if (this.currentTimeMillis && !this.add(httpServletRequest, string, properties)) {
                if (this.append(httpServletRequest, userSession)) {
                    return false;
                }
            } else {
                String string3;
                String string4;
                String string5;
                String string6 = httpServletRequest.getHeader("referer");
                ArrayList<String> arrayList = (ArrayList<String>)userSession.getValue("referer");
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    userSession.putValue("referer", arrayList);
                }
                if ((string5 = ServerUtil.getSiteFromUrl(string6)) != null && !arrayList.contains(string5)) {
                    arrayList.add(string5);
                }
                if ((string4 = ServerUtil.getSiteFromUrl(string3 = httpServletRequest.getRequestURL().toString())) != null && !arrayList.contains(string4)) {
                    arrayList.add(string4);
                }
            }
        }
        return true;
    }

    private boolean add(HttpServletRequest httpServletRequest, String string, Properties properties) throws InvalidUserException {
        Object object;
        boolean bl = false;
        if (this.checkAdminLogin != null && (object = this.checkAdminLogin.getExternalAuthorizedUser(string, httpServletRequest)) != null) {
            bl = true;
        }
        if (!bl) {
            object = null;
            try {
                object = this.decode(httpServletRequest, string, properties);
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
            }
            if (object != null) {
                String string2 = ((AuthInfo)object).password;
                RawUserSession rawUserSession = this.currentTimeMillis(httpServletRequest);
                if (rawUserSession != null) {
                    if (((AuthInfo)object).md5 != null && rawUserSession.md5 != null) {
                        if (((AuthInfo)object).userID != null && ((AuthInfo)object).md5.response != null && ((AuthInfo)object).md5.nonce != null && ((AuthInfo)object).md5.nonce.equals(rawUserSession.md5.nonce) && (((AuthInfo)object).md5.opaque == null || ((AuthInfo)object).md5.opaque.equals(rawUserSession.md5.opaque))) {
                            try {
                                if (this.checkLogin != null) {
                                    string2 = this.checkLogin.getPassword(string, ((AuthInfo)object).userID);
                                }
                            }
                            catch (RemoteException remoteException) {
                                ServiceLogger.logError(remoteException);
                                string2 = "";
                            }
                            if (string2 == null) {
                                string2 = "";
                            }
                        }
                    } else {
                        string2 = ((AuthInfo)object).password;
                    }
                }
                if (super.getAuthenticator().isValidUserEx(string, ((AuthInfo)object).userID, string2)) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    @Override
    public boolean checkAdminLogin(HttpServletRequest httpServletRequest, String string, Properties properties) throws TooManyUsersException, TooManyTimesException, IOException {
        try {
            return this.checkAdminLoginEx(httpServletRequest, string, properties);
        }
        catch (InvalidUserException invalidUserException) {
            return false;
        }
    }

    public boolean checkAdminLoginEx(HttpServletRequest httpServletRequest, String string, Properties properties) throws TooManyUsersException, TooManyTimesException, IOException, InvalidUserException {
        jet.server.api.UserSession userSession = this.getUserSession(httpServletRequest);
        if (userSession == null) {
            RawUserSession rawUserSession = this.currentTimeMillis(httpServletRequest);
            if (rawUserSession != null && rawUserSession.retry >= this.SEDU) {
                throw new TooManyTimesException(630085);
            }
            properties.setProperty("isAdmin", "true");
            userSession = this.equalsIgnoreCase(httpServletRequest, string, properties);
            if (userSession != null) {
                if (this.checkLogin.isAdminUser(string, userSession.getUserID()) || this.checkLogin.isOrganizationAdminUser(string, userSession.getUserID())) {
                    this.contains(httpServletRequest, userSession);
                    return true;
                }
                HttpSession httpSession = httpServletRequest.getSession(true);
                if (httpSession != null) {
                    this.checkAdminLoginEx(httpSession);
                }
            }
            return false;
        }
        if (userSession.getID() == null) {
            throw new TooManyUsersException(630088);
        }
        if (this.clear) {
            if (!this.add(httpServletRequest, string, properties)) {
                if (this.append(httpServletRequest, userSession)) {
                    return false;
                }
            } else {
                String string2;
                String string3;
                String string4;
                String string5 = httpServletRequest.getHeader("referer");
                ArrayList<String> arrayList = (ArrayList<String>)userSession.getValue("referer");
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    userSession.putValue("referer", arrayList);
                }
                if ((string4 = ServerUtil.getSiteFromUrl(string5)) != null && !arrayList.contains(string4)) {
                    arrayList.add(string4);
                }
                if ((string3 = ServerUtil.getSiteFromUrl(string2 = httpServletRequest.getRequestURL().toString())) != null && !arrayList.contains(string3)) {
                    arrayList.add(string3);
                }
            }
        }
        if (this.checkLogin.isAdminUser(string, userSession.getUserID()) || this.checkLogin.isOrganizationAdminUser(string, userSession.getUserID())) {
            return true;
        }
        if (this.checkAdminLoginEx) {
            httpServletRequest.getSession().invalidate();
        }
        return false;
    }

    private boolean append(HttpServletRequest httpServletRequest, jet.server.api.UserSession userSession) {
        String string = httpServletRequest.getHeader("referer");
        ArrayList<String> arrayList = (ArrayList<String>)userSession.getValue("referer");
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            userSession.putValue("referer", arrayList);
        }
        String string2 = httpServletRequest.getRequestURL().toString();
        String string3 = ServerUtil.getSiteFromUrl(string2);
        if (string == null || arrayList.contains(ServerUtil.getSiteFromUrl(string))) {
            if (string == null && string3 != null && !arrayList.contains(string3)) {
                arrayList.add(string3);
            }
            return false;
        }
        String string4 = ServerUtil.getHostFromUrl(string);
        for (String string5 : this.contains) {
            if (!string5.equals(string4)) continue;
            String string6 = ServerUtil.getSiteFromUrl(string);
            if (!arrayList.contains(string6)) {
                arrayList.add(string6);
            }
            return false;
        }
        try {
            List<InetAddress> list = ServerUtil.getAllLocalAddresses();
            if (string4 == null || string4.equals("127.0.0.1") || string4.equals("localhost") || list.contains(InetAddress.getByName(string4))) {
                String string7 = ServerUtil.getSiteFromUrl(string);
                if (!arrayList.contains(string7)) {
                    arrayList.add(string7);
                }
                ServiceLogger.logError("check CSRF vulnerable, headerRefer: " + string + ", sessionReferer: " + arrayList + ", ret: false");
                return false;
            }
        }
        catch (UnknownHostException unknownHostException) {
            ServiceLogger.logError(unknownHostException);
        }
        ServiceLogger.logError("check CSRF vulnerable, headerRefer: " + string + ", sessionReferer: " + arrayList + ", ret: true");
        return true;
    }

    private void askInvalidate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        NlsClientResource nlsClientResource = new NlsClientResource(httpServletRequest);
        PropertyMessageResourcesFactory propertyMessageResourcesFactory = nlsClientResource.getServerResourceFactory();
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = ServerUtil.getResponseWriter(httpServletResponse);
        if (this.containsKey == null) {
            this.containsKey = ServerUtil.getUpperPath(httpServletRequest, "/javascript/jrServer/jrServer.min.js");
        }
        String string2 = httpServletRequest.getParameter("loginCode");
        String string3 = httpServletRequest.getContextPath();
        string3 = string3 + this.containsKey;
        if (string2 == null || string2.trim().length() == 0) {
            printWriter.println("<!DOCTYPE html>");
            printWriter.println("<html>");
            printWriter.println("<head>");
            printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />");
            printWriter.println("<title>" + propertyMessageResourcesFactory.getMessage("HTTP_ERROR_8") + "</title>");
            printWriter.println("<link rel=\"shortcut icon\" href=\"" + HttpUtil.getWebAppUrl(httpServletRequest, string3 + "/favicon.ico") + "\" />");
            printWriter.println("<link href=\"" + HttpUtil.getWebAppUrl(httpServletRequest, string3 + "/style/jrServer/jrServer.min.css") + "\" rel=\"stylesheet\" type=\"text/css\" media=\"screen\" />");
            printWriter.println("<script language=\"javascript\">");
            printWriter.println("var NLSResources = new Object();");
            printWriter.println("NLSResources[\"ERR_MSG_001\"] = \"" + propertyMessageResourcesFactory.getMessage("JS_MSG_001") + "\";");
            printWriter.println("NLSResources[\"DIALOG_TITLE_001\"] = \"" + propertyMessageResourcesFactory.getMessage("2221916") + "\";");
            printWriter.println("NLSResources[\"DIALOG_TITLE_002\"] = \"" + propertyMessageResourcesFactory.getMessage("2221917") + "\";");
            printWriter.println("NLSResources[\"DIALOG_TITLE_003\"] = \"" + propertyMessageResourcesFactory.getMessage("2221918") + "\";");
            printWriter.println("NLSResources[\"DIALOG_TITLE_004\"] = \"" + propertyMessageResourcesFactory.getMessage("2221919") + "\";");
            printWriter.println("NLSResources[\"DIALOG_BUTTON_001\"] = \"" + propertyMessageResourcesFactory.getMessage("91000007") + "\";");
            printWriter.println("NLSResources[\"DIALOG_BUTTON_002\"] = \"" + propertyMessageResourcesFactory.getMessage("91000026") + "\";");
            printWriter.println("NLSResources[\"DIALOG_BUTTON_003\"] = \"" + propertyMessageResourcesFactory.getMessage("91000004") + "\";");
            printWriter.println("NLSResources[\"DIALOG_BUTTON_004\"] = \"" + propertyMessageResourcesFactory.getMessage("91000006") + "\";");
            printWriter.println("NLSResources[\"LOAD_MSG_001\"] = \"" + propertyMessageResourcesFactory.getMessage("22221467") + "\";");
            printWriter.println("NLSResources[\"ERR_MSG_002\"] = \"" + propertyMessageResourcesFactory.getMessage("JS_MSG_004") + "\";");
            printWriter.println("NLSResources[\"ERR_MSG_003\"] = \"" + propertyMessageResourcesFactory.getMessage("JS_MSG_005") + "\";");
            printWriter.println("</script>");
            printWriter.println("<script type=\"text/javascript\" src=\"" + HttpUtil.getWebAppUrl(httpServletRequest, string3 + "/javascript/jquery-1.5.2.min.js") + "\"></script>");
            printWriter.println("<script type=\"text/javascript\" src=\"" + HttpUtil.getWebAppUrl(httpServletRequest, string3 + "/javascript/jquery.base64.js") + "\"></script>");
            printWriter.println("<script type=\"text/javascript\" src=\"" + HttpUtil.getWebAppUrl(httpServletRequest, string3 + "/javascript/jrServer/jrServer.min.js") + "\"></script>");
            printWriter.println("</head>");
            printWriter.println("<body>");
        }
        if (string2 == null || !string2.trim().equals("ajaxLogin")) {
            String string4 = httpServletRequest.getRequestURI();
            if (string4.indexOf("?") != -1) {
                string4 = string4.substring(0, string4.indexOf("?"));
            }
            Enumeration enumeration = httpServletRequest.getParameterNames();
            if (string2 == null || string2.trim().length() == 0) {
                printWriter.println("<div class=\"jrServer-ui jrServer-dialog\"  draggable=\"false\" style=\"width:420px;height:222px;\" data-options=\"");
                printWriter.println("closed: false,");
                printWriter.println("styleName: 'logindialog', ");
                printWriter.println("minimizable: false,");
                printWriter.println("maximizable: false,");
                printWriter.println("closable: false, ");
                printWriter.println("shadow: false\">");
            }
            printWriter.println("<form action=\"" + HttpUtil.getWebAppUrl(httpServletRequest, string4) + "\" method=\"POST\"");
            printWriter.println("class=\"jrServer-ui jrServer-loginform\"");
            printWriter.println(">");
            Boolean bl = (Boolean)httpServletRequest.getAttribute("isAdmin");
            if (bl == null) {
                bl = false;
            }
            printWriter.println("<input type=\"hidden\" name=\"jrs.auth_isadmin\" value=\"" + bl + "\" />");
            String string5 = "";
            String string6 = "";
            String string7 = "";
            while (enumeration.hasMoreElements()) {
                String string8 = (String)enumeration.nextElement();
                String[] stringArray = httpServletRequest.getParameterValues(string8);
                if (stringArray == null || string8.equals("loginCode")) continue;
                for (String string9 : stringArray) {
                    if (null != string8 && "jrs.auth_org".equalsIgnoreCase(string8)) {
                        string5 = string9;
                        continue;
                    }
                    if (null != string8 && "jrs.auth_uid".equalsIgnoreCase(string8)) {
                        string6 = string9;
                        continue;
                    }
                    if (null != string8 && "jrs.auth_pwd".equalsIgnoreCase(string8)) {
                        string7 = string9;
                        continue;
                    }
                    printWriter.println("<input type=\"hidden\" name=\"" + WebSecurityUtil.escapeHTMLAttribute(string8) + "\" value=\"" + WebSecurityUtil.escapeHTMLAttribute(string9) + "\" />");
                }
            }
            printWriter.println("<div class=\"headerTitle\">" + propertyMessageResourcesFactory.getMessage("22221136") + "</div>");
            printWriter.println("<div class=\"headerSubTitle\">" + propertyMessageResourcesFactory.getMessage("22221137") + "</div>");
            printWriter.println("<table border=0 cellspacing=0 cellpadding=0 >");
            printWriter.println("<tr>");
            printWriter.println("<td colspan=2 style=\"height: 20px;\">");
            printWriter.println("<div class=\"message\"></div>");
            printWriter.println("</td>");
            printWriter.println("</tr>");
            if (HttpUtil.getHttpRptServer().getServerEnv().getWebPageOptions().isEnableMultipleOrganization()) {
                printWriter.println("<tr>");
                printWriter.println("<td class=\"label\">" + propertyMessageResourcesFactory.getMessage("22221342") + "</td>");
                printWriter.println("<td class=\"input\">");
                printWriter.println("<input type=\"text\" name=\"jrs.auth_org\" value=\"" + (0 < string5.length() ? WebSecurityUtil.escapeHTMLAttribute(string5) : "System") + "\" />");
                printWriter.println("</td>");
                printWriter.println("</tr>");
            }
            printWriter.println("<tr>");
            printWriter.println("<td class=\"label\">" + propertyMessageResourcesFactory.getMessage("22221132") + "</td>");
            printWriter.println("<td class=\"input\"><input type=\"text\" name=\"jrs.auth_uid\" value=\"" + WebSecurityUtil.escapeHTMLAttribute(string6) + "\" /></td>");
            printWriter.println("</tr>");
            printWriter.println("<tr>");
            printWriter.println("<td class=\"label\">" + propertyMessageResourcesFactory.getMessage("22221133") + "</td>");
            printWriter.println("<td class=\"input\"><input type=\"password\" name=\"jrs.auth_pwd\" value=\"" + WebSecurityUtil.escapeHTMLAttribute(string7) + "\" /></td>");
            printWriter.println("</tr>");
            printWriter.println("<tr>");
            printWriter.println("<td></td><td>");
            printWriter.println("<table border=0 cellspacing=0 cellpadding=0 style=\"width: 100%;\"><tr>");
            printWriter.println("<td style=\"white-space:nowrap;padding-left: 3px;\">");
            printWriter.println("<input name=\"Submit\" type=\"submit\" class=\"submit btn-red\" value=\"" + propertyMessageResourcesFactory.getMessage("22221519") + "\" /><input name=\"Reset\" type=\"button\" class=\"reset btn-gray\" value=\"" + propertyMessageResourcesFactory.getMessage("2220511") + "\" />");
            printWriter.println("</td>");
            printWriter.println("<td id=\"rememberMecheckboxTd\"><input type=\"checkbox\" style=\"padding: 0; margin: 0;\" class=\"rememberMe\" /></td>");
            printWriter.println("<td id=\"rememberMeLabelTd\" class=\"label\">" + propertyMessageResourcesFactory.getMessage("22221134") + "</td>");
            printWriter.println("</tr></table>");
            printWriter.println("</td>");
            printWriter.println("</tr>");
            printWriter.println("</table>");
            printWriter.println("</form>");
            if (string2 == null || string2.trim().length() == 0) {
                printWriter.println("</div>");
            }
        }
        if (string2 == null || string2.trim().length() == 0) {
            printWriter.println("</body>");
            printWriter.println("</html>");
        }
    }

    @Override
    public void sendUnauthorizedResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws IOException {
        if (!BaseHttpUtil.isJRClient(httpServletRequest, null)) {
            if (this.checkAdminLogin != null && !this.checkAdminLogin.handleUnAuthenticatedRequest(httpServletRequest, httpServletResponse, string, string2)) {
                return;
            }
            this.askInvalidate(httpServletRequest, httpServletResponse, string2);
            return;
        }
        this.containsKey(httpServletRequest);
        RawUserSession rawUserSession = this.currentTimeMillis(httpServletRequest);
        rawUserSession.realm = string2;
        if (string.equals("Digest")) {
            rawUserSession.md5 = new MD5Info(httpServletRequest);
        }
        if (this.checkAdminLogin != null && !this.checkAdminLogin.handleUnAuthenticatedRequest(httpServletRequest, httpServletResponse, string, string2)) {
            return;
        }
        httpServletResponse.setStatus(401);
        httpServletResponse.setHeader("WWW-Authenticate", WebSecurityUtil.validateResponseHeader(rawUserSession.makeAuthHeader()));
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<html>");
        printWriter.println("<head>");
        printWriter.println("<title>" + JCliResource.getMessage("CS_MSG_110") + "</title>");
        printWriter.println("</head>");
        printWriter.println("<body>");
        printWriter.println("<H1>401 " + JCliResource.getMessage("CS_MSG_110") + "</H1><h2>");
        printWriter.println("</body>");
        printWriter.println("</html>");
    }

    @Override
    public void logout(HttpServletRequest httpServletRequest) {
        this.clear();
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            jet.server.api.UserSession userSession = this.getUserSession(httpServletRequest);
            if (userSession != null) {
                // empty if block
            }
            this.logout(httpServletRequest, userSession, true);
        }
    }

    private void checkAdminLogin(HttpSession httpSession) {
        try {
            if (httpSession != null) {
                String string = httpSession.getId();
                this.add.remove(string);
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
    }

    private void checkAdminLoginEx(HttpSession httpSession) {
        block5: {
            try {
                if (httpSession == null) break block5;
                try {
                    String string = httpSession.getId();
                    LogoutReg logoutReg = (LogoutReg)this.add.get(string);
                    if (logoutReg != null) {
                        logoutReg.setRetry();
                    }
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
    }

    private boolean checkLogin(HttpServletRequest httpServletRequest) {
        boolean bl = false;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            try {
                String string = httpSession.getId();
                LogoutReg logoutReg = (LogoutReg)this.add.get(string);
                if (logoutReg != null && !logoutReg.retry()) {
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        return bl;
    }

    private void checkLoginEx(HttpServletRequest httpServletRequest, String string) {
        try {
            if (string != null && !BaseHttpUtil.isJRClient(httpServletRequest, null)) {
                this.add.put(string, new LogoutReg());
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        try {
            Hashtable hashtable = this.add;
            synchronized (hashtable) {
                if (this.add.size() >= this.askInvalidate) {
                    String string;
                    Enumeration enumeration = this.add.keys();
                    while (enumeration.hasMoreElements()) {
                        string = (String)enumeration.nextElement();
                        if (System.currentTimeMillis() - ((LogoutReg)this.add.get(string)).getTime() <= this.append) continue;
                        this.add.remove(string);
                    }
                    if (this.add.size() >= this.askInvalidate) {
                        int n = this.askInvalidate / 2;
                        enumeration = this.add.keys();
                        for (int i = 0; enumeration.hasMoreElements() && i < n; ++i) {
                            string = (String)enumeration.nextElement();
                            this.add.remove(string);
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            try {
                Hashtable hashtable = this.add;
                synchronized (hashtable) {
                    if (this.add.size() > this.askInvalidate) {
                        this.add.clear();
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace();
            }
        }
    }

    public void logout(HttpServletRequest httpServletRequest, jet.server.api.UserSession userSession) {
        this.logout(httpServletRequest, userSession, false);
    }

    private void logout(HttpServletRequest httpServletRequest, jet.server.api.UserSession userSession, boolean bl) {
        if (userSession != null) {
            HttpSession httpSession = (HttpSession)this.getExtObj(userSession.getID());
            if (httpSession != null) {
                try {
                    httpSession.removeValue(TAG_JRSESSION);
                    if (this.checkAdminLoginEx) {
                        httpSession.invalidate();
                    }
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                }
                httpSession = httpServletRequest.getSession(true);
                if (bl) {
                    try {
                        this.checkLoginEx(httpServletRequest, httpSession.getId());
                    }
                    catch (Throwable throwable) {
                        ServiceLogger.logError(throwable);
                    }
                }
            }
            super.logout(userSession);
            if (userSession.isExternalAuthorized() && this.checkAdminLogin != null) {
                this.checkAdminLogin.notifyLogout(userSession);
            }
        }
    }

    private void contains(HttpServletRequest httpServletRequest, jet.server.api.UserSession userSession) {
        HttpSession httpSession = httpServletRequest.getSession(true);
        try {
            httpSession.putValue(TAG_JRSESSION, (Object)userSession.getID());
            httpSession.removeValue(TAG_RAWSESSION);
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
    }

    private void containsKey(HttpServletRequest httpServletRequest) {
        if (this.currentTimeMillis(httpServletRequest) == null) {
            HttpSession httpSession = httpServletRequest.getSession(true);
            try {
                httpSession.putValue(TAG_RAWSESSION, (Object)new RawUserSession());
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
    }

    private RawUserSession currentTimeMillis(HttpServletRequest httpServletRequest) {
        RawUserSession rawUserSession = null;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            try {
                rawUserSession = (RawUserSession)httpSession.getValue(TAG_RAWSESSION);
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        return rawUserSession;
    }

    private AuthInfo decode(HttpServletRequest httpServletRequest, String string, Properties properties) throws IOException {
        AuthInfo authInfo = null;
        String string2 = httpServletRequest.getHeader("Authorization");
        if (string2 != null && string2.length() > 0) {
            if (this.checkLogin(httpServletRequest)) {
                this.checkAdminLoginEx(httpServletRequest.getSession(true));
                return null;
            }
            HttpSession httpSession = httpServletRequest.getSession(false);
            if ((httpSession == null || httpSession.isNew()) && (authInfo = this.equals(properties)) == null) {
                this.checkAdminLoginEx(httpServletRequest.getSession(true));
                return null;
            }
            int n = (string2 = string2.trim()).indexOf(" ");
            if (n > 0) {
                if (string2.startsWith("Basic")) {
                    string2 = string2.substring(n).trim();
                    String string3 = CSUtil.getUrlEncoding() != null ? new String(Base64.decode((String)string2), CSUtil.getUrlEncoding()) : new String(Base64.decode((String)string2), "ISO-8859-1");
                    n = string3.indexOf(":");
                    if (n > 0) {
                        authInfo = new AuthInfo();
                        authInfo.userID = string3.substring(0, n).trim();
                        authInfo.password = string3.substring(n + 1);
                    }
                } else if (string2.startsWith("Digest")) {
                    Object object;
                    String string4 = null;
                    String string5 = null;
                    String string6 = null;
                    String string7 = null;
                    String string8 = null;
                    string2 = string2.substring("Digest".length() + 1);
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        object = stringTokenizer.nextToken().trim();
                        int n2 = ((String)object).indexOf("=");
                        if (n2 <= 0) continue;
                        String string9 = ((String)object).substring(0, n2).trim();
                        String string10 = ((String)object).substring(n2 + 1).trim();
                        if (string9.equalsIgnoreCase("username")) {
                            string4 = CSUtil.removeQuotes(string10);
                            continue;
                        }
                        if (string9.equalsIgnoreCase("realm")) {
                            string5 = CSUtil.removeQuotes(string10);
                            continue;
                        }
                        if (string9.equalsIgnoreCase("nonce")) {
                            string6 = CSUtil.removeQuotes(string10);
                            continue;
                        }
                        if (string9.equalsIgnoreCase("response")) {
                            string7 = CSUtil.removeQuotes(string10);
                            continue;
                        }
                        if (!string9.equalsIgnoreCase("opaque")) continue;
                        string8 = CSUtil.removeQuotes(string10);
                    }
                    object = new MD5Info();
                    ((MD5Info)object).nonce = string6;
                    ((MD5Info)object).opaque = string8;
                    ((MD5Info)object).response = string7;
                    authInfo = new AuthInfo();
                    authInfo.userID = string4.trim();
                    authInfo.md5 = object;
                }
            }
        } else {
            authInfo = this.equals(properties);
        }
        return authInfo;
    }

    private AuthInfo equals(Properties properties) throws IOException {
        AuthInfo authInfo = null;
        String string = null;
        String string2 = null;
        String string3 = (String)properties.get("jrs.authorization");
        if (string3 != null && string3.trim().length() > 0) {
            String string4 = CSUtil.getUrlEncoding() != null ? new String(Base64.decode((String)string3), CSUtil.getUrlEncoding()) : new String(Base64.decode((String)string3), "ISO-8859-1");
            int n = string4.indexOf(":");
            if (n > 0) {
                string = string4.substring(0, n);
                string2 = string4.substring(n + 1);
            }
        } else {
            String string5 = (String)properties.get("jrs.auth_org");
            string = (String)properties.get("jrs.auth_uid");
            string2 = (String)properties.get("jrs.auth_pwd");
            if (string2 == null) {
                string2 = "";
            }
            if (string5 != null && string5.trim().length() > 0 && !string5.equals("System")) {
                string = string5 + "\\" + string;
            }
        }
        if (string != null) {
            authInfo = new AuthInfo();
            authInfo.userID = string.trim();
            authInfo.password = string2;
        }
        return authInfo;
    }

    private jet.server.api.UserSession equalsIgnoreCase(HttpServletRequest httpServletRequest, String string, Properties properties) throws TooManyUsersException, IOException, InvalidUserException {
        Object object;
        jet.server.api.UserSession userSession = null;
        if (this.checkAdminLogin != null && (object = this.checkAdminLogin.getExternalAuthorizedUser(string, httpServletRequest)) != null) {
            userSession = this.loginExternalAuthorized(string, (String)object, httpServletRequest.getSession(true));
        }
        if (userSession == null) {
            object = this.decode(httpServletRequest, string, properties);
            String string2 = (String)properties.get("isWait");
            boolean bl = string2 == null ? false : string2.equals("true");
            if (object != null) {
                boolean bl2;
                RawUserSession rawUserSession = this.currentTimeMillis(httpServletRequest);
                if (rawUserSession != null && ((AuthInfo)object).md5 != null && rawUserSession.md5 != null && ((AuthInfo)object).userID != null && ((AuthInfo)object).md5.response != null && ((AuthInfo)object).md5.nonce != null && ((AuthInfo)object).md5.nonce.equals(rawUserSession.md5.nonce) && (((AuthInfo)object).md5.opaque == null || ((AuthInfo)object).md5.opaque.equals(rawUserSession.md5.opaque))) {
                    return this.loginMD5(rawUserSession.realm, ((AuthInfo)object).userID, ((AuthInfo)object).md5.response, ((AuthInfo)object).md5.nonce, rawUserSession.md5.uri, httpServletRequest.getMethod(), httpServletRequest.getSession(true), bl);
                }
                HttpSession httpSession = httpServletRequest.getSession(true);
                boolean bl3 = super.getAuthenticator().isValidUserEx(string, ((AuthInfo)object).userID, ((AuthInfo)object).password);
                if (!bl3) {
                    return null;
                }
                boolean bl4 = bl2 = super.getAuthenticator().isAdminUser(string, ((AuthInfo)object).userID) || super.getAuthenticator().isOrganizationAdminUser(string, ((AuthInfo)object).userID);
                if (!properties.getProperty("isAdmin", "false").equals("true") || bl2) {
                    userSession = this.login(string, ((AuthInfo)object).userID, ((AuthInfo)object).password, httpSession, false, bl);
                }
                if (userSession != null) {
                    this.checkAdminLogin(httpSession);
                } else if (httpSession != null) {
                    this.checkAdminLoginEx(httpSession);
                }
            }
        }
        return userSession;
    }

    private String escapeHTMLAttribute(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            return null;
        }
        try {
            return httpSession.getId();
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            return null;
        }
    }

    @Override
    public boolean isExtraChannel(HttpServletRequest httpServletRequest) {
        return false;
    }

    @Override
    public boolean checkLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Properties properties) throws TooManyUsersException, TooManyTimesException, IOException {
        return this.checkLogin(httpServletRequest, string, properties);
    }

    @Override
    public boolean checkAdminLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Properties properties) throws TooManyUsersException, TooManyTimesException, IOException {
        return this.checkAdminLogin(httpServletRequest, string, properties);
    }

    @Override
    public boolean checkLoginEx(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Properties properties) throws TooManyUsersException, TooManyTimesException, IOException, InvalidUserException {
        return this.checkLoginEx(httpServletRequest, string, properties);
    }

    @Override
    public boolean checkAdminLoginEx(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Properties properties) throws TooManyUsersException, TooManyTimesException, IOException, InvalidUserException {
        return this.checkAdminLoginEx(httpServletRequest, string, properties);
    }

    public void setMonitorUserSessionManager(jet.server.monitor.api.http.HttpUserSessionManager httpUserSessionManager) {
        if (this.checkLoginEx == null) {
            this.checkLoginEx = httpUserSessionManager;
        }
    }
}

