/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import jet.cs.util.APIEnums;
import jet.server.api.CatConnectionInfo;
import toolkit.db.ConnectionInfo;

public class JRCatConnectionInfo
implements CatConnectionInfo {
    private String DEFAULT = null;
    private String NONE = null;
    private String QUALIFIED_2PART = null;
    private String QUALIFIED_3PART = null;
    private String READONLY = null;
    private String READWRITE = null;
    private String READ_COMMITTED = null;
    private String READ_UNCOMMITTED = null;
    private boolean REPEATABLE_READ = false;
    private String SEDU;
    private APIEnums.ConnectionNamePattern SERIALIZABLE;
    private APIEnums.ConnectionReadOnly UNQUALIFIED;
    private String getDateFormat;
    private String getDescription;
    private APIEnums.ConnectionTransactionIsolation getDriver;
    private String getExtraNameChar;
    private String getName;
    private String getPassword = null;
    private String getQualifiedNamePattern = null;
    private String getQuoteNameChar = null;
    private String getReadOnly = null;

    public JRCatConnectionInfo(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, boolean bl) {
        this.DEFAULT = string;
        this.NONE = string2;
        this.QUALIFIED_2PART = string3;
        this.QUALIFIED_3PART = string4;
        this.READONLY = string5;
        this.READWRITE = string6;
        this.READ_COMMITTED = string7;
        this.READ_UNCOMMITTED = string8;
        this.getPassword = string9;
        this.getQualifiedNamePattern = string10;
        this.getQuoteNameChar = string11;
        this.getReadOnly = string12;
        this.REPEATABLE_READ = bl;
    }

    public JRCatConnectionInfo(String string, String string2, ConnectionInfo connectionInfo, boolean bl) {
        this.DEFAULT = string;
        this.NONE = string2;
        this.QUALIFIED_2PART = connectionInfo.getName();
        this.QUALIFIED_3PART = connectionInfo.getDescription();
        this.READONLY = connectionInfo.getUrl();
        this.READWRITE = connectionInfo.getDriver();
        this.READ_COMMITTED = connectionInfo.getUid();
        this.READ_UNCOMMITTED = connectionInfo.getPassword();
        this.SEDU = connectionInfo.getDateFormat();
        this.getDateFormat = connectionInfo.getTimeFormat();
        this.getDescription = connectionInfo.getTimestampFormat();
        this.getExtraNameChar = connectionInfo.getExtraNameChar();
        this.getName = connectionInfo.getQuoteNameChar();
        this.REPEATABLE_READ = bl;
        switch (connectionInfo.getQualifiedNamePattern()) {
            case 0: {
                this.SERIALIZABLE = APIEnums.ConnectionNamePattern.UNQUALIFIED;
                break;
            }
            case 1: {
                this.SERIALIZABLE = APIEnums.ConnectionNamePattern.QUALIFIED_2PART;
                break;
            }
            case 2: {
                this.SERIALIZABLE = APIEnums.ConnectionNamePattern.QUALIFIED_3PART;
                break;
            }
            default: {
                this.SERIALIZABLE = null;
            }
        }
        switch (connectionInfo.getReadOnly()) {
            case 0: {
                this.UNQUALIFIED = APIEnums.ConnectionReadOnly.READWRITE;
                break;
            }
            case 1: {
                this.UNQUALIFIED = APIEnums.ConnectionReadOnly.DEFAULT;
                break;
            }
            case 2: {
                this.UNQUALIFIED = APIEnums.ConnectionReadOnly.READONLY;
                break;
            }
            default: {
                this.UNQUALIFIED = null;
            }
        }
        switch (connectionInfo.getTransactionIsolation()) {
            case 0: {
                this.getDriver = APIEnums.ConnectionTransactionIsolation.DEFAULT;
                break;
            }
            case 1: {
                this.getDriver = APIEnums.ConnectionTransactionIsolation.NONE;
                break;
            }
            case 2: {
                this.getDriver = APIEnums.ConnectionTransactionIsolation.READ_UNCOMMITTED;
                break;
            }
            case 3: {
                this.getDriver = APIEnums.ConnectionTransactionIsolation.READ_COMMITTED;
                break;
            }
            case 4: {
                this.getDriver = APIEnums.ConnectionTransactionIsolation.REPEATABLE_READ;
                break;
            }
            case 5: {
                this.getDriver = APIEnums.ConnectionTransactionIsolation.SERIALIZABLE;
                break;
            }
            default: {
                this.getDriver = null;
            }
        }
    }

    @Override
    public String getType() {
        return this.NONE;
    }

    @Override
    public String getName() {
        return this.QUALIFIED_2PART;
    }

    @Override
    public boolean isDefaultConnection() {
        return this.REPEATABLE_READ;
    }

    @Override
    public String getDesc() {
        return this.QUALIFIED_3PART;
    }

    @Override
    public String getURL() {
        return this.READONLY;
    }

    @Override
    public String getJdbcDriver() {
        return this.READWRITE;
    }

    @Override
    public String getUser() {
        return this.READ_COMMITTED;
    }

    @Override
    public String getPassword() {
        return this.READ_UNCOMMITTED;
    }

    @Override
    public String getClassName() {
        return this.getPassword;
    }

    @Override
    public String getURIValue() {
        return this.getQualifiedNamePattern;
    }

    @Override
    public String getXSDValue() {
        return this.getQuoteNameChar;
    }

    @Override
    public String getRootName() {
        return this.getReadOnly;
    }

    @Override
    public String getDatasourceName() {
        return this.DEFAULT;
    }

    @Override
    public String getDateFormat() {
        return this.SEDU;
    }

    @Override
    public APIEnums.ConnectionNamePattern getNamePattern() {
        return this.SERIALIZABLE;
    }

    @Override
    public APIEnums.ConnectionReadOnly getReadOnly() {
        return this.UNQUALIFIED;
    }

    @Override
    public String getTimeFormat() {
        return this.getDateFormat;
    }

    @Override
    public String getTimestampFormat() {
        return this.getDescription;
    }

    @Override
    public APIEnums.ConnectionTransactionIsolation getTransactionIsolation() {
        return this.getDriver;
    }

    @Override
    public String getExtraCharacters() {
        return this.getExtraNameChar;
    }

    @Override
    public String getQuoteCharacter() {
        return this.getName;
    }
}

