/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.cs.TaskIntf;
import jet.server.api.LargeReportManager;
import jet.server.api.LargeReportRecord;
import jet.server.jrserver.JRLargeReportRecord;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;
import jet.server.schedule.jrtasks.ViewRptTask;
import toolkit.db.DbTools;
import toolkit.db.MiniSort;
import toolkit.db.SortCompareInterface;

public class JRLargeReportManager
implements LargeReportManager,
SortCompareInterface {
    long timeout = SchdTools.TIMEOUT;
    Hashtable htTempResults = new Hashtable();

    public void setTimeout(long l) {
        this.timeout = l;
    }

    public void registerLargeReport(String string, String string2, String string3, String string4, Properties properties, String string5, Thread thread, TaskIntf taskIntf) {
        String string6;
        JRLargeReportRecord jRLargeReportRecord;
        if (string4 != null && (jRLargeReportRecord = (JRLargeReportRecord)this.htTempResults.get(string6 = string4)) == null) {
            jRLargeReportRecord = new JRLargeReportRecord(string, string2, string3, string4, properties, string5, thread, taskIntf);
            this.htTempResults.put(string6, jRLargeReportRecord);
        }
    }

    @Override
    public Vector getLargeReports(String string) {
        Vector<JRLargeReportRecord> vector = new Vector<JRLargeReportRecord>();
        Enumeration enumeration = this.htTempResults.elements();
        while (enumeration.hasMoreElements()) {
            JRLargeReportRecord jRLargeReportRecord = (JRLargeReportRecord)enumeration.nextElement();
            if (jRLargeReportRecord == null || !DbTools.isStringSameNull((String)string, (String)jRLargeReportRecord.getUserID())) continue;
            vector.addElement(jRLargeReportRecord);
        }
        MiniSort.sort(vector, this);
        return vector;
    }

    @Override
    public LargeReportRecord getLargeReportRecord(String string) {
        JRLargeReportRecord jRLargeReportRecord = null;
        if (string != null) {
            jRLargeReportRecord = (JRLargeReportRecord)this.htTempResults.get(string);
        }
        return jRLargeReportRecord;
    }

    @Override
    public LargeReportRecord notifyCompleted(String string) {
        JRLargeReportRecord jRLargeReportRecord = (JRLargeReportRecord)this.getLargeReportRecord(string);
        if (jRLargeReportRecord != null) {
            ViewRptTask viewRptTask;
            TaskIntf taskIntf = jRLargeReportRecord.getTask();
            if (taskIntf != null && taskIntf instanceof ViewRptTask && (viewRptTask = (ViewRptTask)taskIntf).isHtmlPipeLine() && !viewRptTask.isPipeLineFinished()) {
                return null;
            }
            jRLargeReportRecord.notifyCompleted();
        }
        return jRLargeReportRecord;
    }

    @Override
    public void removeLargeReport(String string, boolean bl) {
        JRLargeReportRecord jRLargeReportRecord = (JRLargeReportRecord)this.htTempResults.get(string);
        if (jRLargeReportRecord != null && !jRLargeReportRecord.isCompleted()) {
            ViewRptTask viewRptTask;
            TaskIntf taskIntf;
            if (!bl && (taskIntf = jRLargeReportRecord.getTask()) != null && taskIntf instanceof ViewRptTask && (viewRptTask = (ViewRptTask)taskIntf).isHtmlPipeLine() && !viewRptTask.isPipeLineFinished()) {
                return;
            }
            if (bl) {
                try {
                    jRLargeReportRecord.getTask().stopExec();
                    if (jRLargeReportRecord.getRptThread().isAlive()) {
                        jRLargeReportRecord.getRptThread().stop();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
            }
        }
        if (string != null) {
            this.htTempResults.remove(string);
        }
    }

    public void removeLargeReportIfTimeout() {
        Enumeration enumeration = this.htTempResults.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            JRLargeReportRecord jRLargeReportRecord = (JRLargeReportRecord)this.htTempResults.get(string);
            if (jRLargeReportRecord == null || System.currentTimeMillis() - jRLargeReportRecord.getStartedTime() <= this.timeout) continue;
            this.htTempResults.remove(string);
        }
    }

    @Override
    public boolean isExchangeSortOrder(Object object, Object object2) {
        return object != null && object2 != null && (((JRLargeReportRecord)object).getCatalog() + ((JRLargeReportRecord)object).getReportName() + ((JRLargeReportRecord)object).getStartedTime()).toUpperCase().compareTo((((JRLargeReportRecord)object2).getCatalog() + ((JRLargeReportRecord)object2).getReportName() + ((JRLargeReportRecord)object2).getStartedTime()).toUpperCase()) < 0;
    }

    @Override
    public boolean isLargerOrEqual(Object object, Object object2) {
        return false;
    }

    @Override
    public boolean isLessOrEqual(Object object, Object object2) {
        return false;
    }

    public void setErrorMessage(String string, String string2) {
        JRLargeReportRecord jRLargeReportRecord = (JRLargeReportRecord)this.htTempResults.get(string);
        if (jRLargeReportRecord != null) {
            jRLargeReportRecord.setErrorMessage(string2);
        }
    }

    @Override
    public String getErrorMessage(String string) {
        JRLargeReportRecord jRLargeReportRecord = (JRLargeReportRecord)this.htTempResults.get(string);
        if (jRLargeReportRecord != null) {
            return jRLargeReportRecord.getErrorMessage();
        }
        return null;
    }
}

