/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import jet.cs.TaskIntf;
import jet.server.ServerEnv;
import jet.server.api.LargeReportManager;
import jet.server.api.LargeReportRecord;
import jet.server.api.OndemandReportManager;
import jet.server.api.OndemandReportRecord;
import jet.server.api.ReportSheetInfo;
import jet.server.api.cluster.ClusterException;
import jet.server.cluster.ClusterEnv;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapFactory;
import jet.server.cluster.blocks.MapFlags;
import jet.server.cluster.blocks.MapListenerAdapter;
import jet.server.intf.jrs.RemoteOndemandManager;
import jet.server.jrc.JRTaskManager;
import jet.server.jrserver.JRLargeReportRecord;
import jet.server.jrserver.JROndemandReportRecord;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;
import jet.server.schedule.jrtasks.ViewRptTask;
import toolkit.db.DbTools;
import toolkit.db.MiniSort;
import toolkit.db.SortCompareInterface;

public class JROndemandReportManager
implements OndemandReportManager,
LargeReportManager,
SortCompareInterface {
    private RemoteOndemandManager JROndemandReportRecord = null;
    private int SEDU;
    private long TIMEOUT = SchdTools.TIMEOUT;
    private Hashtable addElement = new Hashtable();
    private JRTaskManager addListener = null;

    public JROndemandReportManager(RemoteOndemandManager remoteOndemandManager, boolean bl) {
        this.JROndemandReportRecord = remoteOndemandManager;
        this.SEDU = ClusterEnv.getMemberID();
        if (!bl) {
            try {
                MapFactory.getMap(MapAttr.JROndemandReportRecord).addListener(new OndemandMapListener());
            }
            catch (ClusterException clusterException) {
                ServiceLogger.logError((Throwable)((Object)clusterException));
            }
        }
    }

    public void setTaskManager(JRTaskManager jRTaskManager) {
        this.addListener = jRTaskManager;
    }

    @Override
    public Vector getOndemandReports(String string) {
        try {
            return this.JROndemandReportRecord.getOndemandReports(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    @Override
    public OndemandReportRecord getOndemandReportRecord(String string) {
        try {
            return this.JROndemandReportRecord.getOndemandReportRecord(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    @Override
    public OndemandReportRecord notifyOndemandCompleted(String string) {
        try {
            return this.JROndemandReportRecord.notifyCompleted(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    @Override
    public OndemandReportRecord changeStatus(String string, String string2) {
        try {
            return this.JROndemandReportRecord.changeStatus(string, string2);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    @Override
    public void removeOndemandReport(String string, boolean bl) {
        try {
            this.JROndemandReportRecord.removeOndemandReport(string, bl);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public void removeOndemandReport(String string) {
        try {
            this.JROndemandReportRecord.removeOndemandReport(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public void removeAllOndemandReport(String string) {
        try {
            this.JROndemandReportRecord.removeAllOndemandReport(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public String registerOndemandReport(String string, String string2, String string3, int n, String string4, ReportSheetInfo reportSheetInfo, int n2, Properties properties, String string5, boolean bl, String string6, String string7, int n3) {
        try {
            return this.JROndemandReportRecord.registerOndemandReport(this.SEDU, string, string2, string3, n, string4, reportSheetInfo, n2, properties, string5, bl, string6, string7, n3);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    public void setOndemandErrorMessage(String string, String string2) {
        try {
            this.JROndemandReportRecord.setErrorMessage(string, string2);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public void addResultFiles(String string, List list) {
        try {
            this.JROndemandReportRecord.addResultFiles(string, list);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public void setTimeout(long l) {
        this.TIMEOUT = l;
    }

    public void registerLargeReport(String string, String string2, String string3, String string4, Properties properties, String string5, Thread thread, TaskIntf taskIntf) {
        String string6;
        JRLargeReportRecord jRLargeReportRecord;
        if (string4 != null && (jRLargeReportRecord = (JRLargeReportRecord)this.addElement.get(string6 = string4)) == null) {
            jRLargeReportRecord = new JRLargeReportRecord(string, string2, string3, string4, properties, string5, thread, taskIntf);
            this.addElement.put(string6, jRLargeReportRecord);
        }
    }

    @Override
    public Vector getLargeReports(String string) {
        Vector<JRLargeReportRecord> vector = new Vector<JRLargeReportRecord>();
        Enumeration enumeration = this.addElement.elements();
        while (enumeration.hasMoreElements()) {
            JRLargeReportRecord jRLargeReportRecord = (JRLargeReportRecord)enumeration.nextElement();
            if (jRLargeReportRecord == null || !DbTools.isStringSameNull((String)string, (String)jRLargeReportRecord.getUserID())) continue;
            vector.addElement(jRLargeReportRecord);
        }
        MiniSort.sort(vector, this);
        return vector;
    }

    @Override
    public LargeReportRecord getLargeReportRecord(String string) {
        JRLargeReportRecord jRLargeReportRecord = null;
        if (string != null) {
            jRLargeReportRecord = (JRLargeReportRecord)this.addElement.get(string);
        }
        return jRLargeReportRecord;
    }

    @Override
    public LargeReportRecord notifyCompleted(String string) {
        JRLargeReportRecord jRLargeReportRecord = (JRLargeReportRecord)this.getLargeReportRecord(string);
        if (jRLargeReportRecord != null) {
            ViewRptTask viewRptTask;
            TaskIntf taskIntf = jRLargeReportRecord.getTask();
            if (taskIntf != null && taskIntf instanceof ViewRptTask && (viewRptTask = (ViewRptTask)taskIntf).isHtmlPipeLine() && !viewRptTask.isPipeLineFinished()) {
                return null;
            }
            jRLargeReportRecord.notifyCompleted();
        }
        return jRLargeReportRecord;
    }

    @Override
    public void removeLargeReport(String string, boolean bl) {
        JRLargeReportRecord jRLargeReportRecord = (JRLargeReportRecord)this.addElement.get(string);
        if (jRLargeReportRecord != null && !jRLargeReportRecord.isCompleted()) {
            if (!bl) {
                ViewRptTask viewRptTask;
                TaskIntf taskIntf = jRLargeReportRecord.getTask();
                if (taskIntf != null && taskIntf instanceof ViewRptTask && (viewRptTask = (ViewRptTask)taskIntf).isHtmlPipeLine() && viewRptTask.getTaskListener() != null && !viewRptTask.isPipeLineFinished()) {
                    return;
                }
            } else {
                try {
                    jRLargeReportRecord.getTask().stopExec();
                    if (jRLargeReportRecord.getRptThread().isAlive()) {
                        jRLargeReportRecord.getRptThread().stop();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
            }
        }
        if (jRLargeReportRecord != null) {
            this.addElement.remove(string);
        }
    }

    public void removeLargeReportIfTimeout() {
        Enumeration enumeration = this.addElement.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            JRLargeReportRecord jRLargeReportRecord = (JRLargeReportRecord)this.addElement.get(string);
            if (jRLargeReportRecord == null || System.currentTimeMillis() - jRLargeReportRecord.getStartedTime() <= this.TIMEOUT) continue;
            this.addElement.remove(string);
        }
    }

    @Override
    public boolean isExchangeSortOrder(Object object, Object object2) {
        return object != null && object2 != null && (((JRLargeReportRecord)object).getCatalog() + ((JRLargeReportRecord)object).getReportName() + ((JRLargeReportRecord)object).getStartedTime()).toUpperCase().compareTo((((JRLargeReportRecord)object2).getCatalog() + ((JRLargeReportRecord)object2).getReportName() + ((JRLargeReportRecord)object2).getStartedTime()).toUpperCase()) < 0;
    }

    @Override
    public boolean isLargerOrEqual(Object object, Object object2) {
        return false;
    }

    @Override
    public boolean isLessOrEqual(Object object, Object object2) {
        return false;
    }

    public void setErrorMessage(String string, String string2) {
        JRLargeReportRecord jRLargeReportRecord = (JRLargeReportRecord)this.addElement.get(string);
        if (jRLargeReportRecord != null) {
            jRLargeReportRecord.setErrorMessage(string2);
        }
    }

    @Override
    public String getErrorMessage(String string) {
        JRLargeReportRecord jRLargeReportRecord = (JRLargeReportRecord)this.addElement.get(string);
        if (jRLargeReportRecord != null) {
            return jRLargeReportRecord.getErrorMessage();
        }
        return null;
    }

    @Override
    public void clearUserOndemandList(String string, boolean bl) {
        try {
            this.JROndemandReportRecord.clearUserOndemandList(string, bl);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public String getOndemandID(String string, String string2) {
        try {
            return this.JROndemandReportRecord.getOndemandID(string, string2);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return "";
    }

    @Override
    public void removeOndemandReport(String string, String string2, boolean bl) {
        try {
            this.JROndemandReportRecord.removeOndemandReport(string, string2, bl);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public void clearMem() {
    }

    class OndemandMapListener
    extends MapListenerAdapter {
        OndemandMapListener() {
        }

        public void afterRemove(String string, int n, String string2, JROndemandReportRecord jROndemandReportRecord, MapFlags mapFlags) {
            if (jROndemandReportRecord != null && jROndemandReportRecord.isLocal()) {
                if (jROndemandReportRecord.isCompleted()) {
                    if (ServerEnv.isPipeline() && jROndemandReportRecord.getResult().endsWith(".html")) {
                        String string3 = jROndemandReportRecord.getResult();
                        if ((string3 = string3.substring(0, string3.length() - ".html".length())).indexOf("_") != -1) {
                            string3 = string3.substring(0, string3.indexOf("_"));
                        }
                        JROndemandReportManager.this.addListener.removePipelineFilenames(string3);
                    }
                    return;
                }
                boolean bl = false;
                Object[] objectArray = MapFlags.getUserFlags(mapFlags);
                if (objectArray != null && objectArray.length > 0) {
                    bl = (Boolean)objectArray[0];
                }
                if (bl) {
                    try {
                        JROndemandReportManager.this.addListener.deleteOndemandReport(jROndemandReportRecord.getOndemandID());
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
        }
    }
}

