/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import jet.ReportEnv;
import jet.server.ServerEnv;
import jet.server.api.ProfileManager;
import jet.server.api.RptServerException;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapFactory;
import jet.server.db.cfg.PropsTable;
import jet.server.db.core.GlobalDataService;
import jet.server.intf.security.SecurityService;
import jet.server.jrc.security.UserDataToolkit;

public class JRProfileManager
implements ProfileManager {
    private static final String PROFILE_MANAGER = "_profile";
    private static final String SEDU = "_name";
    private static final String add = "profile_cfg";
    private static final String addProfile = "Default";
    private String append;
    private String close;
    private PropsTable containsKey;
    private ClusterMap createNewFile;

    public JRProfileManager(String string, String string2) throws Exception {
        this.append = string2;
        this.close = string + string2 + File.separator;
        if (ServerEnv.isClusterEnabled()) {
            this.containsKey = GlobalDataService.getInstance().getPropsTable();
        }
        this.createNewFile = MapFactory.getMapForRealm(string2, MapAttr.PROFILE_MANAGER);
        this.PROFILE_MANAGER();
        this.SEDU("dhtml");
        this.SEDU("studio");
        this.SEDU("dashboard");
    }

    private void PROFILE_MANAGER() throws Exception {
        String string = JRProfileManager.createNewFile(this.append);
        if (this.createNewFile.containsKey(string)) {
            return;
        }
        Properties properties = new Properties();
        String string2 = this.close + add + ".properties";
        File file = new File(string2);
        if (ServerEnv.isClusterEnabled()) {
            Properties properties2 = this.containsKey.queryProp(string);
            if (properties2 != null && properties2.size() > 0) {
                properties = properties2;
            } else if (file.exists()) {
                properties.load(new FileInputStream(file));
                this.containsKey.updateProp(string, properties, true);
            }
        } else if (file.exists()) {
            properties.load(new FileInputStream(string2));
        }
        this.createNewFile.put(string, properties);
    }

    private void SEDU(String string) throws Exception {
        String string2 = JRProfileManager.add(string);
        if (this.createNewFile.containsKey(string2)) {
            return;
        }
        if (ServerEnv.isClusterEnabled()) {
            Hashtable<String, Properties> hashtable = new Hashtable<String, Properties>();
            String[] stringArray = this.getAllProfileNames(string);
            for (int i = 0; i < stringArray.length; ++i) {
                Properties properties = new Properties();
                String string3 = this.append(stringArray[i], string);
                String string4 = this.close + string3 + ".properties";
                File file = new File(string4);
                Properties properties2 = this.containsKey.queryProp("realm_" + this.append + string3);
                if (properties2 != null && properties2.size() > 0) {
                    properties = properties2;
                } else if (file.exists()) {
                    properties.load(new FileInputStream(string4));
                    this.containsKey.updateProp("realm_" + this.append + string3, properties, true);
                }
                hashtable.put(string3, properties);
            }
            this.createNewFile.put(string2, hashtable);
        }
    }

    private boolean isAdminUser(String string, String string2) {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            return "admin".equals(string2);
        }
        return securityService.isAdminUser(string2);
    }

    private static String add(String string) {
        return string + "_profiles";
    }

    private Map addProfile(String string) {
        String string2 = JRProfileManager.add(string);
        HashMap hashMap = (HashMap)this.createNewFile.get(string2);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.createNewFile.put(string2, hashMap);
        }
        return hashMap;
    }

    private String append(String string, String string2) {
        string2 = string2 == null || string2.trim().length() == 0 || "dhtml".equals(string2.trim().toLowerCase()) ? "" : "_" + string2.toLowerCase().trim();
        return Integer.toHexString(string.hashCode()) + PROFILE_MANAGER + string2;
    }

    private String close(String string) {
        string = string == null || string.trim().length() == 0 || "dhtml".equals(string.trim().toLowerCase()) ? "" : "_" + string.toLowerCase().trim();
        return SEDU + string;
    }

    private String containsKey(String string, String string2) {
        return Integer.toHexString(string.hashCode()) + this.close(string2);
    }

    private static String createNewFile(String string) {
        return "profile_config_" + string;
    }

    private void delete(InputStream inputStream, String string) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        int n = 512000;
        byte[] byArray = new byte[n];
        int n2 = 0;
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        while ((n2 = inputStream.read(byArray, 0, n)) != -1) {
            fileOutputStream.write(byArray, 0, n2);
        }
        inputStream.close();
        fileOutputStream.close();
    }

    @Override
    public void addProfile(String string, Properties properties, String string2) throws RptServerException {
        this.addProfile("dhtml", string, properties, string2);
    }

    @Override
    public void addProfile(String string, String string2, Properties properties, String string3) throws RptServerException {
        if (!this.isAdminUser(this.append, string3)) {
            throw new RptServerException(600036);
        }
        if (string2 == null || string2.trim().length() == 0) {
            throw new RptServerException(600037);
        }
        String string4 = JRProfileManager.createNewFile(this.append);
        String string5 = this.append(string2, string);
        Properties properties2 = (Properties)this.createNewFile.get(string4);
        if (properties2.containsKey(string5)) {
            throw new RptServerException(600038, new Object[]{string2}, null);
        }
        try {
            ByteArrayInputStream byteArrayInputStream;
            byte[] byArray;
            Object object;
            properties2.put(string5, string2);
            properties2.put(this.containsKey(string2, string), string2);
            properties.put("jrs.profile", string2);
            properties.put("jrs.profile_last_modified", new Date().toString());
            Map map = this.addProfile(string);
            map.put(string5, properties);
            if (!ServerEnv.isClusterEnabled()) {
                object = new ByteArrayOutputStream();
                properties.store((OutputStream)object, null);
                byArray = ((ByteArrayOutputStream)object).toByteArray();
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                this.delete(byteArrayInputStream, this.close + string5 + ".properties");
            } else {
                this.containsKey.updateProp("realm_" + this.append + string5, properties, true);
            }
            if (!ServerEnv.isClusterEnabled()) {
                object = new ByteArrayOutputStream();
                properties2.store((OutputStream)object, null);
                byArray = ((ByteArrayOutputStream)object).toByteArray();
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                this.delete(byteArrayInputStream, this.close + add + ".properties");
            } else {
                this.containsKey.updateProp(string4, properties2, true);
            }
            object = JRProfileManager.add(string);
            this.createNewFile.put(string4, properties2);
            this.createNewFile.put(object, map);
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
    }

    @Override
    public String[] getAllProfileNames() {
        return this.getAllProfileNames("dhtml");
    }

    @Override
    public String[] getAllProfileNames(String string) {
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        Properties properties = (Properties)this.createNewFile.get(JRProfileManager.createNewFile(this.append));
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            if (!stringArray.endsWith(this.close(string))) continue;
            String string2 = (String)properties.get(stringArray);
            vector.add(string2);
        }
        stringArray = new String[vector.size()];
        for (int i = vector.size() - 1; i >= 0; --i) {
            stringArray[i] = "" + vector.get(i);
        }
        return stringArray;
    }

    @Override
    public Properties getProfile(String string) {
        return this.getProfile("dhtml", string);
    }

    @Override
    public Properties getProfile(String string, String string2) {
        if (string2 == null || string2.trim().length() == 0 || addProfile.equals(string2.trim())) {
            return this.getDefaultProfile(string);
        }
        String string3 = JRProfileManager.createNewFile(this.append);
        String string4 = this.append(string2, string);
        Properties properties = (Properties)this.createNewFile.get(string3);
        if (!properties.containsKey(string4)) {
            return null;
        }
        String string5 = JRProfileManager.add(string);
        Map map = this.addProfile(string);
        Properties properties2 = (Properties)map.get(string4);
        if (properties2 == null) {
            properties2 = new Properties();
            try {
                if (ServerEnv.isClusterEnabled()) {
                    properties2 = this.containsKey.queryProp("realm_" + this.append + string4);
                } else {
                    properties2.load(new FileInputStream(this.close + string4 + ".properties"));
                }
            }
            catch (Exception exception) {
                return null;
            }
            map.put(string4, properties2);
            this.createNewFile.put(string5, map);
        }
        return properties2;
    }

    @Override
    public void removeProfile(String string, String string2) throws RptServerException {
        this.removeProfile("dhtml", string, string2);
    }

    @Override
    public void removeProfile(String string, String string2, String string3) throws RptServerException {
        if (!this.isAdminUser(this.append, string3)) {
            throw new RptServerException(600036);
        }
        try {
            Object object;
            Serializable serializable;
            String string4;
            String string5 = this.append(string2, string);
            Map map = this.addProfile(string);
            map.remove(string5);
            if (!ServerEnv.isClusterEnabled()) {
                string4 = this.close + string5 + ".properties";
                serializable = new File(string4);
                if (((File)serializable).exists()) {
                    ((File)serializable).delete();
                }
            } else {
                this.containsKey.deleteProp("realm_" + this.append + string5);
            }
            string4 = JRProfileManager.createNewFile(this.append);
            serializable = (Properties)this.createNewFile.get(string4);
            ((Properties)serializable).remove(string5);
            ((Properties)serializable).remove(this.containsKey(string2, string));
            if (!ServerEnv.isClusterEnabled()) {
                object = new ByteArrayOutputStream();
                ((Properties)serializable).store((OutputStream)object, null);
                byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                this.delete(byteArrayInputStream, this.close + add + ".properties");
            } else {
                this.containsKey.updateProp(string4, (Properties)serializable, true);
            }
            object = JRProfileManager.add(string);
            this.createNewFile.put(string4, serializable);
            this.createNewFile.put(object, map);
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
    }

    @Override
    public void updateProfile(String string, Properties properties, String string2) throws RptServerException {
        this.updateProfile("dhtml", string, properties, string2);
    }

    @Override
    public void updateProfile(String string, String string2, Properties properties, String string3) throws RptServerException {
        if (!this.isAdminUser(this.append, string3)) {
            throw new RptServerException(600036);
        }
        if (string2 == null || string2.trim().length() == 0) {
            throw new RptServerException(600037);
        }
        String string4 = properties.getProperty("jrs.profile");
        if (string4 == null || string4.trim().length() == 0 || !string4.equals(string2)) {
            properties.put("jrs.profile", string2);
        }
        String string5 = this.append(string2, string);
        String string6 = JRProfileManager.createNewFile(this.append);
        Properties properties2 = (Properties)this.createNewFile.get(string6);
        if (!properties2.containsKey(string5)) {
            throw new RptServerException(600038, new Object[]{string2}, null);
        }
        try {
            Object object;
            Object object2;
            properties.put("jrs.profile_last_modified", new Date().toString());
            if (!ServerEnv.isClusterEnabled()) {
                object2 = new ByteArrayOutputStream();
                properties.store((OutputStream)object2, null);
                object = ((ByteArrayOutputStream)object2).toByteArray();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                this.delete(byteArrayInputStream, this.close + string5 + ".properties");
            } else {
                this.containsKey.updateProp("realm_" + this.append + string5, properties, true);
            }
            object2 = this.addProfile(string);
            object2.put(string5, properties);
            object = JRProfileManager.add(string);
            this.createNewFile.put(object, object2);
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
    }

    @Override
    public Properties getDefaultProfile() {
        return this.getDefaultProfile("dhtml");
    }

    @Override
    public Properties getDefaultProfile(String string) {
        if ("studio".equals(string)) {
            return JRProfileManager.getDefaultStudioProfile();
        }
        if ("dashboard".equals(string)) {
            return JRProfileManager.getDefaultDashboardProfile();
        }
        return JRProfileManager.getDefaultProfile(true, ReportEnv.isWebAdHoc(), true);
    }

    public static Properties getDefaultProfile(boolean bl, boolean bl2, boolean bl3) {
        Properties properties = new Properties();
        properties.put("dhtml.userbar", String.valueOf(bl));
        properties.put("dhtml.reportsetbar", String.valueOf(bl));
        properties.put("dhtml.toolbar", String.valueOf(bl));
        properties.put("dhtml.toc", String.valueOf(bl));
        properties.put("dhtml.menu", String.valueOf(bl));
        properties.put("dhtml.popup", String.valueOf(bl));
        properties.put("dhtml.contextmenu.displayname", "true");
        properties.put("dhtml.contextmenu.filter", "true");
        properties.put("dhtml.contextmenu.sort", "true");
        properties.put("dhtml.contextmenu.goto", "true");
        properties.put("dhtml.contextmenu.drill", "true");
        properties.put("dhtml.contextmenu.show_or_hide", "true");
        properties.put("dhtml.contextmenu.rotate", "true");
        properties.put("dhtml.contextmenu.reset", "true");
        properties.put("dhtml.contextmenu.refresh", "true");
        properties.put("dhtml.contextmenu.search", "true");
        properties.put("dhtml.contextmenu.charttype", "true");
        properties.put("dhtml.contextmenu.tochart", "true");
        properties.put("dhtml.contextmenu.tocrosstab", "true");
        properties.put("dhtml.contextmenu.linkreport", "true");
        properties.put("dhtml.contextmenu.detailreport", "true");
        properties.put("dhtml.contextmenu.delete", "true");
        properties.put("dhtml.contextmenu.bcFilter", "true");
        properties.put("dhtml.contextmenu.properties", "true");
        properties.put("dhtml.contextmenu.expand", "true");
        properties.put("dhtml.contextmenu.style", "true");
        properties.put("dhtml.dso", String.valueOf(bl2));
        properties.put("dhtml.toolbox", String.valueOf(bl2));
        properties.put("dhtml.adhoc", String.valueOf(bl2));
        properties.put("dhtml.tochart", String.valueOf(bl2));
        properties.put("dhtml.tocrosstab", String.valueOf(bl2));
        properties.put("dhtml.rotatecrosstab", String.valueOf(bl2));
        properties.put("dhtml.split", String.valueOf(bl2));
        properties.put("dhtml.merge", String.valueOf(bl2));
        properties.put("dhtml.create", String.valueOf(bl2));
        properties.put("dhtml.preview", String.valueOf(bl2));
        properties.put("dhtml.charttype", String.valueOf(bl2));
        properties.put("dhtml.bcfilter", String.valueOf(bl2));
        properties.put("dhtml.drill", String.valueOf(bl2));
        properties.put("dhtml.grid", String.valueOf(bl2));
        properties.put("dhtml.pivot", String.valueOf(bl2));
        properties.put("dhtml.insert_or_remove", String.valueOf(bl2));
        properties.put("dhtml.create_reportset", String.valueOf(bl2));
        properties.put("dhtml.create_report", String.valueOf(bl2));
        properties.put("dhtml.resize", String.valueOf(bl2));
        properties.put("dhtml.move", String.valueOf(bl2));
        properties.put("dhtml.save", String.valueOf(bl3));
        properties.put("dhtml.saveas", String.valueOf(bl3));
        properties.put("dhtml.filter", String.valueOf(bl3));
        properties.put("dhtml.sort", String.valueOf(bl3));
        properties.put("dhtml.saveresult", String.valueOf(bl3));
        properties.put("dhtml.print", String.valueOf(bl3));
        properties.put("dhtml.search", String.valueOf(bl3));
        properties.put("dhtml.style", String.valueOf(bl3));
        properties.put("dhtml.zoom", String.valueOf(bl3));
        properties.put("dhtml.skin", String.valueOf(bl3));
        properties.put("dhtml.refresh", String.valueOf(bl3));
        properties.put("dhtml.reset", String.valueOf(bl3));
        properties.put("dhtml.unredo", String.valueOf(bl3));
        properties.put("dhtml.nav", String.valueOf(bl3));
        properties.put("dhtml.pagesetup", String.valueOf(bl3));
        properties.put("dhtml.group", String.valueOf(bl3));
        properties.put("dhtml.help", String.valueOf(bl3));
        properties.put("dhtml.open", String.valueOf(bl3));
        properties.put("dhtml.goto", String.valueOf(bl3));
        properties.put("dhtml.recordnumber", String.valueOf(bl3));
        return properties;
    }

    public static Properties getDefaultDashboardProfile() {
        Properties properties = new Properties();
        properties.put("editMode", "{\"Resources\":true,\"New\":true,\"Open\":true,\"Save\":true,\"Saveas\":true,\"Refresh\":true,\"EntParamValue\":true,\"Export\":true,\"Print\":true,\"ClearFilter\":true,\"ServerHome\":true,\"TitleBar\":true,\"ShareParam\":true,\"DSHHeader\":true,\"Help\":true,\"Exit\":true,\"AutoArrange\":true}");
        properties.put("viewMode", "{\"Refresh\":true,\"EntParamValue\":true,\"Export\":true,\"Print\":true,\"ClearFilter\":true,\"ServerHome\":true,\"TitleBar\":true,\"ShareParam\":true,\"DSHHeader\":true,\"Help\":true,\"Exit\":true}");
        return properties;
    }

    public static Properties getDefaultStudioProfile() {
        Properties properties = new Properties();
        return properties;
    }
}

