/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.util.Vector;
import jet.server.ServerEnv;
import jet.server.api.ResultVersionRecord;
import jet.server.api.ResultVersionTable;
import jet.server.api.RptServer;
import jet.server.api.RptServerException;
import jet.server.db.VersionController;
import jet.server.db.VersionRecord;
import jet.server.db.VersionTable;
import jet.server.jrserver.JRResultVersionRecord;
import jet.server.log.ServiceLogger;
import toolkit.db.MiniSort;
import toolkit.db.SortCompareInterface;

public class JRResultVersionTable
implements ResultVersionTable,
SortCompareInterface {
    private VersionController SEDU = null;
    private RptServer addElement = null;
    private VersionTable adjustVersions = null;

    public JRResultVersionTable(VersionTable versionTable, RptServer rptServer) {
        this.adjustVersions = versionTable;
        this.addElement = rptServer;
    }

    public JRResultVersionTable(VersionController versionController, RptServer rptServer) {
        this.SEDU = versionController;
        this.addElement = rptServer;
    }

    @Override
    public synchronized Vector getResultVersionRecords(String string, String string2) throws RptServerException {
        return this.getResultVersionRecords(string, string2, null);
    }

    @Override
    public synchronized Vector getResultVersionRecords(String string, String string2, String string3) throws RptServerException {
        String string4 = string3 == null ? "" : string3;
        return this.getResultVersionRecordsByCatRpt(string, string2, string3);
    }

    @Override
    public synchronized Vector getResultVersionRecordsByCatalogReport(String string, String string2, String string3) throws RptServerException {
        return this.getResultVersionRecords(string, string2, string3, null);
    }

    @Override
    public synchronized Vector getResultVersionRecords(String string, String string2, String string3, String string4) throws RptServerException {
        String string5 = string == null ? "" : string;
        return this.getResultVersionRecordsByCatRpt(string2, string3, string4);
    }

    public synchronized Vector getResultVersionRecordsByCatRpt(String string, String string2, String string3) throws RptServerException {
        if (this.SEDU != null) {
            try {
                Vector vector = this.SEDU.adjustVersions(string, string2, string3);
                int n = vector == null ? 0 : vector.size();
                Vector vector2 = new Vector(n);
                for (int i = 0; i < n; ++i) {
                    vector2.addElement(new JRResultVersionRecord(((VersionRecord)vector.elementAt(i)).getValues()));
                }
                vector2 = MiniSort.sort(vector2, this);
                return vector2;
            }
            catch (ConnectException connectException) {
                ServiceLogger.logError(connectException);
                ServerEnv.dealAdminServerCrash();
                return null;
            }
            catch (ConnectIOException connectIOException) {
                ServiceLogger.logError(connectIOException);
                ServerEnv.dealAdminServerCrash();
                return null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
                throw new RptServerException(exception);
            }
        }
        try {
            return this.adjustVersions.getRecords(string, string2, null, string3, null, -1);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new RptServerException(remoteException);
        }
    }

    @Override
    public synchronized ResultVersionRecord getVersion(String string) throws RptServerException {
        if (this.SEDU != null) {
            try {
                VersionRecord versionRecord = this.SEDU.getVersion(Integer.parseInt(string.trim(), 10));
                if (versionRecord != null) {
                    return new JRResultVersionRecord(versionRecord.getValues());
                }
                return null;
            }
            catch (ConnectException connectException) {
                ServiceLogger.logError(connectException);
                ServerEnv.dealAdminServerCrash();
                return null;
            }
            catch (ConnectIOException connectIOException) {
                ServiceLogger.logError(connectIOException);
                ServerEnv.dealAdminServerCrash();
                return null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
                throw new RptServerException(exception);
            }
        }
        try {
            return this.adjustVersions.getRecord(Integer.parseInt(string.trim(), 10));
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw new RptServerException(exception);
        }
    }

    @Override
    public synchronized void removeVersion(String string) throws RptServerException {
        if (this.SEDU != null) {
            if (string != null) {
                try {
                    this.SEDU.removeVersion(Integer.parseInt(string.trim(), 10));
                }
                catch (ConnectException connectException) {
                    ServiceLogger.logError(connectException);
                    ServerEnv.dealAdminServerCrash();
                }
                catch (ConnectIOException connectIOException) {
                    ServiceLogger.logError(connectIOException);
                    ServerEnv.dealAdminServerCrash();
                }
                catch (RemoteException remoteException) {
                    ServiceLogger.logError(remoteException);
                    throw new RptServerException(remoteException);
                }
            }
        } else {
            try {
                this.adjustVersions.delRecord(Integer.parseInt(string.trim(), 10));
            }
            catch (ConnectException connectException) {
                ServiceLogger.logError(connectException);
                ServerEnv.dealAdminServerCrash();
            }
            catch (ConnectIOException connectIOException) {
                ServiceLogger.logError(connectIOException);
                ServerEnv.dealAdminServerCrash();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
                throw new RptServerException(exception);
            }
        }
    }

    @Override
    public synchronized void commit() throws RptServerException {
        if (this.SEDU != null) {
            try {
                this.SEDU.commit();
            }
            catch (ConnectException connectException) {
                ServiceLogger.logError(connectException);
                ServerEnv.dealAdminServerCrash();
            }
            catch (ConnectIOException connectIOException) {
                ServiceLogger.logError(connectIOException);
                ServerEnv.dealAdminServerCrash();
            }
            catch (RemoteException remoteException) {
                ServiceLogger.logError(remoteException);
                throw new RptServerException(remoteException);
            }
        } else {
            try {
                this.adjustVersions.commit();
            }
            catch (ConnectException connectException) {
                ServiceLogger.logError(connectException);
                ServerEnv.dealAdminServerCrash();
            }
            catch (ConnectIOException connectIOException) {
                ServiceLogger.logError(connectIOException);
                ServerEnv.dealAdminServerCrash();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
                throw new RptServerException(exception);
            }
        }
    }

    @Override
    public boolean isExchangeSortOrder(Object object, Object object2) {
        try {
            if (object != null && object2 != null && object instanceof ResultVersionRecord && ((ResultVersionRecord)object).getCreatedTime().after(((ResultVersionRecord)object2).getCreatedTime())) {
                return true;
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        return false;
    }

    @Override
    public boolean isLargerOrEqual(Object object, Object object2) {
        return false;
    }

    @Override
    public boolean isLessOrEqual(Object object, Object object2) {
        return false;
    }
}

