/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.io.File;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.security.SecureRandom;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.db.Database;
import jet.server.api.db.Workspace;
import jet.server.api.profiling.TaskAuditor;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.WorkspaceImpl;
import jet.server.db.core.WorkspaceManager;
import jet.server.jrc.TaskStatisticRecorder;
import jet.server.log.ServiceLogger;
import jet.server.profiling.jreport.TaskAuditTable;
import jet.server.schedule.SchdTools;

public class JRTaskAuditor
implements TaskAuditor {
    public static final int ON_DEMAND = 1;
    public static final int SCHEDULED = 2;
    public static final int BURSTING_MAIN = 3;
    public static final int BURSTING_SUB = 4;
    public static final int DHTML = 5;
    public static final int JREPORT_STUDIO = 6;
    public static final int DASHBOARD = 7;
    public static final int VA = 8;
    public static final String TASK_TOPIC = "TaskAuditor";
    public static final String TOPIC_TYPE = "TopicType";
    public static final int SUBMIT_TASK = 0;
    public static final int START_TASK = 1;
    public static final int FINISH_TASK = 2;
    public static final int FAILED_TASK = 3;
    public static final int SET_REPORT = 5;
    public static final int SET_CATALOG = 6;
    public static final int ADD_CATALOG = 7;
    public static final int SET_PARAMETERS = 8;
    public static final int CHANGE_PARAMETERS = 9;
    public static final int START_REFRESH_PARAMETERS = 10;
    public static final int FINISH_REFRESH_PARAMETERS = 11;
    public static final int SUBMITED = 1;
    public static final int UNLAUNCH = 2;
    public static final int TASK_QUEUE = 3;
    public static final int RUNNING = 4;
    public static final int INIT_ENGINE = 5;
    public static final int LOAD_REPORT = 6;
    public static final int EXPORTING = 7;
    public static final int EXIT_ENGINE = 8;
    public static final int COMPLETED = 9;
    public static final int FAILED = 10;
    private Hashtable SEDU = new Hashtable();
    private Hashtable addTask = new Hashtable();
    public static final String TASK_ID = "taskID";
    public static final String RPT_NAME = "rptName";
    public static final String TASK_TYPE = "taskType";
    public static final String TASK_STATUS = "taskStatus";
    public static final String SERVER_NAME = "serverName";
    public static final String RUN_HOST = "runHost";
    public static final String RUN_PORT = "runPort";
    public static final String SUBMIT_TIME = "submitTime";
    public static final String START_TIME = "startTime";
    public static final String FINISH_TIME = "finishTime";
    public static final String RPT_PAGES = "rptPages";
    public static final String RPT_SOURCE = "rptSource";
    public static final String RST_FILE_NAME = "rstFileName";
    public static final String USER_NAME = "userName";
    public static final String REASON = "reason";
    public static final String ENGINE_INFO = "engineInfo";
    public static final String FAILED_INFO = "failedInfo";
    public static final String FIRST_SUBMIT_TIME = "firstSubmitTime";
    public static final String RUN_TIMES_NUMBER = "runTimesNumber";
    public static final String PARAMETER = "parameter";
    public static final String CHANGE_TIME = "changeTime";
    private TaskAuditTable append = null;
    private TaskStatisticRecorder currentTimeMillis = null;

    private Database SEDU(Workspace workspace) {
        Object object;
        int n = 8886;
        ExProperties exProperties = new ExProperties();
        try {
            object = ServerEnv.homePath + "derby" + File.separator + "derby.properties";
            exProperties.load((String)object);
            n = exProperties.getProperty("derby.drda.portNumber", 1527);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        object = new DatabaseImpl(workspace, "profile");
        object.setProperty("driver", "org.apache.derby.jdbc.ClientDriver");
        object.setProperty("user", "APP");
        object.setProperty("password", "APP");
        object.setProperty("auto-start-derbyservice", "true");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("jdbc:derby://localhost:").append(n).append("/profilingtable.").append(workspace.getName()).append(";create=true");
        object.setProperty("url", stringBuffer.substring(0));
        ((WorkspaceImpl)workspace).append((Database)object);
        return object;
    }

    public JRTaskAuditor(TaskStatisticRecorder taskStatisticRecorder) throws SQLException {
        this.currentTimeMillis = taskStatisticRecorder;
        Database database = null;
        String string = ServerEnv.getActiveRealm();
        Workspace workspace = WorkspaceManager.getInstance().workspaces(string);
        if (workspace == null) {
            workspace = new WorkspaceImpl(string);
            database = this.SEDU(workspace);
            WorkspaceManager.getInstance().append(workspace);
            WorkspaceManager.getInstance().saveConfig();
        } else {
            database = workspace.databases("profile");
            if (database == null) {
                database = this.SEDU(workspace);
                WorkspaceManager.getInstance().saveConfig();
            }
        }
        try {
            ((DatabaseImpl)database).open();
            this.append = TaskAuditTable.getInstance(database);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
    }

    @Override
    public String generateTaskID() {
        return SchdTools.getIdBase();
    }

    @Override
    public void taskSubmitted(String string, int n, long l, String string2, Map map) {
        StackTraceElement[] stackTraceElementArray;
        Properties properties = new Properties();
        properties.put(TASK_ID, string);
        properties.put(TASK_TYPE, String.valueOf(n));
        properties.put(USER_NAME, string2);
        properties.put(TASK_STATUS, String.valueOf(1));
        properties.put(SUBMIT_TIME, String.valueOf(l));
        properties.put(PARAMETER, map);
        properties.put(TOPIC_TYPE, String.valueOf(0));
        if (5 <= n && n <= 7) {
            this.SEDU.put(string, properties);
        }
        if (5 == n) {
            stackTraceElementArray = new Properties();
            stackTraceElementArray.put("VS_rpt_name", "");
            stackTraceElementArray.put("VI_tsk_type", new Integer(0));
            stackTraceElementArray.put("TS_tsk_submit", (Object)System.currentTimeMillis());
            stackTraceElementArray.put("TC_eng_load", new Long(0L));
            stackTraceElementArray.put("TC_eng_export", new Long(0L));
            stackTraceElementArray.put("TC_eng_other", new Long(0L));
            stackTraceElementArray.put("TC_tsk_other", new Long(0L));
            stackTraceElementArray.put("NC_rpt_pages", new Long(0L));
            stackTraceElementArray.put("NC_rpt_formats", new Long(1L));
            stackTraceElementArray.put("NC_eng_concurrent", new Long(0L));
            stackTraceElementArray.put("NC_que_length", new Long(0L));
            stackTraceElementArray.put("Task_type", "DHTML");
            stackTraceElementArray.put("TaskID", string);
            this.addTask.put(string, stackTraceElementArray);
        }
        if ((stackTraceElementArray = new Exception().getStackTrace()).length >= 2) {
            properties.put("MessageSource", stackTraceElementArray[1].getClassName());
        }
        try {
            ServerEnv.getEventQueue().postEvent(TASK_TOPIC, 0, properties, 1);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        ServiceLogger.logDebug("Task submitted, taskID=" + string + ", taskType=" + n + ", submitTime=" + l + ", user=" + string2, 6);
    }

    @Override
    public void taskStarted(String string, long l) {
        StackTraceElement[] stackTraceElementArray;
        Properties properties = new Properties();
        properties.put(TASK_ID, string);
        properties.put(TASK_STATUS, String.valueOf(4));
        properties.put(START_TIME, String.valueOf(l));
        properties.put(TOPIC_TYPE, String.valueOf(1));
        String string2 = "";
        try {
            string2 = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            string2 = "localhost";
        }
        properties.put(RUN_HOST, string2);
        properties.put(RUN_PORT, String.valueOf(ServerEnv.getActiveRMIPort()));
        Hashtable hashtable = (Hashtable)this.addTask.get(string);
        if (null != hashtable) {
            hashtable.put("TS_eng_start", System.currentTimeMillis());
            long l2 = System.currentTimeMillis();
            long l3 = (Long)hashtable.get("TS_eng_start") - (Long)hashtable.get("TS_tsk_submit");
            long l4 = l2 - (Long)hashtable.get("TS_eng_start");
            long l5 = l2 - (Long)hashtable.get("TS_tsk_submit");
            hashtable.put("TS_eng_exits", l2);
            hashtable.put("TS_tsk_complete", l2);
            hashtable.put("TC_tsk_waited", new Long(l3));
            hashtable.put("TC_eng_total", new Long(l4));
            hashtable.put("TC_tsk_total", new Long(l5));
            hashtable.put("VI_tsk_status", 2);
        }
        if ((stackTraceElementArray = new Exception().getStackTrace()).length >= 2) {
            properties.put("MessageSource", stackTraceElementArray[1].getClassName());
        }
        try {
            ServerEnv.getEventQueue().postEvent(TASK_TOPIC, 1, properties, 1);
            if (null != hashtable) {
                ServerEnv.getEventQueue().postEvent("TaskContext", 0, hashtable, 1);
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        ServiceLogger.logDebug("Task started, taskID=" + string + ", startRunTime=" + l, 6);
    }

    @Override
    public void setTaskReport(String string, String string2) {
        StackTraceElement[] stackTraceElementArray;
        Properties properties = new Properties();
        properties.put(TASK_ID, string);
        Properties properties2 = (Properties)this.SEDU.get(string);
        SecureRandom secureRandom = new SecureRandom();
        if (null != properties2) {
            if (null == string2) {
                int n = Integer.parseInt(properties2.getProperty(TASK_TYPE));
                switch (n) {
                    case 5: {
                        string2 = "New_" + secureRandom.nextInt(1000000) + ".cls";
                        break;
                    }
                    case 6: {
                        string2 = "New_" + secureRandom.nextInt(1000000) + ".wls";
                        break;
                    }
                    case 7: {
                        string2 = "New_" + secureRandom.nextInt(1000000) + ".dsh";
                        break;
                    }
                    case 8: {
                        string2 = "New_" + secureRandom.nextInt(1000000) + ".va";
                        break;
                    }
                    default: {
                        string2 = "New_" + secureRandom.nextInt(1000000) + ".cls";
                        ServiceLogger.logDebug("Set task report, taskID=" + string + ", taskType=" + n + ", reportName=" + string2, 6);
                    }
                }
            }
            properties2.put(RPT_NAME, string2);
        } else if (null == string2) {
            string2 = "New_" + secureRandom.nextInt(1000000) + ".cls";
            ServiceLogger.logDebug("Set task report, taskID=" + string + ", reportName=" + string2, 6);
        }
        properties.put(RPT_NAME, string2);
        properties.put(TOPIC_TYPE, String.valueOf(5));
        Hashtable hashtable = (Hashtable)this.addTask.get(string);
        if (null != hashtable) {
            hashtable.put("VS_rpt_name", string2);
        }
        if ((stackTraceElementArray = new Exception().getStackTrace()).length >= 2) {
            properties.put("MessageSource", stackTraceElementArray[1].getClassName());
        }
        try {
            ServerEnv.getEventQueue().postEvent(TASK_TOPIC, 5, properties, 1);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        ServiceLogger.logDebug("Set task report, taskID=" + string + ", reportName=" + string2, 6);
    }

    @Override
    public void setTaskCatalog(String string, String string2) {
        Object object;
        Properties properties = new Properties();
        properties.put(TASK_ID, string);
        properties.put(RPT_SOURCE, null == string2 ? "" : string2);
        properties.put(TOPIC_TYPE, String.valueOf(6));
        Properties properties2 = (Properties)this.SEDU.get(string);
        if (null != properties2) {
            properties2.put(RPT_SOURCE, null == string2 ? "" : string2);
            object = properties2.getProperty(RPT_NAME);
            if (null == object) {
                this.SEDU.remove(string);
            } else {
                this.currentTimeMillis.addTask(properties2);
            }
        }
        if (((StackTraceElement[])(object = new Exception().getStackTrace())).length >= 2) {
            properties.put("MessageSource", object[1].getClassName());
        }
        try {
            ServerEnv.getEventQueue().postEvent(TASK_TOPIC, 6, properties, 1);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        ServiceLogger.logDebug("Set task catalog, taskID=" + string + ", catalogName=" + string2, 6);
    }

    @Override
    public void addTaskCatalog(String string, String string2) {
        Properties properties = new Properties();
        properties.put(TASK_ID, string);
        properties.put(RPT_SOURCE, string2);
        properties.put(TOPIC_TYPE, String.valueOf(7));
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        if (stackTraceElementArray.length >= 2) {
            properties.put("MessageSource", stackTraceElementArray[1].getClassName());
        }
        try {
            ServerEnv.getEventQueue().postEvent(TASK_TOPIC, 7, properties, 1);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        ServiceLogger.logDebug("Add task catalog, taskID=" + string + ", catalogName=" + string2, 6);
    }

    public void setTaskParameters(String string, Map map) {
        Properties properties = new Properties();
        properties.put(TASK_ID, string);
        properties.put(PARAMETER, map);
        properties.put(TOPIC_TYPE, String.valueOf(8));
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        if (stackTraceElementArray.length >= 2) {
            properties.put("MessageSource", stackTraceElementArray[1].getClassName());
        }
        try {
            ServerEnv.getEventQueue().postEvent(TASK_TOPIC, 8, properties, 1);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        ServiceLogger.logDebug("Set task parameters, taskID=" + string + ", parameters=" + map, 6);
    }

    @Override
    public void taskParametersChanged(String string, long l, int n, Map map) {
        Properties properties = new Properties();
        properties.put(TASK_ID, string);
        properties.put(CHANGE_TIME, String.valueOf(l));
        properties.put(RPT_PAGES, String.valueOf(n));
        properties.put(PARAMETER, map);
        properties.put(TOPIC_TYPE, String.valueOf(9));
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        if (stackTraceElementArray.length >= 2) {
            properties.put("MessageSource", stackTraceElementArray[1].getClassName());
        }
        try {
            ServerEnv.getEventQueue().postEvent(TASK_TOPIC, 9, properties, 1);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        ServiceLogger.logDebug("Task parameters changed, taskID=" + string + ", changeTime=" + l + ", reportPages=" + n + ", parameters=" + map, 6);
    }

    @Override
    public void refreshParametersStarted(String string, long l) {
        StackTraceElement[] stackTraceElementArray;
        Properties properties = new Properties();
        properties.put(TASK_ID, string);
        properties.put(START_TIME, String.valueOf(l));
        properties.put(TOPIC_TYPE, String.valueOf(10));
        Hashtable hashtable = (Hashtable)this.addTask.get(string);
        if (null != hashtable) {
            hashtable.put("TS_tsk_submit", System.currentTimeMillis());
            hashtable.put("TS_eng_start", System.currentTimeMillis());
        }
        if ((stackTraceElementArray = new Exception().getStackTrace()).length >= 2) {
            properties.put("MessageSource", stackTraceElementArray[1].getClassName());
        }
        try {
            ServerEnv.getEventQueue().postEvent(TASK_TOPIC, 10, properties, 1);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        ServiceLogger.logDebug("Refresh parameters started, taskID=" + string + ", startTime=" + l, 6);
    }

    @Override
    public void refreshParametersFinished(String string, long l) {
        StackTraceElement[] stackTraceElementArray;
        Properties properties = new Properties();
        properties.put(TASK_ID, string);
        properties.put(FINISH_TIME, String.valueOf(l));
        properties.put(TOPIC_TYPE, String.valueOf(11));
        Hashtable hashtable = (Hashtable)this.addTask.get(string);
        if (null != hashtable) {
            long l2 = System.currentTimeMillis();
            long l3 = (Long)hashtable.get("TS_eng_start") - (Long)hashtable.get("TS_tsk_submit");
            long l4 = l2 - (Long)hashtable.get("TS_eng_start");
            long l5 = l2 - (Long)hashtable.get("TS_tsk_submit");
            hashtable.put("TS_eng_exits", l2);
            hashtable.put("TS_tsk_complete", l2);
            hashtable.put("TC_tsk_waited", new Long(l3));
            hashtable.put("TC_eng_total", new Long(l4));
            hashtable.put("TC_tsk_total", new Long(l5));
            hashtable.put("VI_tsk_status", 1);
        }
        if ((stackTraceElementArray = new Exception().getStackTrace()).length >= 2) {
            properties.put("MessageSource", stackTraceElementArray[1].getClassName());
        }
        try {
            ServerEnv.getEventQueue().postEvent(TASK_TOPIC, 11, properties, 1);
            if (null != hashtable) {
                ServerEnv.getEventQueue().postEvent("TaskContext", 0, hashtable, 1);
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        ServiceLogger.logDebug("Refresh parameters finished, taskID=" + string + ", finishTime=" + l, 6);
    }

    @Override
    public void taskFinished(String string, long l, int n) {
        StackTraceElement[] stackTraceElementArray;
        Hashtable hashtable;
        Properties properties = new Properties();
        properties.put(TASK_ID, string);
        properties.put(TASK_STATUS, String.valueOf(9));
        properties.put(FINISH_TIME, String.valueOf(l));
        properties.put(RPT_PAGES, String.valueOf(n));
        properties.put(TOPIC_TYPE, String.valueOf(2));
        Properties properties2 = (Properties)this.SEDU.get(string);
        if (null != properties2) {
            properties2.put(RPT_PAGES, (Object)n);
            this.currentTimeMillis.updateTask(string, n);
            this.SEDU.remove(string);
        }
        if (null != (hashtable = (Hashtable)this.addTask.get(string))) {
            long l2 = (Long)hashtable.get("TS_eng_start") - (Long)hashtable.get("TS_tsk_submit");
            long l3 = l - (Long)hashtable.get("TS_eng_start");
            long l4 = l - (Long)hashtable.get("TS_tsk_submit");
            hashtable.put("TS_eng_exits", l);
            hashtable.put("TS_tsk_complete", l);
            hashtable.put("TC_tsk_waited", new Long(l2));
            hashtable.put("TC_eng_total", new Long(l3));
            hashtable.put("TC_tsk_total", new Long(l4));
            hashtable.put("VI_tsk_status", 1);
        }
        if ((stackTraceElementArray = new Exception().getStackTrace()).length >= 2) {
            properties.put("MessageSource", stackTraceElementArray[1].getClassName());
        }
        try {
            ServerEnv.getEventQueue().postEvent(TASK_TOPIC, 2, properties, 1);
            if (null != hashtable) {
                ServerEnv.getEventQueue().postEvent("TaskContext", 0, hashtable, 1);
                this.addTask.remove(string);
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        ServiceLogger.logDebug("Task finished, taskID=" + string + ", completeTime=" + l + ", reportPages=" + n, 6);
    }

    public void taskFinished(String string, long l, int n, String string2, String string3, String string4) {
        StackTraceElement[] stackTraceElementArray;
        Properties properties = new Properties();
        properties.put(TASK_ID, string);
        properties.put(TASK_STATUS, String.valueOf(9));
        properties.put(FINISH_TIME, String.valueOf(l));
        properties.put(RPT_PAGES, String.valueOf(n));
        properties.put(TOPIC_TYPE, String.valueOf(2));
        properties.put(RST_FILE_NAME, string3);
        properties.put(REASON, string2);
        properties.put(ENGINE_INFO, string4);
        Hashtable hashtable = (Hashtable)this.addTask.get(string);
        if (null != hashtable) {
            long l2 = System.currentTimeMillis();
            long l3 = (Long)hashtable.get("TS_eng_start") - (Long)hashtable.get("TS_tsk_submit");
            long l4 = l2 - (Long)hashtable.get("TS_eng_start");
            long l5 = l2 - (Long)hashtable.get("TS_tsk_submit");
            hashtable.put("TS_eng_exits", l2);
            hashtable.put("TS_tsk_complete", l2);
            hashtable.put("TC_tsk_waited", new Long(l3));
            hashtable.put("TC_eng_total", new Long(l4));
            hashtable.put("TC_tsk_total", new Long(l5));
            hashtable.put("VI_tsk_status", 1);
        }
        if ((stackTraceElementArray = new Exception().getStackTrace()).length >= 2) {
            properties.put("MessageSource", stackTraceElementArray[1].getClassName());
        }
        try {
            ServerEnv.getEventQueue().postEvent(TASK_TOPIC, 2, properties, 1);
            if (null != hashtable) {
                ServerEnv.getEventQueue().postEvent("TaskContext", 0, hashtable, 1);
                this.addTask.remove(string);
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        ServiceLogger.logDebug("Task finished, taskID=" + string + ", completeTime=" + l + ", reportPages=" + n + ", reason=" + string2 + ", resultFileName=" + string3 + ", engineInfo=" + string4, 6);
    }

    @Override
    public void taskFailed(String string, long l, String string2) {
        StackTraceElement[] stackTraceElementArray;
        Properties properties = new Properties();
        properties.put(TASK_ID, string);
        properties.put(TASK_STATUS, String.valueOf(10));
        properties.put(FINISH_TIME, String.valueOf(l));
        properties.put(REASON, string2);
        properties.put(TOPIC_TYPE, String.valueOf(3));
        Hashtable hashtable = (Hashtable)this.addTask.get(string);
        if (null != hashtable) {
            long l2 = System.currentTimeMillis();
            long l3 = (Long)hashtable.get("TS_eng_start") - (Long)hashtable.get("TS_tsk_submit");
            long l4 = l2 - (Long)hashtable.get("TS_eng_start");
            long l5 = l2 - (Long)hashtable.get("TS_tsk_submit");
            hashtable.put("TS_eng_exits", l2);
            hashtable.put("TS_tsk_complete", l2);
            hashtable.put("TC_tsk_waited", new Long(l3));
            hashtable.put("TC_eng_total", new Long(l4));
            hashtable.put("TC_tsk_total", new Long(l5));
            hashtable.put("VI_tsk_status", 0);
        }
        if ((stackTraceElementArray = new Exception().getStackTrace()).length >= 2) {
            properties.put("MessageSource", stackTraceElementArray[1].getClassName());
        }
        try {
            ServerEnv.getEventQueue().postEvent(TASK_TOPIC, 3, properties, 1);
            if (null != hashtable) {
                ServerEnv.getEventQueue().postEvent("TaskContext", 0, hashtable, 1);
                this.addTask.remove(string);
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        ServiceLogger.logDebug("Task failed, taskID=" + string + ", completeTime=" + l + ", failReason=" + string2, 6);
    }

    public List getAllAuditTasks() {
        List list = null;
        try {
            list = this.append.getAllAuditTasks();
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return list;
    }

    public List getAllAuditTasks(long l, long l2) {
        List list = null;
        try {
            list = this.append.getAllAuditTasks(l, l2);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return list;
    }

    public List getWaitingAuditTasks() {
        List list = null;
        try {
            list = this.append.getWaitingAuditTasks();
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return list;
    }

    public List getWaitingAuditTasks(long l, long l2) {
        List list = null;
        try {
            list = this.append.getWaitingAuditTasks(l, l2);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return list;
    }

    public List getRunningAuditTasks() {
        List list = null;
        try {
            list = this.append.getRunningAuditTasks();
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return list;
    }

    public List getRunningAuditTasks(long l, long l2) {
        List list = null;
        try {
            list = this.append.getRunningAuditTasks(l, l2);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return list;
    }

    public List getFinishedAuditTasks() {
        List list = null;
        try {
            list = this.append.getFinishedAuditTasks();
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return list;
    }

    public List getFinishedAuditTasks(long l, long l2) {
        List list = null;
        try {
            list = this.append.getFinishedAuditTasks(l, l2);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return list;
    }

    public List getFailedAuditTasks() {
        List list = null;
        try {
            list = this.append.getFailedAuditTasks();
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return list;
    }

    public List getFailedAuditTasks(long l, long l2) {
        List list = null;
        try {
            list = this.append.getFailedAuditTasks(l, l2);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return list;
    }

    public void postEventToQueue(int n, Properties properties) {
        int n2 = n == 0 || n == 1 ? 0 : 1;
        try {
            ServerEnv.getEventQueue().postEvent(TASK_TOPIC, n, properties, n2);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }
}

