/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.UserPreferenceManager;
import jet.server.api.cluster.ClusterException;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapFactory;
import jet.server.jrserver.JRUserPreferenceManagerBase;

public class JRUserDHTMLPreferenceManager
extends JRUserPreferenceManagerBase
implements UserPreferenceManager {
    private static final String DHTML_PREFERENCE_MANAGER = "dhtmlPreference";
    private static String SEDU = "dhtmlprefer.default.properties";

    JRUserDHTMLPreferenceManager(String string, String string2) throws Exception {
        super(string, string2, DHTML_PREFERENCE_MANAGER);
    }

    public void loadDefaultPref() {
        super.getDefaultUserPreference();
    }

    public void loadPreference(String string) {
        super.getUserPreference(string);
    }

    public void removePreferencesByValidUserNames(Enumeration enumeration) {
        super.unloadInvlaidUserPreferences(enumeration);
    }

    @Override
    protected ClusterMap getPrefClusterMap() throws ClusterException {
        return MapFactory.getMapForRealm(this.realmName, MapAttr.DHTML_PREFERENCE_MANAGER);
    }

    @Override
    protected boolean isFilterInvalidKeysOnSave() {
        return true;
    }

    @Override
    protected Properties getAppDefaultPref() {
        Properties properties = JRUserDHTMLPreferenceManager.getProperties(SEDU);
        ExProperties exProperties = ServerEnv.getInstallProps();
        if (exProperties != null && exProperties.size() > 0) {
            Properties properties2 = new Properties();
            properties2.putAll((Map<?, ?>)exProperties);
            properties2.keySet().retainAll(properties.keySet());
            properties.putAll((Map<?, ?>)properties2);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String string) {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(stackTraceElementArray[1].getClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        InputStream inputStream = clazz.getResourceAsStream(string);
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        return properties;
    }
}

