/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jet.server.ServerEnv;
import jet.server.api.UserPreferenceManager;
import jet.server.api.cluster.ClusterException;
import jet.server.api.http.HttpUtil;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.db.cfg.PropsTable;
import jet.server.jrc.JRDataService;
import jet.server.jrserver.JRRptServer;
import jet.server.log.ServiceLogger;

public abstract class JRUserPreferenceManagerBase
implements UserPreferenceManager {
    private final String add;
    protected final String realmName;
    private final String append;
    private final String close = ".properties";
    private String contains;
    private Properties delete;
    private PropsTable deleteProp;
    private ClusterMap doUpdateProp;

    protected JRUserPreferenceManagerBase(String string, String string2, String string3) throws Exception {
        this.add = new File(string, string2).getCanonicalPath();
        this.realmName = string2;
        this.append = string3;
        this.SEDU();
    }

    private void SEDU() throws Exception {
        this.contains = this.append;
        if (ServerEnv.isClusterEnabled()) {
            JRDataService jRDataService = (JRDataService)((JRRptServer)((Object)HttpUtil.getHttpRptServer())).getDataService();
            this.deleteProp = jRDataService.getPropsTable();
        }
        this.doUpdateProp = this.getPrefClusterMap();
        this.delete = this.getAppDefaultPref();
    }

    private boolean add(String string) {
        return string != null && string.length() == 0;
    }

    private String append(String string) {
        if (string == null || this.add(string)) {
            return this.contains;
        }
        return this.contains + "_" + string;
    }

    private File close(String string) {
        if (string == null || this.add(string)) {
            return new File(this.add, this.append + ".properties");
        }
        return new File(new File(this.add, string), this.append + ".properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties contains(String string) {
        Properties properties;
        String string2;
        block11: {
            string2 = this.append(string);
            properties = (Properties)this.doUpdateProp.get(string2);
            if (properties != null) {
                return properties;
            }
            ServiceLogger.logDebug(this.append + " load: " + string);
            try {
                if (ServerEnv.isClusterEnabled() && (properties = this.deleteProp.queryProp(string2)).size() > 0) {
                    this.doUpdateProp.put(string2, properties);
                    return properties;
                }
                properties = new Properties();
                File file = this.close(string);
                if (!file.exists()) break block11;
                FileInputStream fileInputStream = new FileInputStream(file);
                try {
                    properties.load(fileInputStream);
                }
                finally {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable, 3);
            }
        }
        properties = properties == null ? new Properties() : properties;
        this.doUpdateProp.put(string2, properties);
        return properties;
    }

    private void delete(String string, Properties properties) throws IOException {
        if (this.add(string)) {
            return;
        }
        ServiceLogger.logDebug(this.append + " save: " + string);
        Properties properties2 = this.getUserPreference(string);
        properties2.putAll((Map<?, ?>)properties);
        this.save(string, properties2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(String string, Properties properties) throws IOException {
        if (this.add(string)) {
            return;
        }
        this.doUpdateProp(this.delete, properties);
        String string2 = this.append(string);
        this.doUpdateProp.put(string2, properties);
        if (ServerEnv.isClusterEnabled()) {
            try {
                this.deleteProp.doUpdateProp(string2, properties, true);
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException);
            }
            return;
        }
        File file = this.close(string);
        file.getParentFile().mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            properties.store(fileOutputStream, null);
        }
        finally {
            try {
                ((OutputStream)fileOutputStream).close();
            }
            catch (Throwable throwable) {}
        }
    }

    private void deleteProp(String string) throws IOException {
        if (this.add(string)) {
            return;
        }
        ServiceLogger.logDebug(this.append + " delete: " + string);
        String string2 = this.append(string);
        this.doUpdateProp.remove(string2);
        if (ServerEnv.isClusterEnabled()) {
            try {
                this.deleteProp.deleteProp(string2);
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException);
            }
        }
        this.close(string).delete();
    }

    private void doUpdateProp(Properties properties, Properties properties2) {
        if (this.isFilterInvalidKeysOnSave()) {
            Iterator<Object> iterator = properties2.keySet().iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (properties.get(object) != null) continue;
                iterator.remove();
            }
        }
    }

    @Override
    public final Properties getUserPreference(String string) {
        Properties properties = this.getDefaultUserPreference();
        Properties properties2 = this.contains(string);
        Properties properties3 = new Properties(properties);
        if (properties2 != null) {
            properties3.putAll((Map<?, ?>)properties2);
        }
        return properties3;
    }

    @Override
    public final void saveUserPreference(String string, Properties properties) throws IOException {
        this.delete(string, properties);
    }

    @Override
    public final Properties getDefaultUserPreference() {
        Properties properties = this.delete;
        Properties properties2 = this.contains(null);
        Properties properties3 = new Properties(properties);
        if (properties2 != null) {
            properties3.putAll((Map<?, ?>)properties2);
        }
        return properties3;
    }

    @Override
    public final void saveDefaultUserPreference(Properties properties) throws IOException {
        this.delete(null, properties);
    }

    @Override
    public final boolean useDefaultUserPreference(String string) {
        try {
            this.deleteProp(string);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException, 3);
            return false;
        }
        return true;
    }

    public final boolean useDefaultUserPreference(String string, List list) {
        if (this.add(string) || list == null) {
            return false;
        }
        try {
            Properties properties = this.getUserPreference(string);
            if (properties.keySet().removeAll(list)) {
                ServiceLogger.logDebug(this.append + " useDefault: " + string + ", keys=" + list);
                if (list.contains("enable_setting_display_language")) {
                    properties.setProperty("is_forced_language", "true");
                }
                this.save(string, properties);
            }
            return true;
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException, 3);
            return false;
        }
    }

    public final void unloadInvlaidUserPreferences(Enumeration enumeration) {
        ServiceLogger.logDebug(this.append + " unloadInvlaidUserPreferences");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.append(null));
        while (enumeration.hasMoreElements()) {
            arrayList.add(this.append((String)enumeration.nextElement()));
        }
        this.doUpdateProp.retainAll(arrayList);
    }

    protected abstract ClusterMap getPrefClusterMap() throws ClusterException;

    protected abstract boolean isFilterInvalidKeysOnSave();

    protected abstract Properties getAppDefaultPref();

    @Override
    public Properties getUserPreference(String string, String string2) {
        Properties properties = new Properties();
        Properties properties2 = this.getUserPreference(string);
        Enumeration<Object> enumeration = properties2.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string3.startsWith(string2)) continue;
            properties.put(string3, properties2.get(string3));
        }
        return properties;
    }

    @Override
    public String get(String string, String string2) {
        return this.getUserPreference(string).getProperty(string2);
    }

    @Override
    public void set(String string, String string2, String string3) throws IOException {
        if (this.add(string)) {
            return;
        }
        ServiceLogger.logDebug(this.append + " save: " + string);
        Properties properties = this.getUserPreference(string);
        properties.put(string2, string3);
        this.save(string, properties);
    }
}

