/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.io.Serializable;
import java.util.Hashtable;
import jet.server.api.ExpiryListener;
import jet.server.api.InvalidUserSessionException;
import jet.server.api.UserSession;
import jet.server.cluster.ClusterEnv;
import jet.server.log.ServiceLogger;

public class JRUserSession
implements UserSession {
    public static final String HTTP_SESSTION = "jrs.httpSession";
    public static int TIMEOUT = 1800000;
    private static int SEDU = 0;
    private String append = null;
    private String arraycopy = null;
    private String currentTimeMillis = null;
    private transient Object expire = null;
    private long get;
    private long getClusterTime = this.get = ClusterEnv.getClusterTime();
    private boolean getMemberID = true;
    private int indexOf = TIMEOUT;
    private boolean isClusterEnabled = false;
    private boolean logError = false;
    private Hashtable put = new Hashtable(8);
    private int remove;
    private transient ExpiryListener[] toString;
    private static final long serialVersionUID = 7942626092916686036L;

    public JRUserSession() {
    }

    public JRUserSession(String string, String string2, boolean bl) {
        this.append = JRUserSession.SEDU();
        this.arraycopy = string;
        this.currentTimeMillis = string2;
        this.isClusterEnabled = bl;
        this.indexOf = TIMEOUT;
    }

    public JRUserSession(String string, String string2, boolean bl, String string3) {
        this(string, string2, bl);
        this.append = string3;
    }

    @Override
    public String getID() {
        return this.append;
    }

    @Override
    public String getRealm() {
        return this.arraycopy;
    }

    @Override
    public String getUserID() {
        return this.currentTimeMillis;
    }

    @Override
    public boolean isExternalAuthorized() {
        return this.isClusterEnabled;
    }

    @Override
    public Object getExternalObject() {
        return this.expire;
    }

    @Override
    public void setExternalObject(Object object) {
        this.expire = object;
    }

    @Override
    public Object getValue(String string) {
        return this.put.get(string);
    }

    @Override
    public void putValue(String string, Object object) {
        if (!(object instanceof Serializable)) {
            throw new IllegalArgumentException("the value must be Serializable");
        }
        this.put.put(string, object);
    }

    @Override
    public void removeValue(String string) {
        this.put.remove(string);
    }

    @Override
    public boolean isValid() {
        return this.getMemberID;
    }

    @Override
    public void invalidate() {
        this.getMemberID = false;
        int n = this.remove;
        while (--n >= 0) {
            try {
                this.toString[n].expire(this);
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable, 3);
            }
        }
    }

    @Override
    public long getCreationTime() {
        return this.get;
    }

    @Override
    public long getLastAccessTime() {
        return this.getClusterTime;
    }

    @Override
    public void refreshLastAccessTime() throws InvalidUserSessionException {
        if (!this.getMemberID) {
            throw new InvalidUserSessionException(630086, (Object[])new String[]{this.append, this.currentTimeMillis}, null);
        }
        this.getClusterTime = ClusterEnv.getClusterTime();
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.indexOf;
    }

    @Override
    public void setMaxInactiveInterval(int n) {
        this.indexOf = n;
    }

    private static synchronized String SEDU() {
        int n = 0;
        if (ClusterEnv.isClusterEnabled()) {
            n = ClusterEnv.getMemberID();
        }
        long l = System.currentTimeMillis();
        long l2 = n;
        l2 <<= 56;
        l2 += l << 14;
        return String.valueOf(l2 += (long)(++SEDU));
    }

    @Override
    public void addExpiryListener(ExpiryListener expiryListener) {
        ServiceLogger.logError(new Exception("Deprecated method, please invoke UserSessionManager.addSessionExpiryListener()"), 3);
        if (this.indexOf(expiryListener) == -1) {
            if (this.toString == null) {
                this.toString = new ExpiryListener[1];
            }
            if (this.remove == this.toString.length) {
                ExpiryListener[] expiryListenerArray = new ExpiryListener[this.remove + this.remove];
                System.arraycopy(this.toString, 0, expiryListenerArray, 0, this.remove);
                this.toString = expiryListenerArray;
            }
            if (this.toString.length > 0) {
                this.toString[this.remove++] = expiryListener;
            }
        }
    }

    @Override
    public void removeExpiryListener(ExpiryListener expiryListener) {
        int n = this.indexOf(expiryListener);
        if (n != -1) {
            if (n < this.remove - 1) {
                System.arraycopy(this.toString, n + 1, this.toString, n, this.remove - n - 1);
            }
            --this.remove;
            if (this.remove <= this.toString.length / 2) {
                ExpiryListener[] expiryListenerArray = new ExpiryListener[this.toString.length / 2];
                System.arraycopy(this.toString, 0, expiryListenerArray, 0, this.remove);
                this.toString = expiryListenerArray;
            }
        }
    }

    @Override
    public int getExpiryListenerCount() {
        return this.remove;
    }

    @Override
    public ExpiryListener getExpiryListener(int n) {
        return n < 0 || n >= this.remove ? null : this.toString[n];
    }

    @Override
    public int indexOf(ExpiryListener expiryListener) {
        if (this.toString != null) {
            int n = this.toString.length;
            while (--n >= 0) {
                if (this.toString[n] != expiryListener) continue;
                return n;
            }
        }
        return -1;
    }

    @Override
    public boolean isTimeOut() {
        long l = ClusterEnv.getClusterTime() - this.getClusterTime;
        return l > (long)this.indexOf;
    }

    public String toString() {
        return super.toString() + "[id=" + this.append + ", realm=" + this.arraycopy + ", userID=" + this.currentTimeMillis + ", extObj=" + this.expire + ", creationTime=" + this.get + ", lastAccessedTime=" + this.getClusterTime + ", isValid=" + this.getMemberID + ", maxInactiveInterval=" + this.indexOf + ", isExternalAuthorized=" + this.isClusterEnabled + "]";
    }
}

