/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jet.ReportEnv;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.Authenticator;
import jet.server.api.ExpiryListener;
import jet.server.api.InvalidUserSessionException;
import jet.server.api.TooManyUsersException;
import jet.server.api.UserSession;
import jet.server.api.UserSessionManager;
import jet.server.api.admin.cfg.ConfigService;
import jet.server.api.cluster.ClusterException;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapFactory;
import jet.server.cluster.blocks.MapFlags;
import jet.server.cluster.blocks.MapListenerAdapter;
import jet.server.jrc.security.SecurityServiceImpl;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrserver.JRUserDHTMLPreferenceManager;
import jet.server.jrserver.JRUserPreferenceManager;
import jet.server.jrserver.JRUserSession;
import jet.server.jrserver.LoginQueue;
import jet.server.jrserver.OndemandListClearer;
import jet.server.log.ServiceLogger;

public class JRUserSessionManager
implements UserSessionManager {
    protected static final String TAG_EXTRASESSION = "jrs.extraSession";
    protected static final String TAG_KICKOUT = "jrs.kickOutOldSsn";
    protected static final String TAG_REQ = "jrs.extraReq";
    protected static final String TAG_RES = "jrs.extraRes";
    private int SEDU = 5;
    protected HashMap sessionMap = new HashMap();
    protected Hashtable htSessions = new Hashtable();
    private ClusterMap TIMEOUT;
    private Hashtable USER_SESSIONS = new Hashtable();
    private Authenticator add = null;
    private JRUserPreferenceManager addElement = null;
    private JRUserDHTMLPreferenceManager addItem = null;
    private ConfigService addListener = null;
    private long append = -1L;
    private long close = -1L;
    private int compareTo = -1;
    private StringBuffer contains = new StringBuffer();
    protected OndemandListClearer ondemandlistclearer = null;
    private Thread containsKey = null;
    private List createNewFile = new ArrayList();
    private static Hashtable currentTimeMillis = new Hashtable();
    private static Properties delete = new Properties();
    String loginFileName = ServerEnv.homePath + "bin" + File.separator + "login.properties";
    String logoutFileName = ServerEnv.homePath + "bin" + File.separator + "logout.properties";

    public JRUserSessionManager(Authenticator authenticator) {
        this.SEDU();
        this.setAuthenticator(authenticator);
        this.SEDU = ReportEnv.getUsers();
        int n = ServerEnv.getSessionTimeout();
        if (n < 0) {
            n = 0;
        } else if ((n *= 1000) < 0) {
            n = Integer.MAX_VALUE;
        }
        this.setDefaultMaxInactiveInterval(n);
        ServiceLogger.logEvent(4630035, String.valueOf(this.SEDU), 4);
        this.startOndemandListClearer();
        this.elements();
        this.equals();
    }

    private void SEDU() {
        try {
            this.TIMEOUT = MapFactory.getMap(MapAttr.USER_SESSIONS);
        }
        catch (ClusterException clusterException) {
            throw new RuntimeException((Throwable)((Object)clusterException));
        }
        this.TIMEOUT.addListener(new MapListenerAdapter(){

            public void afterPut(String string, int n, String string2, UserSession userSession, UserSession userSession2, MapFlags mapFlags) {
            }

            public void afterRemove(String string, int n, String string2, UserSession userSession, MapFlags mapFlags) {
                if (!1.isLocalEvent(n) && userSession != null) {
                    JRUserSessionManager.this.TIMEOUT(userSession);
                }
            }
        });
    }

    private void TIMEOUT(UserSession userSession) {
        userSession.invalidate();
        for (ExpiryListener expiryListener : this.createNewFile) {
            try {
                ServiceLogger.logDebug(6630095, new Object[]{userSession.getID(), expiryListener}, 6);
                expiryListener.expire(userSession);
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable, 3);
            }
        }
    }

    private void USER_SESSIONS(UserSession userSession) {
        this.TIMEOUT(userSession);
        this.TIMEOUT.remove(userSession.getID());
    }

    @Override
    public void setAuthenticator(Authenticator authenticator) {
        this.add = authenticator;
    }

    public void bindingUserPreferenceManager(JRUserPreferenceManager jRUserPreferenceManager) {
        this.addElement = jRUserPreferenceManager;
        this.append = System.currentTimeMillis();
        this.compareTo = 0;
    }

    public void bindingUserDHTMLPreferenceManager(JRUserDHTMLPreferenceManager jRUserDHTMLPreferenceManager) {
        this.addItem = jRUserDHTMLPreferenceManager;
        this.close = System.currentTimeMillis();
        this.compareTo = 0;
    }

    public void setConfigService(ConfigService configService) {
        this.addListener = configService;
    }

    @Override
    public Authenticator getAuthenticator() {
        return this.add;
    }

    @Override
    public void setDefaultMaxInactiveInterval(int n) {
        JRUserSession.TIMEOUT = n;
    }

    @Override
    public int getDefaultMaxInactiveInterval() {
        return JRUserSession.TIMEOUT;
    }

    @Override
    public UserSession login(String string, String string2, String string3, Object object) throws TooManyUsersException {
        return this.login(string, string2, string3, object, false, false);
    }

    @Override
    public UserSession loginExternalAuthorized(String string, String string2, Object object) throws TooManyUsersException {
        return this.login(string, string2, null, object, true, false);
    }

    @Override
    public boolean isWait(String string) {
        return false;
    }

    @Override
    public void putSessions(UserSession userSession) {
    }

    private void add(UserSession userSession) {
        this.htSessions.remove(userSession.getID());
        String[] stringArray = CSUtil.parsePrincipalDisplayName(userSession.getUserID());
        Hashtable hashtable = (Hashtable)this.sessionMap.get(stringArray[0]);
        hashtable.remove(userSession.getID());
    }

    @Override
    public void logout(UserSession userSession) {
        if (ServiceLogger.isLoggable(3, 5)) {
            ServiceLogger.logEvent(5630036, new Object[]{userSession, this.toString()}, 5);
        }
        if (userSession != null) {
            Object v = this.USER_SESSIONS.remove(userSession.getID());
            HttpSession httpSession = v instanceof HttpSession ? (HttpSession)v : null;
            this.add(userSession);
            this.USER_SESSIONS(userSession);
            String string = userSession.getUserID();
            SecurityServiceImpl.removeKey(string + "$password");
            SecurityServiceImpl.removeKey(string);
            String string2 = userSession.getRealm();
            boolean bl = false;
            try {
                bl = UserDataToolkit.securityAdapter.isAdminUser(string2, string);
            }
            catch (RemoteException remoteException) {
                ServiceLogger.logError(remoteException, 3);
            }
            if (bl && this.isExtraSession(httpSession)) {
                httpSession.removeValue(TAG_EXTRASESSION);
            }
        }
        if (ServiceLogger.isLoggable(3, 5)) {
            ServiceLogger.logEvent(0x55E855, new Object[]{userSession, this.toString()}, 5);
        }
        if (this.addElement != null && (System.currentTimeMillis() - this.append > 1800000L || this.compareTo++ > 50)) {
            this.addElement.removePreferencesByValidUserNames(this.addElement());
            this.append = System.currentTimeMillis();
            this.compareTo = 0;
        }
        if (this.addItem != null && (System.currentTimeMillis() - this.close > 1800000L || this.compareTo++ > 50)) {
            this.addItem.removePreferencesByValidUserNames(this.addElement());
            this.close = System.currentTimeMillis();
            this.compareTo = 0;
        }
        if (userSession != null) {
            this.createNewFile(userSession.getUserID(), System.currentTimeMillis());
        }
    }

    private Enumeration addElement() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.htSessions.elements();
        while (enumeration.hasMoreElements()) {
            String string = ((JRUserSession)enumeration.nextElement()).getUserID();
            if (vector.contains(string)) continue;
            vector.addElement(string);
        }
        return vector.elements();
    }

    @Override
    public UserSession getUserSession(String string) {
        if (string != null) {
            UserSession userSession = (UserSession)this.htSessions.get(string);
            if (userSession != null) {
                return userSession;
            }
            return (UserSession)this.TIMEOUT.get(string);
        }
        return null;
    }

    @Override
    public Enumeration getAllUserSessions() {
        return this.htSessions.elements();
    }

    @Override
    public Enumeration getAllWaitUserSessions() {
        return new Vector().elements();
    }

    @Override
    public void refreshLastAccessTime(String string) throws InvalidUserSessionException {
        UserSession userSession = null;
        if (string != null && (userSession = (UserSession)this.htSessions.get(string)) != null) {
            userSession.refreshLastAccessTime();
        }
    }

    public UserSession login(String string, String string2, String string3, Object object, boolean bl) throws TooManyUsersException {
        return this.login(string, string2, string3, object, bl, false);
    }

    public UserSession login(String string, String string2, String string3, Object object, boolean bl, boolean bl2) throws TooManyUsersException {
        return this.login(string, string2, string3, object, bl, bl2, false);
    }

    public UserSession login(String string, String string2, String string3, Object object, boolean bl, boolean bl2, boolean bl3) throws TooManyUsersException {
        if (ServiceLogger.isLoggable(3, 5)) {
            ServiceLogger.logEvent(5630038, new Object[]{string, string2, object, String.valueOf(bl), this.toString()}, 5);
        }
        UserSession userSession = null;
        if (bl || this.add.isValidUser(string, string2, string3)) {
            userSession = this.addListener(string, string2, string3, object, bl, bl2, bl3);
        } else if (!this.needSecurity()) {
            userSession = this.addItem(string, "", "", null, false, false);
        }
        this.containsKey(string2, System.currentTimeMillis());
        if (this.addElement != null) {
            this.addElement.loadPreference(string2);
        }
        if (this.addItem != null) {
            this.addItem.loadPreference(string2);
        }
        if (ServiceLogger.isLoggable(3, 5)) {
            ServiceLogger.logEvent(5630039, new Object[]{string, string2, object, String.valueOf(bl), this.toString()}, 5);
        }
        this.ondemandlistclearer.removeClearTime(string2);
        return userSession;
    }

    private UserSession addItem(String string, String string2, String string3, Object object, boolean bl, boolean bl2) throws TooManyUsersException {
        return this.addListener(string, string2, string3, object, bl, bl2, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private UserSession addListener(String string, String string2, String string3, Object object, boolean bl, boolean bl2, boolean bl3) throws TooManyUsersException {
        JRUserSession jRUserSession = null;
        String[] stringArray = CSUtil.parsePrincipalDisplayName(string2);
        Hashtable<String, JRUserSession> hashtable = (Hashtable<String, JRUserSession>)this.sessionMap.get(stringArray[0]);
        if (hashtable == null) {
            hashtable = new Hashtable<String, JRUserSession>();
            this.sessionMap.put(stringArray[0], hashtable);
        }
        int n = this.SEDU;
        if (stringArray[0] != null) {
            n = this.addListener.getOrgConfiguration(stringArray[0]).getMaxConcurrentUsers();
        }
        if (ServerEnv.isEnableMultipleLogin()) {
            if (!(this.htSessions.size() >= this.SEDU && this.SEDU > 0 || hashtable.size() >= n && n > 0)) {
                jRUserSession = new JRUserSession(string, string2, bl);
                if (string2 != null) {
                    this.htSessions.put(jRUserSession.getID(), jRUserSession);
                    hashtable.put(jRUserSession.getID(), jRUserSession);
                    this.TIMEOUT.put(jRUserSession.getID(), jRUserSession);
                }
                if (object == null) return jRUserSession;
                this.USER_SESSIONS.put(jRUserSession.getID(), object);
                return jRUserSession;
            }
            if (!bl3 && this.add.isValidAdminUser(string, string2, string3) && object instanceof HttpSession) {
                UserSession userSession = this.compareTo();
                if (userSession != null) {
                    Object object2 = this.getExtObj(userSession.getID());
                    HttpSession httpSession = object2 instanceof HttpSession ? (HttpSession)object2 : null;
                    this.contains.setLength(0);
                    this.contains.append("Session force terminating (").append(" user:").append(userSession.getRealm()).append("/").append(userSession.getUserID()).append(",").append(" userSessionID:").append(userSession.getID()).append(",").append(" httpSessionID:").append(httpSession == null ? "" : httpSession.getId()).append(",").append(" isExtraSession:true )");
                    ServiceLogger.logEvent(this.contains.toString(), 6);
                    if (!this.append((HttpSession)object)) {
                        return jRUserSession;
                    }
                    this.logout(userSession);
                    if (httpSession != null && ServerEnv.invalidateHttpSessionWhenLogout()) {
                        httpSession.invalidate();
                    }
                }
                jRUserSession = new JRUserSession(string, string2, bl);
                this.htSessions.put(jRUserSession.getID(), jRUserSession);
                hashtable.put(jRUserSession.getID(), jRUserSession);
                ((HttpSession)object).putValue(TAG_EXTRASESSION, (Object)"true");
                this.USER_SESSIONS.put(jRUserSession.getID(), object);
                this.close((HttpSession)object);
                this.contains.setLength(0);
                this.contains.append("Created extra Session (").append(" user:").append(jRUserSession.getRealm()).append("/").append(jRUserSession.getUserID()).append(",").append(" userSessionID:").append(jRUserSession.getID()).append(",").append(" httpSessionID:").append(((HttpSession)object).getId()).append(",").append(" isExtraSession:true )");
                ServiceLogger.logEvent(this.contains.toString(), 6);
                return jRUserSession;
            }
            ServiceLogger.logError(3630040, 3);
            System.out.println("You have reach the maximum users limit of your license. Please contact our sales to purchase license for more users.");
            throw new TooManyUsersException(630087);
        }
        UserSession userSession = this.contains(string2);
        if (userSession != null) {
            HttpSession httpSession;
            Object object3 = this.getExtObj(userSession.getID());
            HttpSession httpSession2 = httpSession = object3 instanceof HttpSession ? (HttpSession)object3 : null;
            if (httpSession != null) {
                httpSession.putValue("isUserSessionValid", (Object)"false");
            }
            this.contains.delete(0, this.contains.length());
            this.contains.append("Session force terminating (").append(" user:").append(userSession.getRealm()).append("/").append(userSession.getUserID()).append(",").append(" userSessionID:").append(userSession.getID()).append(",").append(" httpSessionID:").append(httpSession == null ? "" : httpSession.getId()).append(" )");
            ServiceLogger.logEvent(this.contains.substring(0));
            this.logout(userSession);
        }
        if (!(this.htSessions.size() >= this.SEDU && this.SEDU > 0 || hashtable.size() >= n && n > 0)) {
            jRUserSession = new JRUserSession(string, string2, bl);
            this.htSessions.put(jRUserSession.getID(), jRUserSession);
            hashtable.put(jRUserSession.getID(), jRUserSession);
            if (object == null) return jRUserSession;
            this.USER_SESSIONS.put(jRUserSession.getID(), object);
            return jRUserSession;
        }
        ServiceLogger.logError(3630040, 3);
        System.out.println("You have reach the maximum users limit of your license. Please contact our sales to purchase license for more users.");
        throw new TooManyUsersException(630087);
    }

    protected boolean isExtraSession(HttpSession httpSession) {
        if (httpSession != null) {
            try {
                String string = (String)httpSession.getValue(TAG_EXTRASESSION);
                if (string != null && string.equals("true")) {
                    return true;
                }
            }
            catch (IllegalStateException illegalStateException) {
                ServiceLogger.logError(illegalStateException, 3);
            }
        }
        return false;
    }

    private boolean append(HttpSession httpSession) throws TooManyUsersException {
        HttpServletRequest httpServletRequest;
        if (httpSession != null && (httpServletRequest = (HttpServletRequest)httpSession.getValue(TAG_REQ)) != null) {
            String string = httpServletRequest.getParameter(TAG_KICKOUT);
            if (string == null) {
                httpServletRequest.setAttribute("statusCode", (Object)302);
            } else {
                if ("Yes".equals(string)) {
                    return true;
                }
                httpServletRequest.setAttribute("statusCode", (Object)303);
            }
            httpSession.putValue(TAG_KICKOUT, (Object)"Yes");
            return false;
        }
        return false;
    }

    private void close(HttpSession httpSession) {
        HttpServletRequest httpServletRequest;
        if (httpSession != null && (httpServletRequest = (HttpServletRequest)httpSession.getValue(TAG_REQ)) != null) {
            httpServletRequest.setAttribute("statusCode", (Object)201);
        }
    }

    private UserSession compareTo() {
        UserSession userSession = null;
        Enumeration enumeration = this.htSessions.elements();
        while (enumeration.hasMoreElements()) {
            userSession = (UserSession)enumeration.nextElement();
            Object object = this.getExtObj(userSession.getID());
            if (!this.isExtraSession(object instanceof HttpSession ? (HttpSession)object : null)) continue;
            return userSession;
        }
        return null;
    }

    public Object getExtObj(String string) {
        Object var2_2 = null;
        if (string != null) {
            var2_2 = this.USER_SESSIONS.get(string);
        }
        return var2_2;
    }

    public String toString() {
        return super.toString() + "[maxSessions=" + this.SEDU + ", authenticator=" + this.add + ", Sessions number=" + this.htSessions.size() + "]";
    }

    private UserSession contains(String string) {
        UserSession userSession = null;
        Enumeration enumeration = this.htSessions.elements();
        while (enumeration.hasMoreElements()) {
            userSession = (UserSession)enumeration.nextElement();
            if (!userSession.getUserID().equals(string)) continue;
            return userSession;
        }
        return null;
    }

    @Override
    public boolean needSecurity() {
        return ServerEnv.needSecurity();
    }

    public int getUserSessionNumberByOrg(String string) {
        Hashtable hashtable = (Hashtable)this.sessionMap.get(string);
        if (hashtable != null) {
            return hashtable.size();
        }
        return 0;
    }

    public Vector getUserSessions(String string) {
        if (string == null) {
            return new Vector();
        }
        Vector<UserSession> vector = new Vector<UserSession>();
        Enumeration enumeration = this.htSessions.elements();
        String string2 = "";
        while (enumeration.hasMoreElements()) {
            UserSession userSession = (UserSession)enumeration.nextElement();
            string2 = userSession.getUserID();
            if (string2 == null || string2.compareTo(string) != 0) continue;
            vector.add(userSession);
        }
        return vector;
    }

    protected void startOndemandListClearer() {
        this.ondemandlistclearer = new OndemandListClearer();
        long l = ServerEnv.getOndemandLaggingTime() * 1000L;
        if (l > 60000L) {
            l /= 2L;
        }
        this.ondemandlistclearer.setInterval(l);
        this.containsKey = new Thread(this.ondemandlistclearer);
        this.containsKey.start();
    }

    protected void setUserOndemandClearTime(String string) {
        if (string == null) {
            return;
        }
        Vector vector = this.getUserSessions(string);
        if (vector.size() == 0) {
            long l = System.currentTimeMillis();
            long l2 = ServerEnv.getOndemandLaggingTime() * 1000L;
            long l3 = l + l2;
            this.ondemandlistclearer.setClearTime(string, l3);
        }
    }

    public void quit() {
        this.ondemandlistclearer.stop();
        this.ondemandlistclearer = null;
        try {
            this.containsKey.interrupt();
        }
        catch (SecurityException securityException) {
            ServiceLogger.logError(securityException);
        }
        this.currentTimeMillis();
        this.delete();
    }

    private void containsKey(String string, long l) {
        if (!currentTimeMillis.containsKey(string)) {
            LoginQueue loginQueue = new LoginQueue();
            loginQueue.addItem(l);
            currentTimeMillis.put(string, loginQueue);
        } else {
            LoginQueue loginQueue = (LoginQueue)currentTimeMillis.get(string);
            loginQueue.addItem(l);
        }
    }

    private void createNewFile(String string, long l) {
        delete.put(string, Long.toString(l));
    }

    @Override
    public long getLastLoginTime(String string) {
        if (!currentTimeMillis.containsKey(string)) {
            return 0L;
        }
        LoginQueue loginQueue = (LoginQueue)currentTimeMillis.get(string);
        return loginQueue.getLastItem();
    }

    @Override
    public long getLastLogoutTime(String string) {
        if (!delete.containsKey(string)) {
            return 0L;
        }
        long l = 0L;
        try {
            l = Long.parseLong((String)delete.get(string));
        }
        catch (NumberFormatException numberFormatException) {
            ServiceLogger.logError(numberFormatException, 3);
        }
        return l;
    }

    private void currentTimeMillis() {
        Object object;
        Properties properties = new Properties();
        Object object2 = currentTimeMillis.keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            LoginQueue loginQueue = (LoginQueue)currentTimeMillis.get(object);
            properties.setProperty((String)object, Long.toString(loginQueue.getCurItem()));
        }
        object2 = null;
        try {
            object = new File(this.loginFileName);
            if (((File)object).exists()) {
                ((File)object).createNewFile();
            }
            object2 = new FileOutputStream(this.loginFileName);
            properties.store((OutputStream)object2, null);
            ((FileOutputStream)object2).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void delete() {
        try {
            File file = new File(this.loginFileName);
            if (file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.logoutFileName);
            delete.store(fileOutputStream, null);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void elements() {
        File file = new File(this.loginFileName);
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    try {
                        this.containsKey(string, Long.parseLong(properties.getProperty(string)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        ServiceLogger.logError(numberFormatException, 3);
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                ServiceLogger.logError(fileNotFoundException, 3);
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException, 3);
            }
        }
    }

    private void equals() {
        File file = new File(this.logoutFileName);
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(this.logoutFileName);
                delete.load(fileInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                ServiceLogger.logError(fileNotFoundException, 3);
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException, 3);
            }
        }
    }

    @Override
    public boolean addSessionExpiryListener(ExpiryListener expiryListener) {
        ServiceLogger.logDebug(4630093, expiryListener, 4);
        if (expiryListener != null && !this.createNewFile.contains(expiryListener)) {
            return this.createNewFile.add(expiryListener);
        }
        return false;
    }

    @Override
    public boolean removeSessionExpiryListener(ExpiryListener expiryListener) {
        ServiceLogger.logDebug(4630094, expiryListener, 4);
        return this.createNewFile.remove(expiryListener);
    }

    @Override
    public void updateUserSession(UserSession userSession) throws InvalidUserSessionException {
        UserSession userSession2 = (UserSession)this.htSessions.get(userSession.getID());
        if (userSession2 != null) {
            this.htSessions.put(userSession.getID(), userSession);
            String[] stringArray = CSUtil.parsePrincipalDisplayName(userSession.getUserID());
            Hashtable hashtable = (Hashtable)this.sessionMap.get(stringArray[0]);
            hashtable.put(userSession.getID(), userSession);
            this.TIMEOUT.put(userSession.getID(), userSession);
            return;
        }
        userSession2 = (UserSession)this.TIMEOUT.get(userSession.getID());
        if (userSession2 != null) {
            this.TIMEOUT.put(userSession.getID(), userSession);
            return;
        }
        throw new InvalidUserSessionException("The UserSession is not exist");
    }
}

