/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import jet.server.ServerEnv;
import jet.server.api.RptServer;
import jet.server.api.RptServerException;
import jet.server.api.VersionAmountLimitTable;
import jet.server.db.VersionAmountRecordContainer;
import jet.server.db.VersionLimitTable;
import jet.server.log.ServiceLogger;

public class JRVersionAmountLimitTable
implements VersionAmountLimitTable {
    private VersionAmountRecordContainer SEDU = null;
    private RptServer commit = null;
    private VersionLimitTable dealAdminServerCrash = null;

    public JRVersionAmountLimitTable(VersionLimitTable versionLimitTable, RptServer rptServer) {
        this.dealAdminServerCrash = versionLimitTable;
        this.commit = rptServer;
    }

    public JRVersionAmountLimitTable(VersionAmountRecordContainer versionAmountRecordContainer, RptServer rptServer) {
        this.SEDU = versionAmountRecordContainer;
        this.commit = rptServer;
    }

    @Override
    public synchronized int getVersionAmount(String string, String string2, String string3) throws RptServerException {
        if (this.SEDU != null) {
            try {
                return this.SEDU.getMaxAmount(string, string2);
            }
            catch (ConnectException connectException) {
                ServiceLogger.logError(connectException);
                ServerEnv.dealAdminServerCrash();
                return 0;
            }
            catch (ConnectIOException connectIOException) {
                ServiceLogger.logError(connectIOException);
                ServerEnv.dealAdminServerCrash();
                return 0;
            }
            catch (RemoteException remoteException) {
                ServiceLogger.logError(remoteException);
                throw new RptServerException(remoteException);
            }
        }
        try {
            return this.dealAdminServerCrash.getMaxAmount(string, string2, string3);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
            return 0;
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
            return 0;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new RptServerException(remoteException);
        }
    }

    @Override
    public synchronized void setVersionAmount(String string, String string2, String string3, int n) throws RptServerException {
        if (this.SEDU != null) {
            try {
                this.SEDU.setMaxAmount(string, string2, string3, n);
            }
            catch (ConnectException connectException) {
                ServiceLogger.logError(connectException);
                ServerEnv.dealAdminServerCrash();
            }
            catch (ConnectIOException connectIOException) {
                ServiceLogger.logError(connectIOException);
                ServerEnv.dealAdminServerCrash();
            }
            catch (RemoteException remoteException) {
                ServiceLogger.logError(remoteException);
                throw new RptServerException(remoteException);
            }
        } else {
            try {
                this.dealAdminServerCrash.setMaxAmount(string, string2, string3, n);
            }
            catch (ConnectException connectException) {
                ServiceLogger.logError(connectException);
                ServerEnv.dealAdminServerCrash();
            }
            catch (ConnectIOException connectIOException) {
                ServiceLogger.logError(connectIOException);
                ServerEnv.dealAdminServerCrash();
            }
            catch (RemoteException remoteException) {
                ServiceLogger.logError(remoteException);
                throw new RptServerException(remoteException);
            }
        }
    }

    @Override
    public synchronized void disableVersionAmount(String string, String string2, String string3) throws RptServerException {
        if (this.SEDU != null) {
            try {
                this.SEDU.disableAmount(string, string2, string3);
            }
            catch (ConnectException connectException) {
                ServiceLogger.logError(connectException);
                ServerEnv.dealAdminServerCrash();
            }
            catch (ConnectIOException connectIOException) {
                ServiceLogger.logError(connectIOException);
                ServerEnv.dealAdminServerCrash();
            }
            catch (RemoteException remoteException) {
                ServiceLogger.logError(remoteException);
                throw new RptServerException(remoteException);
            }
        } else {
            try {
                this.dealAdminServerCrash.delRecord(string, string2, string3);
            }
            catch (ConnectException connectException) {
                ServiceLogger.logError(connectException);
                ServerEnv.dealAdminServerCrash();
            }
            catch (ConnectIOException connectIOException) {
                ServiceLogger.logError(connectIOException);
                ServerEnv.dealAdminServerCrash();
            }
            catch (RemoteException remoteException) {
                ServiceLogger.logError(remoteException);
                throw new RptServerException(remoteException);
            }
        }
    }

    @Override
    public synchronized void commit() throws RptServerException {
        if (this.SEDU != null) {
            try {
                this.SEDU.commit();
            }
            catch (ConnectException connectException) {
                ServiceLogger.logError(connectException);
                ServerEnv.dealAdminServerCrash();
            }
            catch (ConnectIOException connectIOException) {
                ServiceLogger.logError(connectIOException);
                ServerEnv.dealAdminServerCrash();
            }
            catch (RemoteException remoteException) {
                ServiceLogger.logError(remoteException);
                throw new RptServerException(remoteException);
            }
        } else {
            try {
                this.dealAdminServerCrash.commit();
            }
            catch (ConnectException connectException) {
                ServiceLogger.logError(connectException);
                ServerEnv.dealAdminServerCrash();
            }
            catch (ConnectIOException connectIOException) {
                ServiceLogger.logError(connectIOException);
                ServerEnv.dealAdminServerCrash();
            }
            catch (RemoteException remoteException) {
                ServiceLogger.logError(remoteException);
                throw new RptServerException(remoteException);
            }
        }
    }
}

