/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import jet.ReportEnv;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.WebPageOptions;
import jet.server.api.admin.cfg.ConfigService;
import jet.server.api.admin.cfg.ConfigurationAdvanced;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.log.ServiceLogger;

public class JRWebPageOptions
implements WebPageOptions,
Serializable {
    private static Hashtable IsMultiLanguage = new Hashtable(2);
    private boolean hasDbOption = true;
    private boolean hasEncoding = true;
    private boolean isShowNameWithPostfix = true;
    private boolean usePermissionDialog = false;
    private boolean hasStyleGroupOption = true;
    private boolean hasConvertEncOption = true;
    private boolean hasTaskListener = true;
    private boolean getToApplet = true;
    private boolean getToHtml = true;
    private boolean getToPdf = true;
    private boolean getToText = true;
    private boolean getToExcel = true;
    private boolean getToPs = true;
    private boolean getToRtf = true;
    private boolean getToXML = true;
    private boolean getToDHTML = true;
    private boolean getToWST = true;
    private boolean needSecurity = true;
    private boolean isShowVersionParamContents = true;
    private boolean isPublishTempToVersion = false;
    private boolean isPipeline = true;
    private long reportWaitTimeouts = 500L;
    private String sendfileJSPWebApp = "";
    private String monitorServerWebURL = "";
    private String adhocReportJSPWebApp = "";
    private String dhtmlWebServletPath = "";
    private String dhtmlWebJspPath = "";
    private String helpWebServletPath = "";
    private String adhocServletPath = "";
    private String adhocJSPPath = "";
    private String jrservletPath = "";
    private boolean adhoc = false;
    private int scheme = 0;
    private String engineDefEncoding = "";
    private boolean useRelativeAppUrl = true;
    private boolean isEnableDynamicResource = false;
    private boolean showCatalogNode = false;
    private String webSiteUrl = "";
    private String helpUrl = "";
    private String tutorialUrl = "";
    private String skinDir = "";
    private String rootDirOfFolderSelector = "";
    private String delimiter = "";
    private boolean enableMonitorLink = true;
    private static ArrayList SEDU;
    private int autoRecoverTaskMaxTimes;
    private long autoRecoverTaskInterval;
    private boolean autoRecoverTaskRedoAll;
    private boolean isEnableTaskDuration = false;
    private boolean isAdhoc = false;
    private boolean isLive = false;
    private boolean enableJDashboard = false;
    private boolean enableVA = false;
    private boolean enableMultipleOrganization = false;
    private boolean enableMultipleLanguage = false;
    private int ondemandTaskInitPriority;
    private int scheduleTaskInitPriority;
    private boolean isMarkUnviewdResult = false;
    private boolean enablePLS = true;
    private Properties helpDocProp = null;
    private ExProperties props = new ExProperties();
    private String servPropName = ServerEnv.getServPropName();
    private boolean isCheckCSRF = true;

    public JRWebPageOptions() {
        this.IsMultiLanguage();
        try {
            this.props.load(this.servPropName);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    private void IsMultiLanguage() {
        this.hasDbOption = ServerEnv.hasDbOption();
        this.hasEncoding = ServerEnv.hasEncoding();
        this.isShowNameWithPostfix = ServerEnv.isShowNameWithPostfix();
        this.usePermissionDialog = ServerEnv.usePermissionDialog();
        this.hasStyleGroupOption = ServerEnv.hasStyleGroupOption();
        this.hasConvertEncOption = ServerEnv.hasConvertEncOption();
        this.hasTaskListener = ServerEnv.hasTaskListener();
        this.getToApplet = ServerEnv.getToApplet();
        this.getToHtml = ServerEnv.getToHtml();
        this.getToPdf = ServerEnv.getToPdf();
        this.getToText = ServerEnv.getToText();
        this.getToExcel = ServerEnv.getToExcel();
        this.getToPs = ServerEnv.getToPs();
        this.getToRtf = ServerEnv.getToRtf();
        this.getToXML = ServerEnv.getToXML();
        this.getToDHTML = ServerEnv.getToDHTML();
        this.needSecurity = ServerEnv.needSecurity();
        this.isShowVersionParamContents = ServerEnv.isShowVersionParamContents();
        this.isPublishTempToVersion = ServerEnv.isPublishTempToVersion();
        this.isPipeline = ServerEnv.isPipeline();
        this.reportWaitTimeouts = ServerEnv.getReportWaitTimeouts();
        this.sendfileJSPWebApp = ServerEnv.getJSPWebAppName("jsp.webapp.sendfile");
        this.monitorServerWebURL = ServerEnv.getJSPWebAppName("monitor.server.web.url");
        this.adhocReportJSPWebApp = ServerEnv.getJSPWebAppName("jsp.webapp.adhocreport");
        this.dhtmlWebServletPath = ServerEnv.getJSPWebAppName("jsp.webapp.dhtml");
        this.dhtmlWebJspPath = ServerEnv.getJSPWebAppName("jsp.webapp.dhtmljsp");
        this.helpWebServletPath = ServerEnv.getJSPWebAppName("jsp.webapp.help");
        this.adhocServletPath = ServerEnv.getAdhocServletPath();
        this.adhocJSPPath = ServerEnv.getAdhocJspPath();
        this.jrservletPath = ServerEnv.getJRServletPath();
        this.engineDefEncoding = ServerEnv.getEngineDefaultEncoding();
        if (this.engineDefEncoding == null) {
            System.getProperty("file.encoding");
        }
        this.useRelativeAppUrl = ServerEnv.useRelativeAppUrl();
        this.isEnableDynamicResource = ServerEnv.isEnableDynamicResource();
        this.showCatalogNode = ServerEnv.showCatalogNode();
        this.webSiteUrl = ServerEnv.getWebSiteUrl();
        this.helpUrl = ServerEnv.getHelpUrl();
        this.tutorialUrl = ServerEnv.getTutorialUrl();
        this.skinDir = ServerEnv.getSkinDir();
        this.rootDirOfFolderSelector = ServerEnv.getRootDirOfFolderSelector();
        this.delimiter = ServerEnv.getMultipleParameterValuesDelimiter();
        this.enableMonitorLink = ServerEnv.isEnableMonitorLink();
        this.autoRecoverTaskMaxTimes = ServerEnv.getAutoRecoverTaskMaxTimes();
        this.autoRecoverTaskInterval = ServerEnv.getAutoRecoverTaskInterval();
        this.autoRecoverTaskRedoAll = ServerEnv.getAutoRecoverTaskRedoAll();
        this.isEnableTaskDuration = ServerEnv.isEnableTaskDuration();
        this.isAdhoc = ReportEnv.isWebAdHoc();
        this.isLive = ReportEnv.isLive();
        this.enableJDashboard = ReportEnv.isDashBoard();
        this.enableVA = ServerEnv.isEnabledVA();
        this.enableMultipleOrganization = ServerEnv.isEnableMultipleOrganization();
        this.enableMultipleLanguage = ServerEnv.IsMultiLanguage();
        this.adhoc = ServerEnv.getAdHocUser() > 0;
        this.scheme = (Integer)IsMultiLanguage.get(HttpUtil.getAuthScheme());
        this.ondemandTaskInitPriority = ServerEnv.getOndemandTaskInitPriority();
        this.scheduleTaskInitPriority = ServerEnv.getScheduleTaskInitPriority();
        this.isMarkUnviewdResult = ServerEnv.isMarkUnviewedResultVersion();
        this.enablePLS = ServerEnv.isEnablePLStoVersion();
        this.helpDocProp = ServerEnv.getHelpDocProperties();
        this.isCheckCSRF = ServerEnv.isEnableCheckCSRF();
    }

    @Override
    public boolean hasDbOption() {
        return this.hasDbOption;
    }

    @Override
    public boolean hasEncoding() {
        return this.hasEncoding;
    }

    @Override
    public boolean isShowNameWithPostfix() {
        return this.isShowNameWithPostfix;
    }

    @Override
    public boolean usePermissionDialog() {
        return this.usePermissionDialog;
    }

    @Override
    public boolean hasStyleGroupOption() {
        return this.hasStyleGroupOption;
    }

    @Override
    public boolean hasConvertEncOption() {
        return this.hasConvertEncOption;
    }

    @Override
    public boolean hasTaskListener() {
        return this.hasTaskListener;
    }

    @Override
    public boolean getToApplet() {
        return this.getToApplet;
    }

    @Override
    public boolean getToHtml() {
        return this.getToHtml;
    }

    @Override
    public boolean getToPdf() {
        return this.getToPdf;
    }

    @Override
    public boolean getToText() {
        return this.getToText;
    }

    @Override
    public boolean getToExcel() {
        return this.getToExcel;
    }

    @Override
    public boolean getToPs() {
        return this.getToPs;
    }

    @Override
    public boolean getToRtf() {
        return this.getToRtf;
    }

    @Override
    public boolean getToXML() {
        return this.getToXML;
    }

    @Override
    public boolean getToDHTML() {
        return this.getToDHTML;
    }

    public boolean getToWST() {
        return this.getToWST;
    }

    @Override
    public boolean hasNewWindowSameName() {
        return true;
    }

    @Override
    public boolean needSecurity() {
        return this.needSecurity;
    }

    @Override
    public boolean isShowVersionParamContents() {
        return this.isShowVersionParamContents;
    }

    @Override
    public boolean isPublishTempToVersion() {
        return this.isPublishTempToVersion;
    }

    @Override
    public boolean isPublishTempToVersion(String string) {
        if (string != null && this.isPipeline() && (string.endsWith("html") || string.endsWith("htm"))) {
            return false;
        }
        return this.isPublishTempToVersion();
    }

    @Override
    public boolean isPipeline() {
        return this.isPipeline;
    }

    @Override
    public long getReportWaitTimeouts() {
        return this.reportWaitTimeouts;
    }

    @Override
    public String getJSPWebAppName(String string) {
        if (string.equals("jsp.webapp.sendfile")) {
            return this.sendfileJSPWebApp;
        }
        if (string.equals("monitor.server.web.url")) {
            return this.monitorServerWebURL;
        }
        if (string.equals("jsp.webapp.adhocreport")) {
            return this.adhocReportJSPWebApp;
        }
        if (string.equals("jsp.webapp.dhtml")) {
            return this.dhtmlWebServletPath;
        }
        if (string.equals("jsp.webapp.dhtmljsp")) {
            return this.dhtmlWebJspPath;
        }
        if (string.equals("jsp.webapp.help")) {
            return this.helpWebServletPath;
        }
        return "";
    }

    @Override
    public String getAdhocServletPath() {
        return this.adhocServletPath;
    }

    @Override
    public String getAdhocJspPath() {
        return this.adhocJSPPath;
    }

    @Override
    public String getJRServletPath() {
        return this.jrservletPath;
    }

    @Override
    public boolean getAdHoc() {
        return this.adhoc;
    }

    @Override
    public int getActiveRealmScheme() {
        return this.scheme;
    }

    @Override
    public String getEngineDefaultEncoding() {
        return this.engineDefEncoding;
    }

    @Override
    public boolean useRelativeWebAppUrl() {
        return this.useRelativeAppUrl;
    }

    @Override
    public boolean isEnableDynamicResource() {
        return this.isEnableDynamicResource;
    }

    @Override
    public boolean showCatalogNode() {
        return this.showCatalogNode;
    }

    @Override
    public String getWebSiteUrl() {
        return this.webSiteUrl;
    }

    @Override
    public String getHelpUrl() {
        return this.helpUrl;
    }

    @Override
    public String getHelpPage(String string) {
        return this.helpDocProp.getProperty(string);
    }

    @Override
    public String getTutorialUrl() {
        return this.tutorialUrl;
    }

    @Override
    public String getSkinDir() {
        return ServerEnv.getSkinDir(null);
    }

    @Override
    public String getSkinDir(HttpServletRequest httpServletRequest) {
        return ServerEnv.getSkinDir(httpServletRequest);
    }

    @Override
    public String getRootDirOfFolderSelector() {
        return this.rootDirOfFolderSelector;
    }

    @Override
    public boolean isEnableRoleBasedAuthorization() {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        ConfigService configService = httpRptServer.getAdminService().getConfigService();
        ConfigurationAdvanced configurationAdvanced = configService.getConfigurationAdvanced();
        return configurationAdvanced.isEnableRoleBasedAuthorization();
    }

    @Override
    public boolean isEnableDispalyUserPermissionUI() {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        ConfigService configService = httpRptServer.getAdminService().getConfigService();
        ConfigurationAdvanced configurationAdvanced = configService.getConfigurationAdvanced();
        return configurationAdvanced.isEnableDispalyUserPermissionUI();
    }

    @Override
    public boolean isEnableDispalyRolePermissionUI() {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        ConfigService configService = httpRptServer.getAdminService().getConfigService();
        ConfigurationAdvanced configurationAdvanced = configService.getConfigurationAdvanced();
        return configurationAdvanced.isEnableDispalyRolePermissionUI();
    }

    @Override
    public boolean isEnableDispalyGroupPermissionUI() {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        ConfigService configService = httpRptServer.getAdminService().getConfigService();
        ConfigurationAdvanced configurationAdvanced = configService.getConfigurationAdvanced();
        return configurationAdvanced.isEnableDispalyGroupPermissionUI();
    }

    @Override
    public String getMultipleParameterValuesDelimiter() {
        return this.delimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMonitoringWebURL() {
        String string = null;
        Object object = SEDU;
        synchronized (object) {
            for (int i = SEDU.size() - 1; i >= 0; --i) {
                String string2 = (String)SEDU.get(i);
                if (HttpUtil.isValidMonitoringURL(string2)) {
                    string = string2;
                    break;
                }
                SEDU.remove(i);
            }
        }
        if (string == null && !ServerEnv.isClusterAdminServer()) {
            object = ServerEnv.getClusterAdminHost();
            String string3 = ServerEnv.getClusterAdminRMIPort();
            string = HttpUtil.getValidMonitoringURL((String)object, string3);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMonitoringWebURL(String string) {
        ArrayList arrayList = SEDU;
        synchronized (arrayList) {
            if (!SEDU.contains(string)) {
                SEDU.add(string);
            }
        }
    }

    @Override
    public boolean isEnableMonitorLink() {
        return this.enableMonitorLink;
    }

    @Override
    public int getAutoRecoverTaskMaxTimes() {
        return this.autoRecoverTaskMaxTimes;
    }

    @Override
    public long getAutoRecoverTaskInterval() {
        return this.autoRecoverTaskInterval;
    }

    @Override
    public boolean getAutoRecoverTaskRedoAll() {
        return this.autoRecoverTaskRedoAll;
    }

    @Override
    public boolean isEnableTaskDuration() {
        return this.isEnableTaskDuration;
    }

    @Override
    public boolean isWebAdHoc() {
        return this.isAdhoc;
    }

    @Override
    public boolean isLive() {
        return this.isLive;
    }

    @Override
    public int getOndemandTaskInitPriority() {
        return this.ondemandTaskInitPriority;
    }

    @Override
    public int getScheduleTaskInitPriority() {
        return this.scheduleTaskInitPriority;
    }

    @Override
    public boolean isPromptTaskQueueFull() {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        ConfigService configService = httpRptServer.getAdminService().getConfigService();
        ConfigurationAdvanced configurationAdvanced = configService.getConfigurationAdvanced();
        return configurationAdvanced.isPromptTaskQueueFull();
    }

    @Override
    public boolean isPromptActionQueueFull() {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        ConfigService configService = httpRptServer.getAdminService().getConfigService();
        ConfigurationAdvanced configurationAdvanced = configService.getConfigurationAdvanced();
        return configurationAdvanced.isPromptActionQueueFull();
    }

    @Override
    public boolean isMarkUnviewedResultVersion() {
        return this.isMarkUnviewdResult;
    }

    @Override
    public boolean isEnablePageLevelSecurity() {
        return this.enablePLS;
    }

    @Override
    public boolean isEnableJDashboard() {
        return this.enableJDashboard;
    }

    @Override
    public boolean isEnableVA() {
        return this.enableVA;
    }

    @Override
    public boolean isEnableMultipleOrganization() {
        return this.enableMultipleOrganization;
    }

    @Override
    public boolean isEnableMultiLanguage() {
        return this.enableMultipleLanguage;
    }

    @Override
    public boolean isEnableCheckCSRF() {
        return this.isCheckCSRF;
    }

    static {
        IsMultiLanguage.put("Basic", new Integer(0));
        IsMultiLanguage.put("Digest", new Integer(1));
        SEDU = new ArrayList();
    }
}

