/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.cfg;

import java.sql.SQLException;
import java.util.Properties;
import jet.cs.CSUtil;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.admin.cfg.ConfigurationCluster;
import jet.server.db.cfg.PropsTable;
import jet.server.db.core.GlobalDataService;
import jet.server.log.ServiceLogger;
import jet.server.util.WebSecurityUtil;

public class JRConfigurationCluster
implements ConfigurationCluster {
    private ExProperties SEDU = new ExProperties();
    private String get = ServerEnv.getServPropName();
    private Properties getBoolean = new Properties();
    boolean isCluster = false;
    PropsTable probTable = null;

    public JRConfigurationCluster() {
        this.loadProperties();
        this.isCluster = ServerEnv.isClusterEnabled();
        if (this.isCluster) {
            GlobalDataService globalDataService = GlobalDataService.getInstance();
            this.probTable = globalDataService.getPropsTable();
            try {
                this.getBoolean = this.probTable.queryProp("server.properties");
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
            }
        }
    }

    @Override
    public void loadProperties() {
        try {
            this.SEDU = ServerEnv.getServerProps();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public boolean isClusterAdminServer() {
        return true;
    }

    @Override
    public void setClusterAdminServer(boolean bl) {
    }

    @Override
    public boolean isClusterBackupServer() {
        return false;
    }

    @Override
    public void setClusterBackupServer(boolean bl) {
    }

    @Override
    public String getClusterAdminHost() {
        return "";
    }

    @Override
    public void setClusterAdminHost(String string) {
    }

    @Override
    public String getClusterAdminRMIPort() {
        return "";
    }

    @Override
    public void setClusterAdminRMIPort(String string) {
    }

    @Override
    public String getServerRMIPort() {
        String string = (String)this.getBoolean.get("server.rmi.port");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return ServerEnv.getServerRMIPort();
    }

    @Override
    public void setServerRMIPort(String string) {
        try {
            this.SEDU.setProperty("server.rmi.port", string);
            this.getBoolean.put("server.rmi.port", string);
            this.SEDU.save(this.get, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public String getSharePropertyDirectory() {
        String string = (String)this.getBoolean.get("resource.share.properties.dir");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return ServerEnv.getSharePropertyDirectory();
    }

    @Override
    public void setSharePropertyDirectory(String string) {
        try {
            string = WebSecurityUtil.validateFilePathStr(string);
            this.SEDU.setProperty("resource.share.properties.dir", string);
            this.getBoolean.put("resource.share.properties.dir", string);
            this.SEDU.save(this.get, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public String getShareRealmDirectory() {
        String string = (String)this.getBoolean.get("resource.share.realm.dir");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return ServerEnv.getShareRealmDirectory();
    }

    @Override
    public void setShareRealmDirectory(String string) {
        try {
            string = WebSecurityUtil.validateFilePathStr(string);
            this.SEDU.setProperty("resource.share.realm.dir", string);
            this.getBoolean.put("resource.share.realm.dir", string);
            this.SEDU.save(this.get, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public String getClusterResourceRoot() {
        String string = (String)this.getBoolean.get("resource.root");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return ServerEnv.getClusterResourceRoot();
    }

    @Override
    public void setClusterResourceRoot(String string) {
        try {
            string = WebSecurityUtil.validateFilePathStr(string);
            this.SEDU.setProperty("resource.root", string);
            this.getBoolean.put("resource.root", string);
            this.SEDU.save(this.get, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public String getShareTempDirectory() {
        String string = (String)this.getBoolean.get("resource.share.temp.dir");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return ServerEnv.getShareTempDirectory();
    }

    @Override
    public void setShareTempDirectory(String string) {
        try {
            string = WebSecurityUtil.validateFilePathStr(string);
            this.SEDU.setProperty("resource.share.temp.dir", string);
            this.getBoolean.put("resource.share.temp.dir", string);
            this.SEDU.save(this.get, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public String getShareDsoDirectory() {
        return "";
    }

    @Override
    public void setShareDsoDirectory(String string) {
    }

    @Override
    public String getShareHistoryDirectory() {
        String string = (String)this.getBoolean.get("resource.share.hist.dir");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return ServerEnv.getShareHistoryDirectory();
    }

    @Override
    public void setShareHistoryDirectory(String string) {
        try {
            string = WebSecurityUtil.validateFilePathStr(string);
            this.SEDU.setProperty("resource.share.hist.dir", string);
            this.getBoolean.put("resource.share.hist.dir", string);
            this.SEDU.save(this.get, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public boolean isClusterEnabled() {
        return CSUtil.getBoolean(this.getBoolean.getProperty("cluster.enable"), ServerEnv.isClusterEnabled());
    }

    @Override
    public boolean setClusterEnabled(boolean bl) {
        try {
            this.SEDU.setProperty("cluster.enable", bl);
            this.getBoolean.put("cluster.enable", String.valueOf(bl));
            this.SEDU.save(this.get, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return false;
    }

    @Override
    public boolean hasClusterLicense() {
        return ServerEnv.hasClusterLicense();
    }

    @Override
    public int getClusterMemeberID() {
        String string = (String)this.getBoolean.get("cluster.member.id");
        if (string != null && string.trim().length() > 0) {
            return CSUtil.parseInt(string, 0);
        }
        string = this.SEDU.getProperty("cluster.member.id");
        return CSUtil.parseInt(string, 0);
    }

    @Override
    public String getClusterName() {
        String string = (String)this.getBoolean.get("cluster.name");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        string = this.SEDU.getProperty("cluster.name");
        return string;
    }

    @Override
    public int getClusterSchedulerLeaseActiveCount() {
        String string = ServerEnv.getPropertyFromClusterRegistry("cluster.scheduler.lease.active_time");
        return CSUtil.parseInt(string, 2);
    }

    @Override
    public long getClusterSchedulerLeaseValidTime() {
        String string = ServerEnv.getPropertyFromClusterRegistry("cluster.scheduler.lease.valid_time");
        return CSUtil.parseLong(string, 300L);
    }

    @Override
    public long getClusterShedulerLeaseCheckInterval() {
        String string = ServerEnv.getPropertyFromClusterRegistry("cluster.scheduler.lease.check_interval");
        return CSUtil.parseLong(string, 30L);
    }

    @Override
    public int getClusterStorageCrdResultCopies() {
        String string = ServerEnv.getPropertyFromClusterRegistry("cluster.storage.crd.result.copy_number");
        return CSUtil.parseInt(string, 2);
    }

    @Override
    public int getClusterStorageHistoryCopies() {
        String string = ServerEnv.getPropertyFromClusterRegistry("cluster.storage.history.copy_number");
        return CSUtil.parseInt(string, 2);
    }

    @Override
    public int getClusterStorageRealmCopies() {
        String string = ServerEnv.getPropertyFromClusterRegistry("cluster.storage.realm.copy_number");
        return CSUtil.parseInt(string, 2);
    }

    @Override
    public boolean isClusterSchedulerLeaseEnabled() {
        String string = ServerEnv.getPropertyFromClusterRegistry("cluster.scheduler.lease.enabled");
        return CSUtil.getBoolean(string, false);
    }

    @Override
    public void setClusterMemberID(int n) {
        try {
            this.SEDU.setProperty("cluster.member.id", Integer.toString(n));
            this.getBoolean.put("cluster.member.id", Integer.toString(n));
            this.SEDU.save(this.get, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public void setClusterName(String string) {
        try {
            this.SEDU.setProperty("cluster.name", string);
            this.getBoolean.put("cluster.name", string);
            this.SEDU.save(this.get, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public void setClusterSchedulerLeaseActiveCount(int n) {
        this.SEDU("cluster.scheduler.lease.active_time", Integer.toString(n));
    }

    @Override
    public void setClusterSchedulerLeaseCheckInterval(long l) {
        this.SEDU("cluster.scheduler.lease.check_interval", Long.toString(l));
    }

    @Override
    public void setClusterSchedulerLeaseEnabled(boolean bl) {
        this.SEDU("cluster.scheduler.lease.enabled", Boolean.toString(bl));
    }

    @Override
    public void setClusterSchedulerLeaseValidTime(long l) {
        this.SEDU("cluster.scheduler.lease.valid_time", Long.toString(l));
    }

    @Override
    public void setClusterStorageCrdResultCopies(int n) {
        this.SEDU("cluster.storage.crd.result.copy_number", Integer.toString(n));
    }

    @Override
    public void setClusterStorageHistoryCopies(int n) {
        this.SEDU("cluster.storage.history.copy_number", Integer.toString(n));
    }

    @Override
    public void setClusterStorageRealmCopies(int n) {
        this.SEDU("cluster.storage.realm.copy_number", Integer.toString(n));
    }

    private void SEDU(String string, String string2) {
        try {
            ServerEnv.registerProperty(string, string2);
            this.probTable.updateProp("server.properties", string, string2);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public int getShareMemoryNodeNumber() {
        String string = ServerEnv.getPropertyFromClusterRegistry("cluster.share_memory.node_number");
        return CSUtil.parseInt(string, 2);
    }

    @Override
    public void setShareMemoryNodeNumber(int n) {
        this.SEDU("cluster.share_memory.node_number", Integer.toString(n));
    }
}

