/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.cfg;

import java.security.Principal;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingException;
import jet.JSvrResource;
import jet.server.ServerEnv;
import jet.server.api.admin.cfg.ConfigurationLDAP;
import jet.server.api.admin.cfg.SynchronizationResult;
import jet.server.api.exception.InUseException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.intf.security.Group;
import jet.server.intf.security.Role;
import jet.server.intf.security.SecurityProvider;
import jet.server.intf.security.SecurityService;
import jet.server.intf.security.User;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrc.security.ldap.SynchronizationResultImpl;
import jet.server.jrc.security.ldap.intf.LDAPGroup;
import jet.server.jrc.security.ldap.intf.LDAPManager;
import jet.server.jrc.security.ldap.intf.LDAPUser;
import jet.server.log.ServiceLogger;

public class JRConfigurationLDAP
implements ConfigurationLDAP {
    private LDAPManager SEDU = UserDataToolkit.getLdapManager();
    private SecurityService add;
    private SecurityProvider addElement;
    private boolean addLDAPGroup = false;

    public JRConfigurationLDAP() {
        String string = ServerEnv.getActiveRealm();
        this.add = UserDataToolkit.getSecurityService(string);
        this.addElement = UserDataToolkit.getSecurityProvider(string);
    }

    @Override
    public Enumeration getLdapSynchronization() {
        return null;
    }

    @Override
    public Enumeration getUserNames() {
        Vector vector = new Vector();
        if (!this.SEDU.isLDAPEnable()) {
            return vector.elements();
        }
        try {
            vector = this.SEDU.getAllLDAPUsers();
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
        }
        Vector<String> vector2 = new Vector<String>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            LDAPUser lDAPUser = (LDAPUser)enumeration.nextElement();
            vector2.add(lDAPUser.getName());
        }
        return vector2.elements();
    }

    @Override
    public boolean importLDAPGroupsAndUsers() {
        return false;
    }

    @Override
    public boolean checkSynchronization() {
        if (!this.SEDU.isLDAPEnable()) {
            return false;
        }
        this.synchronize();
        return true;
    }

    @Override
    public void setEncryptedUserAuthInfo(String string, String string2) {
    }

    @Override
    public Vector listExistedUsers() {
        Vector vector;
        Vector<LDAPUser> vector2 = new Vector<LDAPUser>();
        if (!this.SEDU.isLDAPEnable()) {
            return vector2;
        }
        try {
            vector = this.SEDU.getAllLDAPUsers();
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            return vector2;
        }
        if (vector == null) {
            return null;
        }
        Enumeration enumeration = this.addElement.getImportedLDAPUserNames().elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals("admin") || string.equals("guest")) continue;
            for (int i = 0; i < vector.size(); ++i) {
                LDAPUser lDAPUser = (LDAPUser)vector.get(i);
                if (!lDAPUser.getName().equalsIgnoreCase(string)) continue;
                vector2.addElement(lDAPUser);
            }
        }
        return vector2;
    }

    @Override
    public Vector listExistedGroups() {
        Vector vector;
        Vector<LDAPGroup> vector2 = new Vector<LDAPGroup>();
        if (!this.SEDU.isLDAPEnable()) {
            return vector2;
        }
        try {
            vector = this.SEDU.getAllLDAPGroups();
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            return vector2;
        }
        if (vector == null) {
            return null;
        }
        if (this.SEDU.isImportToRole()) {
            Enumeration enumeration = this.add.getAllRoles().elements();
            while (enumeration.hasMoreElements()) {
                Role role = (Role)enumeration.nextElement();
                if (role.getName().equals("administrators") || role.getName().equals("everyone")) continue;
                for (int i = 0; i < vector.size(); ++i) {
                    LDAPGroup lDAPGroup = (LDAPGroup)vector.get(i);
                    if (!lDAPGroup.getName().equalsIgnoreCase(role.getName())) continue;
                    vector2.addElement(lDAPGroup);
                }
            }
        } else {
            Enumeration enumeration = this.add.getAllGroups().elements();
            while (enumeration.hasMoreElements()) {
                Group group = (Group)enumeration.nextElement();
                for (int i = 0; i < vector.size(); ++i) {
                    LDAPGroup lDAPGroup = (LDAPGroup)vector.get(i);
                    if (!lDAPGroup.getName().equalsIgnoreCase(group.getName())) continue;
                    vector2.addElement(lDAPGroup);
                }
            }
        }
        return vector2;
    }

    @Override
    public Vector listExistedUserNames() {
        return null;
    }

    @Override
    public String listExistedUserFullName(String string) {
        return null;
    }

    @Override
    public Vector listExistedGroupsName() {
        return null;
    }

    @Override
    public String listExistedGroupDescriptions(String string) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean importLDAPUsers(boolean bl) {
        try {
            Vector vector;
            if (this.addLDAPGroup || !this.SEDU.isLDAPEnable()) {
                boolean bl2 = false;
                return bl2;
            }
            this.addLDAPGroup = true;
            try {
                vector = this.SEDU.getAllLDAPUsers();
            }
            catch (NamingException namingException) {
                ServiceLogger.logError(namingException);
                this.addLDAPGroup = false;
                boolean bl3 = false;
                this.addLDAPGroup = false;
                return bl3;
            }
            if (vector == null || vector.size() == 0) {
                ServiceLogger.logDebug(6660217, 6);
                this.addLDAPGroup = false;
                boolean bl4 = false;
                return bl4;
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                LDAPUser lDAPUser = (LDAPUser)enumeration.nextElement();
                this.addElement.addLDAPUser(lDAPUser, bl);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            this.addLDAPGroup = false;
            boolean bl5 = false;
            return bl5;
        }
        finally {
            this.addLDAPGroup = false;
        }
        this.addLDAPGroup = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean importSpecifyLDAPUsers(Vector vector, boolean bl) {
        if (this.addLDAPGroup || !this.SEDU.isLDAPEnable()) {
            return false;
        }
        try {
            this.addLDAPGroup = true;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                LDAPUser lDAPUser;
                String string = (String)enumeration.nextElement();
                try {
                    lDAPUser = this.SEDU.getLDAPUser(string);
                }
                catch (NamingException namingException) {
                    ServiceLogger.logError(namingException);
                    this.addLDAPGroup = false;
                    boolean bl2 = false;
                    this.addLDAPGroup = false;
                    return bl2;
                }
                if (lDAPUser == null) {
                    this.addLDAPGroup = false;
                    ServiceLogger.logError("The ldap user: " + string + " does not exist!");
                    boolean bl3 = false;
                    return bl3;
                }
                String string2 = null;
                if (lDAPUser == null || (string2 = this.addElement.addLDAPUser(lDAPUser, bl)) == null) continue;
                this.addLDAPGroup = false;
                boolean bl4 = false;
                return bl4;
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            exception.printStackTrace();
            this.addLDAPGroup = false;
            boolean bl5 = false;
            return bl5;
        }
        finally {
            this.addLDAPGroup = false;
        }
        this.addLDAPGroup = false;
        return true;
    }

    @Override
    public boolean importLDAPRoles(boolean bl) {
        return this.importLDAPGroups(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean importLDAPGroups(boolean bl) {
        if (this.addLDAPGroup || !this.SEDU.isLDAPEnable()) {
            return false;
        }
        try {
            Object object;
            Object object2;
            Hashtable hashtable;
            Hashtable hashtable2;
            this.addLDAPGroup = true;
            try {
                hashtable2 = this.SEDU.getAllLDAPGroupsHT();
                hashtable = this.SEDU.getAllLDAPUsersHT();
            }
            catch (NamingException namingException) {
                ServiceLogger.logError(namingException);
                this.addLDAPGroup = false;
                boolean bl2 = false;
                this.addLDAPGroup = false;
                return bl2;
            }
            boolean bl3 = this.SEDU.isImportToRole();
            Enumeration enumeration = hashtable2.elements();
            Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
            Hashtable<String, Object> hashtable4 = new Hashtable<String, Object>();
            Hashtable<String, Object> hashtable5 = new Hashtable<String, Object>();
            while (enumeration.hasMoreElements()) {
                object2 = (LDAPGroup)enumeration.nextElement();
                object = this.addElement.addLDAPGroup((LDAPGroup)object2, bl3);
                if (object != null) {
                    ServiceLogger.logDebug((String)object);
                    continue;
                }
                hashtable5.put(object2.getName(), object2);
            }
            object2 = hashtable5.elements();
            while (object2.hasMoreElements()) {
                Object object3;
                object = (LDAPGroup)object2.nextElement();
                String string = object.getName();
                Vector vector = object.getUserNames();
                for (int i = 0; i < vector.size(); ++i) {
                    String string2 = (String)vector.elementAt(i);
                    object3 = (LDAPUser)hashtable.get(string2);
                    if (object3 == null) continue;
                    if (!hashtable3.containsKey(string2) && !hashtable4.containsKey(string2)) {
                        String string3 = this.addElement.addLDAPUser((LDAPUser)object3, bl);
                        if (string3 == null) {
                            hashtable3.put(string2, object3);
                        } else {
                            hashtable4.put(string2, object3);
                        }
                    }
                    if (!hashtable3.containsKey(string2) || hashtable4.containsKey(string2)) continue;
                    try {
                        if (bl3) {
                            this.addElement.addSubUserToRole(string2, string);
                            continue;
                        }
                        this.addElement.addUserToGroup(string2, string);
                        continue;
                    }
                    catch (NoSuchRoleException noSuchRoleException) {
                        ServiceLogger.logError((Throwable)((Object)noSuchRoleException));
                        break;
                    }
                    catch (NoSuchUserException noSuchUserException) {
                        continue;
                    }
                    catch (NoSuchGroupException noSuchGroupException) {
                        ServiceLogger.logError((Throwable)((Object)noSuchGroupException));
                        break;
                    }
                }
                Vector vector2 = object.getSubGroupNames();
                for (int i = 0; i < vector2.size(); ++i) {
                    object3 = (String)vector2.elementAt(i);
                    if (!hashtable5.containsKey(object3)) continue;
                    try {
                        if (bl3) {
                            this.addElement.addSubRoleToRole((String)object3, string);
                            continue;
                        }
                        this.addElement.addSubGroupToGroup((String)object3, string);
                        continue;
                    }
                    catch (NoSuchRoleException noSuchRoleException) {
                        continue;
                    }
                    catch (NoSuchGroupException noSuchGroupException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            this.addLDAPGroup = false;
        }
        finally {
            this.addLDAPGroup = false;
        }
        this.addLDAPGroup = false;
        return true;
    }

    @Override
    public boolean importSpecifyLDAPRoles(Vector vector, boolean bl) {
        return this.importSpecifyLDAPGroups(vector, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean importSpecifyLDAPGroups(Vector vector, boolean bl) {
        if (this.addLDAPGroup || !this.SEDU.isLDAPEnable()) {
            return false;
        }
        try {
            Object object;
            Object object2;
            Object object3;
            this.addLDAPGroup = true;
            Enumeration enumeration = vector.elements();
            boolean bl2 = this.SEDU.isImportToRole();
            Hashtable<String, LDAPUser> hashtable = new Hashtable<String, LDAPUser>();
            Hashtable<Object, Object> hashtable2 = new Hashtable<Object, Object>();
            block15: while (enumeration.hasMoreElements()) {
                object3 = (String)enumeration.nextElement();
                try {
                    object2 = this.SEDU.getLDAPGroup((String)object3);
                }
                catch (NamingException namingException) {
                    ServiceLogger.logError(namingException);
                    this.addLDAPGroup = false;
                    boolean bl3 = false;
                    this.addLDAPGroup = false;
                    return bl3;
                }
                if (object2[0] == null || ((Vector)object2[0]).size() != 1) {
                    ServiceLogger.logDebug(6660218, object3, 6);
                    continue;
                }
                object = (LDAPGroup)((Vector)object2[0]).firstElement();
                String string = this.addElement.addLDAPGroup((LDAPGroup)object, bl2);
                if (string != null) {
                    ServiceLogger.logDebug(string);
                    continue;
                }
                hashtable2.put(object3, object);
                if (object2[1] == null || ((Vector)object2[1]).size() == 0) continue;
                for (int i = 0; i < ((Vector)object2[1]).size(); ++i) {
                    LDAPUser lDAPUser = (LDAPUser)((Vector)object2[1]).elementAt(i);
                    String string2 = lDAPUser.getName();
                    if (!hashtable.containsKey(string2)) {
                        this.addElement.addLDAPUser(lDAPUser, bl);
                        hashtable.put(string2, lDAPUser);
                    }
                    try {
                        if (bl2) {
                            this.addElement.addSubUserToRole(string2, (String)object3);
                            continue;
                        }
                        this.addElement.addUserToGroup(string2, (String)object3);
                        continue;
                    }
                    catch (NoSuchRoleException noSuchRoleException) {
                        ServiceLogger.logError((Throwable)((Object)noSuchRoleException));
                        continue block15;
                    }
                    catch (NoSuchUserException noSuchUserException) {
                        continue;
                    }
                    catch (NoSuchGroupException noSuchGroupException) {
                        // empty catch block
                    }
                }
            }
            object3 = hashtable2.elements();
            while (object3.hasMoreElements()) {
                object2 = (LDAPGroup)object3.nextElement();
                object = object2.getSubGroupNames();
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    String string = (String)((Vector)object).elementAt(i);
                    if (!hashtable2.containsKey(string)) continue;
                    try {
                        if (bl2) {
                            this.addElement.addSubRoleToRole(string, object2.getName());
                            continue;
                        }
                        this.addElement.addSubGroupToGroup(string, object2.getName());
                        continue;
                    }
                    catch (NoSuchRoleException noSuchRoleException) {
                        continue;
                    }
                    catch (NoSuchGroupException noSuchGroupException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            this.addLDAPGroup = false;
        }
        finally {
            this.addLDAPGroup = false;
        }
        this.addLDAPGroup = false;
        return true;
    }

    @Override
    public boolean importAllLDAPUsersAndGroups(boolean bl) {
        if (this.importLDAPUsers(bl)) {
            return this.importLDAPGroups(bl);
        }
        return false;
    }

    @Override
    public Vector getLDAPUsers() {
        if (!this.SEDU.isLDAPEnable()) {
            return new Vector();
        }
        try {
            return this.SEDU.getAllLDAPUsers();
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            return new Vector();
        }
    }

    @Override
    public Vector getLDAPGroups() {
        if (!this.SEDU.isLDAPEnable()) {
            return new Vector();
        }
        try {
            return this.SEDU.getAllLDAPGroups();
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            return new Vector();
        }
    }

    @Override
    public Vector getEncryptedUsers() {
        return null;
    }

    @Override
    public String testRoleMap(String string, String string2) {
        if (!this.SEDU.isLDAPEnable()) {
            return "LDAP support is disable!";
        }
        try {
            this.add.getRole(string2);
        }
        catch (NoSuchRoleException noSuchRoleException) {
            return JSvrResource.getMessage("SECURITY_ERR_13_ROLE_NOT_EXIST", string2);
        }
        return this.SEDU.testFilter(string);
    }

    @Override
    public String autoImportLDAPUser(String string, String string2) {
        String string3;
        LDAPUser lDAPUser;
        if (!this.SEDU.isLDAPEnable()) {
            return "LDAP support is disable!";
        }
        try {
            lDAPUser = this.SEDU.getLDAPUser(string);
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            return JSvrResource.getMessage("SECURITY_ERR_61_LDAP_NOT_GET_USER", string);
        }
        if (lDAPUser == null) {
            return JSvrResource.getMessage("SECURITY_ERR_61_LDAP_NOT_GET_USER", string);
        }
        boolean bl = this.SEDU.isValidLdapUser(string, string2);
        if (!bl) {
            string3 = lDAPUser.getProperty("ldapuser_dn");
            bl = this.SEDU.isValidLdapUserByDN(string, string3, string2);
        }
        if (!bl) {
            return JSvrResource.getMessage("SECURITY_ERR_60_LDAP_NOT_VALID_USER", string);
        }
        string3 = this.addElement.addLDAPUser(lDAPUser, false);
        if (string3 != null) {
            return string3;
        }
        if (this.SEDU.isImportToRole()) {
            Object object;
            Vector vector;
            try {
                vector = this.SEDU.getLDAPGroupsNameByUser(string);
                object = this.addElement.getImportedLDAPRoleNames();
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    String string4 = (String)((Vector)object).elementAt(i);
                    if (!vector.contains(string4)) continue;
                    try {
                        this.addElement.addSubUserToRole(string, string4);
                        continue;
                    }
                    catch (NoSuchRoleException noSuchRoleException) {
                        continue;
                    }
                    catch (NoSuchUserException noSuchUserException) {
                        return JSvrResource.getMessage("SEUCRITY_ERR_62_LDAP_ADD_USER_FAILED");
                    }
                }
            }
            catch (NamingException namingException) {
                ServiceLogger.logError(namingException);
            }
            vector = this.SEDU.getRoleNamsByFilter(string);
            object = vector.elements();
            while (object.hasMoreElements()) {
                String string5 = (String)object.nextElement();
                try {
                    this.addElement.addSubUserToRole(string, string5);
                }
                catch (NoSuchRoleException noSuchRoleException) {
                }
                catch (NoSuchUserException noSuchUserException) {
                    return JSvrResource.getMessage("SEUCRITY_ERR_62_LDAP_ADD_USER_FAILED");
                }
            }
        } else {
            Object object;
            Vector vector;
            try {
                vector = this.SEDU.getLDAPGroupsNameByUser(string);
                object = this.addElement.getImportedLDAPGroupNames();
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    String string6 = (String)((Vector)object).elementAt(i);
                    if (!vector.contains(string6)) continue;
                    try {
                        this.addElement.addUserToGroup(string, string6);
                        continue;
                    }
                    catch (NoSuchGroupException noSuchGroupException) {
                        continue;
                    }
                    catch (NoSuchUserException noSuchUserException) {
                        return JSvrResource.getMessage("SEUCRITY_ERR_62_LDAP_ADD_USER_FAILED");
                    }
                }
            }
            catch (NamingException namingException) {
                ServiceLogger.logError(namingException);
            }
            vector = this.SEDU.getRoleNamsByFilter(string);
            object = vector.elements();
            while (object.hasMoreElements()) {
                String string7 = (String)object.nextElement();
                try {
                    this.addElement.addSubUserToRole(string, string7);
                }
                catch (NoSuchRoleException noSuchRoleException) {
                }
                catch (NoSuchUserException noSuchUserException) {
                    return JSvrResource.getMessage("SEUCRITY_ERR_62_LDAP_ADD_USER_FAILED");
                }
            }
        }
        return null;
    }

    @Override
    public boolean confirmFilter(String string, String string2) {
        if (!this.SEDU.isLDAPEnable()) {
            return false;
        }
        return this.SEDU.isInFilter(string2, string);
    }

    @Override
    public boolean isConfromFilter(String string, String string2) {
        if (!this.SEDU.isLDAPEnable()) {
            return false;
        }
        return this.SEDU.isInFilter(string2, string);
    }

    @Override
    public boolean isValidLDAPUser(String string, String string2) {
        if (!this.SEDU.isLDAPEnable()) {
            return false;
        }
        return this.SEDU.isValidLdapUser(string, string2);
    }

    @Override
    public boolean isValidLDAPUserByDN(String string, String string2, String string3) {
        if (!this.SEDU.isLDAPEnable()) {
            return false;
        }
        return this.SEDU.isValidLdapUserByDN(string, string2, string3);
    }

    @Override
    public SynchronizationResult synchronize() {
        Object object;
        String string;
        Principal principal;
        Object object2;
        Object object3;
        Hashtable hashtable;
        Hashtable hashtable2;
        SynchronizationResultImpl synchronizationResultImpl = new SynchronizationResultImpl();
        if (this.addLDAPGroup || !this.SEDU.isLDAPEnable()) {
            return synchronizationResultImpl;
        }
        this.addLDAPGroup = true;
        try {
            hashtable2 = this.SEDU.getAllLDAPUsersHT();
            hashtable = this.SEDU.getAllLDAPGroupsHT();
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            this.addLDAPGroup = false;
            return synchronizationResultImpl;
        }
        Vector vector = this.addElement.getImportedLDAPUsers();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object3 = (User)enumeration.nextElement();
            object2 = object3.getName();
            if (hashtable2.containsKey(object2)) {
                principal = (LDAPUser)hashtable2.get(object2);
                string = object3.getEmail();
                object = principal.getProperty("email");
                String string2 = object3.getFullName();
                String string3 = principal.getProperty("full_name");
                if (string.equals(object) && string2.equals(string3)) continue;
                try {
                    this.addElement.updateAttributes((String)object2, string3, object3.getDescription(), (String)object, object3.isEnableNullPS(), object3.getMinPSLength(), new Date(System.currentTimeMillis()), object3.isNeverExpire(), object3.getExpireTime(), object3.isAccountDisable());
                    synchronizationResultImpl.addModifiedUser((String)object2);
                }
                catch (NoSuchUserException noSuchUserException) {
                    ServiceLogger.logError((Throwable)((Object)noSuchUserException), 3);
                }
                continue;
            }
            try {
                this.addElement.removeUserInherRelation((String)object2);
                this.addElement.removeUser((String)object2, "admin");
                synchronizationResultImpl.addRemovedUser((String)object2);
            }
            catch (NoSuchUserException noSuchUserException) {
                ServiceLogger.logError((Throwable)((Object)noSuchUserException), 3);
            }
            catch (InUseException inUseException) {
                ServiceLogger.logError((Throwable)((Object)inUseException), 3);
            }
        }
        if (this.SEDU.isImportToRole()) {
            object3 = this.addElement.getImportedLDAPRoles();
            object2 = ((Vector)object3).elements();
            while (object2.hasMoreElements()) {
                principal = (Role)object2.nextElement();
                string = principal.getName();
                if (hashtable.containsKey(string)) {
                    object = (LDAPGroup)hashtable.get(string);
                    boolean bl = this.SEDU((LDAPGroup)object, (Role)principal);
                    if (!bl) continue;
                    synchronizationResultImpl.addModifiedRole(string);
                    continue;
                }
                try {
                    this.addElement.removeRoleInherRelation(string);
                    this.addElement.removeRole(string);
                    synchronizationResultImpl.addRemovedRole(string);
                }
                catch (NoSuchRoleException noSuchRoleException) {
                    ServiceLogger.logError((Throwable)((Object)noSuchRoleException), 3);
                }
                catch (InUseException inUseException) {
                    ServiceLogger.logError((Throwable)((Object)inUseException), 3);
                }
            }
        } else {
            object3 = this.addElement.getImportedLDAPGroups();
            object2 = ((Vector)object3).elements();
            while (object2.hasMoreElements()) {
                principal = (Group)object2.nextElement();
                string = principal.getName();
                if (hashtable.containsKey(string)) {
                    object = (LDAPGroup)hashtable.get(string);
                    boolean bl = this.add((LDAPGroup)object, (Group)principal);
                    if (!bl) continue;
                    synchronizationResultImpl.addModifiedGroup(string);
                    continue;
                }
                try {
                    this.addElement.removeGroupInherRelation(string);
                    this.addElement.removeGroup(string);
                    synchronizationResultImpl.addRemovedGroup(string);
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    ServiceLogger.logError((Throwable)((Object)noSuchGroupException), 3);
                }
                catch (InUseException inUseException) {
                    ServiceLogger.logError((Throwable)((Object)inUseException), 3);
                }
            }
        }
        this.addLDAPGroup = false;
        return synchronizationResultImpl;
    }

    private boolean SEDU(LDAPGroup lDAPGroup, Role role) {
        Object object;
        Object object2;
        Object object3;
        Vector vector;
        String string = role.getName();
        boolean bl = false;
        Vector vector2 = lDAPGroup.getUserNames();
        int n = 0;
        if (role.getSubUsersFlag() != lDAPGroup.getUsersFlag()) {
            vector = (Vector)role.getSubUserNames().clone();
            object3 = vector.elements();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                if (vector2.contains(object2)) continue;
                try {
                    this.addElement.removeUserFromParentRole((String)object2, string);
                    ++n;
                }
                catch (NoSuchRoleException noSuchRoleException) {
                    ServiceLogger.logError((Throwable)((Object)noSuchRoleException), 3);
                }
                catch (NoSuchUserException noSuchUserException) {
                    ServiceLogger.logError((Throwable)((Object)noSuchUserException), 3);
                }
            }
            if (n != 0) {
                bl = true;
                n = 0;
            }
        }
        if (role.getSubUsersFlag() != lDAPGroup.getUsersFlag()) {
            vector = role.getSubUserNames();
            object3 = vector2.elements();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                if (vector.contains(object2)) continue;
                try {
                    object = this.add.getIntegrityUser((String)object2);
                }
                catch (NoSuchUserException noSuchUserException) {
                    ServiceLogger.logError((Throwable)((Object)noSuchUserException), 3);
                    continue;
                }
                if (object.getLdapType() != 1) continue;
                try {
                    this.addElement.addSubUserToRole((String)object2, string);
                    ++n;
                }
                catch (NoSuchRoleException noSuchRoleException) {
                    ServiceLogger.logError((Throwable)((Object)noSuchRoleException), 3);
                }
                catch (NoSuchUserException noSuchUserException) {
                    ServiceLogger.logError((Throwable)((Object)noSuchUserException), 3);
                }
            }
            if (n != 0) {
                bl = true;
                n = 0;
            }
        }
        vector = lDAPGroup.getSubGroupNames();
        if (role.getSubRolesFlag() != lDAPGroup.getSubGroupsFlag()) {
            object3 = (Vector)role.getSubRoleNames().clone();
            object2 = ((Vector)object3).elements();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                if (vector.contains(object)) continue;
                try {
                    this.addElement.removeRoleFromParentRole((String)object, string);
                    ++n;
                }
                catch (NoSuchRoleException noSuchRoleException) {
                    ServiceLogger.logError((Throwable)((Object)noSuchRoleException), 3);
                }
            }
            if (n != 0) {
                bl = true;
                n = 0;
            }
        }
        if (role.getSubRolesFlag() != lDAPGroup.getSubGroupsFlag()) {
            object3 = role.getSubRoleNames();
            object2 = vector.elements();
            while (object2.hasMoreElements()) {
                Role role2;
                object = (String)object2.nextElement();
                if (((Vector)object3).contains(object)) continue;
                try {
                    role2 = this.add.getRole((String)object);
                }
                catch (NoSuchRoleException noSuchRoleException) {
                    ServiceLogger.logError((Throwable)((Object)noSuchRoleException), 3);
                    continue;
                }
                if (role2.getType() != 1) continue;
                try {
                    this.addElement.addSubRoleToRole((String)object, string);
                    ++n;
                }
                catch (NoSuchRoleException noSuchRoleException) {
                    ServiceLogger.logError((Throwable)((Object)noSuchRoleException), 3);
                }
            }
            if (n != 0) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean add(LDAPGroup lDAPGroup, Group group) {
        Object object;
        Object object2;
        Object object3;
        Vector vector;
        String string = group.getName();
        boolean bl = false;
        Vector vector2 = lDAPGroup.getUserNames();
        int n = 0;
        if (group.getUsersFlag() != lDAPGroup.getUsersFlag()) {
            vector = (Vector)group.getUserNames().clone();
            object3 = vector.elements();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                if (vector2.contains(object2)) continue;
                try {
                    this.addElement.removeUserFromGroup((String)object2, string);
                    ++n;
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    ServiceLogger.logError((Throwable)((Object)noSuchGroupException), 3);
                }
                catch (NoSuchUserException noSuchUserException) {
                    ServiceLogger.logError((Throwable)((Object)noSuchUserException), 3);
                }
            }
            if (n != 0) {
                bl = true;
                n = 0;
            }
        }
        if (group.getUsersFlag() != lDAPGroup.getUsersFlag()) {
            vector = group.getUserNames();
            object3 = vector2.elements();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                if (vector.contains(object2)) continue;
                try {
                    object = this.add.getIntegrityUser((String)object2);
                }
                catch (NoSuchUserException noSuchUserException) {
                    ServiceLogger.logError((Throwable)((Object)noSuchUserException), 3);
                    continue;
                }
                if (object.getLdapType() != 1) continue;
                try {
                    this.addElement.addUserToGroup((String)object2, string);
                    ++n;
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    ServiceLogger.logError((Throwable)((Object)noSuchGroupException), 3);
                }
                catch (NoSuchUserException noSuchUserException) {
                    ServiceLogger.logError((Throwable)((Object)noSuchUserException), 3);
                }
            }
            if (n != 0) {
                bl = true;
                n = 0;
            }
        }
        vector = lDAPGroup.getSubGroupNames();
        if (group.getSubGroupsFlag() != lDAPGroup.getSubGroupsFlag()) {
            object3 = (Vector)group.getSubGroupNames().clone();
            object2 = ((Vector)object3).elements();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                if (vector.contains(object)) continue;
                try {
                    this.addElement.removeSubGroupFromGroup((String)object, string);
                    ++n;
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    ServiceLogger.logError((Throwable)((Object)noSuchGroupException), 3);
                }
            }
            if (n != 0) {
                bl = true;
                n = 0;
            }
        }
        if (group.getSubGroupsFlag() != lDAPGroup.getSubGroupsFlag()) {
            object3 = group.getSubGroupNames();
            object2 = vector.elements();
            while (object2.hasMoreElements()) {
                Group group2;
                object = (String)object2.nextElement();
                if (((Vector)object3).contains(object)) continue;
                try {
                    group2 = this.add.getGroup((String)object);
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    ServiceLogger.logError((Throwable)((Object)noSuchGroupException), 3);
                    continue;
                }
                if (group2.getType() != 1) continue;
                try {
                    this.addElement.addSubGroupToGroup((String)object, string);
                    ++n;
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    ServiceLogger.logError((Throwable)((Object)noSuchGroupException), 3);
                }
            }
            if (n != 0) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean isLDAPScheduleEnable() {
        return this.SEDU.isLDAPScheduleEnable();
    }

    @Override
    public Properties getSynchronizeSchedule() {
        return this.SEDU.getSynchronizeSchedule();
    }

    @Override
    public boolean disableSynSchedule() {
        return this.SEDU.disableSynSchedule();
    }

    @Override
    public boolean enableSynSchedule() {
        return this.SEDU.enableSynSchedule();
    }

    @Override
    public boolean deleteSynSchedule() {
        return this.SEDU.deleteSynSchedule();
    }

    @Override
    public boolean exportSynResultToXMLFile(String string, SynchronizationResult synchronizationResult) {
        return this.SEDU.exportSynResultToXMLFile(string, synchronizationResult);
    }

    @Override
    public SynchronizationResult getLastLDAPSynchronizeScheduleResult() {
        return this.SEDU.getLastSynScheduleResult();
    }

    @Override
    public boolean submitSynchronizeSchedule(Properties properties, String string) {
        if (!this.SEDU.isLDAPEnable()) {
            return false;
        }
        return this.SEDU.submitSynchronizeSchedule(properties, string);
    }
}

