/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.cfg;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.NamingException;
import jet.server.api.admin.cfg.ConfigurationLDAPServer;
import jet.server.api.cluster.ClusterException;
import jet.server.api.cluster.ClusterService;
import jet.server.api.cluster.Member;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.intf.jrs.MemberMonitor;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrc.security.ldap.LDAPConnectionImpl;
import jet.server.jrc.security.ldap.LDAPEnvironments;
import jet.server.jrc.security.ldap.NoSuchRoleMapException;
import jet.server.jrc.security.ldap.RoleMapExistException;
import jet.server.jrc.security.ldap.intf.LDAPGroup;
import jet.server.jrc.security.ldap.intf.LDAPManager;
import jet.server.jrc.security.ldap.intf.LDAPUser;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;

public class JRConfigurationLDAPServer
implements ConfigurationLDAPServer {
    private LDAPManager SEDU;
    private Hashtable addElement = new Hashtable();

    public JRConfigurationLDAPServer() {
        this.SEDU = UserDataToolkit.getLdapManager();
        this.addElement = (Hashtable)this.SEDU.getLDAPProperties().clone();
    }

    @Override
    public void setLdapEnable(boolean bl) {
        this.addElement.put("enableLDAPSupport", String.valueOf(bl));
    }

    @Override
    public boolean isLdapEnable() {
        String string = (String)this.addElement.get("enableLDAPSupport");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return false;
    }

    @Override
    public String getLDAPVersion() {
        String string = (String)this.addElement.get("ldapVersion");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    @Override
    public void setLDAPVersion(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("ldapVersion", string);
    }

    @Override
    public void setImportUserUponAuthentication(boolean bl) {
        this.addElement.put("enableAutoImportLDAPUser", String.valueOf(bl));
    }

    @Override
    public boolean isImportUserUponAuthentication() {
        String string = (String)this.addElement.get("enableAutoImportLDAPUser");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return false;
    }

    @Override
    public void setLDAPURL(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("url", string);
    }

    @Override
    public String getLDAPURL() {
        String string = (String)this.addElement.get("url");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    @Override
    public void setLADPServerPort(int n) {
        this.addElement.put("serverPort", String.valueOf(n));
    }

    @Override
    public int getLADPServerPort() {
        int n = -1;
        String string = (String)this.addElement.get("serverPort");
        if (string != null && string.trim().length() > 0) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                ServiceLogger.logError(numberFormatException, 3);
            }
            return n;
        }
        return n;
    }

    @Override
    public void setEncryptedPort(int n) {
    }

    @Override
    public int getEncryptedPort() {
        return 0;
    }

    @Override
    public void setRoot(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("rootEntry", string);
    }

    @Override
    public String getRoot() {
        String string = (String)this.addElement.get("rootEntry");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    @Override
    public void setDirectoryManagerDN(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("directoryManagerDN", string);
    }

    @Override
    public String getDirectoryManagerDN() {
        String string = (String)this.addElement.get("directoryManagerDN");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    @Override
    public void setPassword(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("password", string);
    }

    @Override
    public String getPassword() {
        String string = (String)this.addElement.get("password");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    @Override
    public void setEncryptionType(String string) {
    }

    @Override
    public String getEncryptionType() {
        return "";
    }

    @Override
    public void setEncryptionInLayer(boolean bl) {
        this.addElement.put("isUsingSSL", String.valueOf(bl));
    }

    @Override
    public boolean isEncryptionInLayer() {
        String string = (String)this.addElement.get("isUsingSSL");
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        return string.trim().equals("true");
    }

    @Override
    public void setImportGroupType(String string) {
        this.addElement.put("importGroupType", string);
    }

    @Override
    public String getImportGroupType() {
        String string = (String)this.addElement.get("importGroupType");
        if (string == null || string.trim().length() == 0) {
            return "role";
        }
        return string;
    }

    @Override
    public void setFirstUseLocal(boolean bl) {
    }

    @Override
    public boolean isFirstUseLocal() {
        return false;
    }

    @Override
    public String[] getUseServerList() {
        String[] stringArray = new String[]{"Current Settings", "Novell Directory Server", "iPlanet Directory Server", "Microsoft Site Server", "OpenLDAP Directory Server", "Win2000 Active Directory", "Lotus Domino on NT"};
        return stringArray;
    }

    @Override
    public boolean isConnection() {
        LDAPEnvironments lDAPEnvironments = new LDAPEnvironments(this.addElement);
        LDAPConnectionImpl lDAPConnectionImpl = new LDAPConnectionImpl(lDAPEnvironments);
        return lDAPConnectionImpl.connect();
    }

    @Override
    public boolean isConnection(Hashtable hashtable) {
        hashtable.put("socketTime", this.SEDU.getSocketTimeStr());
        LDAPEnvironments lDAPEnvironments = new LDAPEnvironments(hashtable);
        LDAPConnectionImpl lDAPConnectionImpl = new LDAPConnectionImpl(lDAPEnvironments);
        return lDAPConnectionImpl.connect();
    }

    @Override
    public Vector getRootUsers() {
        try {
            return this.SEDU.getAllLDAPUsers();
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            return new Vector();
        }
    }

    @Override
    public void setGroupCommonName(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("groupCN", string);
    }

    @Override
    public String getGroupCommonName() {
        String string = (String)this.addElement.get("groupCN");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    @Override
    public void setGroupMemberType(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("groupMemberType", string);
    }

    @Override
    public String getGroupMemberType() {
        String string = (String)this.addElement.get("groupMemberType");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    @Override
    public void setGroupDistinguishName(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("groupDN", string);
    }

    @Override
    public String getGroupDistinguishName() {
        String string = (String)this.addElement.get("groupDN");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    @Override
    public void setGroupFilter(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("groupFilter", string);
    }

    @Override
    public String getGroupFilter() {
        String string = (String)this.addElement.get("groupFilter");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    @Override
    public void setAdminGroup(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("groupAdminGroup", string);
    }

    @Override
    public String getAdminGroup() {
        String string = (String)this.addElement.get("groupAdminGroup");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    @Override
    public Vector getGroupNames() {
        Enumeration enumeration;
        Vector<String> vector = new Vector<String>();
        if (!this.isLdapEnable()) {
            return vector;
        }
        LDAPEnvironments lDAPEnvironments = new LDAPEnvironments(this.addElement);
        LDAPConnectionImpl lDAPConnectionImpl = new LDAPConnectionImpl(lDAPEnvironments);
        lDAPConnectionImpl.connect();
        try {
            enumeration = lDAPConnectionImpl.getAllLDAPGroups().keys();
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            return vector;
        }
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            vector.addElement(string);
        }
        return vector;
    }

    @Override
    public Vector queryGroups(Hashtable hashtable) {
        Enumeration enumeration;
        Vector<LDAPGroup> vector = new Vector<LDAPGroup>();
        if (!this.SEDU(hashtable)) {
            return vector;
        }
        hashtable.put("socketTime", this.SEDU.getSocketTimeStr());
        LDAPEnvironments lDAPEnvironments = new LDAPEnvironments(hashtable);
        LDAPConnectionImpl lDAPConnectionImpl = new LDAPConnectionImpl(lDAPEnvironments);
        lDAPConnectionImpl.connect();
        try {
            enumeration = lDAPConnectionImpl.getAllLDAPGroups().elements();
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            return vector;
        }
        while (enumeration.hasMoreElements()) {
            LDAPGroup lDAPGroup = (LDAPGroup)enumeration.nextElement();
            vector.addElement(lDAPGroup);
        }
        return vector;
    }

    private boolean SEDU(Hashtable hashtable) {
        String string = (String)hashtable.get("enableLDAPSupport");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return false;
    }

    @Override
    public String getGroupDescriptions(String string) {
        LDAPGroup lDAPGroup;
        if (!this.isLdapEnable()) {
            return null;
        }
        LDAPEnvironments lDAPEnvironments = new LDAPEnvironments(this.addElement);
        LDAPConnectionImpl lDAPConnectionImpl = new LDAPConnectionImpl(lDAPEnvironments);
        lDAPConnectionImpl.connect();
        try {
            lDAPGroup = (LDAPGroup)lDAPConnectionImpl.getLDAPGroup(string)[0].get(0);
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            return "";
        }
        return lDAPGroup.getProperty("description");
    }

    @Override
    public void setUserAttributeName(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("userAN", string);
    }

    @Override
    public String getUserAttributeName() {
        String string = (String)this.addElement.get("userAN");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    @Override
    public void setUserCommonName(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("userCN", string);
    }

    @Override
    public void setUserEnableSAN(boolean bl) {
        this.addElement.put("userEnableSAN", String.valueOf(bl));
    }

    @Override
    public void setUserSAN(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("userSAN", string);
    }

    @Override
    public void setGroupEnableSAN(boolean bl) {
        this.addElement.put("groupEnableSAN", String.valueOf(bl));
    }

    @Override
    public void setGroupSAN(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("groupSAN", string);
    }

    @Override
    public String getUserCommonName() {
        String string = (String)this.addElement.get("userCN");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    @Override
    public boolean isUserEnableSAN() {
        String string = (String)this.addElement.get("userEnableSAN");
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        return string.trim().equals("true");
    }

    @Override
    public String getUserSAN() {
        String string = (String)this.addElement.get("userSAN");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    @Override
    public boolean isGroupEnableSAN() {
        String string = (String)this.addElement.get("groupEnableSAN");
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        return string.trim().equals("true");
    }

    @Override
    public String getGroupSAN() {
        String string = (String)this.addElement.get("groupSAN");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    @Override
    public void setUserPassword(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("userPassword", string);
    }

    @Override
    public String getUserPassword() {
        String string = (String)this.addElement.get("userPassword");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    @Override
    public void setUserDistinguishName(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("userDN", string);
    }

    @Override
    public String getUserDistinguishName() {
        String string = (String)this.addElement.get("userDN");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    @Override
    public void setUserFilter(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("userFilter", string);
    }

    @Override
    public String getUserFilter() {
        String string = (String)this.addElement.get("userFilter");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    @Override
    public Vector getUserNames() {
        Enumeration enumeration;
        Vector<String> vector = new Vector<String>();
        if (!this.isLdapEnable()) {
            return vector;
        }
        LDAPEnvironments lDAPEnvironments = new LDAPEnvironments(this.addElement);
        LDAPConnectionImpl lDAPConnectionImpl = new LDAPConnectionImpl(lDAPEnvironments);
        lDAPConnectionImpl.connect();
        try {
            enumeration = lDAPConnectionImpl.getAllLDAPUsers().keys();
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            return vector;
        }
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            vector.addElement(string);
        }
        return vector;
    }

    @Override
    public Vector queryUsers(Hashtable hashtable) {
        Enumeration enumeration;
        Vector<LDAPUser> vector = new Vector<LDAPUser>();
        if (!this.SEDU(hashtable)) {
            return vector;
        }
        hashtable.put("socketTime", this.SEDU.getSocketTimeStr());
        LDAPEnvironments lDAPEnvironments = new LDAPEnvironments(hashtable);
        LDAPConnectionImpl lDAPConnectionImpl = new LDAPConnectionImpl(lDAPEnvironments);
        lDAPConnectionImpl.connect();
        try {
            enumeration = lDAPConnectionImpl.getAllLDAPUsers().elements();
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            return vector;
        }
        while (enumeration.hasMoreElements()) {
            LDAPUser lDAPUser = (LDAPUser)enumeration.nextElement();
            vector.addElement(lDAPUser);
        }
        return vector;
    }

    @Override
    public String getUserFullNames(String string) {
        Hashtable hashtable;
        if (!this.isLdapEnable()) {
            return null;
        }
        LDAPEnvironments lDAPEnvironments = new LDAPEnvironments(this.addElement);
        LDAPConnectionImpl lDAPConnectionImpl = new LDAPConnectionImpl(lDAPEnvironments);
        lDAPConnectionImpl.connect();
        try {
            hashtable = lDAPConnectionImpl.getAllLDAPUsers();
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            return "";
        }
        LDAPUser lDAPUser = (LDAPUser)hashtable.get(string);
        if (lDAPUser != null) {
            return lDAPUser.getProperty("full_name");
        }
        return "";
    }

    @Override
    public void getDefauleSettingValue(String string) {
        if (string != null && string.trim().length() > 0) {
            if (string.equalsIgnoreCase("iPlanet Directory Server")) {
                this.addElement.put("userCN", "cn");
                this.addElement.put("userDN", "ou=people");
                this.addElement.put("userFilter", "(&(uid=*)(objectclass=person))");
                this.addElement.put("userPassword", "userPassword");
                this.addElement.put("userAN", "uid");
                this.addElement.put("groupAdminGroup", "");
                this.addElement.put("groupCN", "cn");
                this.addElement.put("groupDN", "ou=groups");
                this.addElement.put("groupFilter", "(&(cn=*)(objectclass=groupofuniquenames))");
                this.addElement.put("groupMemberType", "uniqueMember");
            } else if (string.equalsIgnoreCase("Microsoft Site Server")) {
                this.addElement.put("userCN", "cn");
                this.addElement.put("userDN", "ou=Members");
                this.addElement.put("userFilter", "(&(cn=*)(objectclass=member))");
                this.addElement.put("userPassword", "userPassword");
                this.addElement.put("userAN", "cn");
                this.addElement.put("groupAdminGroup", "");
                this.addElement.put("groupCN", "cn");
                this.addElement.put("groupDN", "ou=groups");
                this.addElement.put("groupFilter", "(&(cn=*)(objectclass=mgroup))");
                this.addElement.put("groupMemberType", "uniqueMember");
            } else if (string.equalsIgnoreCase("Novell Directory Server")) {
                this.addElement.put("userCN", "cn");
                this.addElement.put("userDN", "ou=people");
                this.addElement.put("userFilter", "(&(cn=*)(objectclass=person))");
                this.addElement.put("userPassword", "userPassword");
                this.addElement.put("userAN", "uid");
                this.addElement.put("groupAdminGroup", "");
                this.addElement.put("groupCN", "cn");
                this.addElement.put("groupDN", "ou=groups");
                this.addElement.put("groupFilter", "(&(cn=*)(objectclass=groupofuniquenames))");
                this.addElement.put("groupMemberType", "uniqueMember");
            } else if (string.equalsIgnoreCase("OpenLDAP Directory Server")) {
                this.addElement.put("userCN", "cn");
                this.addElement.put("userDN", "ou=members");
                this.addElement.put("userFilter", "(&(uid=*)(objectclass=person))");
                this.addElement.put("userPassword", "userPassword");
                this.addElement.put("userAN", "uid");
                this.addElement.put("groupAdminGroup", "");
                this.addElement.put("groupCN", "cn");
                this.addElement.put("groupDN", "ou=groups");
                this.addElement.put("groupFilter", "(&(cn=*)(objectclass=groupofuniquenames))");
                this.addElement.put("groupMemberType", "uniqueMember");
            } else if (string.equalsIgnoreCase("Win2000 Active Directory")) {
                this.addElement.put("userCN", "userPrincipalName");
                this.addElement.put("userDN", "cn=users");
                this.addElement.put("userFilter", "(&(cn=*)(objectclass=person))");
                this.addElement.put("userPassword", "userPassword");
                this.addElement.put("userAN", "cn");
                this.addElement.put("groupAdminGroup", "");
                this.addElement.put("groupCN", "cn");
                this.addElement.put("groupDN", "cn=users");
                this.addElement.put("groupFilter", "(&(cn=*)(objectclass=group))");
                this.addElement.put("groupMemberType", "member");
            } else if (string.equalsIgnoreCase("Lotus Domino on NT")) {
                this.addElement.put("userCN", "cn");
                this.addElement.put("userDN", "");
                this.addElement.put("userFilter", "(&(cn=*)(objectclass=person))");
                this.addElement.put("userPassword", "userPassword");
                this.addElement.put("userAN", "uid");
                this.addElement.put("groupAdminGroup", "");
                this.addElement.put("groupCN", "cn");
                this.addElement.put("groupDN", "");
                this.addElement.put("groupFilter", "(&(cn=*)(objectclass=groupofnames))");
                this.addElement.put("groupMemberType", "member");
            } else if (string.equalsIgnoreCase("Current Settings")) {
                this.addElement = (Hashtable)this.SEDU.getLDAPProperties().clone();
            }
        }
    }

    @Override
    public Hashtable getProperties() {
        this.addElement = (Hashtable)this.SEDU.getLDAPProperties().clone();
        return this.addElement;
    }

    @Override
    public void saveProperties() {
        this.SEDU.savePropertiese(this.addElement);
    }

    @Override
    public void runAtServerRestart() {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        ClusterService clusterService = httpRptServer.getClusterService();
        if (clusterService != null) {
            Member[] memberArray = null;
            try {
                memberArray = clusterService.getAllMembers();
            }
            catch (ClusterException clusterException) {
                ServiceLogger.logError((Throwable)((Object)clusterException), 3);
            }
            for (int i = 0; i < memberArray.length; ++i) {
                if (!memberArray[i].isBackupAdmin()) continue;
                try {
                    String string = memberArray[i].getHost();
                    int n = Integer.parseInt(memberArray[i].getPort());
                    String string2 = "MemberMonitor";
                    MemberMonitor memberMonitor = (MemberMonitor)RemoteObjectFactory.getRemoteObject(string, n, string2);
                    memberMonitor.setLdapConfig(this.addElement);
                    continue;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
            }
        }
    }

    @Override
    public void setEncryptedPort(String string) {
    }

    @Override
    public boolean createNewRoleMap(String string, String string2) throws RoleMapExistException {
        return this.SEDU.addRoleMap(string, string2);
    }

    @Override
    public String createRoleMap(String string, String string2) throws RoleMapExistException {
        return this.SEDU.addNewRoleMap(string, string2);
    }

    @Override
    public boolean removeRoleMap(String string) throws NoSuchRoleMapException {
        return this.SEDU.removeRoleMap(string);
    }

    @Override
    public boolean editRoleMap(String string, String string2, String string3) throws NoSuchRoleMapException {
        return this.SEDU.editRoleMap(string, string2, string3);
    }

    @Override
    public Vector getAllRoleMaps() {
        return this.SEDU.getRoleMaps();
    }

    @Override
    public boolean isEnableNoneImportedLDAPSupport() {
        String string = (String)this.addElement.get("enableNoneImportedLDAPSupport");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return false;
    }

    @Override
    public void setEnableLDAPProviders(boolean bl) {
        this.addElement.put("enableNoneImportedLDAPSupport", String.valueOf(bl));
    }
}

