/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.cfg;

import java.util.StringTokenizer;
import java.util.Vector;
import jet.ReportEnv;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.RptServerException;
import jet.server.api.admin.cfg.ConfigurationPerformance;
import jet.server.api.exception.NoLiveLicenseException;
import jet.server.api.http.HttpUtil;
import jet.server.log.ServiceLogger;

public class JRConfigurationPerformance
implements ConfigurationPerformance {
    private ExProperties SEDU = new ExProperties();
    private String addElement = ServerEnv.getServPropName();

    public JRConfigurationPerformance() {
        this.loadProperties();
    }

    @Override
    public void loadProperties() {
        try {
            this.SEDU = ServerEnv.getServerProps();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public void saveProperty() {
        try {
            this.SEDU.save(this.addElement, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public void setEnablePreloadFont(boolean bl) {
        this.SEDU.setProperty("performance.loadfont", bl);
        this.saveProperty();
    }

    @Override
    public boolean getEnablePreloadFont() {
        return this.SEDU.getProperty("performance.loadfont", true);
    }

    @Override
    public void setPreloadCatalogsName(Vector vector) {
        String string = "";
        for (int i = 0; i < vector.size(); ++i) {
            string = string + (String)vector.elementAt(i) + ",";
        }
        this.SEDU.setProperty("performance.preloadedcats", string);
        this.saveProperty();
    }

    @Override
    public Vector getPreloadCatalogsName() {
        String string = this.SEDU.getProperty("performance.preloadedcats");
        Vector<String> vector = new Vector<String>();
        if (string != null && string.trim().length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken());
            }
        }
        return vector;
    }

    @Override
    public void setPreloadReportsName(Vector vector) {
        String string = "";
        for (int i = 0; i < vector.size(); ++i) {
            string = string + (String)vector.elementAt(i) + ",";
        }
        this.SEDU.setProperty("performance.preloadedrpts", string);
        this.saveProperty();
    }

    @Override
    public Vector getPreloadReportsName() {
        Vector<String> vector = new Vector<String>();
        String string = this.SEDU.getProperty("performance.preloadedrpts");
        if (string != null && string.trim().length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                block8: {
                    string2 = stringTokenizer.nextToken();
                    if (!ReportEnv.isLive()) {
                        int n;
                        String string3 = "JReport_System_User";
                        if (string2.startsWith("/USERFOLDERPATH") && (n = string2.indexOf("/", "/USERFOLDERPATH".length() + 1)) > -1) {
                            string3 = string2.substring("/USERFOLDERPATH".length() + 1, n);
                        }
                        if (string2.indexOf("-V") > 0) {
                            string2 = string2.substring(0, string2.indexOf("-V"));
                        }
                        try {
                            if (HttpUtil.getHttpRptServer().getResourceManager().getPathInfo(string3, string2).isLiveReport()) {
                            }
                            break block8;
                        }
                        catch (RptServerException rptServerException) {
                            ServiceLogger.logError((Throwable)((Object)rptServerException), 3);
                            if (!(rptServerException.getCause().getCause() instanceof NoLiveLicenseException)) break block8;
                        }
                        continue;
                    }
                }
                vector.addElement(string2);
            }
        }
        return vector;
    }

    @Override
    public void setPreloadCatalogClass(boolean bl) {
        this.SEDU.setProperty("performance.preloadcatcls", bl);
        this.saveProperty();
    }

    @Override
    public boolean getPreloadCatalogClass() {
        return this.SEDU.getProperty("performance.preloadcatcls", true);
    }

    @Override
    public void setPreloadReportClass(boolean bl) {
        this.SEDU.setProperty("performance.preloadrptcls", bl);
        this.saveProperty();
    }

    @Override
    public boolean getPreloadReportClass() {
        return this.SEDU.getProperty("performance.preloadrptcls", true);
    }

    @Override
    public void setPreloadEngineClass(boolean bl) {
        this.SEDU.setProperty("performance.preloadenginecls", bl);
        this.saveProperty();
    }

    @Override
    public boolean getPreloadEngineClass() {
        return this.SEDU.getProperty("performance.preloadenginecls", true);
    }

    @Override
    public void setPreloadDsoClass(boolean bl) {
        this.SEDU.setProperty("performance.preloaddsocls", bl);
        this.saveProperty();
    }

    @Override
    public void setCompressIO(boolean bl) {
        this.SEDU.setProperty("performance.compressio", bl);
        this.saveProperty();
    }

    @Override
    public boolean getCompressIO() {
        return this.SEDU.getProperty("performance.compressio", false);
    }

    @Override
    public boolean getPreloadDsoClass() {
        return this.SEDU.getProperty("performance.preloaddsocls", true);
    }
}

