/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.cfg;

import java.util.Properties;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.admin.cfg.ConfigurationRMI;
import jet.server.log.ServiceLogger;

public class JRConfigurationRMI
implements ConfigurationRMI {
    private ExProperties SEDU = new ExProperties();
    private String get = ServerEnv.getServPropName();
    private Properties getLocalRMIHost = new Properties();

    public JRConfigurationRMI() {
        this.loadProperties();
    }

    public void loadProperties() {
        try {
            this.SEDU = ServerEnv.getServerProps();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public String getServerRMIHost() {
        String string = (String)this.getLocalRMIHost.get("server.rmi.host");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return ServerEnv.getLocalRMIHost();
    }

    @Override
    public void setServerRMIHost(String string) {
        try {
            this.SEDU.load(this.get);
            this.SEDU.setProperty("server.rmi.host", string);
            this.getLocalRMIHost.put("server.rmi.host", string);
            this.SEDU.save(this.get, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public String getServerRMIPort() {
        String string = (String)this.getLocalRMIHost.get("server.rmi.port");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return ServerEnv.getServerRMIPort();
    }

    @Override
    public void setServerRMIPort(String string) {
        try {
            this.SEDU.load(this.get);
            this.SEDU.setProperty("server.rmi.port", string);
            this.getLocalRMIHost.put("server.rmi.port", string);
            this.SEDU.save(this.get, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }
}

