/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.cfg;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.admin.cfg.ConfigurationService;
import jet.server.db.cfg.PropsTable;
import jet.server.db.core.GlobalDataService;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.log.ServiceLogger;
import jet.server.userman.Realm;
import jet.server.util.WebSecurityUtil;

public class JRConfigurationService
implements ConfigurationService {
    private ExProperties DEFAULT_SSL_KEYSTORE = new ExProperties();
    private String SEDU = ServerEnv.getServPropName();
    private Properties addElement = new Properties();
    PropsTable propTable = null;
    boolean isCluster = ServerEnv.isClusterEnabled();

    public JRConfigurationService() {
        if (this.isCluster) {
            GlobalDataService globalDataService = GlobalDataService.getInstance();
            this.propTable = globalDataService.getPropsTable();
        } else {
            this.loadProperties();
        }
    }

    @Override
    public void loadProperties() {
        try {
            this.DEFAULT_SSL_KEYSTORE = ServerEnv.getServerProps();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public boolean setPort(int n) {
        boolean bl = false;
        try {
            int n2 = n;
            if (n2 <= 0 || n2 > 65535) {
                throw new Exception();
            }
            if (n2 != ServerEnv.getAdminPort()) {
                this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.port", n2);
                this.DEFAULT_SSL_KEYSTORE.save(this.SEDU, null);
                this.addElement.put("httpserver.port", String.valueOf(n2));
                bl = true;
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return bl;
    }

    @Override
    public int getPort() {
        String string = (String)this.addElement.get("httpserver.port");
        if (string != null && string.trim().length() > 0) {
            return Integer.parseInt(string);
        }
        return ServerEnv.getPort();
    }

    @Override
    public void setAdminPort(int n) {
        this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.admin.port", n);
        this.addElement.put("httpserver.admin.port", String.valueOf(n));
        try {
            this.DEFAULT_SSL_KEYSTORE.save(this.SEDU, null);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
    }

    @Override
    public int getAdminPort() {
        String string = (String)this.addElement.get("httpserver.admin.port");
        if (string != null && string.trim().length() > 0) {
            return Integer.parseInt(string);
        }
        return ServerEnv.getAdminPort();
    }

    @Override
    public boolean setMaxNumberOfHandler(int n) {
        boolean bl = false;
        try {
            int n2 = n;
            if (n2 < 0) {
                throw new Exception();
            }
            this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.max.handlers", n2);
            this.addElement.put("httpserver.max.handlers", String.valueOf(n2));
            this.DEFAULT_SSL_KEYSTORE.save(this.SEDU, null);
            bl = true;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return bl;
    }

    @Override
    public int getMaxNumberOfHandler() {
        String string = (String)this.addElement.get("httpserver.max.handlers");
        if (string != null && string.trim().length() > 0) {
            return Integer.parseInt(string);
        }
        return ServerEnv.getMaxHandlers();
    }

    @Override
    public boolean setMaxNumberOfConnection(int n) {
        boolean bl = false;
        try {
            int n2 = n;
            if (n2 < 0) {
                throw new Exception();
            }
            this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.max.connections", n2);
            this.addElement.put("httpserver.max.connections", String.valueOf(n2));
            this.DEFAULT_SSL_KEYSTORE.save(this.SEDU, null);
            bl = true;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return bl;
    }

    @Override
    public int getMaxNumberOfConnection() {
        String string = (String)this.addElement.get("httpserver.max.connections");
        if (string != null && string.trim().length() > 0) {
            return Integer.parseInt(string);
        }
        return ServerEnv.getMaxConnections();
    }

    @Override
    public boolean setConnectionTimeout(int n) {
        boolean bl = false;
        try {
            int n2 = n;
            if (n2 < 0) {
                throw new Exception();
            }
            this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.timeout", n2);
            this.addElement.put("httpserver.timeout", String.valueOf(n2));
            this.DEFAULT_SSL_KEYSTORE.save(this.SEDU, null);
            bl = true;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        return bl;
    }

    @Override
    public int getConnectionTimeout() {
        String string = (String)this.addElement.get("httpserver.timeout");
        if (string != null && string.trim().length() > 0) {
            return Integer.parseInt(string);
        }
        return ServerEnv.getTimeout();
    }

    @Override
    public boolean setServletPropertyFileName(String string) {
        boolean bl = false;
        try {
            String string2 = WebSecurityUtil.validateFilePathStr(string);
            if (!new File(string2).exists()) {
                throw new Exception();
            }
            this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.servlet.propfile", string2);
            this.addElement.put("httpserver.servlet.propfile", string2);
            this.DEFAULT_SSL_KEYSTORE.save(this.SEDU, null);
            bl = true;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return bl;
    }

    @Override
    public String getServletPropertyFileName() {
        String string = (String)this.addElement.get("httpserver.servlet.propfile");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        String string2 = "";
        try {
            string2 = ServerEnv.getServerProps().getProperty("httpserver.servlet.propfile", System.getProperty("reporthome", ".") + File.separator + "bin" + File.separator + "servlet.properties");
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return string2;
    }

    @Override
    public void setActiveRealm(String string) {
        try {
            if (this.isCluster) {
                ServerEnv.registerProperty("server.realm.active", string);
                this.propTable.updateProp("server.properties", "server.realm.active", string);
            } else {
                this.DEFAULT_SSL_KEYSTORE.setProperty("server.realm.active", string);
                this.addElement.put("server.realm.active", string);
                this.DEFAULT_SSL_KEYSTORE.save(this.SEDU, null);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getRealms() {
        Vector<String> vector = new Vector<String>();
        Class<Realm> clazz = Realm.class;
        synchronized (Realm.class) {
            Iterator iterator = UserDataToolkit.getRealmNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                vector.addElement(string);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return vector;
        }
    }

    @Override
    public String getActiveRealm() {
        String string = (String)this.addElement.get("server.realm.active");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        String string2 = ServerEnv.getActiveRealm();
        return string2;
    }

    @Override
    public boolean getServiceOnAll() {
        String string = (String)this.addElement.get("httpserver.host.all");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return ServerEnv.useAllHosts();
    }

    @Override
    public void setServiceOnAll(boolean bl) {
        try {
            this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.host.all", bl);
            this.addElement.put("httpserver.host.all", String.valueOf(bl));
            this.DEFAULT_SSL_KEYSTORE.save(this.SEDU, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public Vector getHostAddresses() {
        InetAddress[] inetAddressArray = ServerEnv.getHostAddrs();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < inetAddressArray.length; ++i) {
            String string = inetAddressArray[i].toString();
            vector.addElement(string);
        }
        return vector;
    }

    @Override
    public String getHostName() {
        String string = (String)this.addElement.get("httpserver.host.name");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return ServerEnv.getHostName();
    }

    @Override
    public void setHostName(String string) {
        try {
            this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.host.name", string);
            this.addElement.put("httpserver.host.name", string);
            this.DEFAULT_SSL_KEYSTORE.save(this.SEDU, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    private void DEFAULT_SSL_KEYSTORE() {
        try {
            this.DEFAULT_SSL_KEYSTORE.save(this.SEDU, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public boolean isEnableSSL() {
        return this.DEFAULT_SSL_KEYSTORE.getProperty("httpserver.ssl.enable", false);
    }

    @Override
    public void setEnableSSL(boolean bl) {
        this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.ssl.enable", bl);
        this.DEFAULT_SSL_KEYSTORE();
    }

    @Override
    public int getSSLPort() {
        return this.DEFAULT_SSL_KEYSTORE.getProperty("httpserver.ssl.port", 6888);
    }

    @Override
    public void setSSLPort(int n) {
        this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.ssl.port", n);
        this.DEFAULT_SSL_KEYSTORE();
    }

    @Override
    public int getSSLAdminPort() {
        return this.DEFAULT_SSL_KEYSTORE.getProperty("httpserver.ssl.admin.port", 6889);
    }

    @Override
    public void setSSLAdminPort(int n) {
        this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.ssl.admin.port", n);
        this.DEFAULT_SSL_KEYSTORE();
    }

    @Override
    public String getSSLKeystoreFile() {
        return this.DEFAULT_SSL_KEYSTORE.getProperty("httpserver.ssl.keystore", ServerEnv.DEFAULT_SSL_KEYSTORE);
    }

    @Override
    public void setSSLKeystoreFile(String string) {
        this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.ssl.keystore", string);
        this.DEFAULT_SSL_KEYSTORE();
    }

    @Override
    public String getSSLKeystorePassword() {
        return this.DEFAULT_SSL_KEYSTORE.getProperty("httpserver.ssl.keystore.password", "jinfonet");
    }

    @Override
    public void setSSLKeystorePassword(String string) {
        this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.ssl.keystore.password", string);
        this.DEFAULT_SSL_KEYSTORE();
    }

    @Override
    public String getSSLKeystoreType() {
        return this.DEFAULT_SSL_KEYSTORE.getProperty("httpserver.ssl.keystore.type", "JKS");
    }

    @Override
    public void setSSLKeystoreType(String string) {
        this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.ssl.keystore.type", string);
        this.DEFAULT_SSL_KEYSTORE();
    }

    @Override
    public String getSSLAlgorithm() {
        return this.DEFAULT_SSL_KEYSTORE.getProperty("httpserver.ssl.algorithm", "sunx509");
    }

    @Override
    public void setSSLAlgorithm(String string) {
        this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.ssl.algorithm", string);
        this.DEFAULT_SSL_KEYSTORE();
    }

    @Override
    public String getSSLProtocol() {
        return this.DEFAULT_SSL_KEYSTORE.getProperty("httpserver.ssl.protocol", "SSL");
    }

    @Override
    public void setSSLProtocol(String string) {
        this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.ssl.protocol", string);
        this.DEFAULT_SSL_KEYSTORE();
    }

    @Override
    public void setDashboardPort(int n) {
        this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.dashboard.port", n);
        this.addElement.put("httpserver.dashboard.port", String.valueOf(n));
        try {
            this.DEFAULT_SSL_KEYSTORE.save(this.SEDU, null);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
    }

    @Override
    public int getDashboardPort() {
        String string = (String)this.addElement.get("httpserver.dashboard.port");
        if (string != null && string.trim().length() > 0) {
            return Integer.parseInt(string);
        }
        return ServerEnv.getDashboardPort();
    }

    @Override
    public int getSSLDashboardPort() {
        return this.DEFAULT_SSL_KEYSTORE.getProperty("httpserver.ssl.dashboard.port", 6887);
    }

    @Override
    public void setSSLDashboardPort(int n) {
        this.DEFAULT_SSL_KEYSTORE.setProperty("httpserver.ssl.dashboard.port", n);
        this.DEFAULT_SSL_KEYSTORE();
    }
}

